<?php
/**
 * File: $Id: jstree.class.php,v 1.1 2004/10/13 12:03:38 Farsus Exp $
 */
/*  -------------------------------------------------------  */
/*               CIAMOS - Content Managing                     */
/*  -------------------------------------------------------  */
/*  Original Author        : Florian Solcher (alphalogic)       */
/*  Author's Email        : webdesign@alphalogic.org           */
/*  Author's Homepage    : www.alphalogic.org                   */
/*  -------------------------------------------------------  */
/*  License Type           : GPL: See /manual/LICENSES/GPL.txt  */
/*  -------------------------------------------------------  */
/*  -------------------------------------------------------  */
/*  Adapted for RunCms by EsseBe   - www.essebe.ch           */
/*  -------------------------------------------------------  */
if ( !isset($treejsincluded) ) $treejsincluded = FALSE;
class jstree {
    var $js_menu_array;
    var $orientation;
    var $name;
    var $design;
    var $design_array;
    var $css;
    var $css_parsed;

    function jstree($name, $array, $orientation='vertical_bottom_right') 
    {
        $this->js_menu_array = $array;
        $this->name = $name;
        switch ($orientation) {
            case 'vertical_bottom_right':
            $this->orientation = 'vbr';
            break;
            case 'vertical_bottom_left':
            $this->orientation = 'vbl';
            break;
            case 'vertical_top_right':
            $this->orientation = 'vur';
            break;
            case 'vertical_top_left':
            $this->orientation = 'vul';
            break;
            case 'horizontal_bottom_right':
            $this->orientation = 'hbr';
            break;
            case 'horizontal_bottom_left':
            $this->orientation = 'hbl';
            break;
            case 'horizontal_top_right':
            $this->orientation = 'hur';
            break;
            case 'horizontal_top_left':
            $this->orientation = 'hul';
            break;
        }
    }

    function setDesign($design='') {
        $this->design = $design;
    }

    function setCSS($css='') {
        $this->css =$css;
    }


    function gen_js_menu_array($what='') {
        $array = (!$what) ? $this->js_menu_array : $what;
        foreach ($array as $key => $node) {
            $menu .= '[';
            if (!$node['title']) $node['title'] = $node['name'];
            $menu .= "'".$node['image']."','".$node['title']."','".$node['link']."','','".$node['name']."'";
            if (is_array($node['leaves'])) {
                $menu .= ', ';
                $menu .= $this->gen_js_menu_array($node['leaves']);
            }
            $menu .= ']';
            if ($key+1 != count ($array)) $menu .=', ';
        }
        return $menu;
    }

    function gen_theme_var() {
        if ($this->design == '') {
                $this->design = array(
                'mainFolderRight' => "'&nbsp;'",
                'mainItemLeft'    => "'&nbsp;'",
                'mainItemRight'   => "'&nbsp;'",
                'folderLeft'      => "''",
                'folderRight'      => "''",
                'itemLeft'          => "''",
                'itemRight'          => "''",
                'mainSpacing'      => "0",
                'subSpacing'      => "0",
                'delay'              => "500"
            );
        }
        $i = 0;
        $theme_var = 'var '.$this->name.'_theme = {'."\n";
        foreach ($this->design as $attribute => $value) {
            $i++;
            $theme_var .= $attribute.': '.$value;
            if ($i!=count($this->design)) $theme_var .= ",\n";
        }
        $theme_var .= '};'."\n";
        $theme_var .= 'var '.$this->name.'_themeHSplit = [_cmNoAction, '."'".'<td class="jsmenu_MenuItemLeft"></td><td colspan="2"><div class="jsmenu_MenuSplit"></div></td>'."'".'];'."\n";
        $theme_var .= 'var '.$this->name.'_themeMainHSplit = [_cmNoAction, '."'".'<td class="jsmenu_MainItemLeft"></td><td colspan="2"><div class="jsmenu_MenuSplit"></div></td>'."'".'];'."\n";
        $theme_var .= 'var '.$this->name.'_themeMainVSplit = [_cmNoAction, '."'".'|'."'".'];'."\n";
        $this->design_array = $theme_var;
    }

    function gen_css () {
        if ($this->css == '') {
            $this->css = XOOPS_URL.'/themes/'.getTheme().'/menu/default.css';
        }
    }

    function render() {
        global $treejsincluded;
        $this->gen_js_menu_array();
        $this->js_menu_array = '['.$this->gen_js_menu_array().']';
        $this->gen_theme_var();
        $this->gen_css();
        $tree_code  = '<SCRIPT LANGUAGE="JavaScript"><!--'."\n var ".$this->name.' = '.$this->js_menu_array.";\n".'--></SCRIPT>';
        if (!$treejsincluded) {
            $tree_code .= '<SCRIPT LANGUAGE="JavaScript" SRC="'.XOOPS_URL.'/class/jsmenu/menu.js"></SCRIPT>';
            $treejsincluded = TRUE;
        }
        $tree_code .= '<LINK REL="stylesheet" HREF="'.$this->css.'" TYPE="text/css">';
        $tree_code .= '<SCRIPT LANGUAGE="JavaScript"><!--'."\n ".$this->design_array."\n".'--></SCRIPT>';
        $tree_code .= '<DIV ID="'.$this->name.'"></DIV>';
        $tree_code .= '<SCRIPT LANGUAGE="JavaScript"><!--'."\n"."cmDraw ('".$this->name."', ".$this->name.", '".$this->orientation."', ".$this->name."_theme, 'jsmenu_');\n--></SCRIPT>";
        return $tree_code;
    }
}
?>