/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.graphicsio.pdf;

import java.awt.GradientPaint;
import java.awt.Paint;
import java.awt.TexturePaint;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import org.freehep.graphicsio.pdf.PDFDictionary;
import org.freehep.graphicsio.pdf.PDFImageDelayQueue;
import org.freehep.graphicsio.pdf.PDFName;
import org.freehep.graphicsio.pdf.PDFStream;
import org.freehep.graphicsio.pdf.PDFWriter;

public class PDFPaintDelayQueue {
    private static int currentNumber = 0;
    private List paintList;
    private PDFWriter pdf;
    private PDFImageDelayQueue imageDelayQueue;
    private AffineTransform pageMatrix;

    public PDFPaintDelayQueue(PDFWriter pdf, PDFImageDelayQueue imageDelayQueue) {
        this.pdf = pdf;
        this.paintList = new LinkedList();
        this.imageDelayQueue = imageDelayQueue;
        this.pageMatrix = new AffineTransform();
    }

    public void setPageMatrix(AffineTransform t) {
        this.pageMatrix = new AffineTransform(t);
    }

    public PDFName delayPaint(Paint paint, AffineTransform transform, String writeAs) {
        Entry e = new Entry(paint, transform, writeAs);
        this.paintList.add(e);
        return this.pdf.name(e.name);
    }

    public void processAll() throws IOException {
        ListIterator i = this.paintList.listIterator();
        while (i.hasNext()) {
            Entry e = (Entry)i.next();
            if (e.written) continue;
            e.written = true;
            if (e.paint instanceof GradientPaint) {
                this.addGradientPaint(e);
                continue;
            }
            if (!(e.paint instanceof TexturePaint)) continue;
            this.addTexturePaint(e);
        }
    }

    public int addPatterns() throws IOException {
        if (this.paintList.size() > 0) {
            PDFDictionary patterns = this.pdf.openDictionary("Pattern");
            ListIterator i = this.paintList.listIterator();
            while (i.hasNext()) {
                Entry e = (Entry)i.next();
                patterns.entry(e.name, this.pdf.ref(e.name));
            }
            this.pdf.close(patterns);
        }
        return this.paintList.size();
    }

    private void addGradientPaint(Entry e) throws IOException {
        GradientPaint gp = (GradientPaint)e.paint;
        PDFDictionary pattern = this.pdf.openDictionary(e.name);
        pattern.entry("Type", this.pdf.name("Pattern"));
        pattern.entry("PatternType", 2);
        this.setMatrix(pattern, e, 0.0, 0.0);
        PDFDictionary shading = pattern.openDictionary("Shading");
        shading.entry("ShadingType", 2);
        shading.entry("ColorSpace", this.pdf.name("DeviceRGB"));
        Point2D p1 = gp.getPoint1();
        Point2D p2 = gp.getPoint2();
        shading.entry("Coords", new double[]{p1.getX(), p1.getY(), p2.getX(), p2.getY()});
        double[] domain = new double[]{0.0, 1.0};
        shading.entry("Domain", domain);
        String functionRef = e.name + "Function";
        shading.entry("Function", this.pdf.ref(functionRef));
        shading.entry("Extend", new boolean[]{true, true});
        pattern.close(shading);
        this.pdf.close(pattern);
        float[] col0 = new float[3];
        gp.getColor1().getRGBColorComponents(col0);
        double[] c0 = new double[]{col0[0], col0[1], col0[2]};
        float[] col1 = new float[3];
        gp.getColor2().getRGBColorComponents(col1);
        double[] c1 = new double[]{col1[0], col1[1], col1[2]};
        if (gp.isCyclic()) {
            this.addLinearFunction(functionRef, c0, c1, domain);
        } else {
            this.addLinearFunction(functionRef, c0, c1, domain);
        }
    }

    private void addLinearFunction(String functionRef, double[] c0, double[] c1, double[] dom) throws IOException {
        PDFDictionary function = this.pdf.openDictionary(functionRef);
        function.entry("FunctionType", 2);
        function.entry("Domain", dom);
        function.entry("Range", new double[]{0.0, 1.0, 0.0, 1.0, 0.0, 1.0});
        function.entry("C0", c0);
        function.entry("C1", c1);
        function.entry("N", 1);
        this.pdf.close(function);
    }

    private void addCyclicFunction(String functionRef, double[] c0, double[] c1, double[] dom) throws IOException {
        PDFStream function = this.pdf.openStream(functionRef);
        function.entry("FunctionType", 4);
        function.entry("Domain", dom);
        function.entry("Range", new double[]{0.0, 1.0, 0.0, 1.0, 0.0, 1.0});
        function.println("{");
        for (int i = 0; i < 3; ++i) {
            if (i < 2) {
                function.println("dup");
            }
            function.println(c1[i] - c0[i] + " mul");
            function.println(c0[i] + " add");
            if (i >= 2) continue;
            function.println("exch");
        }
        function.println("}");
        this.pdf.close(function);
    }

    private void addTexturePaint(Entry e) throws IOException {
        TexturePaint tp = (TexturePaint)e.paint;
        PDFStream pattern = this.pdf.openStream(e.name, null);
        pattern.entry("Type", this.pdf.name("Pattern"));
        pattern.entry("PatternType", 1);
        pattern.entry("PaintType", 1);
        BufferedImage image = tp.getImage();
        pattern.entry("TilingType", 1);
        double width = tp.getAnchorRect().getWidth();
        double height = tp.getAnchorRect().getHeight();
        double offsX = tp.getAnchorRect().getX();
        double offsY = tp.getAnchorRect().getY();
        pattern.entry("BBox", new double[]{0.0, 0.0, width, height});
        pattern.entry("XStep", width);
        pattern.entry("YStep", height);
        PDFDictionary resources = pattern.openDictionary("Resources");
        resources.entry("ProcSet", new Object[]{this.pdf.name("PDF"), this.pdf.name("ImageC")});
        pattern.close(resources);
        this.setMatrix(pattern, e, offsX, offsY);
        pattern.matrix(width, 0.0, 0.0, -height, 0.0, height);
        String[] encode = e.writeAs.equals("Smallest Size") ? new String[]{null, "ASCII85"} : (e.writeAs.equals("ZLIB") ? new String[]{"Flate", "ASCII85"} : new String[]{"DCT", "ASCII85"});
        pattern.inlineImage(image, null, encode);
        this.pdf.close(pattern);
    }

    private void setMatrix(PDFDictionary dict, Entry e, double translX, double translY) throws IOException {
        AffineTransform trafo = new AffineTransform(this.pageMatrix);
        trafo.concatenate(e.trafo);
        trafo.translate(translX, translY);
        double[] matrix = new double[6];
        trafo.getMatrix(matrix);
        dict.entry("Matrix", new double[]{matrix[0], matrix[1], matrix[2], matrix[3], matrix[4], matrix[5]});
    }

    private class Entry {
        private Paint paint;
        private String name;
        private AffineTransform trafo;
        private String writeAs;
        private boolean written;

        private Entry(Paint paint, AffineTransform trafo, String writeAs) {
            this.paint = paint;
            this.trafo = trafo;
            this.writeAs = writeAs;
            this.name = "Paint" + currentNumber++;
            this.written = false;
        }
    }
}

