/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.graphicsio.emf;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.GraphicsConfiguration;
import java.awt.Paint;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.TexturePaint;
import java.awt.Toolkit;
import java.awt.font.GlyphVector;
import java.awt.geom.AffineTransform;
import java.awt.geom.CubicCurve2D;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.awt.geom.RoundRectangle2D;
import java.awt.image.RenderedImage;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.text.AttributedCharacterIterator;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.freehep.graphics2d.PrintColor;
import org.freehep.graphicsio.AbstractVectorGraphicsIO;
import org.freehep.graphicsio.emf.AlphaBlend;
import org.freehep.graphicsio.emf.BeginPath;
import org.freehep.graphicsio.emf.CreateBrushIndirect;
import org.freehep.graphicsio.emf.DeleteObject;
import org.freehep.graphicsio.emf.EMFConstants;
import org.freehep.graphicsio.emf.EMFHandleManager;
import org.freehep.graphicsio.emf.EMFOutputStream;
import org.freehep.graphicsio.emf.EMFPathConstructor;
import org.freehep.graphicsio.emf.EMFRectangle;
import org.freehep.graphicsio.emf.EOF;
import org.freehep.graphicsio.emf.Ellipse;
import org.freehep.graphicsio.emf.EndPath;
import org.freehep.graphicsio.emf.ExtCreateFontIndirectW;
import org.freehep.graphicsio.emf.ExtCreatePen;
import org.freehep.graphicsio.emf.ExtLogFontW;
import org.freehep.graphicsio.emf.ExtLogPen;
import org.freehep.graphicsio.emf.ExtSelectClipRgn;
import org.freehep.graphicsio.emf.ExtTextOutW;
import org.freehep.graphicsio.emf.FillPath;
import org.freehep.graphicsio.emf.LogBrush32;
import org.freehep.graphicsio.emf.ModifyWorldTransform;
import org.freehep.graphicsio.emf.PolyBezier;
import org.freehep.graphicsio.emf.Polyline;
import org.freehep.graphicsio.emf.Region;
import org.freehep.graphicsio.emf.RestoreDC;
import org.freehep.graphicsio.emf.RoundRect;
import org.freehep.graphicsio.emf.SaveDC;
import org.freehep.graphicsio.emf.SelectClipPath;
import org.freehep.graphicsio.emf.SelectObject;
import org.freehep.graphicsio.emf.SetBkMode;
import org.freehep.graphicsio.emf.SetMapMode;
import org.freehep.graphicsio.emf.SetMiterLimit;
import org.freehep.graphicsio.emf.SetPolyFillMode;
import org.freehep.graphicsio.emf.SetTextAlign;
import org.freehep.graphicsio.emf.SetTextColor;
import org.freehep.graphicsio.emf.SetViewportExtEx;
import org.freehep.graphicsio.emf.SetViewportOrgEx;
import org.freehep.graphicsio.emf.SetWindowExtEx;
import org.freehep.graphicsio.emf.SetWindowOrgEx;
import org.freehep.graphicsio.emf.StrokeAndFillPath;
import org.freehep.graphicsio.emf.StrokePath;
import org.freehep.graphicsio.emf.TextW;
import org.freehep.graphicsio.font.FontUtilities;
import org.freehep.util.UserProperties;

public class EMFGraphics2D
extends AbstractVectorGraphicsIO
implements EMFConstants {
    public static final String version = "$Revision: 1.1.1.1 $";
    private EMFHandleManager handleManager;
    private int penHandle;
    private int brushHandle;
    private Rectangle imageBounds;
    private OutputStream ros;
    private EMFOutputStream os;
    private boolean fontSet = false;
    private Color textColor = null;
    private Color penColor = null;
    private Color brushColor = null;
    private Map fontTable;
    private Map unitFontTable;
    private EMFGraphics2D parentGraphics;
    private EMFPathConstructor pathConstructor;
    private boolean evenOdd;
    private static final Rectangle dummy = new Rectangle(0, 0, 0, 0);
    private static final String rootKey = EMFGraphics2D.class.getName();
    public static final String TRANSPARENT = rootKey + "." + "Transparent";
    public static final String BACKGROUND = rootKey + "." + "Background";
    public static final String BACKGROUND_COLOR = rootKey + "." + "BackgroundColor";
    private static final UserProperties defaultProperties = new UserProperties();
    Point[] points = new Point[]{new Point(0, 0), new Point(0, 0), new Point(0, 0), new Point(0, 0)};
    Color invisible = new Color(0, 0, 0, 0);
    private static final Properties replaceFonts;

    public static Properties getDefaultProperties() {
        return defaultProperties;
    }

    public static void setDefaultProperties(Properties newProperties) {
        defaultProperties.setProperties(newProperties);
    }

    public EMFGraphics2D(File file, Dimension size) throws FileNotFoundException {
        this((OutputStream)new FileOutputStream(file), size);
    }

    public EMFGraphics2D(File file, Component component) throws FileNotFoundException {
        this((OutputStream)new FileOutputStream(file), component);
    }

    public EMFGraphics2D(OutputStream os, Dimension size) {
        super(size, false);
        this.imageBounds = new Rectangle(0, 0, size.width, size.height);
        this.init(os);
    }

    public EMFGraphics2D(OutputStream os, Component component) {
        super(component, false);
        this.imageBounds = new Rectangle(0, 0, this.getSize().width, this.getSize().height);
        this.init(os);
    }

    private void init(OutputStream os) {
        this.fontTable = new HashMap();
        this.unitFontTable = new HashMap();
        this.evenOdd = false;
        this.handleManager = new EMFHandleManager();
        this.ros = os;
        this.initProperties((Properties)defaultProperties);
    }

    protected EMFGraphics2D(EMFGraphics2D graphics, boolean doRestoreOnDispose) {
        super((AbstractVectorGraphicsIO)graphics, doRestoreOnDispose);
        this.os = graphics.os;
        this.imageBounds = graphics.imageBounds;
        this.handleManager = graphics.handleManager;
        this.fontTable = graphics.fontTable;
        this.unitFontTable = graphics.unitFontTable;
        this.pathConstructor = graphics.pathConstructor;
        this.evenOdd = graphics.evenOdd;
        this.textColor = graphics.textColor;
        this.penColor = graphics.penColor;
        this.brushColor = graphics.brushColor;
        this.parentGraphics = graphics;
    }

    public void writeHeader() throws IOException {
        Dimension device = this.isDeviceIndependent() ? new Dimension(1024, 768) : Toolkit.getDefaultToolkit().getScreenSize();
        String producer = this.getClass().getName();
        if (!this.isDeviceIndependent()) {
            producer = producer + " " + version.substring(1, version.length() - 1);
        }
        this.os = new EMFOutputStream(new BufferedOutputStream(this.ros), this.imageBounds, this.handleManager, this.getCreator(), producer, device);
        this.pathConstructor = new EMFPathConstructor(this.os, this.imageBounds);
        Point orig = new Point(this.imageBounds.x, this.imageBounds.y);
        Dimension size = new Dimension(this.imageBounds.width, this.imageBounds.height);
        this.os.writeTag(new SetMapMode(8));
        this.os.writeTag(new SetWindowOrgEx(orig));
        this.os.writeTag(new SetWindowExtEx(size));
        this.os.writeTag(new SetViewportOrgEx(orig));
        this.os.writeTag(new SetViewportExtEx(size));
        this.os.writeTag(new SetTextAlign(24));
        this.os.writeTag(new SetTextColor(this.getColor()));
        this.os.writeTag(new SetPolyFillMode(2));
    }

    public void writeGraphicsState() throws IOException {
        super.writeGraphicsState();
        AffineTransform n = AffineTransform.getScaleInstance(0.05, 0.05);
        this.os.writeTag(new ModifyWorldTransform(n, 2));
    }

    public void writeBackground() throws IOException {
        if (this.isProperty(TRANSPARENT)) {
            this.setBackground(null);
            this.os.writeTag(new SetBkMode(1));
        } else if (this.isProperty(BACKGROUND)) {
            this.os.writeTag(new SetBkMode(2));
            this.setBackground(this.getPropertyColor(BACKGROUND_COLOR));
            this.clearRect(0.0, 0.0, this.getSize().width, this.getSize().height);
        } else {
            this.os.writeTag(new SetBkMode(2));
            this.setBackground(this.getComponent() != null ? this.getComponent().getBackground() : Color.WHITE);
            this.clearRect(0.0, 0.0, this.getSize().width, this.getSize().height);
        }
    }

    public void writeTrailer() throws IOException {
        int handle;
        while ((handle = this.handleManager.highestHandleInUse()) >= 0) {
            this.os.writeTag(new DeleteObject(handle));
            this.handleManager.freeHandle(handle);
        }
        this.os.writeTag(new EOF());
    }

    public void closeStream() throws IOException {
        this.os.close();
    }

    public Graphics create() {
        try {
            this.writeGraphicsSave();
        }
        catch (IOException e) {
            this.handleException(e);
        }
        return new EMFGraphics2D(this, true);
    }

    public Graphics create(double x, double y, double width, double height) {
        try {
            this.writeGraphicsSave();
        }
        catch (IOException e) {
            this.handleException(e);
        }
        EMFGraphics2D graphics = new EMFGraphics2D(this, true);
        graphics.translate(x, y);
        graphics.clipRect(0.0, 0.0, width, height);
        return graphics;
    }

    protected void writeGraphicsSave() throws IOException {
        this.os.writeTag(new SaveDC());
    }

    protected void writeGraphicsRestore() throws IOException {
        if (this.penHandle != 0) {
            this.os.writeTag(new DeleteObject(this.handleManager.freeHandle(this.penHandle)));
        }
        if (this.brushHandle != 0) {
            this.os.writeTag(new DeleteObject(this.handleManager.freeHandle(this.brushHandle)));
        }
        this.os.writeTag(new RestoreDC());
        if (this.fontSet) {
            this.parentGraphics.fontSet = false;
        }
    }

    public void draw(Shape shape) {
        try {
            if (shape instanceof Line2D) {
                Line2D line = (Line2D)shape;
                this.drawLine(line.getX1(), line.getY1(), line.getX2(), line.getY2());
                return;
            }
            if (shape instanceof Rectangle2D) {
                Rectangle2D rect = (Rectangle2D)shape;
                this.drawRect(rect.getMinX(), rect.getMinY(), rect.getWidth(), rect.getHeight());
                return;
            }
            if (shape instanceof CubicCurve2D) {
                CubicCurve2D curve = (CubicCurve2D)shape;
                this.writePen((BasicStroke)this.getStroke(), this.getColor());
                this.points[0].x = this.toUnit(curve.getX1());
                this.points[0].y = this.toUnit(curve.getY1());
                this.points[1].x = this.toUnit(curve.getCtrlX1());
                this.points[1].y = this.toUnit(curve.getCtrlY1());
                this.points[2].x = this.toUnit(curve.getCtrlX2());
                this.points[2].y = this.toUnit(curve.getCtrlY2());
                this.points[3].x = this.toUnit(curve.getX2());
                this.points[4].y = this.toUnit(curve.getY2());
                this.os.writeTag(new PolyBezier(this.imageBounds, 4, this.points));
                return;
            }
            this.writePen((BasicStroke)this.getStroke(), this.getColor());
            this.writePath(shape);
            this.os.writeTag(new StrokePath(this.imageBounds));
        }
        catch (IOException e) {
            this.handleException(e);
        }
    }

    public void fill(Shape shape) {
        if (shape instanceof Rectangle2D) {
            Rectangle2D rect = (Rectangle2D)shape;
            this.fillRect(rect.getMinX(), rect.getMinY(), rect.getWidth(), rect.getHeight());
            return;
        }
        if (shape instanceof Ellipse2D) {
            Ellipse2D ellipse = (Ellipse2D)shape;
            this.fillOval(ellipse.getMinX(), ellipse.getMinY(), ellipse.getWidth(), ellipse.getHeight());
            return;
        }
        if (shape instanceof RoundRectangle2D) {
            RoundRectangle2D rect = (RoundRectangle2D)shape;
            this.fillRoundRect(rect.getMinX(), rect.getMinY(), rect.getWidth(), rect.getHeight(), rect.getArcWidth(), rect.getArcHeight());
            return;
        }
        try {
            this.writeBrush(this.getColor());
            this.writePath(shape);
            this.os.writeTag(new FillPath(this.imageBounds));
        }
        catch (IOException e) {
            this.handleException(e);
        }
    }

    public void fillAndDraw(Shape shape, Color fillColor) {
        try {
            this.writePen((BasicStroke)this.getStroke(), this.getColor());
            this.writeBrush(fillColor);
            if (shape instanceof Rectangle2D) {
                Rectangle2D rect = (Rectangle2D)shape;
                Rectangle bounds = new Rectangle(this.toUnit(rect.getMinX()), this.toUnit(rect.getMinY()), this.toUnit(rect.getWidth()), this.toUnit(rect.getHeight()));
                this.os.writeTag(new EMFRectangle(bounds));
                return;
            }
            if (shape instanceof Ellipse2D) {
                Ellipse2D ellipse = (Ellipse2D)shape;
                Rectangle bounds = new Rectangle(this.toUnit(ellipse.getMinX()), this.toUnit(ellipse.getMinY()), this.toUnit(ellipse.getWidth()), this.toUnit(ellipse.getHeight()));
                this.os.writeTag(new Ellipse(bounds));
                return;
            }
            if (shape instanceof RoundRectangle2D) {
                RoundRectangle2D rect = (RoundRectangle2D)shape;
                Rectangle bounds = new Rectangle(this.toUnit(rect.getMinX()), this.toUnit(rect.getMinY()), this.toUnit(rect.getWidth()), this.toUnit(rect.getHeight()));
                this.os.writeTag(new RoundRect(bounds, new Dimension(this.toUnit(rect.getArcWidth() * 2.0), this.toUnit(rect.getArcHeight() * 2.0))));
                return;
            }
            this.writePath(shape);
            this.os.writeTag(new StrokeAndFillPath(this.imageBounds));
        }
        catch (IOException e) {
            this.handleException(e);
        }
    }

    public void drawLine(double x1, double y1, double x2, double y2) {
        try {
            this.writePen((BasicStroke)this.getStroke(), this.getColor());
            this.points[0].x = this.toUnit(x1);
            this.points[0].y = this.toUnit(y1);
            this.points[1].x = this.toUnit(x2);
            this.points[1].y = this.toUnit(y2);
            this.os.writeTag(new Polyline(this.imageBounds, 2, this.points));
        }
        catch (IOException e) {
            this.handleException(e);
        }
    }

    public void drawOval(double x, double y, double width, double height) {
        try {
            this.writePen((BasicStroke)this.getStroke(), this.getColor());
            this.writeBrush(this.invisible);
            Rectangle bounds = new Rectangle(this.toUnit(x), this.toUnit(y), this.toUnit(width), this.toUnit(height));
            this.os.writeTag(new Ellipse(bounds));
        }
        catch (IOException e) {
            this.handleException(e);
        }
    }

    public void drawRect(double x, double y, double width, double height) {
        try {
            this.writePen((BasicStroke)this.getStroke(), this.getColor());
            this.writeBrush(this.invisible);
            Rectangle bounds = new Rectangle(this.toUnit(x), this.toUnit(y), this.toUnit(width), this.toUnit(height));
            this.os.writeTag(new EMFRectangle(bounds));
        }
        catch (IOException e) {
            this.handleException(e);
        }
    }

    public void drawRoundRect(double x, double y, double width, double height, double arcWidth, double arcHeight) {
        try {
            this.writePen((BasicStroke)this.getStroke(), this.getColor());
            this.writeBrush(this.invisible);
            Rectangle bounds = new Rectangle(this.toUnit(x), this.toUnit(y), this.toUnit(width), this.toUnit(height));
            this.os.writeTag(new RoundRect(bounds, new Dimension(this.toUnit(arcWidth), this.toUnit(arcHeight))));
        }
        catch (IOException e) {
            this.handleException(e);
        }
    }

    public void fillOval(double x, double y, double width, double height) {
        try {
            this.writePen((BasicStroke)this.getStroke(), this.invisible);
            this.writeBrush(this.getColor());
            Rectangle bounds = new Rectangle(this.toUnit(x), this.toUnit(y), this.toUnit(width), this.toUnit(height));
            this.os.writeTag(new Ellipse(bounds));
        }
        catch (IOException e) {
            this.handleException(e);
        }
    }

    public void fillRect(double x, double y, double width, double height) {
        try {
            this.writePen((BasicStroke)this.getStroke(), this.invisible);
            this.writeBrush(this.getColor());
            Rectangle bounds = new Rectangle(this.toUnit(x), this.toUnit(y), this.toUnit(width), this.toUnit(height));
            this.os.writeTag(new EMFRectangle(bounds));
        }
        catch (IOException e) {
            this.handleException(e);
        }
    }

    public void fillRoundRect(double x, double y, double width, double height, double arcWidth, double arcHeight) {
        try {
            this.writePen((BasicStroke)this.getStroke(), this.invisible);
            this.writeBrush(this.getColor());
            Rectangle bounds = new Rectangle(this.toUnit(x), this.toUnit(y), this.toUnit(width), this.toUnit(height));
            this.os.writeTag(new RoundRect(bounds, new Dimension(this.toUnit(arcWidth), this.toUnit(arcHeight))));
        }
        catch (IOException e) {
            this.handleException(e);
        }
    }

    public void copyArea(int x, int y, int width, int height, int dx, int dy) {
        this.writeWarning(this.getClass() + ": copyArea(int, int, int, int, int, int) not implemented.");
    }

    protected void writeImage(RenderedImage image, AffineTransform xform, Color bkg) throws IOException {
        this.writeGraphicsSave();
        AffineTransform imageTransform = new AffineTransform(1.0, 0.0, 0.0, -1.0, 0.0, (double)image.getHeight());
        imageTransform.preConcatenate(xform);
        this.transform(imageTransform);
        this.os.writeTag(new AlphaBlend(this.imageBounds, this.toUnit(0.0), this.toUnit(0.0), this.toUnit(image.getWidth()), this.toUnit(image.getHeight()), new AffineTransform(), image, bkg));
        this.writeGraphicsRestore();
    }

    public void writeString(String string, double x, double y) throws IOException {
        Color color;
        Paint paint = this.getPaint();
        if (paint instanceof Color) {
            color = (Color)paint;
        } else if (paint instanceof GradientPaint) {
            GradientPaint gp = (GradientPaint)paint;
            color = PrintColor.mixColor((Color)gp.getColor1(), (Color)gp.getColor2());
        } else {
            Color bkg = this.getBackground();
            color = bkg == null ? Color.BLACK : PrintColor.invert((Color)bkg);
        }
        if (!color.equals(this.textColor)) {
            this.textColor = color;
            this.os.writeTag(new SetTextColor(this.textColor));
        }
        Font font = this.getFont();
        Font unitFont = (Font)this.unitFontTable.get(font);
        if (!this.fontSet) {
            Integer fontIndex = (Integer)this.fontTable.get(font);
            if (fontIndex == null) {
                String fontName = font.getName();
                string = FontUtilities.getEncodedString((String)string, (String)fontName);
                fontName = replaceFonts.getProperty(fontName, fontName);
                String windowsFontName = FontUtilities.getWindowsFontName((String)fontName);
                unitFont = new Font(windowsFontName, font.getStyle(), font.getSize());
                unitFont = unitFont.deriveFont(font.getSize2D() * 1.0f * 20.0f);
                this.unitFontTable.put(font, unitFont);
                ExtLogFontW logFontW = new ExtLogFontW(unitFont);
                int handle = this.handleManager.getHandle();
                this.os.writeTag(new ExtCreateFontIndirectW(handle, logFontW));
                fontIndex = new Integer(handle);
                this.fontTable.put(font, fontIndex);
            }
            this.os.writeTag(new SelectObject(fontIndex));
            this.fontSet = true;
        }
        int[] widths = new int[string.length()];
        for (int i = 0; i < widths.length; ++i) {
            double w = unitFont.getStringBounds(string, i, i + 1, this.getFontRenderContext()).getWidth();
            widths[i] = (int)w;
        }
        TextW text = new TextW(new Point(this.toUnit(x), this.toUnit(y)), string, 0, dummy, widths);
        this.os.writeTag(new ExtTextOutW(this.imageBounds, 2, 1.0f, 1.0f, text));
    }

    public void drawString(AttributedCharacterIterator iterator, float x, float y) {
        this.writeWarning(this.getClass() + ": drawString(AttributedCharacterIterator, float, float) not implemented.");
    }

    public void drawGlyphVector(GlyphVector glyphs, float x, float y) {
        this.writeWarning(this.getClass() + ": drawGlyphVector(GlyphVector, float, float) not implemented.");
        for (int i = 0; i < glyphs.getNumGlyphs(); ++i) {
            this.fill(glyphs.getGlyphOutline(i, x, y));
        }
    }

    protected void writeTransform(AffineTransform t) throws IOException {
        AffineTransform n = new AffineTransform(t.getScaleX(), t.getShearY(), t.getShearX(), t.getScaleY(), t.getTranslateX() * 1.0 * 20.0, t.getTranslateY() * 1.0 * 20.0);
        this.os.writeTag(new ModifyWorldTransform(n, 2));
    }

    protected void writeSetClip(Shape s) throws IOException {
        if (s instanceof RectangularShape) {
            RectangularShape r = (RectangularShape)s;
            AffineTransform currentTransform = this.getTransform();
            Point2D xy = currentTransform.transform(new Point2D.Double(r.getMinX(), r.getMinY()), null);
            Point2D wh = currentTransform.deltaTransform(new Point2D.Double(r.getWidth(), r.getHeight()), null);
            Rectangle rgn = new Rectangle((int)xy.getX(), (int)xy.getY(), (int)wh.getX(), (int)wh.getY());
            this.os.writeTag(new ExtSelectClipRgn(5, new Region(this.imageBounds, rgn)));
        } else {
            this.clip(s);
        }
    }

    protected void writeClip(Rectangle2D r2d) throws IOException {
        if (r2d == null) {
            return;
        }
        AffineTransform currentTransform = this.getTransform();
        Point2D xy = currentTransform.transform(new Point2D.Double(r2d.getX(), r2d.getY()), null);
        Point2D wh = currentTransform.deltaTransform(new Point2D.Double(r2d.getWidth(), r2d.getHeight()), null);
        Rectangle rgn = new Rectangle((int)xy.getX(), (int)xy.getY(), (int)wh.getX(), (int)wh.getY());
        this.os.writeTag(new ExtSelectClipRgn(1, new Region(this.imageBounds, rgn)));
    }

    protected void writeClip(Shape s) throws IOException {
        if (s == null) {
            return;
        }
        this.writePath(s);
        this.os.writeTag(new SelectClipPath(1));
    }

    public void writeStroke(Stroke stroke) throws IOException {
        if (stroke instanceof BasicStroke) {
            this.writePen((BasicStroke)stroke, this.getColor());
        }
    }

    public void setPaintMode() {
        this.writeWarning(this.getClass() + ": setPaintMode() not implemented.");
    }

    public void setXORMode(Color c1) {
        this.writeWarning(this.getClass() + ": setXORMode(Color) not implemented.");
    }

    protected void writePaint(Color p) throws IOException {
    }

    protected void writePaint(GradientPaint p) throws IOException {
        this.writeWarning(this.getClass() + ": writePaint(GradientPaint) not implemented.");
        this.setColor(PrintColor.mixColor((Color)p.getColor1(), (Color)p.getColor2()));
    }

    protected void writePaint(TexturePaint p) throws IOException {
        this.writeWarning(this.getClass() + ": writePaint(TexturePaint) not implemented.");
        this.setColor(Color.RED);
    }

    protected void writePaint(Paint p) throws IOException {
        this.writeWarning(this.getClass() + ": writePaint(Paint) not implemented for " + p.getClass());
        this.setColor(Color.WHITE);
    }

    public void setFont(Font font) {
        if (!font.equals(this.getFont())) {
            this.fontSet = false;
        }
        super.setFont(font);
    }

    public GraphicsConfiguration getDeviceConfiguration() {
        this.writeWarning(this.getClass() + ": getDeviceConfiguration() not implemented.");
        return null;
    }

    public boolean hit(Rectangle rect, Shape s, boolean onStroke) {
        this.writeWarning(this.getClass() + ": hit(Rectangle, Shape, boolean) not implemented.");
        return false;
    }

    public void writeComment(String comment) throws IOException {
        this.writeWarning(this.getClass() + ": writeComment(String) not implemented.");
    }

    public String toString() {
        return "EMFGraphics2D";
    }

    protected GeneralPath createShape(double[] xPoints, double[] yPoints, int nPoints, boolean close) {
        GeneralPath path = new GeneralPath(0);
        if (nPoints > 0) {
            path.moveTo((float)xPoints[0], (float)yPoints[0]);
            double lastX = xPoints[0];
            double lastY = yPoints[0];
            if (close && Math.abs(xPoints[nPoints - 1] - lastX) < 1.0 && Math.abs(yPoints[nPoints - 1] - lastY) < 1.0) {
                --nPoints;
            }
            for (int i = 1; i < nPoints; ++i) {
                if (!(Math.abs(xPoints[i] - lastX) > 1.0) && !(Math.abs(yPoints[i] - lastY) > 1.0)) continue;
                path.lineTo((float)xPoints[i], (float)yPoints[i]);
                lastX = xPoints[i];
                lastY = yPoints[i];
            }
            if (close) {
                path.closePath();
            }
        }
        return path;
    }

    private boolean writePath(Shape shape) throws IOException {
        boolean eo = EMFPathConstructor.isEvenOdd((Shape)shape);
        if (eo != this.evenOdd) {
            this.evenOdd = eo;
            this.os.writeTag(new SetPolyFillMode(this.evenOdd ? 1 : 2));
        }
        this.os.writeTag(new BeginPath());
        this.pathConstructor.addPath(shape);
        this.os.writeTag(new EndPath());
        return this.evenOdd;
    }

    private void writePen(BasicStroke stroke, Color color) throws IOException {
        if (color.equals(this.penColor) && stroke.equals(this.getStroke())) {
            return;
        }
        this.penColor = color;
        int style = 65536;
        switch (stroke.getEndCap()) {
            case 0: {
                style |= 0x200;
                break;
            }
            case 1: {
                style |= 0;
                break;
            }
            case 2: {
                style |= 0x100;
            }
        }
        switch (stroke.getLineJoin()) {
            case 0: {
                style |= 0x2000;
                break;
            }
            case 1: {
                style |= 0;
                break;
            }
            case 2: {
                style |= 0x1000;
            }
        }
        float[] dashArray = stroke.getDashArray();
        int[] dash = new int[dashArray != null ? dashArray.length : 0];
        style |= dash.length == 0 ? 0 : 7;
        for (int i = 0; i < dash.length; ++i) {
            dash[i] = this.toUnit(dashArray[i]);
        }
        int brushStyle = color.getAlpha() == 0 ? 1 : 0;
        ExtLogPen pen = new ExtLogPen(style, this.toUnit(stroke.getLineWidth()), brushStyle, this.getPrintColor(color), 0, dash);
        if (this.penHandle != 0) {
            this.os.writeTag(new DeleteObject(this.penHandle));
        } else {
            this.penHandle = this.handleManager.getHandle();
        }
        this.os.writeTag(new ExtCreatePen(this.penHandle, pen));
        this.os.writeTag(new SelectObject(this.penHandle));
        if (!(this.getStroke() instanceof BasicStroke) || ((BasicStroke)this.getStroke()).getMiterLimit() != stroke.getMiterLimit()) {
            this.os.writeTag(new SetMiterLimit(this.toUnit(stroke.getMiterLimit())));
        }
    }

    private void writeBrush(Color color) throws IOException {
        if (color.equals(this.brushColor)) {
            return;
        }
        this.brushColor = color;
        int brushStyle = color.getAlpha() == 0 ? 1 : 0;
        LogBrush32 brush = new LogBrush32(brushStyle, this.getPrintColor(color), 0);
        if (this.brushHandle != 0) {
            this.os.writeTag(new DeleteObject(this.brushHandle));
        } else {
            this.brushHandle = this.handleManager.getHandle();
        }
        this.os.writeTag(new CreateBrushIndirect(this.brushHandle, brush));
        this.os.writeTag(new SelectObject(this.brushHandle));
    }

    private int toUnit(double d) {
        return (int)Math.floor(d * 1.0 * 20.0);
    }

    static {
        defaultProperties.setProperty(TRANSPARENT, true);
        defaultProperties.setProperty(BACKGROUND, false);
        defaultProperties.setProperty(BACKGROUND_COLOR, Color.GRAY);
        replaceFonts = new Properties();
        replaceFonts.setProperty("Symbol", "Arial Unicode MS");
        replaceFonts.setProperty("ZapfDingbats", "Arial Unicode MS");
    }
}

