/*
 * Decompiled with CFR 0.152.
 */
package jp.riken.brain.ni.samuraigraph.figure;

import jp.riken.brain.ni.samuraigraph.base.SGDrawingElement;
import jp.riken.brain.ni.samuraigraph.base.SGTuple2f;

public abstract class SGDrawingElementLine
extends SGDrawingElement {
    public static final int LINE_TYPE_SOLID = 1;
    public static final int LINE_TYPE_BROKEN = 2;
    public static final int LINE_TYPE_DOT = 3;
    public static final String LINE_NAME_SOLID = "Solid";
    public static final String LINE_NAME_BROKEN = "Broken";
    public static final String LINE_NAME_DOT = "Dotted";
    protected SGTuple2f mStart = new SGTuple2f();
    protected SGTuple2f mEnd = new SGTuple2f();
    protected int mLineType;
    protected float mLineWidth;

    public SGDrawingElementLine() {
    }

    public SGDrawingElementLine(SGTuple2f sGTuple2f, SGTuple2f sGTuple2f2) {
        this.mStart.setValues(sGTuple2f);
        this.mEnd.setValues(sGTuple2f2);
    }

    public SGDrawingElementLine(SGTuple2f sGTuple2f, SGTuple2f sGTuple2f2, float f) {
        this.mStart.setValues(sGTuple2f);
        this.mEnd.setValues(sGTuple2f2);
        this.mLineWidth = f;
    }

    public SGDrawingElementLine(SGDrawingElementLine sGDrawingElementLine) {
        this.mStart.setValues(sGDrawingElementLine.getStart());
        this.mEnd.setValues(sGDrawingElementLine.getEnd());
        this.mLineWidth = sGDrawingElementLine.getLineWidth();
        this.mLineType = sGDrawingElementLine.getLineType();
    }

    public boolean setType(int n) {
        this.mLineType = n;
        return true;
    }

    public boolean setTermPoints(float f, float f2, float f3, float f4) {
        this.mStart.setValues(f, f2);
        this.mEnd.setValues(f3, f4);
        return true;
    }

    public boolean setTermPoints(SGTuple2f sGTuple2f, SGTuple2f sGTuple2f2) {
        this.mStart = sGTuple2f;
        this.mEnd = sGTuple2f2;
        return true;
    }

    public boolean setLineWidth(float f) {
        this.mLineWidth = f;
        return true;
    }

    public boolean setLineType(int n) {
        this.mLineType = n;
        return true;
    }

    public SGTuple2f getStart() {
        return new SGTuple2f(this.mStart.x, this.mStart.y);
    }

    public SGTuple2f getEnd() {
        return new SGTuple2f(this.mEnd.x, this.mEnd.y);
    }

    public int getLineType() {
        return this.mLineType;
    }

    public float getLineWidth() {
        return this.mLineWidth;
    }

    public static Integer getLineTypeFromName(String string) {
        int n;
        if (string == null) {
            return null;
        }
        if (string.equals(LINE_NAME_SOLID)) {
            n = 1;
        } else if (string.equals(LINE_NAME_BROKEN)) {
            n = 2;
        } else if (string.equals(LINE_NAME_DOT)) {
            n = 3;
        } else {
            return null;
        }
        return new Integer(n);
    }

    public static String getLineTypeName(int n) {
        String string = null;
        switch (n) {
            case 1: {
                string = LINE_NAME_SOLID;
                break;
            }
            case 2: {
                string = LINE_NAME_BROKEN;
                break;
            }
            case 3: {
                string = LINE_NAME_DOT;
                break;
            }
        }
        return string;
    }

    public boolean setProperty(SGDrawingElement sGDrawingElement) {
        if (!(sGDrawingElement instanceof SGDrawingElementLine)) {
            return false;
        }
        if (!super.setProperty(sGDrawingElement)) {
            return false;
        }
        SGDrawingElementLine sGDrawingElementLine = (SGDrawingElementLine)sGDrawingElement;
        this.setLineType(sGDrawingElementLine.getLineType());
        this.setLineWidth(sGDrawingElementLine.getLineWidth());
        return true;
    }
}

