/*
 * Decompiled with CFR 0.152.
 */
package jp.riken.brain.ni.samuraigraph.figure.java2d;

import java.awt.Graphics2D;
import java.io.IOException;
import java.io.Writer;
import jp.riken.brain.ni.samuraigraph.base.SGDrawingElement;
import jp.riken.brain.ni.samuraigraph.base.SGProperties;
import jp.riken.brain.ni.samuraigraph.base.SGTuple2f;
import jp.riken.brain.ni.samuraigraph.base.SGUtilityText;
import jp.riken.brain.ni.samuraigraph.figure.SGDrawingElementString;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGDrawingElementString2D;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGDrawingElementString2DExtended;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGElementGroup;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGElementGroupSXY;

public abstract class SGElementGroupString
extends SGElementGroupSXY {
    protected String mFontFamilyName;
    protected float mFontSize;
    protected int mFontStyle;
    protected float mAngle;
    public static final String PF_STRING_TITLE = "<String>";
    public static final String KEY_FONT_SIZE = "Font Size";
    public static final String KEY_FONT_FAMILY_NAME = "Font Family Name";
    public static final String KEY_FONT_STYLE = "Font Style";
    public static final String KEY_STRING_ANGLE = "Angle";

    public boolean setFont(String string, int n, float f) {
        this.mFontFamilyName = string;
        this.mFontStyle = n;
        this.mFontSize = f;
        if (this.mDrawingElementArray != null) {
            for (int i = 0; i < this.mDrawingElementArray.length; ++i) {
                SGDrawingElementString sGDrawingElementString = (SGDrawingElementString)this.mDrawingElementArray[i];
                sGDrawingElementString.setFont(string, n, f);
            }
        }
        return true;
    }

    public boolean setAngle(float f) {
        this.mAngle = f;
        if (this.mDrawingElementArray != null) {
            for (int i = 0; i < this.mDrawingElementArray.length; ++i) {
                SGDrawingElementString sGDrawingElementString = (SGDrawingElementString)this.mDrawingElementArray[i];
                sGDrawingElementString.setAngle(f);
            }
        }
        return true;
    }

    public String getFontFamilyName() {
        return this.mFontFamilyName;
    }

    public float getFontSize() {
        return this.mFontSize;
    }

    public int getFontStyle() {
        return this.mFontStyle;
    }

    public float getAngle() {
        return this.mAngle;
    }

    public boolean paintElement(Graphics2D graphics2D) {
        if (this.mDrawingElementArray != null) {
            for (int i = 0; i < this.mDrawingElementArray.length; ++i) {
                SGDrawingElementString2DExtended sGDrawingElementString2DExtended = (SGDrawingElementString2DExtended)this.mDrawingElementArray[i];
                sGDrawingElementString2DExtended.drawString(graphics2D);
            }
        }
        return true;
    }

    public SGDrawingElement getDrawingElement() {
        SGDrawingElementString2D sGDrawingElementString2D = new SGDrawingElementString2D();
        sGDrawingElementString2D.setVisible(this.mVisibleFlag);
        sGDrawingElementString2D.setFont(this.mFontFamilyName, this.mFontStyle, this.mFontSize);
        sGDrawingElementString2D.setAngle(this.mAngle);
        sGDrawingElementString2D.setColorList(this.mColorList);
        return sGDrawingElementString2D;
    }

    protected boolean initDrawingElement(int n) {
        SGDrawingElementString2DExtended[] sGDrawingElementString2DExtendedArray = new SGDrawingElementString2DExtended[n];
        for (int i = 0; i < n; ++i) {
            sGDrawingElementString2DExtendedArray[i] = new SGDrawingElementString2DExtended();
        }
        this.mDrawingElementArray = sGDrawingElementString2DExtendedArray;
        return true;
    }

    public boolean setLocation(SGTuple2f[] sGTuple2fArray) {
        if (sGTuple2fArray == null) {
            throw new IllegalArgumentException("pointArray==null");
        }
        if (sGTuple2fArray.length != this.mDrawingElementArray.length) {
            throw new Error("pointArray.length != this.mDrawingElementArray.length");
        }
        for (int i = 0; i < sGTuple2fArray.length; ++i) {
            SGDrawingElementString2DExtended sGDrawingElementString2DExtended = (SGDrawingElementString2DExtended)this.mDrawingElementArray[i];
            boolean bl = !sGTuple2fArray[i].isInfinite() && !sGTuple2fArray[i].isNaN();
            sGDrawingElementString2DExtended.setVisible(bl);
            if (!bl) continue;
            sGDrawingElementString2DExtended.setLocation(sGTuple2fArray[i]);
        }
        return true;
    }

    public boolean setPropertiesOfDrawingElements() {
        for (int i = 0; i < this.mDrawingElementArray.length; ++i) {
            SGDrawingElementString sGDrawingElementString = (SGDrawingElementString)this.mDrawingElementArray[i];
            sGDrawingElementString.setFont(this.mFontFamilyName, this.mFontStyle, this.mFontSize);
            sGDrawingElementString.setAngle(this.mAngle);
            sGDrawingElementString.setColorList(this.mColorList);
            sGDrawingElementString.setMagnification(this.mMagnification);
        }
        return true;
    }

    public boolean setProperty(SGDrawingElement sGDrawingElement) {
        if (!(sGDrawingElement instanceof SGDrawingElementString)) {
            return false;
        }
        if (!super.setProperty(sGDrawingElement)) {
            return false;
        }
        SGDrawingElementString sGDrawingElementString = (SGDrawingElementString)sGDrawingElement;
        this.setFont(sGDrawingElementString.getFontFamilyName(), sGDrawingElementString.getFontStyle(), sGDrawingElementString.getFontSize());
        this.setAngle(sGDrawingElementString.getAngle());
        return true;
    }

    public boolean writePropertyOfData(Writer writer) throws IOException {
        writer.write("<String>\n");
        SGUtilityText.writePropertyLine(writer, KEY_FONT_SIZE, new Float(this.mFontSize));
        SGUtilityText.writePropertyLine(writer, KEY_FONT_FAMILY_NAME, this.mFontFamilyName);
        SGUtilityText.writePropertyLine(writer, KEY_FONT_STYLE, new Integer(this.mFontStyle));
        SGUtilityText.writeColorListPropertyLine(writer, "Colors", this.mColorList);
        SGUtilityText.writePropertyLine(writer, KEY_STRING_ANGLE, new Double((double)(-this.mAngle) / (Math.PI / 180)));
        writer.write("\n");
        return false;
    }

    public SGProperties getProperties() {
        StringProperties stringProperties = new StringProperties();
        this.getProperties(stringProperties);
        return stringProperties;
    }

    public boolean getProperties(SGProperties sGProperties) {
        if (sGProperties == null) {
            return false;
        }
        if (!(sGProperties instanceof StringProperties)) {
            return false;
        }
        super.getProperties(sGProperties);
        StringProperties stringProperties = (StringProperties)sGProperties;
        stringProperties.setFontFamilyName(this.getFontFamilyName());
        stringProperties.setFontSize(this.getFontSize());
        stringProperties.setFontStyle(this.getFontStyle());
        stringProperties.setAngle(this.getAngle());
        return true;
    }

    public boolean setProperties(SGProperties sGProperties) {
        if (!(sGProperties instanceof StringProperties)) {
            return false;
        }
        if (!super.setProperties(sGProperties)) {
            return false;
        }
        StringProperties stringProperties = (StringProperties)sGProperties;
        Float f = stringProperties.getFontSize();
        if (f == null) {
            return false;
        }
        Integer n = stringProperties.getFontStyle();
        if (n == null) {
            return false;
        }
        this.setFont(stringProperties.getFontFamilyName(), n, f.floatValue());
        Float f2 = stringProperties.getAngle();
        if (f2 == null) {
            return false;
        }
        this.setAngle(f2.floatValue());
        return true;
    }

    public static class StringProperties
    extends SGElementGroup.ElementGroupProperties {
        public static final String[] keys = new String[]{"Font Size", "Font Style", "Font Family Name", "Angle"};

        public boolean equals(Object object) {
            if (!(object instanceof StringProperties)) {
                return false;
            }
            if (!super.equals(object)) {
                return false;
            }
            StringProperties stringProperties = (StringProperties)object;
            for (int i = 0; i < keys.length; ++i) {
                if (this.getProperty(keys[i]).equals(stringProperties.getProperty(keys[i]))) continue;
                return false;
            }
            return true;
        }

        public Float getFontSize() {
            String string = this.getProperty(SGElementGroupString.KEY_FONT_SIZE);
            return SGUtilityText.getFloat(string);
        }

        public Integer getFontStyle() {
            String string = this.getProperty(SGElementGroupString.KEY_FONT_STYLE);
            return SGUtilityText.getInteger(string);
        }

        public String getFontFamilyName() {
            return this.getProperty(SGElementGroupString.KEY_FONT_FAMILY_NAME);
        }

        public Float getAngle() {
            String string = this.getProperty(SGElementGroupString.KEY_STRING_ANGLE);
            return SGUtilityText.getFloat(string);
        }

        public boolean setFontSize(float f) {
            if (f < 0.0f) {
                return false;
            }
            this.setProperty(SGElementGroupString.KEY_FONT_SIZE, new Float(f).toString());
            return true;
        }

        public boolean setFontStyle(int n) {
            this.setProperty(SGElementGroupString.KEY_FONT_STYLE, new Integer(n).toString());
            return true;
        }

        public boolean setFontFamilyName(String string) {
            if (string == null) {
                return false;
            }
            this.setProperty(SGElementGroupString.KEY_FONT_FAMILY_NAME, new String(string));
            return true;
        }

        public boolean setAngle(float f) {
            this.setProperty(SGElementGroupString.KEY_STRING_ANGLE, new Float(f).toString());
            return true;
        }
    }
}

