/*
 * 쐬: 2004/06/22
 *
 * ̐ꂽRg̑}ev[gύX邽
 * EBhE > ݒ > Java > R[h > R[hƃRg
 */
package jp.riken.brain.ni.samuraigraph.data;

import java.lang.IllegalArgumentException;
import jp.riken.brain.ni.samuraigraph.base.SGData;


/**
 * @author kuromaru
 *
 * ̐ꂽRg̑}ev[gύX邽
 * EBhE > ݒ > Java > R[h > R[hƃRg
 */
public class SGSXYSamplingData extends SGSXYMultipleData implements SGITwoDimensionalData
{

	/**
	 * 
	 */
	private double mSamplingRate;


	/**
	 * 
	 */
	public SGSXYSamplingData()
	{
		super();
	}


	/**
	 * 
	 */
	public SGSXYSamplingData( final double sRate, final double[][] yArray )
	{
		super();

		if( sRate<=0 )
		{
			throw new IllegalArgumentException();
		}

		if( yArray==null )
		{
			throw new IllegalArgumentException();
		}

		if( yArray.length==0 )
		{
			throw new IllegalArgumentException();
		}

		int len = yArray[0].length;
		for( int ii=1; ii<yArray.length; ii++ )
		{
			if( yArray[ii].length != len )
			{
				throw new IllegalArgumentException();
			}
		}

		this.mSamplingRate = sRate;
		this.setYValueArray( yArray );
	}


	/**
	 * 
	 */
	public double getSamplingRate()
	{
		return this.mSamplingRate;
	}



	/**
	 * 
	 */
	public double[] getXValueArray()
	{
		final double[] xArray = new double[this.getDataLength()];

		for( int ii=0; ii<xArray.length; ii++ )
		{
			xArray[ii] = ii/this.mSamplingRate;
		}
		
		return xArray;
	}



	/**
	 * 
	 */
	public boolean setData( final SGData data )
	{
		if( data==null )
		{
			return false;
		}

		if( ( data instanceof SGSXYSamplingData ) == false )
		{
			return false;
		}

		SGSXYSamplingData data_ = (SGSXYSamplingData)data;
		this.mSamplingRate = data_.mSamplingRate;

		double[][] yArray = data_.getYValueArray();

		final double[][] array = new double[yArray.length][];
		for( int ii=0; ii<array.length; ii++ )
		{
			array[ii] = new double[yArray[ii].length];
			for( int jj=0; jj<array[ii].length; jj++ )
			{
				array[ii][jj] = yArray[ii][jj];
			}
		}
		this.setYValueArray( array );

		return true;
	}


	/**
	 * 
	 */
	public double getMinValueX()
	{
		return 0.0;
	}


	/**
	 * 
	 */
	public double getMaxValueX()
	{
		return ( this.getDataLength() - 1 )/this.mSamplingRate;
	}



}

