
package jp.riken.brain.ni.samuraigraph.figure.java2d;

import java.awt.*;
import java.io.*;
import jp.riken.brain.ni.samuraigraph.base.*;
import jp.riken.brain.ni.samuraigraph.data.*;
import jp.riken.brain.ni.samuraigraph.figure.*;


public abstract class SGElementGroupString extends SGElementGroupSXY
{

	/**
	 * 
	 */
	protected String mFontFamilyName;


	/**
	 *
	 */
	protected float mFontSize;


	/**
	 *
	 */
	protected int mFontStyle;


	/**
	 * 
	 */
	protected float mAngle;





	/**
	 * 
	 */
	public SGElementGroupString()
	{
		super();
	}



	/**
	 * 
	 * @param name
	 * @param style
	 * @param size
	 * @return
	 */
	public boolean setFont( final String name, final int style, final float size )
	{
		this.mFontFamilyName = name;
		this.mFontStyle = style;
		this.mFontSize = size;
		if( this.mDrawingElementArray!=null )
		{
			for( int ii=0; ii<this.mDrawingElementArray.length; ii++ )
			{
				SGDrawingElementString el
					= (SGDrawingElementString)this.mDrawingElementArray[ii];
				el.setFont( name, style, size );
			}
		}

		return true;
	}


	/**
	 * 
	 */
/*	public boolean setFontFamilyName( final String name )
	{
		this.mFontFamilyName = name;
		if( this.mDrawingElementArray!=null )
		{
			for( int ii=0; ii<this.mDrawingElementArray.length; ii++ )
			{
				SGDrawingElementString el
					= (SGDrawingElementString)this.mDrawingElementArray[ii];
				el.setFontFamilyName(name);
			}
		}
		return true;
	}
*/	


	/**
	 * 
	 */
/*	public boolean setFontSize( final float size )
	{
		this.mFontSize = size;
		if( this.mDrawingElementArray!=null )
		{
			for( int ii=0; ii<this.mDrawingElementArray.length; ii++ )
			{
				SGDrawingElementString el
					= (SGDrawingElementString)this.mDrawingElementArray[ii];
				el.setFontSize(size);
			}
		}
		return true;
	}
*/	
	
	/**
	 * 
	 */
/*	public boolean setFontStyle( final int style )
	{
		this.mFontStyle = style;
		if( this.mDrawingElementArray!=null )
		{
			for( int ii=0; ii<this.mDrawingElementArray.length; ii++ )
			{
				SGDrawingElementString el
					= (SGDrawingElementString)this.mDrawingElementArray[ii];
				el.setFontStyle(style);
			}
		}
		return true;
	}
*/	

	/**
	 * 
	 */
	public boolean setAngle( final float angle )
	{
		this.mAngle = angle;
		if( this.mDrawingElementArray!=null )
		{
			for( int ii=0; ii<this.mDrawingElementArray.length; ii++ )
			{
				SGDrawingElementString el
					= (SGDrawingElementString)this.mDrawingElementArray[ii];
				el.setAngle(angle);
			}
		}
		return true;
	}


	/**
	 * 
	 */
	public String getFontFamilyName()
	{
		return this.mFontFamilyName;
	}


	/**
	 * 
	 */
	public float getFontSize()
	{
		return this.mFontSize;
	}


	/**
	 * 
	 */
	public int getFontStyle()
	{
		return this.mFontStyle;
	}


	/**
	 * 
	 */
	public float getAngle()
	{
		return this.mAngle;
	}



	/**
	 * 
	 */
	public boolean paintElement( final Graphics2D g2d )
	{
		if( this.mDrawingElementArray!=null )
		{
			for( int ii=0; ii<this.mDrawingElementArray.length; ii++ )
			{
				SGDrawingElementString2DExtended el
					= (SGDrawingElementString2DExtended)this.mDrawingElementArray[ii];
				el.drawString(g2d);
			}
		}
		return true;
	}



	/**
	 * 
	 */
	public SGDrawingElement getDrawingElement()
	{
		SGDrawingElementString2D el = new SGDrawingElementString2D();
		el.setVisible( this.mVisibleFlag );
		el.setFont( this.mFontFamilyName, this.mFontStyle, this.mFontSize );
		el.setAngle( this.mAngle );
		el.setColorList( this.mColorList );
		return el;
	}



	/**
	 * 
	 * @return
	 */
	protected boolean initDrawingElement( final int num )
	{
		SGDrawingElementString[] array = new SGDrawingElementString2DExtended[num];
		for( int ii=0; ii<num; ii++ )
		{
			array[ii] = new SGDrawingElementString2DExtended();
		}
		this.mDrawingElementArray = array;
		return true;
	}



	/**
	 * 
	 */
	public boolean setLocation(
		final SGTuple2f[] pointArray )
	{

		if( pointArray==null )
		{
			throw new IllegalArgumentException("pointArray==null");
		}

		if( pointArray.length != this.mDrawingElementArray.length )
		{
			throw new Error("pointArray.length != this.mDrawingElementArray.length");
		}

		// V{̕`vf쐬
		for( int ii=0; ii<pointArray.length; ii++ )
		{
			SGDrawingElementString2DExtended el
				= (SGDrawingElementString2DExtended)this.mDrawingElementArray[ii];
			final boolean eff = !( pointArray[ii].isInfinite() || pointArray[ii].isNaN() );
			el.setVisible( eff );
			if( eff )
			{
				el.setLocation( pointArray[ii] );
			}
		}

		return true;
	}


	/**
	 * 
	 * @return
	 */
	public boolean setPropertiesOfDrawingElements()
	{
		for( int ii=0; ii<this.mDrawingElementArray.length; ii++ )
		{
			final SGDrawingElementString el
				= (SGDrawingElementString)this.mDrawingElementArray[ii];
//			el.setFontSize( this.mFontSize );
//			el.setFontFamilyName( this.mFontFamilyName );
//			el.setFontStyle( this.mFontStyle );
			el.setFont( this.mFontFamilyName, this.mFontStyle, this.mFontSize );
			el.setAngle( this.mAngle );
			el.setColorList( this.mColorList );
			el.setMagnification( this.mMagnification );
		}
		return true;
	}



	/**
	 * 
	 */
	public boolean setProperty( final SGDrawingElement element )
	{
		if( !(element instanceof SGDrawingElementString) )
		{
			return false;
		}

		if( super.setProperty( element ) == false )
		{
			return false;
		}

		SGDrawingElementString el = (SGDrawingElementString)element;

		this.setFont( el.getFontFamilyName(), el.getFontStyle(), el.getFontSize() );		
//		this.setFontFamilyName( el.getFontFamilyName() );
//		this.setFontSize( el.getFontSize() );
//		this.setFontStyle( el.getFontStyle() );
		this.setAngle( el.getAngle() );

		return true;
	}


	public static final String PF_STRING_TITLE = "<String>";

	public static final String KEY_FONT_SIZE = "Font Size";
	public static final String KEY_FONT_FAMILY_NAME = "Font Family Name";
	public static final String KEY_FONT_STYLE = "Font Style";
	public static final String KEY_STRING_ANGLE = "Angle";


	/**
	 * 
	 */
	public boolean writePropertyOfData( final Writer writer ) throws IOException
	{

		writer.write( PF_STRING_TITLE + "\n" );

		SGUtilityText.writePropertyLine( writer, KEY_FONT_SIZE, new Float( this.mFontSize ) );
		SGUtilityText.writePropertyLine( writer, KEY_FONT_FAMILY_NAME, this.mFontFamilyName );
		SGUtilityText.writePropertyLine( writer, KEY_FONT_STYLE, new Integer( this.mFontStyle ) );
		SGUtilityText.writeColorListPropertyLine( writer, KEY_COLOR_LIST, this.mColorList );
		SGUtilityText.writePropertyLine( writer, KEY_STRING_ANGLE, new Double( - this.mAngle / (Math.PI/180.0) ) );

		writer.write("\n");

		return false;
	}



	/**
	 * 
	 */
	public SGProperties getProperties()
	{
		StringProperties p = new StringProperties();
		this.getProperties(p);
		return p;
	}


	/**
	 * 
	 */
	public boolean getProperties( SGProperties p )
	{
		if( p==null ) return false;
		if( ( p instanceof StringProperties ) == false ) return false;

		super.getProperties(p);

		StringProperties sp = (StringProperties)p;
		sp.setFontFamilyName( this.getFontFamilyName() );
		sp.setFontSize( this.getFontSize() );
		sp.setFontStyle( this.getFontStyle() );
		sp.setAngle( this.getAngle() );

		return true;
	}


	/**
	 * 
	 */
	public boolean setProperties( SGProperties p )
	{
		if( ( p instanceof StringProperties ) == false ) return false;

		if( super.setProperties(p) == false ) return false;
		
		StringProperties sp = (StringProperties)p;
//		this.setFontFamilyName( sp.getFontFamilyName() );

		final Float fontSize = sp.getFontSize();
		if( fontSize==null )
		{
			return false;
		}
//		this.setFontSize( fontSize.floatValue() );

		final Integer fontStyle = sp.getFontStyle();
		if( fontStyle==null )
		{
			return false;
		}
//		this.setFontStyle( fontStyle.intValue() );

		this.setFont( sp.getFontFamilyName(), fontStyle.intValue(), fontSize.floatValue() );

		final Float angle = sp.getAngle();
		if( angle==null )
		{
			return false;
		}
		this.setAngle( angle.floatValue() );

		return true;
	}




	/**
	 * 
	 */
	public static class StringProperties extends ElementGroupProperties
	{
		
//		float fontSize;
//		int fontStyle;
//		String fontFamilyName;
//		double angle;


		public static final String[] keys = {
			KEY_FONT_SIZE, KEY_FONT_STYLE, KEY_FONT_FAMILY_NAME, KEY_STRING_ANGLE
		};



		/**
		 * 
		 *
		 */
		public StringProperties()
		{
			super();
		}


		/**
		 * 
		 */
		public boolean equals( final Object obj )
		{

			if( ( obj instanceof StringProperties ) == false )
			{
				return false;
			}
			
			if( super.equals(obj) == false ) return false;

			StringProperties p = (StringProperties)obj;
			for( int ii=0; ii<keys.length; ii++ )
			{
				if( this.getProperty(keys[ii]).equals(p.getProperty(keys[ii])) == false )
				{
					return false;
				}
			}

			return true;
		}



		public Float getFontSize()
		{
			final String value = this.getProperty(KEY_FONT_SIZE);
			return SGUtilityText.getFloat(value);
		}


		public Integer getFontStyle()
		{
			final String value = this.getProperty(KEY_FONT_STYLE);
			return SGUtilityText.getInteger(value);
		}


		public String getFontFamilyName()
		{
			return this.getProperty(KEY_FONT_FAMILY_NAME);
		}


		public Float getAngle()
		{
			final String value = this.getProperty(KEY_STRING_ANGLE);
			return SGUtilityText.getFloat(value);
		}


		public boolean setFontSize( final float size )
		{
			if( size<0.0f )
			{
				return false;
			}
			this.setProperty( KEY_FONT_SIZE, new Float(size).toString() );
			return true;
		}


		public boolean setFontStyle( final int style )
		{
			this.setProperty( KEY_FONT_STYLE, new Integer(style).toString() );
			return true;
		}


		public boolean setFontFamilyName( final String name )
		{
			if( name==null )
			{
				return false;
			}
			this.setProperty( KEY_FONT_FAMILY_NAME, new String(name) );
			return true;
		}

		public boolean setAngle( final float angle )
		{
			this.setProperty( KEY_STRING_ANGLE, new Float(angle).toString() );
			return true;
		}



		/**
		 * 
		 */
/*		public String toString()
		{
			String str = new String("[");
			str += new String("visible="+visible+", ");
			str += new String("colorList="+colorList+", ");
			str += new String("fontSize="+fontSize+", ");
			str += new String("fontStyle="+fontStyle+", ");
			str += new String("fontFamilyName="+fontFamilyName+", ");
			str += new String("angle="+angle+", ");
			str += new String("]");

			return str;
		}
*/
	}


}

