/*
 * Decompiled with CFR 0.152.
 */
package jp.riken.brain.ni.samuraigraph.application;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.NoSuchElementException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jp.riken.brain.ni.samuraigraph.base.SGCSVTokenizer;
import jp.riken.brain.ni.samuraigraph.base.SGData;
import jp.riken.brain.ni.samuraigraph.base.SGIProgressControl;
import jp.riken.brain.ni.samuraigraph.base.SGUtilityText;
import jp.riken.brain.ni.samuraigraph.data.SGISXYTypeData;
import jp.riken.brain.ni.samuraigraph.data.SGIVXYTypeData;
import jp.riken.brain.ni.samuraigraph.data.SGSXYData;
import jp.riken.brain.ni.samuraigraph.data.SGSXYDateData;
import jp.riken.brain.ni.samuraigraph.data.SGSXYMultipleData;
import jp.riken.brain.ni.samuraigraph.data.SGSXYSamplingData;
import jp.riken.brain.ni.samuraigraph.data.SGVXYData;

public class SGDataCreator {
    private static final String PROGRESS_MESSAGE_READFILE = "Read File";
    private static final String PROGRESS_MESSAGE_CREATEDATA = "Create Data";

    public SGData create(String string, ArrayList arrayList, SGIProgressControl sGIProgressControl) throws FileNotFoundException, IllegalArgumentException {
        SGData sGData = null;
        sGIProgressControl.startProgress();
        try {
            if (string == null || arrayList == null) {
                throw new IllegalArgumentException("path==null || infoList==null");
            }
            if (arrayList.size() == 0) {
                SGData sGData2 = null;
                return sGData2;
            }
            String string2 = (String)arrayList.get(0);
            if (string2.equals("SXY")) {
                sGData = (SGData)((Object)this.createSXYData(string, sGIProgressControl));
            } else if (string2.equals("SXY_DATE")) {
                sGData = (SGData)((Object)this.createSXYDateData(string, sGIProgressControl));
            } else if (string2.equals("VXY")) {
                if (arrayList.size() <= 1) {
                    SGData sGData3 = null;
                    return sGData3;
                }
                Object e = arrayList.get(1);
                if (!(e instanceof Boolean)) {
                    SGData sGData4 = null;
                    return sGData4;
                }
                Boolean bl = (Boolean)e;
                sGData = (SGData)((Object)this.createVXYData(string, bl, sGIProgressControl));
            } else if (string2.equals("SXY_MULTIPLE")) {
                sGData = this.createSXYMultipleData(string, sGIProgressControl);
            } else if (string2.equals("SXY_SAMPLING")) {
                if (arrayList.size() <= 1) {
                    SGData sGData5 = null;
                    return sGData5;
                }
                Object e = arrayList.get(1);
                if (!(e instanceof Number)) {
                    SGData sGData6 = null;
                    return sGData6;
                }
                Number number = (Number)e;
                sGData = this.createSXYSamplingData(string, number.doubleValue(), sGIProgressControl);
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw fileNotFoundException;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw illegalArgumentException;
        }
        finally {
            sGIProgressControl.endProgress();
        }
        return sGData;
    }

    private static ArrayList getSXYTextColumnIndexList(int n) {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        for (int i = 0; i < n; ++i) {
            if (n == 3 && i == 2 || n == 5 && i == 4) {
                arrayList.add(new Integer(0));
                continue;
            }
            arrayList.add(new Integer(1));
        }
        return arrayList;
    }

    private static ArrayList getVXYTextColumnIndexList(int n) {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        for (int i = 0; i < n; ++i) {
            arrayList.add(new Integer(1));
        }
        return arrayList;
    }

    private static ArrayList getSXYMultipleTextColumnIndexList(int n) {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        for (int i = 0; i < n; ++i) {
            arrayList.add(new Integer(1));
        }
        return arrayList;
    }

    private static ArrayList getSXYDateTextColumnIndexList(int n) {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        for (int i = 0; i < n; ++i) {
            if (i == 0 || n == 3 && i == 2 || n == 5 && i == 4) {
                arrayList.add(new Integer(0));
                continue;
            }
            arrayList.add(new Integer(1));
        }
        return arrayList;
    }

    private SGISXYTypeData createSXYData(String string, SGIProgressControl sGIProgressControl) throws FileNotFoundException {
        int n;
        sGIProgressControl.setProgressMessage(PROGRESS_MESSAGE_READFILE);
        sGIProgressControl.setIndeterminateProgress(true);
        int n2 = this.getColumnNumber(string);
        if (n2 < 2 || n2 > 5) {
            return null;
        }
        ArrayList arrayList = new ArrayList();
        ArrayList arrayList2 = SGDataCreator.getSXYTextColumnIndexList(n2);
        ArrayList[] arrayListArray = this.createListArray(string, n2, arrayList, arrayList2);
        if (arrayListArray == null) {
            return null;
        }
        sGIProgressControl.setProgressMessage(PROGRESS_MESSAGE_CREATEDATA);
        int n3 = arrayListArray[0].size();
        SGSXYData sGSXYData = null;
        String string2 = null;
        Double d = null;
        String[] stringArray = arrayList.size() != 0 ? new String[n2] : null;
        double[] dArray = new double[n3];
        double[] dArray2 = new double[n3];
        double[] dArray3 = (double[])(n2 == 4 || n2 == 5 ? new double[n3] : null);
        double[] dArray4 = (double[])(n2 == 4 || n2 == 5 ? new double[n3] : null);
        String[] stringArray2 = n2 == 3 || n2 == 5 ? new String[n3] : null;
        for (n = 0; n < arrayList.size(); ++n) {
            stringArray[n] = (String)arrayList.get(n);
        }
        sGIProgressControl.setIndeterminateProgress(false);
        for (n = 0; n < n3; ++n) {
            sGIProgressControl.setProgressValue((float)n / (float)n3);
            string2 = (String)arrayListArray[0].get(n);
            d = SGUtilityText.getDouble(string2);
            if (d == null) {
                return null;
            }
            dArray[n] = d;
            string2 = (String)arrayListArray[1].get(n);
            d = SGUtilityText.getDouble(string2);
            if (d == null) {
                return null;
            }
            dArray2[n] = d;
            if (n2 == 4 || n2 == 5) {
                string2 = (String)arrayListArray[2].get(n);
                d = SGUtilityText.getDouble(string2);
                if (d == null) {
                    return null;
                }
                dArray3[n] = d;
                string2 = (String)arrayListArray[3].get(n);
                d = SGUtilityText.getDouble(string2);
                if (d == null) {
                    return null;
                }
                dArray4[n] = d;
            }
            if (n2 != 3 && n2 != 5) continue;
            stringArray2[n] = (String)arrayListArray[n2 - 1].get(n);
        }
        sGSXYData = new SGSXYData(stringArray, dArray, dArray2, dArray3, dArray4, stringArray2);
        return sGSXYData;
    }

    private SGISXYTypeData createSXYDateData(String string, SGIProgressControl sGIProgressControl) throws FileNotFoundException {
        int n;
        sGIProgressControl.setProgressMessage(PROGRESS_MESSAGE_READFILE);
        sGIProgressControl.setIndeterminateProgress(true);
        int n2 = this.getColumnNumber(string);
        if (n2 < 2 || n2 > 5) {
            return null;
        }
        ArrayList arrayList = new ArrayList();
        ArrayList arrayList2 = SGDataCreator.getSXYDateTextColumnIndexList(n2);
        ArrayList[] arrayListArray = this.createListArray(string, n2, arrayList, arrayList2);
        if (arrayListArray == null) {
            return null;
        }
        sGIProgressControl.setProgressMessage(PROGRESS_MESSAGE_CREATEDATA);
        int n3 = arrayListArray[0].size();
        SGSXYDateData sGSXYDateData = null;
        String string2 = null;
        Double d = null;
        String[] stringArray = arrayList.size() != 0 ? new String[n2] : null;
        String[] stringArray2 = new String[n3];
        double[] dArray = new double[n3];
        double[] dArray2 = (double[])(n2 == 4 || n2 == 5 ? new double[n3] : null);
        double[] dArray3 = (double[])(n2 == 4 || n2 == 5 ? new double[n3] : null);
        String[] stringArray3 = n2 == 3 || n2 == 5 ? new String[n3] : null;
        for (n = 0; n < arrayList.size(); ++n) {
            stringArray[n] = (String)arrayList.get(n);
        }
        for (n = 0; n < n3; ++n) {
            sGIProgressControl.setProgressValue((float)n / (float)n3);
            stringArray2[n] = (String)arrayListArray[0].get(n);
            string2 = (String)arrayListArray[1].get(n);
            d = SGUtilityText.getDouble(string2);
            if (d == null) {
                return null;
            }
            dArray[n] = d;
            if (n2 == 4 || n2 == 5) {
                string2 = (String)arrayListArray[2].get(n);
                d = SGUtilityText.getDouble(string2);
                if (d == null) {
                    return null;
                }
                dArray2[n] = d;
                string2 = (String)arrayListArray[3].get(n);
                d = SGUtilityText.getDouble(string2);
                if (d == null) {
                    return null;
                }
                dArray3[n] = d;
            }
            if (n2 != 3 && n2 != 5) continue;
            stringArray3[n] = (String)arrayListArray[n2 - 1].get(n);
        }
        try {
            sGSXYDateData = new SGSXYDateData(stringArray, stringArray2, dArray, dArray2, dArray3, stringArray3);
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        return sGSXYDateData;
    }

    private SGSXYMultipleData createSXYMultipleData(String string, SGIProgressControl sGIProgressControl) throws FileNotFoundException {
        int n;
        sGIProgressControl.setProgressMessage(PROGRESS_MESSAGE_READFILE);
        sGIProgressControl.setIndeterminateProgress(true);
        int n2 = this.getColumnNumber(string);
        if (n2 < 2) {
            return null;
        }
        ArrayList arrayList = new ArrayList();
        ArrayList arrayList2 = SGDataCreator.getSXYMultipleTextColumnIndexList(n2);
        ArrayList[] arrayListArray = this.createListArray(string, n2, arrayList, arrayList2);
        if (arrayListArray == null) {
            return null;
        }
        sGIProgressControl.setProgressMessage(PROGRESS_MESSAGE_CREATEDATA);
        int n3 = arrayListArray[0].size();
        SGSXYMultipleData sGSXYMultipleData = null;
        String string2 = null;
        Double d = null;
        String[] stringArray = arrayList.size() != 0 ? new String[n2] : null;
        double[] dArray = new double[n3];
        double[][] dArrayArray = new double[n2 - 1][];
        for (n = 0; n < n2 - 1; ++n) {
            dArrayArray[n] = new double[n3];
        }
        for (n = 0; n < arrayList.size(); ++n) {
            stringArray[n] = (String)arrayList.get(n);
        }
        for (n = 0; n < n3; ++n) {
            sGIProgressControl.setProgressValue((float)n / (float)n3);
            string2 = (String)arrayListArray[0].get(n);
            d = SGUtilityText.getDouble(string2);
            if (d == null) {
                return null;
            }
            dArray[n] = d;
            for (int i = 0; i < n2 - 1; ++i) {
                string2 = (String)arrayListArray[i + 1].get(n);
                d = SGUtilityText.getDouble(string2);
                if (d == null) {
                    return null;
                }
                dArrayArray[i][n] = d;
            }
        }
        sGSXYMultipleData = new SGSXYMultipleData(stringArray, dArray, dArrayArray);
        return sGSXYMultipleData;
    }

    private SGSXYMultipleData createSXYSamplingData(String string, double d, SGIProgressControl sGIProgressControl) throws FileNotFoundException {
        int n;
        sGIProgressControl.setProgressMessage(PROGRESS_MESSAGE_READFILE);
        sGIProgressControl.setIndeterminateProgress(true);
        int n2 = this.getColumnNumber(string);
        if (n2 < 1) {
            return null;
        }
        ArrayList arrayList = new ArrayList();
        ArrayList arrayList2 = SGDataCreator.getSXYMultipleTextColumnIndexList(n2);
        ArrayList[] arrayListArray = this.createListArray(string, n2, arrayList, arrayList2);
        if (arrayListArray == null) {
            return null;
        }
        sGIProgressControl.setProgressMessage(PROGRESS_MESSAGE_CREATEDATA);
        int n3 = arrayListArray[0].size();
        SGSXYSamplingData sGSXYSamplingData = null;
        String string2 = null;
        Double d2 = null;
        String[] stringArray = arrayList.size() != 0 ? new String[n2] : null;
        double[] dArray = new double[n3];
        double[][] dArrayArray = new double[n2][];
        for (n = 0; n < n2; ++n) {
            dArrayArray[n] = new double[n3];
        }
        for (n = 0; n < arrayList.size(); ++n) {
            stringArray[n] = (String)arrayList.get(n);
        }
        for (n = 0; n < n3; ++n) {
            sGIProgressControl.setProgressValue((float)n / (float)n3);
            for (int i = 0; i < n2; ++i) {
                string2 = (String)arrayListArray[i].get(n);
                d2 = SGUtilityText.getDouble(string2);
                if (d2 == null) {
                    return null;
                }
                dArrayArray[i][n] = d2;
            }
        }
        sGSXYSamplingData = new SGSXYSamplingData(stringArray, d, (double[][])dArrayArray);
        return sGSXYSamplingData;
    }

    private SGIVXYTypeData createVXYData(String string, boolean bl, SGIProgressControl sGIProgressControl) throws FileNotFoundException {
        int n;
        sGIProgressControl.setProgressMessage(PROGRESS_MESSAGE_READFILE);
        sGIProgressControl.setIndeterminateProgress(true);
        int n2 = this.getColumnNumber(string);
        if (n2 != 4) {
            return null;
        }
        ArrayList arrayList = new ArrayList();
        ArrayList arrayList2 = SGDataCreator.getVXYTextColumnIndexList(n2);
        ArrayList[] arrayListArray = this.createListArray(string, n2, arrayList, arrayList2);
        if (arrayListArray == null) {
            return null;
        }
        sGIProgressControl.setProgressMessage(PROGRESS_MESSAGE_CREATEDATA);
        int n3 = arrayListArray[0].size();
        SGVXYData sGVXYData = null;
        String string2 = null;
        Double d = null;
        String[] stringArray = arrayList.size() != 0 ? new String[n2] : null;
        double[] dArray = new double[n3];
        double[] dArray2 = new double[n3];
        double[] dArray3 = new double[n3];
        double[] dArray4 = new double[n3];
        for (n = 0; n < arrayList.size(); ++n) {
            stringArray[n] = (String)arrayList.get(n);
        }
        for (n = 0; n < n3; ++n) {
            sGIProgressControl.setProgressValue((float)n / (float)n3);
            string2 = (String)arrayListArray[0].get(n);
            d = SGUtilityText.getDouble(string2);
            if (d == null) {
                return null;
            }
            dArray[n] = d;
            string2 = (String)arrayListArray[1].get(n);
            d = SGUtilityText.getDouble(string2);
            if (d == null) {
                return null;
            }
            dArray2[n] = d;
            string2 = (String)arrayListArray[2].get(n);
            d = SGUtilityText.getDouble(string2);
            if (d == null) {
                return null;
            }
            if (bl && d < 0.0) {
                return null;
            }
            dArray3[n] = d;
            string2 = (String)arrayListArray[3].get(n);
            d = SGUtilityText.getDouble(string2);
            if (d == null) {
                return null;
            }
            dArray4[n] = d;
        }
        sGVXYData = new SGVXYData(stringArray, dArray, dArray2, dArray3, dArray4, bl);
        return sGVXYData;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private int getColumnNumber(String string) throws FileNotFoundException {
        int n = -1;
        BufferedReader bufferedReader = null;
        try {
            bufferedReader = new BufferedReader(new FileReader(string));
            ArrayList arrayList = this.getFirstTokenList(bufferedReader);
            n = arrayList.size();
            Object var6_6 = null;
            if (bufferedReader == null) return n;
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            if (bufferedReader == null) throw throwable;
            try {
                bufferedReader.close();
                throw throwable;
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (IOException iOException) {}
        bufferedReader.close();
        return n;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private ArrayList[] createListArray(String var1_1, int var2_2, ArrayList var3_3, ArrayList var4_4) throws FileNotFoundException {
        block23: {
            block22: {
                block21: {
                    block20: {
                        var5_5 = new ArrayList[var2_2];
                        for (var6_6 = 0; var6_6 < var5_5.length; ++var6_6) {
                            var5_5[var6_6] = new ArrayList<E>();
                        }
                        var6_7 = null;
                        try {
                            var6_7 = new BufferedReader(new FileReader(var1_1));
                            var7_8 = 1;
                            while ((var8_10 = SGUtilityText.readLine(var6_7)) != null) {
                                var9_12 = new ArrayList<E>();
                                if (!SGUtilityText.tokenize(var8_10, var9_12, true)) {
                                    var10_13 = null;
                                    var15_17 = null;
                                    if (var6_7 == null) return var10_13;
                                    break block20;
                                }
                                if (var9_12.size() != var2_2) {
                                    if (var9_12.size() == 0) continue;
                                    var10_13 = null;
                                    break block21;
                                }
                                var10_13 = SGDataCreator.getColumnIndexListOfNumber(var9_12);
                                if (var7_8 != 0 && this.evaluteTitleList(var10_13)) {
                                    var3_3.addAll(var9_12);
                                    var7_8 = 0;
                                    continue;
                                }
                                if (!this.machesNumberColumnIndex(var4_4, var10_13)) {
                                    var11_14 = null;
                                    break block22;
                                }
                                var11_14 = new String[var2_2];
                                for (var12_15 = 0; var12_15 < var2_2; ++var12_15) {
                                    var13_16 = (String)var9_12.get(var12_15);
                                    var5_5[var12_15].add(var13_16);
                                }
                            }
                            break block23;
                        }
                        catch (Throwable var14_27) {
                            var15_21 = null;
                            if (var6_7 == null) throw var14_27;
                            try {
                                var6_7.close();
                                throw var14_27;
                            }
                            catch (IOException var16_26) {
                                // empty catch block
                            }
                            throw var14_27;
                        }
                    }
                    ** try [egrp 2[TRYBLOCK] [9 : 252->260)] { 
lbl55:
                    // 1 sources

                    var6_7.close();
                    return var10_13;
lbl57:
                    // 1 sources

                    catch (IOException var16_22) {
                        // empty catch block
                    }
                    return var10_13;
                }
                var15_18 = null;
                if (var6_7 == null) return var10_13;
                ** try [egrp 2[TRYBLOCK] [9 : 252->260)] { 
lbl64:
                // 1 sources

                var6_7.close();
                return var10_13;
lbl66:
                // 1 sources

                catch (IOException var16_23) {
                    // empty catch block
                }
                return var10_13;
            }
            var15_19 = null;
            if (var6_7 == null) return var11_14;
            ** try [egrp 2[TRYBLOCK] [9 : 252->260)] { 
lbl73:
            // 1 sources

            var6_7.close();
            return var11_14;
lbl75:
            // 1 sources

            catch (IOException var16_24) {
                // empty catch block
            }
            return var11_14;
        }
        var15_20 = null;
        if (var6_7 != null) {
            try {}
            catch (IOException var16_25) {}
            var6_7.close();
        }
        var7_8 = var5_5[0].size();
        var8_11 = 1;
        while (var8_11 < var5_5.length) {
            if (var5_5[var8_11].size() != var7_8) {
                return null;
            }
            ++var8_11;
        }
        return var5_5;
    }

    private boolean machesNumberColumnIndex(ArrayList arrayList, ArrayList arrayList2) {
        if (arrayList.size() != arrayList2.size()) {
            return false;
        }
        for (int i = 0; i < arrayList.size(); ++i) {
            Integer n = (Integer)arrayList.get(i);
            Integer n2 = (Integer)arrayList2.get(i);
            if (n != 1 || n2 != 0) continue;
            return false;
        }
        return true;
    }

    private static ArrayList getColumnIndexListOfNumber(ArrayList arrayList) {
        ArrayList<Integer> arrayList2 = new ArrayList<Integer>();
        Pattern pattern = Pattern.compile("^[+-]?[0-9]+(\\.[0-9]*)?([eE][+-]?[0-9]+)?$");
        for (int i = 0; i < arrayList.size(); ++i) {
            String string = (String)arrayList.get(i);
            Matcher matcher = pattern.matcher(string);
            if (matcher.matches()) {
                arrayList2.add(new Integer(1));
                continue;
            }
            arrayList2.add(new Integer(0));
        }
        return arrayList2;
    }

    private boolean evaluteTitleList(ArrayList arrayList) {
        boolean bl = true;
        if (arrayList.size() == 0) {
            return false;
        }
        for (int i = 0; i < arrayList.size(); ++i) {
            Integer n = (Integer)arrayList.get(i);
            if (n == 0) continue;
            bl = false;
        }
        return bl;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean getFileTypeCandidateList(String string, ArrayList arrayList) throws FileNotFoundException {
        BufferedReader bufferedReader = null;
        try {
            ArrayList arrayList2;
            bufferedReader = new BufferedReader(new FileReader(string));
            ArrayList arrayList3 = this.getFirstTokenList(bufferedReader);
            int n = arrayList3.size();
            HashSet<String> hashSet = new HashSet<String>();
            ArrayList arrayList4 = SGDataCreator.getColumnIndexListOfNumber(arrayList3);
            if (this.evaluteTitleList(arrayList4)) {
                arrayList3 = this.getFirstTokenList(bufferedReader);
                arrayList4 = SGDataCreator.getColumnIndexListOfNumber(arrayList3);
            }
            if (this.evaluateDataTypeSXY(arrayList3) && this.machesNumberColumnIndex(arrayList2 = SGDataCreator.getSXYTextColumnIndexList(n), arrayList4)) {
                hashSet.add("SXY");
            }
            if (this.evaluateDataTypeVXY(arrayList3) && this.machesNumberColumnIndex(arrayList2 = SGDataCreator.getVXYTextColumnIndexList(n), arrayList4)) {
                hashSet.add("VXY");
            }
            if (this.evaluateDataTypeSXYMultiple(arrayList3) && this.machesNumberColumnIndex(arrayList2 = SGDataCreator.getSXYMultipleTextColumnIndexList(n), arrayList4)) {
                if (n >= 3) {
                    hashSet.add("SXY_MULTIPLE");
                }
                if (n >= 1) {
                    hashSet.add("SXY_SAMPLING");
                }
            }
            if (this.evaluateDataTypeSXYDate(arrayList3) && this.machesNumberColumnIndex(arrayList2 = SGDataCreator.getSXYDateTextColumnIndexList(n), arrayList4)) {
                hashSet.add("SXY_DATE");
            }
            arrayList.addAll(hashSet);
            Object var10_10 = null;
            if (bufferedReader == null) return true;
        }
        catch (Throwable throwable) {
            Object var10_11 = null;
            if (bufferedReader == null) throw throwable;
            try {
                bufferedReader.close();
                throw throwable;
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (IOException iOException) {}
        bufferedReader.close();
        return true;
    }

    private boolean evaluateDataTypeSXY(ArrayList arrayList) {
        int n;
        int n2 = arrayList.size();
        ArrayList<Integer> arrayList2 = new ArrayList<Integer>();
        if (n2 == 2 | n2 == 4) {
            for (n = 0; n < n2; ++n) {
                arrayList2.add(new Integer(n));
            }
        } else if (n2 == 3) {
            arrayList2.add(new Integer(0));
            arrayList2.add(new Integer(1));
        } else if (n2 == 5) {
            for (n = 0; n < 4; ++n) {
                arrayList2.add(new Integer(n));
            }
        } else {
            return false;
        }
        n = 1;
        for (int i = 0; i < arrayList2.size(); ++i) {
            int n3 = (Integer)arrayList2.get(i);
            String string = (String)arrayList.get(n3);
            Double d = SGUtilityText.getDouble(string);
            if (d != null) continue;
            n = 0;
            break;
        }
        return n != 0;
    }

    private boolean evaluateDataTypeVXY(ArrayList arrayList) {
        boolean bl = true;
        int n = arrayList.size();
        if (n != 4) {
            return false;
        }
        for (int i = 0; i < n; ++i) {
            String string = (String)arrayList.get(i);
            Double d = SGUtilityText.getDouble(string);
            if (d != null) continue;
            bl = false;
            break;
        }
        return bl;
    }

    private boolean evaluateDataTypeSXYMultiple(ArrayList arrayList) {
        boolean bl = true;
        int n = arrayList.size();
        for (int i = 0; i < n; ++i) {
            String string = (String)arrayList.get(i);
            Double d = SGUtilityText.getDouble(string);
            if (d != null) continue;
            bl = false;
            break;
        }
        return bl;
    }

    private boolean evaluateDataTypeSXYDate(ArrayList arrayList) {
        Object object;
        int n = arrayList.size();
        if (n != 2 & n != 3 & n != 4 & n != 5) {
            return false;
        }
        ArrayList arrayList2 = new ArrayList();
        arrayList2.add(arrayList.get(0));
        DateFormat dateFormat = DateFormat.getDateInstance();
        for (int i = 0; i < arrayList2.size(); ++i) {
            String string = (String)arrayList2.get(i);
            object = SGUtilityText.getDate(string);
            if (object != null) continue;
            return false;
        }
        ArrayList arrayList3 = new ArrayList();
        arrayList3.add(arrayList.get(1));
        if (n == 4 | n == 5) {
            arrayList3.add(arrayList.get(1));
            arrayList3.add(arrayList.get(2));
            arrayList3.add(arrayList.get(3));
        }
        for (int i = 0; i < arrayList3.size(); ++i) {
            object = (String)arrayList3.get(i);
            Double d = SGUtilityText.getDouble((String)object);
            if (d != null) continue;
            return false;
        }
        return true;
    }

    private ArrayList getFirstTokenList(BufferedReader bufferedReader) {
        String string;
        ArrayList<String> arrayList = new ArrayList<String>();
        while ((string = SGUtilityText.readLine(bufferedReader)) != null) {
            arrayList.clear();
            SGCSVTokenizer sGCSVTokenizer = new SGCSVTokenizer(string, true);
            while (sGCSVTokenizer.hasMoreTokens()) {
                try {
                    String string2 = sGCSVTokenizer.nextToken();
                    arrayList.add(string2);
                }
                catch (NoSuchElementException noSuchElementException) {}
            }
            int n = arrayList.size();
            if (n == 0) continue;
            break;
        }
        return arrayList;
    }
}

