/*
 * Decompiled with CFR 0.152.
 */
package jp.riken.brain.ni.samuraigraph.application;

import java.awt.Component;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import jp.riken.brain.ni.samuraigraph.application.SGIApplicationTextConstants;
import jp.riken.brain.ni.samuraigraph.application.SGWizardDialog;
import jp.riken.brain.ni.samuraigraph.base.SGUtility;
import jp.riken.brain.ni.samuraigraph.base.SGUtilityText;

public class SGXYDataTypeSelectionWizardDialog
extends SGWizardDialog
implements SGIApplicationTextConstants {
    public static final String TITLE = "Data Type";
    private JPanel mButtonPanel;
    protected JButton mCancelButton;
    private JRadioButton mDateXYRadioButton;
    private JRadioButton mMultipleXYRadioButton;
    protected JButton mNextButton;
    protected JButton mOKButton;
    private JRadioButton mOrthogonalRadioButton;
    private JPanel mPanel;
    private JRadioButton mPolarRadioButton;
    protected JButton mPreviousButton;
    private JTextField mSamplingRateField;
    private JLabel mSamplingUnitLabel;
    private JRadioButton mSamplingXYRadioButton;
    private JRadioButton mScalarXYRadioButton;
    private JRadioButton mVectorXYRadioButton;
    private final Map mDataTypeButtonMap = new HashMap();
    private static final String[] DATA_TYPE_ARRAY = new String[]{"SXY", "VXY", "SXY_MULTIPLE", "SXY_SAMPLING", "SXY_DATE"};

    public SGXYDataTypeSelectionWizardDialog() {
        this.initComponents();
        this.initProperty();
    }

    public SGXYDataTypeSelectionWizardDialog(Frame frame, boolean bl) {
        super(frame, bl);
        this.initComponents();
        this.initProperty();
    }

    private void initComponents() {
        this.mPanel = new JPanel();
        this.mScalarXYRadioButton = new JRadioButton();
        this.mMultipleXYRadioButton = new JRadioButton();
        this.mSamplingXYRadioButton = new JRadioButton();
        this.mSamplingRateField = new JTextField();
        this.mVectorXYRadioButton = new JRadioButton();
        this.mSamplingUnitLabel = new JLabel();
        this.mDateXYRadioButton = new JRadioButton();
        this.mPolarRadioButton = new JRadioButton();
        this.mOrthogonalRadioButton = new JRadioButton();
        this.mButtonPanel = new JPanel();
        this.mPreviousButton = new JButton();
        this.mNextButton = new JButton();
        this.mOKButton = new JButton();
        this.mCancelButton = new JButton();
        this.getContentPane().setLayout(new GridBagLayout());
        this.mPanel.setLayout(new GridBagLayout());
        this.mPanel.setBorder(new TitledBorder(null, "Select the Data Type", 0, 0, new Font("Dialog", 1, 12)));
        this.mScalarXYRadioButton.setFont(new Font("Dialog", 0, 12));
        this.mScalarXYRadioButton.setText("Scalar-XY");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 10, 0, 0);
        this.mPanel.add((Component)this.mScalarXYRadioButton, gridBagConstraints);
        this.mMultipleXYRadioButton.setFont(new Font("Dialog", 0, 12));
        this.mMultipleXYRadioButton.setText("Multiple-XY");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(0, 10, 0, 0);
        gridBagConstraints.anchor = 17;
        this.mPanel.add((Component)this.mMultipleXYRadioButton, gridBagConstraints);
        this.mSamplingXYRadioButton.setFont(new Font("Dialog", 0, 12));
        this.mSamplingXYRadioButton.setText("Sampling-XY");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.insets = new Insets(0, 10, 0, 0);
        gridBagConstraints.anchor = 17;
        this.mPanel.add((Component)this.mSamplingXYRadioButton, gridBagConstraints);
        this.mSamplingRateField.setColumns(3);
        this.mSamplingRateField.setFont(new Font("Dialog", 0, 12));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.insets = new Insets(0, 0, 0, 10);
        gridBagConstraints.anchor = 13;
        this.mPanel.add((Component)this.mSamplingRateField, gridBagConstraints);
        this.mVectorXYRadioButton.setFont(new Font("Dialog", 0, 12));
        this.mVectorXYRadioButton.setText("Vector-XY");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.insets = new Insets(0, 10, 10, 0);
        gridBagConstraints.anchor = 17;
        this.mPanel.add((Component)this.mVectorXYRadioButton, gridBagConstraints);
        this.mSamplingUnitLabel.setFont(new Font("Dialog", 0, 12));
        this.mSamplingUnitLabel.setText("Hz");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.insets = new Insets(0, 0, 0, 10);
        gridBagConstraints.anchor = 17;
        this.mPanel.add((Component)this.mSamplingUnitLabel, gridBagConstraints);
        this.mDateXYRadioButton.setFont(new Font("Dialog", 0, 12));
        this.mDateXYRadioButton.setText("Date-XY");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.insets = new Insets(0, 10, 0, 0);
        gridBagConstraints.anchor = 17;
        this.mPanel.add((Component)this.mDateXYRadioButton, gridBagConstraints);
        this.mPolarRadioButton.setFont(new Font("Dialog", 0, 12));
        this.mPolarRadioButton.setText("Polar");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.insets = new Insets(0, 0, 10, 0);
        this.mPanel.add((Component)this.mPolarRadioButton, gridBagConstraints);
        this.mOrthogonalRadioButton.setFont(new Font("Dialog", 0, 12));
        this.mOrthogonalRadioButton.setText("Orthogonal");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.insets = new Insets(0, 0, 10, 0);
        this.mPanel.add((Component)this.mOrthogonalRadioButton, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(10, 10, 0, 10);
        this.getContentPane().add((Component)this.mPanel, gridBagConstraints);
        this.mPreviousButton.setFont(new Font("Dialog", 1, 12));
        this.mPreviousButton.setText("<Prev");
        this.mButtonPanel.add(this.mPreviousButton);
        this.mNextButton.setFont(new Font("Dialog", 1, 12));
        this.mNextButton.setText("Next>");
        this.mButtonPanel.add(this.mNextButton);
        this.mOKButton.setFont(new Font("Dialog", 1, 12));
        this.mOKButton.setText("OK");
        this.mButtonPanel.add(this.mOKButton);
        this.mCancelButton.setFont(new Font("Dialog", 1, 12));
        this.mCancelButton.setText("Cancel");
        this.mButtonPanel.add(this.mCancelButton);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.getContentPane().add((Component)this.mButtonPanel, gridBagConstraints);
        this.pack();
    }

    private boolean initProperty() {
        this.setTitle(TITLE);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.mScalarXYRadioButton);
        buttonGroup.add(this.mDateXYRadioButton);
        buttonGroup.add(this.mVectorXYRadioButton);
        buttonGroup.add(this.mMultipleXYRadioButton);
        buttonGroup.add(this.mSamplingXYRadioButton);
        ButtonGroup buttonGroup2 = new ButtonGroup();
        buttonGroup2.add(this.mPolarRadioButton);
        buttonGroup2.add(this.mOrthogonalRadioButton);
        this.mScalarXYRadioButton.setSelected(true);
        this.mSamplingRateField.setEnabled(false);
        this.mSamplingRateField.setText(Double.toString(1.0));
        this.mOrthogonalRadioButton.setSelected(true);
        this.mScalarXYRadioButton.addActionListener(this);
        this.mVectorXYRadioButton.addActionListener(this);
        this.mDateXYRadioButton.addActionListener(this);
        this.mMultipleXYRadioButton.addActionListener(this);
        this.mSamplingXYRadioButton.addActionListener(this);
        this.mDataTypeButtonMap.put("SXY", this.mScalarXYRadioButton);
        this.mDataTypeButtonMap.put("VXY", this.mVectorXYRadioButton);
        this.mDataTypeButtonMap.put("SXY_MULTIPLE", this.mMultipleXYRadioButton);
        this.mDataTypeButtonMap.put("SXY_SAMPLING", this.mSamplingXYRadioButton);
        this.mDataTypeButtonMap.put("SXY_DATE", this.mDateXYRadioButton);
        this.getPreviousButton().addActionListener(this);
        this.getNextButton().addActionListener(this);
        this.getOKButton().addActionListener(this);
        this.getCancelButton().addActionListener(this);
        this.mSamplingRateField.addActionListener(this);
        return true;
    }

    public String getSelectedDataType() {
        String string = null;
        Map map = this.mDataTypeButtonMap;
        Iterator iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            Object k = iterator.next();
            JRadioButton jRadioButton = (JRadioButton)map.get(k);
            if (!jRadioButton.isSelected()) continue;
            string = (String)k;
            break;
        }
        return string;
    }

    public boolean setEffectiveDataType(ArrayList arrayList) {
        JRadioButton jRadioButton;
        String string;
        int n;
        if (arrayList == null) {
            return false;
        }
        if (arrayList.size() == 0) {
            return false;
        }
        Map map = this.mDataTypeButtonMap;
        String[] stringArray = DATA_TYPE_ARRAY;
        for (n = 0; n < stringArray.length; ++n) {
            string = stringArray[n];
            jRadioButton = (JRadioButton)map.get(string);
            boolean bl = arrayList.contains(string);
            jRadioButton.setEnabled(bl);
        }
        for (n = 0; n < stringArray.length; ++n) {
            string = stringArray[n];
            jRadioButton = (JRadioButton)map.get(string);
            if (!jRadioButton.isEnabled()) continue;
            jRadioButton.setSelected(true);
            break;
        }
        return true;
    }

    public Double getSamplingRate() {
        String string = this.mSamplingRateField.getText();
        return SGUtilityText.getDouble(string);
    }

    public boolean isPolarSelected() {
        return this.mPolarRadioButton.isSelected();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        super.actionPerformed(actionEvent);
        this.updateComponents();
        Object object = actionEvent.getSource();
        if (object.equals(this.mSamplingRateField)) {
            this.onOK();
        }
    }

    protected boolean onOK() {
        if (this.mSamplingXYRadioButton.isSelected()) {
            boolean bl = true;
            Double d = this.getSamplingRate();
            if (d == null) {
                bl = false;
            } else {
                double d2 = d;
                if (d2 <= 0.0) {
                    bl = false;
                }
            }
            if (!bl) {
                SGUtility.showMessageDialog(this, "Input value is invalid.", "Error", 0);
                return false;
            }
        }
        return super.onOK();
    }

    public void setVisible(boolean bl) {
        this.updateComponents();
        super.setVisible(bl);
    }

    private void updateComponents() {
        this.mSamplingRateField.setEnabled(this.mSamplingXYRadioButton.isSelected());
        boolean bl = this.mVectorXYRadioButton.isSelected();
        this.mPolarRadioButton.setEnabled(bl);
        this.mOrthogonalRadioButton.setEnabled(bl);
    }

    protected JButton getPreviousButton() {
        return this.mPreviousButton;
    }

    protected JButton getNextButton() {
        return this.mNextButton;
    }

    protected JButton getOKButton() {
        return this.mOKButton;
    }

    protected JButton getCancelButton() {
        return this.mCancelButton;
    }
}

