/*
 * Decompiled with CFR 0.152.
 */
package jp.riken.brain.ni.samuraigraph.data;

import java.io.IOException;
import java.io.Writer;
import jp.riken.brain.ni.samuraigraph.base.SGData;
import jp.riken.brain.ni.samuraigraph.base.SGUtility;
import jp.riken.brain.ni.samuraigraph.base.SGUtilityText;
import jp.riken.brain.ni.samuraigraph.data.SGISXYTypeData;

public class SGSXYData
extends SGData
implements SGISXYTypeData,
Cloneable {
    protected double[] mXValueArray = null;
    protected double[] mYValueArray = null;
    protected double[] mLowerErrorArray = null;
    protected double[] mUpperErrorArray = null;
    protected String[] mStringArray = null;

    public SGSXYData() {
    }

    public SGSXYData(String[] stringArray, double[] dArray, double[] dArray2) {
        this(stringArray, dArray, dArray2, null, null, null);
    }

    public SGSXYData(String[] stringArray, double[] dArray, double[] dArray2, double[] dArray3, double[] dArray4) {
        this(stringArray, dArray, dArray2, dArray3, dArray4, null);
    }

    public SGSXYData(String[] stringArray, double[] dArray, double[] dArray2, String[] stringArray2) {
        this(stringArray, dArray, dArray2, null, null, stringArray2);
    }

    public SGSXYData(String[] stringArray, double[] dArray, double[] dArray2, double[] dArray3, double[] dArray4, String[] stringArray2) {
        this.setTitle(stringArray);
        if (dArray == null || dArray2 == null) {
            throw new IllegalArgumentException("xValueArray==null || yValueArray==null");
        }
        if (dArray.length != dArray2.length) {
            throw new IllegalArgumentException("xValueArray.length!=yValueArray.length");
        }
        this.mXValueArray = SGUtility.copyDoubleArray(dArray);
        this.mYValueArray = SGUtility.copyDoubleArray(dArray2);
        if (dArray3 != null && dArray4 != null) {
            if (dArray3.length != dArray.length) {
                throw new IllegalArgumentException("lowerErrorArray.length!=xValueArray.length");
            }
            if (dArray4.length != dArray.length) {
                throw new IllegalArgumentException("upperErrorArray.length!=xValueArray.length");
            }
            this.mLowerErrorArray = SGUtility.copyDoubleArray(dArray3);
            this.mUpperErrorArray = SGUtility.copyDoubleArray(dArray4);
        }
        if (stringArray2 != null) {
            if (stringArray2.length != dArray.length) {
                throw new IllegalArgumentException("stringArray.length!=xValueArray.length");
            }
            this.mStringArray = SGUtility.copyStringArray(stringArray2);
        }
    }

    public SGSXYData(SGData sGData) {
        this.setData(sGData);
    }

    public boolean setData(SGData sGData) {
        if (!(sGData instanceof SGSXYData)) {
            throw new IllegalArgumentException("!(data instanceof SGSXYData)");
        }
        SGSXYData sGSXYData = (SGSXYData)sGData;
        this.setTitle(sGSXYData.getTitleArray());
        this.mXValueArray = sGSXYData.getXValueArray();
        this.mYValueArray = sGSXYData.getYValueArray();
        this.mLowerErrorArray = sGSXYData.getLowerErrorValueArray();
        this.mUpperErrorArray = sGSXYData.getUpperErrorValueArray();
        this.mStringArray = sGSXYData.getStringArray();
        return true;
    }

    public int getPointsNumber() {
        if (this.mXValueArray == null) {
            return -1;
        }
        return this.mXValueArray.length;
    }

    public String getDataType() {
        return "SXY";
    }

    public double getMinValueX() {
        double d = Double.MAX_VALUE;
        double[] dArray = this.mXValueArray;
        for (int i = 0; i < dArray.length; ++i) {
            double d2 = dArray[i];
            if (!(d2 < d)) continue;
            d = d2;
        }
        return d;
    }

    public double getMaxValueX() {
        double d = -1.7976931348623157E308;
        double[] dArray = this.mXValueArray;
        for (int i = 0; i < dArray.length; ++i) {
            double d2 = dArray[i];
            if (!(d2 > d)) continue;
            d = d2;
        }
        return d;
    }

    public double getMinValueY() {
        double d = Double.MAX_VALUE;
        double[] dArray = this.mYValueArray;
        if (this.mLowerErrorArray != null) {
            double[] dArray2 = this.mLowerErrorArray;
            for (int i = 0; i < dArray.length; ++i) {
                double d2 = dArray[i] + dArray2[i];
                if (!(d2 < d)) continue;
                d = d2;
            }
        } else {
            for (int i = 0; i < dArray.length; ++i) {
                double d3 = dArray[i];
                if (!(d3 < d)) continue;
                d = d3;
            }
        }
        return d;
    }

    public double getMaxValueY() {
        double d = -1.7976931348623157E308;
        double[] dArray = this.mYValueArray;
        if (this.mUpperErrorArray != null) {
            double[] dArray2 = this.mUpperErrorArray;
            for (int i = 0; i < dArray.length; ++i) {
                double d2 = dArray[i] + dArray2[i];
                if (!(d2 > d)) continue;
                d = d2;
            }
        } else {
            for (int i = 0; i < dArray.length; ++i) {
                double d3 = dArray[i];
                if (!(d3 > d)) continue;
                d = d3;
            }
        }
        return d;
    }

    public Double getXValue(int n) {
        return new Double(this.mXValueArray[n]);
    }

    public Double getYValue(int n) {
        return new Double(this.mYValueArray[n]);
    }

    public Double getLowerErrorValue(int n) {
        if (this.isErrorValueHolding()) {
            return new Double(this.mLowerErrorArray[n]);
        }
        return null;
    }

    public Double getUpperErrorValue(int n) {
        if (this.isErrorValueHolding()) {
            return new Double(this.mUpperErrorArray[n]);
        }
        return null;
    }

    public String getString(int n) {
        if (this.isStringArrayHolding()) {
            return this.mStringArray[n];
        }
        return null;
    }

    public double[] getXValueArray() {
        return SGUtility.copyDoubleArray(this.mXValueArray);
    }

    public double[] getYValueArray() {
        return SGUtility.copyDoubleArray(this.mYValueArray);
    }

    public double[] getLowerErrorValueArray() {
        if (this.isErrorValueHolding()) {
            return SGUtility.copyDoubleArray(this.mLowerErrorArray);
        }
        return null;
    }

    public double[] getUpperErrorValueArray() {
        if (this.isErrorValueHolding()) {
            return SGUtility.copyDoubleArray(this.mUpperErrorArray);
        }
        return null;
    }

    public String[] getStringArray() {
        if (this.isStringArrayHolding()) {
            return SGUtility.copyStringArray(this.mStringArray);
        }
        return null;
    }

    public boolean isErrorValueHolding() {
        return this.mLowerErrorArray != null;
    }

    public boolean isStringArrayHolding() {
        return this.mStringArray != null;
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }

    public Object copy() {
        return this.clone();
    }

    public void dispose() {
        super.dispose();
        this.mXValueArray = null;
        this.mYValueArray = null;
        this.mLowerErrorArray = null;
        this.mUpperErrorArray = null;
        this.mStringArray = null;
    }

    protected boolean writeData(Writer writer) throws IOException {
        if (this.mXValueArray == null || this.mXValueArray.length == 0) {
            return false;
        }
        for (int i = 0; i < this.mXValueArray.length; ++i) {
            String string = this.mXValueArray[i] + "," + this.mYValueArray[i];
            if (this.mUpperErrorArray != null) {
                string = string + "," + this.mUpperErrorArray[i] + "," + this.mLowerErrorArray[i];
            }
            if (this.mStringArray != null) {
                string = string + "," + SGUtilityText.getCSVString(this.mStringArray[i]);
            }
            string = string + "\n";
            writer.write(string);
        }
        return true;
    }
}

