/*
 * Decompiled with CFR 0.152.
 */
package jp.riken.brain.ni.samuraigraph.figure;

import java.awt.Color;
import java.io.Serializable;
import java.util.List;
import jp.riken.brain.ni.samuraigraph.base.SGDrawingElement;
import jp.riken.brain.ni.samuraigraph.base.SGProperties;
import jp.riken.brain.ni.samuraigraph.base.SGTuple2f;
import jp.riken.brain.ni.samuraigraph.base.SGUtilityText;
import jp.riken.brain.ni.samuraigraph.figure.SGDrawingElementLine;
import jp.riken.brain.ni.samuraigraph.figure.SGIRectangleConstants;
import org.w3c.dom.Element;

public abstract class SGDrawingElementRectangle
extends SGDrawingElement
implements SGIRectangleConstants {
    private float mX;
    private float mY;
    private float mWidth;
    private float mHeight;
    private float mEdgeLineWidth;
    private int mEdgeLineType;
    private Color mEdgeLineColor;
    private boolean mTransparentFlag;
    private int mCap = 0;
    private int mJoin = 1;
    private float mMiterLimit = 1.0f;
    private float mDashPhase = 0.0f;

    public void dispose() {
        super.dispose();
        this.mEdgeLineColor = null;
    }

    public float getX() {
        return this.mX;
    }

    public float getY() {
        return this.mY;
    }

    public SGTuple2f getLocation() {
        return new SGTuple2f(this.getX(), this.getY());
    }

    public float getWidth() {
        return this.mWidth;
    }

    public float getHeight() {
        return this.mHeight;
    }

    public float getEdgeLineWidth() {
        return this.mEdgeLineWidth;
    }

    public Color getEdgeLineColor() {
        return this.mEdgeLineColor;
    }

    public int getEdgeLineType() {
        return this.mEdgeLineType;
    }

    public boolean isTransparent() {
        return this.mTransparentFlag;
    }

    protected int getStrokeCap() {
        return this.mCap;
    }

    protected int getStrokeJoin() {
        return this.mJoin;
    }

    protected float getStrokeMiterLimit() {
        return this.mMiterLimit;
    }

    protected float getStrokeDashPhase() {
        return this.mDashPhase;
    }

    public boolean setEdgeLineWidth(float f) {
        this.mEdgeLineWidth = f;
        return true;
    }

    public boolean setEdgeLineWidth(float f, String string) {
        return this.setEdgeLineWidth((float)SGUtilityText.convertToPoint(f, string));
    }

    public boolean setEdgeLineType(int n) {
        this.mEdgeLineType = n;
        return true;
    }

    public boolean setEdgeLineColor(Color color) {
        this.mEdgeLineColor = color;
        return true;
    }

    public boolean setTransparent(boolean bl) {
        this.mTransparentFlag = bl;
        return true;
    }

    public boolean setX(float f) {
        this.mX = f;
        return true;
    }

    public boolean setY(float f) {
        this.mY = f;
        return true;
    }

    public boolean setLocation(float f, float f2) {
        this.setX(f);
        this.setY(f2);
        return true;
    }

    public boolean setLocation(SGTuple2f sGTuple2f) {
        this.setLocation(sGTuple2f.x, sGTuple2f.y);
        return true;
    }

    public boolean setWidth(float f) {
        this.mWidth = f;
        return true;
    }

    public boolean setWidth(float f, String string) {
        return this.setWidth((float)SGUtilityText.convertToPoint(f, string));
    }

    public boolean setHeight(float f) {
        this.mHeight = f;
        return true;
    }

    public boolean setHeight(float f, String string) {
        return this.setHeight((float)SGUtilityText.convertToPoint(f, string));
    }

    public boolean setSize(float f, float f2) {
        this.setWidth(f);
        this.setHeight(f2);
        return true;
    }

    public boolean setBounds(float f, float f2, float f3, float f4) {
        this.setLocation(f, f2);
        this.setSize(f3, f4);
        return true;
    }

    public SGProperties getProperties() {
        RectangleProperties rectangleProperties = new RectangleProperties();
        if (!this.getProperties(rectangleProperties)) {
            return null;
        }
        return rectangleProperties;
    }

    public boolean getProperties(SGProperties sGProperties) {
        if (!(sGProperties instanceof RectangleProperties)) {
            return false;
        }
        if (!super.getProperties(sGProperties)) {
            return false;
        }
        RectangleProperties rectangleProperties = (RectangleProperties)sGProperties;
        rectangleProperties.setHeight(this.getHeight());
        rectangleProperties.setWidth(this.getWidth());
        rectangleProperties.setEdgeLineWidth(this.getEdgeLineWidth());
        rectangleProperties.setEdgeLineType(this.getEdgeLineType());
        rectangleProperties.setEdgeLineColor(this.getEdgeLineColor());
        rectangleProperties.setTransparent(this.isTransparent());
        return true;
    }

    public boolean setProperties(SGProperties sGProperties) {
        if (!(sGProperties instanceof RectangleProperties)) {
            return false;
        }
        if (!super.setProperties(sGProperties)) {
            return false;
        }
        RectangleProperties rectangleProperties = (RectangleProperties)sGProperties;
        Float f = rectangleProperties.getWidth();
        if (f == null) {
            return false;
        }
        this.setWidth(f.floatValue());
        Float f2 = rectangleProperties.getHeight();
        if (f2 == null) {
            return false;
        }
        this.setHeight(f2.floatValue());
        Float f3 = rectangleProperties.getEdgeLineWidth();
        if (f3 == null) {
            return false;
        }
        this.setEdgeLineWidth(f3.floatValue());
        int n = rectangleProperties.getEdgeLineType();
        if (n == -1) {
            return false;
        }
        this.setEdgeLineType(n);
        Color color = rectangleProperties.getEdgeLineColor();
        if (color == null) {
            return false;
        }
        this.setEdgeLineColor(color);
        this.setTransparent(rectangleProperties.isTransparent());
        return true;
    }

    public boolean writeProperty(Element element) {
        element.setAttribute("EdgeLineWidth", Float.toString(this.mEdgeLineWidth) + "pt");
        element.setAttribute("EdgeLineType", SGDrawingElementLine.getLineTypeName(this.getEdgeLineType()));
        element.setAttribute("Transparent", Boolean.toString(this.isTransparent()));
        element.setAttribute("InnerColor", SGUtilityText.getColorListString(this.getColorList()));
        element.setAttribute("EdgeLineColor", SGUtilityText.getColorString(this.mEdgeLineColor));
        return true;
    }

    public boolean readProperty(Element element) {
        Serializable serializable;
        String string = null;
        Number number = null;
        Color color = null;
        Boolean bl = null;
        List list = null;
        string = element.getAttribute("EdgeLineWidth");
        if (string.length() != 0) {
            serializable = new StringBuffer();
            number = SGUtilityText.getNumber(string, serializable);
            if (number == null) {
                return false;
            }
            float f = number.floatValue();
            if (!this.setEdgeLineWidth(f, serializable.toString())) {
                return false;
            }
        }
        if ((string = element.getAttribute("EdgeLineType")).length() != 0) {
            number = SGDrawingElementLine.getLineTypeFromName(string);
            if (number == null) {
                return false;
            }
            int n = number.intValue();
            if (!this.setEdgeLineType(n)) {
                return false;
            }
        }
        if ((string = element.getAttribute("Transparent")).length() != 0) {
            bl = SGUtilityText.getBoolean(string);
            if (bl == null) {
                return false;
            }
            boolean bl2 = bl;
            if (!this.setTransparent(bl2)) {
                return false;
            }
        }
        if ((string = element.getAttribute("InnerColor")).length() != 0) {
            list = SGUtilityText.getColorList(string);
            if (list == null) {
                return false;
            }
            if (!this.setColorList(list)) {
                return false;
            }
        }
        if ((string = element.getAttribute("EdgeLineColor")).length() != 0) {
            color = SGUtilityText.getColorFromString(string);
            if (color == null) {
                return false;
            }
            serializable = color;
            if (!this.setEdgeLineColor((Color)serializable)) {
                return false;
            }
        }
        return true;
    }

    public static class RectangleProperties
    extends SGDrawingElement.DrawingElementProperties {
        private float mWidth = 0.0f;
        private float mHeight = 0.0f;
        private float mEdgeLineWidth = 0.0f;
        private int mEdgeLineType = -1;
        private Color mEdgeLineColor = null;
        private boolean mTransparent = false;

        public boolean equals(Object object) {
            if (!(object instanceof RectangleProperties)) {
                return false;
            }
            if (!super.equals(object)) {
                return false;
            }
            RectangleProperties rectangleProperties = (RectangleProperties)object;
            if (this.mWidth != rectangleProperties.mWidth) {
                return false;
            }
            if (this.mHeight != rectangleProperties.mHeight) {
                return false;
            }
            if (this.mEdgeLineWidth != rectangleProperties.mEdgeLineWidth) {
                return false;
            }
            if (this.mEdgeLineType != rectangleProperties.mEdgeLineType) {
                return false;
            }
            if (!this.mEdgeLineColor.equals(rectangleProperties.mEdgeLineColor)) {
                return false;
            }
            return this.mTransparent == rectangleProperties.mTransparent;
        }

        public Float getWidth() {
            return new Float(this.mWidth);
        }

        public Float getHeight() {
            return new Float(this.mHeight);
        }

        public Float getEdgeLineWidth() {
            return new Float(this.mEdgeLineWidth);
        }

        public int getEdgeLineType() {
            return this.mEdgeLineType;
        }

        public Color getEdgeLineColor() {
            return this.mEdgeLineColor;
        }

        public boolean isTransparent() {
            return this.mTransparent;
        }

        public boolean setWidth(float f) {
            this.mWidth = f;
            return true;
        }

        public boolean setHeight(float f) {
            this.mHeight = f;
            return true;
        }

        public boolean setEdgeLineWidth(float f) {
            if (f < 0.0f) {
                throw new IllegalArgumentException("width<0.0f");
            }
            this.mEdgeLineWidth = f;
            return true;
        }

        public boolean setEdgeLineType(int n) {
            this.mEdgeLineType = n;
            return true;
        }

        public boolean setEdgeLineColor(Color color) {
            if (color == null) {
                throw new IllegalArgumentException("cl==null");
            }
            this.mEdgeLineColor = color;
            return true;
        }

        public boolean setTransparent(boolean bl) {
            this.mTransparent = bl;
            return true;
        }
    }
}

