/*
 * Decompiled with CFR 0.152.
 */
package jp.riken.brain.ni.samuraigraph.figure;

import java.awt.Color;
import jp.riken.brain.ni.samuraigraph.base.SGDrawingElement;
import jp.riken.brain.ni.samuraigraph.base.SGIDrawingElementConstants;
import jp.riken.brain.ni.samuraigraph.base.SGProperties;
import jp.riken.brain.ni.samuraigraph.base.SGTuple2f;
import jp.riken.brain.ni.samuraigraph.base.SGUtilityText;
import jp.riken.brain.ni.samuraigraph.figure.SGISymbolConstants;

public abstract class SGDrawingElementSymbol
extends SGDrawingElement
implements SGISymbolConstants,
SGIDrawingElementConstants {
    private SGTuple2f mLocation = new SGTuple2f();
    private float mSize;
    private int mType;
    private float mAngle;
    private Color mLineColor;
    private float mLineWidth;

    public void dispose() {
        super.dispose();
        this.mLocation = null;
        this.mLineColor = null;
    }

    public boolean setX(float f) {
        this.mLocation.setX(f);
        return true;
    }

    public boolean setY(float f) {
        this.mLocation.setY(f);
        return true;
    }

    public boolean setLocation(float f, float f2) {
        this.mLocation.setValues(f, f2);
        return true;
    }

    public boolean setLocation(SGTuple2f sGTuple2f) {
        this.mLocation = sGTuple2f;
        return true;
    }

    public boolean setSize(float f) {
        this.mSize = f;
        return true;
    }

    public boolean setSize(float f, String string) {
        double d = SGUtilityText.convertToPoint(f, string);
        return this.setSize((float)d);
    }

    public boolean setType(int n) {
        this.mType = n;
        return true;
    }

    public boolean setAngle(float f) {
        this.mAngle = f;
        return true;
    }

    public boolean setLineColor(Color color) {
        this.mLineColor = color;
        return true;
    }

    public boolean setLineWidth(float f) {
        this.mLineWidth = f;
        return true;
    }

    public boolean setLineWidth(float f, String string) {
        double d = SGUtilityText.convertToPoint(f, string);
        return this.setLineWidth((float)d);
    }

    public SGTuple2f getLocation() {
        return new SGTuple2f(this.mLocation);
    }

    public float getX() {
        return this.mLocation.x;
    }

    public float getY() {
        return this.mLocation.y;
    }

    public float getSize() {
        return this.mSize;
    }

    public int getType() {
        return this.mType;
    }

    public float getAngle() {
        return this.mAngle;
    }

    public Color getLineColor() {
        return this.mLineColor;
    }

    public float getLineWidth() {
        return this.mLineWidth;
    }

    public static Integer getSymbolTypeFromName(String string) {
        int n;
        if (string == null) {
            return null;
        }
        String string2 = string.toLowerCase();
        if (string2.equals("No Symbol".toLowerCase())) {
            n = -1;
        } else if (string2.equals("Circle".toLowerCase())) {
            n = 1;
        } else if (string2.equals("Square".toLowerCase())) {
            n = 2;
        } else if (string2.equals("Diamond".toLowerCase())) {
            n = 3;
        } else if (string2.equals("Triangle".toLowerCase())) {
            n = 4;
        } else if (string2.equals("Inverted Triangle".toLowerCase()) | string2.equals("I-Triangle".toLowerCase())) {
            n = 5;
        } else if (string2.equals("Cross".toLowerCase())) {
            n = 6;
        } else if (string2.equals("Plus".toLowerCase())) {
            n = 7;
        } else if (string2.equals("Transverse Line".toLowerCase())) {
            n = 8;
        } else {
            return null;
        }
        return new Integer(n);
    }

    public static String getSymbolTypeName(int n) {
        String string = null;
        switch (n) {
            case -1: {
                string = "No Symbol";
                break;
            }
            case 1: {
                string = "Circle";
                break;
            }
            case 2: {
                string = "Square";
                break;
            }
            case 3: {
                string = "Diamond";
                break;
            }
            case 4: {
                string = "Triangle";
                break;
            }
            case 5: {
                string = "Inverted Triangle";
                break;
            }
            case 6: {
                string = "Cross";
                break;
            }
            case 7: {
                string = "Plus";
                break;
            }
            case 8: {
                string = "Transverse Line";
                break;
            }
        }
        return string;
    }

    public static boolean isLineTypeSymbol(int n) {
        return n == 6 | n == 7 | n == 8;
    }

    public SGProperties getProperties() {
        SymbolProperties symbolProperties = new SymbolProperties();
        this.getProperties(symbolProperties);
        return symbolProperties;
    }

    public boolean getProperties(SGProperties sGProperties) {
        if (sGProperties == null) {
            return false;
        }
        if (!(sGProperties instanceof SymbolProperties)) {
            return false;
        }
        super.getProperties(sGProperties);
        SymbolProperties symbolProperties = (SymbolProperties)sGProperties;
        symbolProperties.setSize(this.getSize());
        symbolProperties.setSymbolType(this.getType());
        symbolProperties.setLineWidth(this.getLineWidth());
        symbolProperties.setLineColor(this.getLineColor());
        return true;
    }

    public static class SymbolProperties
    extends SGDrawingElement.DrawingElementProperties {
        private int mType = -1;
        private float mSize = 0.0f;
        private float mLineWidth = 0.0f;
        private Color mLineColor = null;

        public boolean equals(Object object) {
            if (!(object instanceof SymbolProperties)) {
                return false;
            }
            if (!super.equals(object)) {
                return false;
            }
            SymbolProperties symbolProperties = (SymbolProperties)object;
            if (symbolProperties.mType != this.mType) {
                return false;
            }
            if (symbolProperties.mSize != this.mSize) {
                return false;
            }
            if (symbolProperties.mLineWidth != this.mLineWidth) {
                return false;
            }
            return symbolProperties.mLineColor.equals(this.mLineColor);
        }

        public Float getSize() {
            return new Float(this.mSize);
        }

        public Integer getSymbolType() {
            return new Integer(this.mType);
        }

        public Float getLineWidth() {
            return new Float(this.mLineWidth);
        }

        public Color getLineColor() {
            return this.mLineColor;
        }

        public boolean setSize(float f) {
            if (f < 0.0f) {
                return false;
            }
            this.mSize = f;
            return true;
        }

        public boolean setSymbolType(int n) {
            this.mType = n;
            return true;
        }

        public boolean setLineWidth(float f) {
            if (f < 0.0f) {
                return false;
            }
            this.mLineWidth = f;
            return true;
        }

        public boolean setLineColor(Color color) {
            if (color == null) {
                return false;
            }
            this.mLineColor = color;
            return true;
        }
    }
}

