/*
 * Decompiled with CFR 0.152.
 */
package jp.riken.brain.ni.samuraigraph.figure.java2d;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSeparator;
import javax.swing.SpinnerNumberModel;
import javax.swing.border.TitledBorder;
import jp.riken.brain.ni.samuraigraph.base.SGCheckBox;
import jp.riken.brain.ni.samuraigraph.base.SGComponentGroup;
import jp.riken.brain.ni.samuraigraph.base.SGComponentGroupElement;
import jp.riken.brain.ni.samuraigraph.base.SGIDisposable;
import jp.riken.brain.ni.samuraigraph.base.SGPropertyPanel;
import jp.riken.brain.ni.samuraigraph.base.SGSpinner;
import jp.riken.brain.ni.samuraigraph.base.SGTextField;
import jp.riken.brain.ni.samuraigraph.base.SGUtility;
import jp.riken.brain.ni.samuraigraph.base.SGUtilityText;
import jp.riken.brain.ni.samuraigraph.figure.SGIAxisConstants;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGIAxisPanelObserver;

public class SGAxisPanel
extends SGPropertyPanel
implements ActionListener,
SGIDisposable,
SGIAxisConstants {
    public static final String MSG_RANGE_ERROR = "Axis range is invalid.";
    public static final String MSG_STEP_ERROR = "Zero value is set to the step value.";
    private String mConfiguration;
    private SGCheckBox mAutoTickMarkCheckBox;
    private SGCheckBox mAxisVisibleCheckBox;
    private JLabel mBaseLabel;
    private SGTextField mBaseTextField;
    private SGCheckBox mExponentCheckBox;
    private JLabel mExponentLabel;
    private SGSpinner mExponentSpinner;
    private JLabel mFormatLabel;
    private JSeparator mFormatSeparator;
    private SGCheckBox mFormatVisibleCheckBox;
    private JRadioButton mInnerRadioButton;
    private SGCheckBox mIntegerCheckBox;
    private SGCheckBox mInvertCoordinatesCheckBox;
    private JLabel mLeftSpaceLabel;
    private JRadioButton mLinearRadioButton;
    private JRadioButton mLogRadioButton;
    private JLabel mMaxLabel;
    private SGTextField mMaxValueTextField;
    private JLabel mMinLabel;
    private SGTextField mMinValueTextField;
    private JRadioButton mOuterRadioButton;
    private JLabel mRightSpaceLabel;
    private JPanel mScalePanel;
    private JLabel mStepLabel;
    private SGTextField mStepTextField;
    private JLabel mTickMarkLabel;
    private JSeparator mTickMarkSeparator;
    private SGCheckBox mTickMarkVisibleCheckBox;
    private JLabel mTitleLabel;
    private JLabel mTitleLeftSpaceLabel;
    private JPanel mTitlePanel;
    private JLabel mTitleRightSpaceLabel;
    private SGTextField mTitleTextField;
    private SGCheckBox mTitleVisibleCheckBox;
    private JRadioButton mScaleNoSelectedRadioButton = new JRadioButton();
    private JRadioButton mDirectionNoSelectedRadioButton = new JRadioButton();
    private SGComponentGroup mTitleComponentGroup = new SGComponentGroup();
    private SGComponentGroup mTickMarkComponentGroup = new SGComponentGroup();
    private SGComponentGroup mScaleTypeComponentGroup = new SGComponentGroup();
    private SGComponentGroup mExponentComponentGroup = new SGComponentGroup();
    private SGComponentGroup mFormatComponentGroup = new SGComponentGroup();
    private SGComponentGroup mAxisVisibleComponentGroup = new SGComponentGroup();
    public static final int AXIS_EXPONENT_STEP = 1;

    public SGAxisPanel(String string) {
        this.mConfiguration = string;
        this.initComponents();
        this.initProerty();
    }

    private void initComponents() {
        this.mScalePanel = new JPanel();
        this.mTickMarkLabel = new JLabel();
        this.mAutoTickMarkCheckBox = new SGCheckBox();
        this.mLinearRadioButton = new JRadioButton();
        this.mTickMarkVisibleCheckBox = new SGCheckBox();
        this.mTickMarkSeparator = new JSeparator();
        this.mLogRadioButton = new JRadioButton();
        this.mMinLabel = new JLabel();
        this.mMaxLabel = new JLabel();
        this.mMinValueTextField = new SGTextField();
        this.mMaxValueTextField = new SGTextField();
        this.mBaseLabel = new JLabel();
        this.mBaseTextField = new SGTextField();
        this.mStepTextField = new SGTextField();
        this.mStepLabel = new JLabel();
        this.mLeftSpaceLabel = new JLabel();
        this.mRightSpaceLabel = new JLabel();
        this.mOuterRadioButton = new JRadioButton();
        this.mInnerRadioButton = new JRadioButton();
        this.mExponentLabel = new JLabel();
        this.mIntegerCheckBox = new SGCheckBox();
        this.mExponentCheckBox = new SGCheckBox();
        this.mFormatVisibleCheckBox = new SGCheckBox();
        this.mFormatLabel = new JLabel();
        this.mFormatSeparator = new JSeparator();
        this.mExponentSpinner = new SGSpinner();
        this.mInvertCoordinatesCheckBox = new SGCheckBox();
        this.mTitlePanel = new JPanel();
        this.mTitleVisibleCheckBox = new SGCheckBox();
        this.mTitleTextField = new SGTextField();
        this.mTitleLabel = new JLabel();
        this.mTitleLeftSpaceLabel = new JLabel();
        this.mTitleRightSpaceLabel = new JLabel();
        this.mAxisVisibleCheckBox = new SGCheckBox();
        this.setLayout(new GridBagLayout());
        this.mScalePanel.setLayout(new GridBagLayout());
        this.mScalePanel.setBorder(new TitledBorder(null, "Scale", 0, 0, new Font("Dialog", 1, 12)));
        this.mScalePanel.setFont(new Font("SansSerif", 0, 11));
        this.mTickMarkLabel.setFont(new Font("Dialog", 3, 12));
        this.mTickMarkLabel.setText("Tick Mark");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.mScalePanel.add((Component)this.mTickMarkLabel, gridBagConstraints);
        this.mAutoTickMarkCheckBox.setText("Auto");
        this.mAutoTickMarkCheckBox.setFont(new Font("Dialog", 0, 12));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 10, 0, 5);
        this.mScalePanel.add((Component)this.mAutoTickMarkCheckBox, gridBagConstraints);
        this.mLinearRadioButton.setFont(new Font("Dialog", 0, 12));
        this.mLinearRadioButton.setText("Linear");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 20, 0, 5);
        this.mScalePanel.add((Component)this.mLinearRadioButton, gridBagConstraints);
        this.mTickMarkVisibleCheckBox.setText("Visible");
        this.mTickMarkVisibleCheckBox.setFont(new Font("Dialog", 0, 12));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 20, 0, 5);
        this.mScalePanel.add((Component)this.mTickMarkVisibleCheckBox, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 25, 5, 5);
        this.mScalePanel.add((Component)this.mTickMarkSeparator, gridBagConstraints);
        this.mLogRadioButton.setFont(new Font("Dialog", 0, 12));
        this.mLogRadioButton.setText("Log");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 6;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 5, 0, 5);
        this.mScalePanel.add((Component)this.mLogRadioButton, gridBagConstraints);
        this.mMinLabel.setFont(new Font("Dialog", 0, 12));
        this.mMinLabel.setText("Min");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 15, 5, 5);
        this.mScalePanel.add((Component)this.mMinLabel, gridBagConstraints);
        this.mMaxLabel.setFont(new Font("Dialog", 0, 12));
        this.mMaxLabel.setText("Max");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 15, 5, 5);
        this.mScalePanel.add((Component)this.mMaxLabel, gridBagConstraints);
        this.mMinValueTextField.setColumns(6);
        this.mMinValueTextField.setFont(new Font("Dialog", 0, 12));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.mScalePanel.add((Component)this.mMinValueTextField, gridBagConstraints);
        this.mMaxValueTextField.setColumns(6);
        this.mMaxValueTextField.setFont(new Font("Dialog", 0, 12));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.mScalePanel.add((Component)this.mMaxValueTextField, gridBagConstraints);
        this.mBaseLabel.setFont(new Font("Dialog", 0, 12));
        this.mBaseLabel.setText("Base");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 15, 5, 5);
        this.mScalePanel.add((Component)this.mBaseLabel, gridBagConstraints);
        this.mBaseTextField.setColumns(6);
        this.mBaseTextField.setFont(new Font("Dialog", 0, 12));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 5, 5, 5);
        this.mScalePanel.add((Component)this.mBaseTextField, gridBagConstraints);
        this.mStepTextField.setColumns(6);
        this.mStepTextField.setFont(new Font("Dialog", 0, 12));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 5, 5, 5);
        this.mScalePanel.add((Component)this.mStepTextField, gridBagConstraints);
        this.mStepLabel.setFont(new Font("Dialog", 0, 12));
        this.mStepLabel.setText("Step");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 15, 5, 5);
        this.mScalePanel.add((Component)this.mStepLabel, gridBagConstraints);
        this.mLeftSpaceLabel.setFont(new Font("MS Sans Serif", 0, 12));
        this.mLeftSpaceLabel.setText("    ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        this.mScalePanel.add((Component)this.mLeftSpaceLabel, gridBagConstraints);
        this.mRightSpaceLabel.setFont(new Font("MS Sans Serif", 0, 12));
        this.mRightSpaceLabel.setText("    ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 7;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(5, 5, 0, 5);
        this.mScalePanel.add((Component)this.mRightSpaceLabel, gridBagConstraints);
        this.mOuterRadioButton.setFont(new Font("Dialog", 0, 12));
        this.mOuterRadioButton.setText("Outer");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 6;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 5, 5, 5);
        this.mScalePanel.add((Component)this.mOuterRadioButton, gridBagConstraints);
        this.mInnerRadioButton.setFont(new Font("Dialog", 0, 12));
        this.mInnerRadioButton.setText("Inner");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 20, 5, 5);
        this.mScalePanel.add((Component)this.mInnerRadioButton, gridBagConstraints);
        this.mExponentLabel.setFont(new Font("Dialog", 1, 14));
        this.mExponentLabel.setText("10");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(0, 10, 0, 0);
        this.mScalePanel.add((Component)this.mExponentLabel, gridBagConstraints);
        this.mIntegerCheckBox.setText("Integer");
        this.mIntegerCheckBox.setFont(new Font("Dialog", 0, 12));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 15, 5, 5);
        this.mScalePanel.add((Component)this.mIntegerCheckBox, gridBagConstraints);
        this.mExponentCheckBox.setText("Exp Part");
        this.mExponentCheckBox.setFont(new Font("Dialog", 0, 12));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 15, 5, 5);
        this.mScalePanel.add((Component)this.mExponentCheckBox, gridBagConstraints);
        this.mFormatVisibleCheckBox.setText("Visible");
        this.mFormatVisibleCheckBox.setFont(new Font("Dialog", 0, 12));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 15, 5, 5);
        this.mScalePanel.add((Component)this.mFormatVisibleCheckBox, gridBagConstraints);
        this.mFormatLabel.setFont(new Font("Dialog", 3, 12));
        this.mFormatLabel.setText("Format ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.mScalePanel.add((Component)this.mFormatLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(5, 0, 5, 5);
        this.mScalePanel.add((Component)this.mFormatSeparator, gridBagConstraints);
        this.mExponentSpinner.setFont(new Font("Dialog", 0, 10));
        this.mExponentSpinner.setPreferredSize(new Dimension(40, 20));
        this.mExponentSpinner.setValue(new Integer(0));
        this.mExponentSpinner.setVerifyInputWhenFocusTarget(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.anchor = 17;
        this.mScalePanel.add((Component)this.mExponentSpinner, gridBagConstraints);
        this.mInvertCoordinatesCheckBox.setText("Invert Coordinates");
        this.mInvertCoordinatesCheckBox.setFont(new Font("Dialog", 0, 12));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 20, 0, 0);
        this.mScalePanel.add((Component)this.mInvertCoordinatesCheckBox, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.add((Component)this.mScalePanel, gridBagConstraints);
        this.mTitlePanel.setLayout(new GridBagLayout());
        this.mTitlePanel.setBorder(new TitledBorder(null, "Title", 0, 0, new Font("Dialog", 1, 12)));
        this.mTitlePanel.setFont(new Font("SansSerif", 0, 11));
        this.mTitleVisibleCheckBox.setText("Visible");
        this.mTitleVisibleCheckBox.setFont(new Font("Dialog", 0, 12));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 15, 5, 5);
        this.mTitlePanel.add((Component)this.mTitleVisibleCheckBox, gridBagConstraints);
        this.mTitleTextField.setColumns(8);
        this.mTitleTextField.setFont(new Font("Dialog", 0, 12));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.ipadx = 60;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.mTitlePanel.add((Component)this.mTitleTextField, gridBagConstraints);
        this.mTitleLabel.setFont(new Font("Dialog", 0, 12));
        this.mTitleLabel.setText("Label");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.mTitlePanel.add((Component)this.mTitleLabel, gridBagConstraints);
        this.mTitleLeftSpaceLabel.setFont(new Font("MS Sans Serif", 0, 12));
        this.mTitleLeftSpaceLabel.setText("    ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        this.mTitlePanel.add((Component)this.mTitleLeftSpaceLabel, gridBagConstraints);
        this.mTitleRightSpaceLabel.setFont(new Font("MS Sans Serif", 0, 12));
        this.mTitleRightSpaceLabel.setText("    ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 0;
        this.mTitlePanel.add((Component)this.mTitleRightSpaceLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.add((Component)this.mTitlePanel, gridBagConstraints);
        this.mAxisVisibleCheckBox.setText("Visible Axis");
        this.mAxisVisibleCheckBox.setFont(new Font("Dialog", 0, 12));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 16;
        gridBagConstraints.insets = new Insets(5, 5, 15, 5);
        this.add((Component)this.mAxisVisibleCheckBox, gridBagConstraints);
    }

    public void dispose() {
        this.mConfiguration = null;
        this.mScaleNoSelectedRadioButton = null;
        this.mDirectionNoSelectedRadioButton = null;
        this.mTitleComponentGroup.dispose();
        this.mTitleComponentGroup = null;
        this.mTickMarkComponentGroup.dispose();
        this.mTickMarkComponentGroup = null;
        this.mScaleTypeComponentGroup.dispose();
        this.mScaleTypeComponentGroup = null;
        this.mExponentComponentGroup.dispose();
        this.mExponentComponentGroup = null;
        this.mFormatComponentGroup.dispose();
        this.mFormatComponentGroup = null;
        this.mAxisVisibleComponentGroup.dispose();
        this.mAxisVisibleComponentGroup = null;
    }

    public String getConfiguration() {
        return this.mConfiguration;
    }

    public void setConfiguration(String string) {
        if (string == null) {
            throw new IllegalArgumentException("str==null");
        }
        this.mConfiguration = string;
    }

    public ArrayList getTextFieldComponentsList() {
        ArrayList<SGTextField> arrayList = new ArrayList<SGTextField>();
        arrayList.addAll(this.getNumberTextFieldList());
        arrayList.add(this.mTitleTextField);
        return arrayList;
    }

    public ArrayList getNumberTextFieldList() {
        ArrayList<SGTextField> arrayList = new ArrayList<SGTextField>();
        arrayList.add(this.mMinValueTextField);
        arrayList.add(this.mMaxValueTextField);
        arrayList.add(this.mBaseTextField);
        arrayList.add(this.mStepTextField);
        return arrayList;
    }

    private boolean initProerty() {
        Object object = new ButtonGroup();
        ((ButtonGroup)object).add(this.mLinearRadioButton);
        ((ButtonGroup)object).add(this.mLogRadioButton);
        ((ButtonGroup)object).add(this.mScaleNoSelectedRadioButton);
        object = new ButtonGroup();
        ((ButtonGroup)object).add(this.mInnerRadioButton);
        ((ButtonGroup)object).add(this.mOuterRadioButton);
        ((ButtonGroup)object).add(this.mDirectionNoSelectedRadioButton);
        this.mAxisVisibleCheckBox.addActionListener(this);
        this.mTitleVisibleCheckBox.addActionListener(this);
        this.mFormatVisibleCheckBox.addActionListener(this);
        this.mTickMarkVisibleCheckBox.addActionListener(this);
        this.mAutoTickMarkCheckBox.addActionListener(this);
        this.mExponentCheckBox.addActionListener(this);
        this.mLinearRadioButton.addActionListener(this);
        this.mLogRadioButton.addActionListener(this);
        this.mExponentSpinner.initProperties(new SpinnerNumberModel(0.0, -10.0, 10.0, 1.0), null, 0, 0);
        object = this.mConfiguration + "-> ";
        this.mTitleTextField.setDescription((String)object + "Title-> Label");
        this.mMinValueTextField.setDescription((String)object + "Scale-> Min");
        this.mMaxValueTextField.setDescription((String)object + "Scale-> Max");
        this.mStepTextField.setDescription((String)object + "Tick Mark-> Step");
        this.mBaseTextField.setDescription((String)object + "Tick Mark-> Base");
        this.mExponentSpinner.setDescription((String)object + "Format-> Exp Part");
        SGComponentGroupElement[] sGComponentGroupElementArray = new SGComponentGroupElement[]{new SGComponentGroupElement(this.mTitleLabel), new SGComponentGroupElement(this.mTitleTextField)};
        SGComponentGroupElement[] sGComponentGroupElementArray2 = new SGComponentGroupElement[]{new SGComponentGroupElement(this.mInnerRadioButton), new SGComponentGroupElement(this.mOuterRadioButton)};
        SGComponentGroupElement[] sGComponentGroupElementArray3 = new SGComponentGroupElement[]{new SGComponentGroupElement(this.mExponentLabel), new SGComponentGroupElement(this.mExponentSpinner)};
        SGComponentGroupElement[] sGComponentGroupElementArray4 = new SGComponentGroupElement[]{sGComponentGroupElementArray3[0], sGComponentGroupElementArray3[1], new SGComponentGroupElement(this.mIntegerCheckBox), new SGComponentGroupElement(this.mExponentCheckBox)};
        SGComponentGroupElement[] sGComponentGroupElementArray5 = new SGComponentGroupElement[]{new SGComponentGroupElement(this.mAutoTickMarkCheckBox), new SGComponentGroupElement(this.mStepLabel), new SGComponentGroupElement(this.mStepTextField), new SGComponentGroupElement(this.mBaseLabel), new SGComponentGroupElement(this.mBaseTextField), sGComponentGroupElementArray4[2]};
        SGComponentGroupElement[] sGComponentGroupElementArray6 = new SGComponentGroupElement[]{new SGComponentGroupElement(this.mTitleVisibleCheckBox), sGComponentGroupElementArray[0], sGComponentGroupElementArray[1], new SGComponentGroupElement(this.mMinLabel), new SGComponentGroupElement(this.mMinValueTextField), new SGComponentGroupElement(this.mMaxLabel), new SGComponentGroupElement(this.mMaxValueTextField), new SGComponentGroupElement(this.mLinearRadioButton), new SGComponentGroupElement(this.mLogRadioButton), new SGComponentGroupElement(this.mTickMarkLabel), sGComponentGroupElementArray5[0], sGComponentGroupElementArray5[1], sGComponentGroupElementArray5[2], sGComponentGroupElementArray5[3], sGComponentGroupElementArray5[4], new SGComponentGroupElement(this.mTickMarkVisibleCheckBox), sGComponentGroupElementArray2[0], sGComponentGroupElementArray2[1], new SGComponentGroupElement(this.mFormatLabel), new SGComponentGroupElement(this.mFormatVisibleCheckBox), sGComponentGroupElementArray4[0], sGComponentGroupElementArray4[1], sGComponentGroupElementArray4[2], sGComponentGroupElementArray4[3]};
        this.mTitleComponentGroup.addElement(sGComponentGroupElementArray);
        this.mTickMarkComponentGroup.addElement(sGComponentGroupElementArray2);
        this.mScaleTypeComponentGroup.addElement(sGComponentGroupElementArray5);
        this.mExponentComponentGroup.addElement(sGComponentGroupElementArray3);
        this.mFormatComponentGroup.addElement(sGComponentGroupElementArray4);
        this.mAxisVisibleComponentGroup.addElement(sGComponentGroupElementArray6);
        return true;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        Object object = actionEvent.getSource();
        if (object.equals(this.mAxisVisibleCheckBox)) {
            this.setAxisVisible(this.mAxisVisibleCheckBox.getSelected());
        } else if (object.equals(this.mTitleVisibleCheckBox)) {
            this.setTitleVisible(this.mTitleVisibleCheckBox.getSelected());
        } else if (object.equals(this.mFormatVisibleCheckBox)) {
            this.setFormatVisible(this.mFormatVisibleCheckBox.getSelected());
        } else if (object.equals(this.mTickMarkVisibleCheckBox)) {
            this.setTickMarkVisible(this.mTickMarkVisibleCheckBox.getSelected());
        } else if (object.equals(this.mLinearRadioButton) | object.equals(this.mLogRadioButton)) {
            boolean bl = this.getScaleType() == 0;
            this.mScaleTypeComponentGroup.setEnabled(bl);
        } else if (object.equals(this.mAutoTickMarkCheckBox)) {
            boolean bl = this.mAutoTickMarkCheckBox.isSelected();
            this.mStepTextField.setEditable(!bl);
            this.mBaseTextField.setEditable(!bl);
        } else if (object.equals(this.mExponentCheckBox)) {
            this.setExponentVisible(this.mExponentCheckBox.getSelected());
        }
    }

    private boolean setTitleComponentsEnabled(Boolean bl) {
        boolean bl2 = true;
        if (bl != null) {
            bl2 = bl;
        }
        this.mTitleComponentGroup.setEnabled(bl2);
        return true;
    }

    private boolean setExponentComponentEnabled(Boolean bl) {
        boolean bl2 = true;
        if (bl != null) {
            bl2 = bl;
        }
        this.mExponentComponentGroup.setEnabled(bl2);
        return true;
    }

    private boolean setScaleLineComponentsEnabled(Boolean bl) {
        boolean bl2 = true;
        if (bl != null) {
            bl2 = bl;
        }
        this.mTickMarkComponentGroup.setEnabled(bl2);
        return true;
    }

    public Integer getScaleType() {
        Integer n = null;
        if (this.mLinearRadioButton.isSelected()) {
            n = new Integer(0);
        } else if (this.mLogRadioButton.isSelected()) {
            n = new Integer(1);
        }
        return n;
    }

    public Number getMinValue() {
        String string = this.mMinValueTextField.getText();
        if (string.length() == 0) {
            return null;
        }
        return SGUtilityText.getDouble(string);
    }

    public Number getMaxValue() {
        String string = this.mMaxValueTextField.getText();
        if (string.length() == 0) {
            return null;
        }
        return SGUtilityText.getDouble(string);
    }

    public Boolean getInvCoordFlag() {
        return this.mInvertCoordinatesCheckBox.getSelected();
    }

    public Boolean getAutoCalcFlag() {
        return this.mAutoTickMarkCheckBox.getSelected();
    }

    public Number getStepValue() {
        String string = this.mStepTextField.getText();
        return SGUtilityText.getDouble(string);
    }

    public Number getBaseValue() {
        String string = this.mBaseTextField.getText();
        return SGUtilityText.getDouble(string);
    }

    public String getTitleString() {
        return this.mTitleTextField.getText();
    }

    public Boolean isAxisVisible() {
        return this.mAxisVisibleCheckBox.getSelected();
    }

    public Boolean isTitleVisible() {
        return this.mTitleVisibleCheckBox.getSelected();
    }

    public Boolean isFormatVisible() {
        return this.mFormatVisibleCheckBox.getSelected();
    }

    public Boolean isTickMarkVisible() {
        return this.mTickMarkVisibleCheckBox.getSelected();
    }

    public Boolean getScaleLineDirection() {
        Boolean bl = null;
        if (this.mInnerRadioButton.isSelected()) {
            bl = Boolean.TRUE;
        } else if (this.mOuterRadioButton.isSelected()) {
            bl = Boolean.FALSE;
        }
        return bl;
    }

    public Boolean isFormatInteger() {
        return this.mIntegerCheckBox.getSelected();
    }

    public Boolean isExponentVisible() {
        return this.mExponentCheckBox.getSelected();
    }

    public Number getExponentValue() {
        return this.mExponentSpinner.getNumber();
    }

    public boolean setTitle(String string) {
        if (string == null) {
            this.mTitleTextField.setText("");
            return true;
        }
        this.mTitleTextField.setText(string);
        return true;
    }

    public boolean setScaleType(Integer n) {
        if (n == null) {
            this.mScaleNoSelectedRadioButton.setSelected(true);
        } else {
            int n2 = n;
            switch (n2) {
                case 0: {
                    this.mLinearRadioButton.setSelected(true);
                    break;
                }
                case 1: {
                    this.mLogRadioButton.setSelected(true);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("The scale type is illegal.");
                }
            }
        }
        return true;
    }

    public boolean setAxisVisible(Boolean bl) {
        this.mAxisVisibleCheckBox.setSelected(bl);
        boolean bl2 = true;
        if (bl != null) {
            bl2 = bl;
        }
        this.mAxisVisibleComponentGroup.setEnabled(bl2);
        return true;
    }

    public boolean setTitleVisible(Boolean bl) {
        this.mTitleVisibleCheckBox.setSelected(bl);
        boolean bl2 = true;
        if (bl != null) {
            bl2 = bl;
        }
        this.mTitleComponentGroup.setEnabled(bl2);
        return true;
    }

    public boolean setTickMarkVisible(Boolean bl) {
        this.mTickMarkVisibleCheckBox.setSelected(bl);
        boolean bl2 = true;
        if (bl != null) {
            bl2 = bl;
        }
        this.mTickMarkComponentGroup.setEnabled(bl2);
        return true;
    }

    public boolean setTickMarkInside(Boolean bl) {
        if (bl == null) {
            this.mDirectionNoSelectedRadioButton.setSelected(true);
        } else {
            boolean bl2 = bl;
            if (bl2) {
                this.mInnerRadioButton.setSelected(true);
            } else {
                this.mOuterRadioButton.setSelected(true);
            }
        }
        return true;
    }

    public boolean setFormatVisible(Boolean bl) {
        this.mFormatVisibleCheckBox.setSelected(bl);
        boolean bl2 = true;
        if (bl != null) {
            bl2 = bl;
        }
        this.mFormatComponentGroup.setEnabled(bl2);
        return true;
    }

    public boolean setFormatInteger(Boolean bl) {
        this.mIntegerCheckBox.setSelected(bl);
        return true;
    }

    public boolean setMinValue(Object object) {
        return SGUtility.setValue(this.mMinValueTextField, object);
    }

    public boolean setMaxValue(Object object) {
        return SGUtility.setValue(this.mMaxValueTextField, object);
    }

    public boolean setInvertCoordinates(Boolean bl) {
        this.mInvertCoordinatesCheckBox.setSelected(bl);
        return true;
    }

    public boolean setAutoCalcFlag(Boolean bl) {
        this.mAutoTickMarkCheckBox.setSelected(bl);
        boolean bl2 = true;
        if (bl != null) {
            bl2 = bl;
        }
        this.mBaseTextField.setEditable(!bl2);
        this.mStepTextField.setEditable(!bl2);
        return true;
    }

    public boolean setBaseValue(Object object) {
        return SGUtility.setValue(this.mBaseTextField, object);
    }

    public boolean setStepValue(Object object) {
        return SGUtility.setValue(this.mStepTextField, object);
    }

    public boolean setExponentVisible(Boolean bl) {
        this.mExponentCheckBox.setSelected(bl);
        boolean bl2 = true;
        if (bl != null) {
            bl2 = bl;
        }
        this.mExponentComponentGroup.setEnabled(bl2);
        return true;
    }

    public boolean setExponentValue(Object object) {
        return SGUtility.setIntValue(this.mExponentSpinner, object);
    }

    public ArrayList getSpinnerList() {
        ArrayList<SGSpinner> arrayList = new ArrayList<SGSpinner>();
        arrayList.add(this.mExponentSpinner);
        return arrayList;
    }

    public boolean setComponentsProperty(ArrayList arrayList) {
        SGIAxisPanelObserver sGIAxisPanelObserver = (SGIAxisPanelObserver)arrayList.get(0);
        boolean bl = sGIAxisPanelObserver.isAxisVisible();
        boolean bl2 = sGIAxisPanelObserver.isTitleVisible();
        String string = sGIAxisPanelObserver.getTitleString();
        double d = sGIAxisPanelObserver.getMinValue();
        double d2 = sGIAxisPanelObserver.getMaxValue();
        boolean bl3 = sGIAxisPanelObserver.isInvertCoordinates();
        int n = sGIAxisPanelObserver.getScaleType();
        boolean bl4 = sGIAxisPanelObserver.isCalculateAutomatically();
        double d3 = sGIAxisPanelObserver.getStepValue();
        double d4 = sGIAxisPanelObserver.getBaselineValue();
        boolean bl5 = sGIAxisPanelObserver.isTickMarksVisible();
        boolean bl6 = sGIAxisPanelObserver.isTickMarksInside();
        boolean bl7 = sGIAxisPanelObserver.isNumbersVisible();
        boolean bl8 = sGIAxisPanelObserver.isNumbersInteger();
        boolean bl9 = sGIAxisPanelObserver.getExponentFlag();
        int n2 = sGIAxisPanelObserver.getExponentValue();
        Boolean bl10 = bl;
        Boolean bl11 = bl2;
        String string2 = string;
        Double d5 = new Double(d);
        Double d6 = new Double(d2);
        Boolean bl12 = bl3;
        Integer n3 = new Integer(n);
        Boolean bl13 = bl4;
        Double d7 = new Double(d3);
        Double d8 = new Double(d4);
        Boolean bl14 = bl5;
        Boolean bl15 = bl6;
        Boolean bl16 = bl7;
        Boolean bl17 = bl8;
        Boolean bl18 = bl9;
        Integer n4 = new Integer(n2);
        if (arrayList.size() > 1) {
            boolean bl19;
            SGIAxisPanelObserver sGIAxisPanelObserver2;
            int n5;
            for (n5 = 1; n5 < arrayList.size(); ++n5) {
                sGIAxisPanelObserver2 = (SGIAxisPanelObserver)arrayList.get(n5);
                bl19 = sGIAxisPanelObserver2.isAxisVisible();
                if (bl == bl19) continue;
                bl10 = null;
                break;
            }
            for (n5 = 1; n5 < arrayList.size(); ++n5) {
                sGIAxisPanelObserver2 = (SGIAxisPanelObserver)arrayList.get(n5);
                bl19 = sGIAxisPanelObserver2.isTitleVisible();
                if (bl2 == bl19) continue;
                bl11 = null;
                break;
            }
            for (n5 = 1; n5 < arrayList.size(); ++n5) {
                sGIAxisPanelObserver2 = (SGIAxisPanelObserver)arrayList.get(n5);
                String string3 = sGIAxisPanelObserver2.getTitleString();
                if (string.equals(string3)) continue;
                string2 = null;
                break;
            }
            for (n5 = 1; n5 < arrayList.size(); ++n5) {
                sGIAxisPanelObserver2 = (SGIAxisPanelObserver)arrayList.get(n5);
                double d9 = sGIAxisPanelObserver2.getMinValue();
                if (d == d9) continue;
                d5 = null;
                break;
            }
            for (n5 = 1; n5 < arrayList.size(); ++n5) {
                sGIAxisPanelObserver2 = (SGIAxisPanelObserver)arrayList.get(n5);
                double d10 = sGIAxisPanelObserver2.getMaxValue();
                if (d2 == d10) continue;
                d6 = null;
                break;
            }
            for (n5 = 1; n5 < arrayList.size(); ++n5) {
                sGIAxisPanelObserver2 = (SGIAxisPanelObserver)arrayList.get(n5);
                boolean bl20 = sGIAxisPanelObserver2.isInvertCoordinates();
                if (bl3 == bl20) continue;
                bl12 = null;
                break;
            }
            for (n5 = 1; n5 < arrayList.size(); ++n5) {
                sGIAxisPanelObserver2 = (SGIAxisPanelObserver)arrayList.get(n5);
                int n6 = sGIAxisPanelObserver2.getScaleType();
                if (n == n6) continue;
                n3 = null;
                break;
            }
            for (n5 = 1; n5 < arrayList.size(); ++n5) {
                sGIAxisPanelObserver2 = (SGIAxisPanelObserver)arrayList.get(n5);
                boolean bl21 = sGIAxisPanelObserver2.isCalculateAutomatically();
                if (bl4 == bl21) continue;
                bl13 = null;
                break;
            }
            for (n5 = 1; n5 < arrayList.size(); ++n5) {
                sGIAxisPanelObserver2 = (SGIAxisPanelObserver)arrayList.get(n5);
                double d11 = sGIAxisPanelObserver2.getStepValue();
                if (d3 == d11) continue;
                d7 = null;
                break;
            }
            for (n5 = 1; n5 < arrayList.size(); ++n5) {
                sGIAxisPanelObserver2 = (SGIAxisPanelObserver)arrayList.get(n5);
                double d12 = sGIAxisPanelObserver2.getBaselineValue();
                if (d4 == d12) continue;
                d8 = null;
                break;
            }
            for (n5 = 1; n5 < arrayList.size(); ++n5) {
                sGIAxisPanelObserver2 = (SGIAxisPanelObserver)arrayList.get(n5);
                boolean bl22 = sGIAxisPanelObserver2.isTickMarksVisible();
                if (bl5 == bl22) continue;
                bl14 = null;
                break;
            }
            for (n5 = 1; n5 < arrayList.size(); ++n5) {
                sGIAxisPanelObserver2 = (SGIAxisPanelObserver)arrayList.get(n5);
                boolean bl23 = sGIAxisPanelObserver2.isTickMarksInside();
                if (bl6 == bl23) continue;
                bl15 = null;
                break;
            }
            for (n5 = 1; n5 < arrayList.size(); ++n5) {
                sGIAxisPanelObserver2 = (SGIAxisPanelObserver)arrayList.get(n5);
                boolean bl24 = sGIAxisPanelObserver2.isNumbersVisible();
                if (bl7 == bl24) continue;
                bl16 = null;
                break;
            }
            for (n5 = 1; n5 < arrayList.size(); ++n5) {
                sGIAxisPanelObserver2 = (SGIAxisPanelObserver)arrayList.get(n5);
                boolean bl25 = sGIAxisPanelObserver2.isNumbersInteger();
                if (bl8 == bl25) continue;
                bl17 = null;
                break;
            }
            for (n5 = 1; n5 < arrayList.size(); ++n5) {
                sGIAxisPanelObserver2 = (SGIAxisPanelObserver)arrayList.get(n5);
                boolean bl26 = sGIAxisPanelObserver2.getExponentFlag();
                if (bl9 == bl26) continue;
                bl18 = null;
                break;
            }
            for (n5 = 1; n5 < arrayList.size(); ++n5) {
                sGIAxisPanelObserver2 = (SGIAxisPanelObserver)arrayList.get(n5);
                int n7 = sGIAxisPanelObserver2.getExponentValue();
                if (n2 == n7) continue;
                n4 = null;
                break;
            }
        }
        this.setTitleVisible(bl11);
        this.setTitle(string2);
        this.setMinValue(d5);
        this.setMaxValue(d6);
        this.setInvertCoordinates(bl12);
        this.setScaleType(n3);
        this.setAutoCalcFlag(bl13);
        this.setStepValue(d7);
        this.setBaseValue(d8);
        this.setTickMarkVisible(bl14);
        this.setTickMarkInside(bl15);
        this.setFormatVisible(bl16);
        this.setFormatInteger(bl17);
        this.setExponentVisible(bl18);
        this.setExponentValue(n4);
        this.setAxisVisible(bl10);
        return true;
    }

    public boolean setPropertiesToListeners(SGIAxisPanelObserver sGIAxisPanelObserver) {
        Boolean bl = this.isAxisVisible();
        Boolean bl2 = this.isTitleVisible();
        String string = this.getTitleString();
        Number number = this.getMinValue();
        Number number2 = this.getMaxValue();
        Boolean bl3 = this.getInvCoordFlag();
        Integer n = this.getScaleType();
        Boolean bl4 = this.getAutoCalcFlag();
        Number number3 = this.getBaseValue();
        Number number4 = this.getStepValue();
        Boolean bl5 = this.isTickMarkVisible();
        Boolean bl6 = this.getScaleLineDirection();
        Boolean bl7 = this.isFormatVisible();
        Boolean bl8 = this.isFormatInteger();
        Boolean bl9 = this.isExponentVisible();
        Number number5 = this.getExponentValue();
        if (!sGIAxisPanelObserver.hasValidAxisRange(number, number2, n)) {
            String string2 = "Axis range is invalid.: " + this.mConfiguration;
            this.setInputErrorMessage(string2);
            return false;
        }
        if (!sGIAxisPanelObserver.hasValidAxisValues(number3, number4, n)) {
            String string3 = "Zero value is set to the step value.: " + this.mConfiguration;
            this.setInputErrorMessage(string3);
            return false;
        }
        if (bl != null) {
            sGIAxisPanelObserver.setAxisVisible(bl);
        }
        if (bl2 != null) {
            sGIAxisPanelObserver.setTitleVisible(bl2);
        }
        if (string != null) {
            sGIAxisPanelObserver.setTitle(string);
        }
        if (number != null) {
            sGIAxisPanelObserver.setMinValue(number.doubleValue());
        }
        if (number2 != null) {
            sGIAxisPanelObserver.setMaxValue(number2.doubleValue());
        }
        if (bl3 != null) {
            sGIAxisPanelObserver.setInvertCoordinates(bl3);
        }
        if (n != null) {
            sGIAxisPanelObserver.setScaleType(n);
        }
        if (bl4 != null) {
            sGIAxisPanelObserver.setCalculateAutomatically(bl4);
        }
        if (number3 != null) {
            sGIAxisPanelObserver.setBaselineValue(number3.doubleValue());
        }
        if (number4 != null) {
            sGIAxisPanelObserver.setStepValue(number4.doubleValue());
        }
        if (bl5 != null) {
            sGIAxisPanelObserver.setTickMarksVisible(bl5);
        }
        if (bl6 != null) {
            sGIAxisPanelObserver.setTickMarksInside(bl6);
        }
        if (bl7 != null) {
            sGIAxisPanelObserver.setNumbersVisible(bl7);
        }
        if (bl8 != null) {
            sGIAxisPanelObserver.setNumbersInteger(bl8);
        }
        if (bl9 != null) {
            sGIAxisPanelObserver.setExponentFlag(bl9);
        }
        if (number5 != null) {
            sGIAxisPanelObserver.setExponentValue(number5.intValue());
        }
        return true;
    }

    protected boolean hasValidInputValues() {
        return true;
    }
}

