/*
 * Decompiled with CFR 0.152.
 */
package jp.riken.brain.ni.samuraigraph.figure.java2d;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.List;
import jp.riken.brain.ni.samuraigraph.base.SGDrawingElement;
import jp.riken.brain.ni.samuraigraph.base.SGIConstants;
import jp.riken.brain.ni.samuraigraph.base.SGProperties;
import jp.riken.brain.ni.samuraigraph.base.SGTuple2f;
import jp.riken.brain.ni.samuraigraph.base.SGUtilityText;
import jp.riken.brain.ni.samuraigraph.figure.SGDrawingElementArrow;
import jp.riken.brain.ni.samuraigraph.figure.SGDrawingElementLine;
import jp.riken.brain.ni.samuraigraph.figure.SGElementGroup;
import jp.riken.brain.ni.samuraigraph.figure.SGIArrowConstants;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGDrawingElementArrow2D;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGElementGroupVXY;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGIElementGroupConstants;
import org.w3c.dom.Element;

public abstract class SGElementGroupArrow
extends SGElementGroupVXY
implements SGIArrowConstants,
SGIElementGroupConstants {
    protected int mLineType;
    protected float mLineWidth;
    protected float mHeadSize;
    protected float mHeadOpenAngle;
    protected float mHeadCloseAngle;
    protected float mHeadLineWidth;
    protected int mStartHeadType;
    protected int mEndHeadType;
    protected int mCap = 0;
    protected int mJoin = 1;
    protected float mMiterLimit = 1.0f;
    protected float mDashPhase = 0.0f;

    public int getLineType() {
        return this.mLineType;
    }

    public float getLineWidth() {
        return this.mLineWidth;
    }

    public float getLineWidth(String string) {
        return (float)SGUtilityText.convertFromPoint(this.getLineWidth(), string);
    }

    public float getHeadSize() {
        return this.mHeadSize;
    }

    public float getHeadSize(String string) {
        return (float)SGUtilityText.convertFromPoint(this.getHeadSize(), string);
    }

    public float getHeadOpenAngle() {
        return this.mHeadOpenAngle;
    }

    public float getHeadCloseAngle() {
        return this.mHeadCloseAngle;
    }

    public int getStartHeadType() {
        return this.mStartHeadType;
    }

    public int getEndHeadType() {
        return this.mEndHeadType;
    }

    public boolean setLineType(int n) {
        this.mLineType = n;
        SGDrawingElement[] sGDrawingElementArray = this.mDrawingElementArray;
        if (sGDrawingElementArray != null) {
            for (int i = 0; i < sGDrawingElementArray.length; ++i) {
                SGDrawingElementArrow sGDrawingElementArrow = (SGDrawingElementArrow)sGDrawingElementArray[i];
                sGDrawingElementArrow.setLineType(n);
            }
        }
        return true;
    }

    public boolean setLineWidth(float f) {
        this.mLineWidth = f;
        SGDrawingElement[] sGDrawingElementArray = this.mDrawingElementArray;
        if (sGDrawingElementArray != null) {
            for (int i = 0; i < sGDrawingElementArray.length; ++i) {
                SGDrawingElementArrow sGDrawingElementArrow = (SGDrawingElementArrow)sGDrawingElementArray[i];
                sGDrawingElementArrow.setLineWidth(f);
            }
        }
        return true;
    }

    public boolean setLineWidth(float f, String string) {
        double d = SGUtilityText.convertToPoint(f, string);
        return this.setLineWidth((float)d);
    }

    public boolean setHeadSize(float f) {
        this.mHeadSize = f;
        SGDrawingElement[] sGDrawingElementArray = this.mDrawingElementArray;
        if (sGDrawingElementArray != null) {
            for (int i = 0; i < sGDrawingElementArray.length; ++i) {
                SGDrawingElementArrow sGDrawingElementArrow = (SGDrawingElementArrow)sGDrawingElementArray[i];
                sGDrawingElementArrow.setHeadSize(this.mHeadSize);
            }
        }
        return true;
    }

    public boolean setHeadSize(float f, String string) {
        double d = SGUtilityText.convertToPoint(f, string);
        return this.setHeadSize((float)d);
    }

    public boolean setHeadOpenAngle(float f) {
        this.mHeadOpenAngle = f;
        SGDrawingElement[] sGDrawingElementArray = this.mDrawingElementArray;
        if (sGDrawingElementArray != null) {
            for (int i = 0; i < sGDrawingElementArray.length; ++i) {
                SGDrawingElementArrow sGDrawingElementArrow = (SGDrawingElementArrow)sGDrawingElementArray[i];
                sGDrawingElementArrow.setHeadOpenAngle(f);
            }
        }
        return true;
    }

    public boolean setHeadCloseAngle(float f) {
        this.mHeadCloseAngle = f;
        SGDrawingElement[] sGDrawingElementArray = this.mDrawingElementArray;
        if (sGDrawingElementArray != null) {
            for (int i = 0; i < sGDrawingElementArray.length; ++i) {
                SGDrawingElementArrow sGDrawingElementArrow = (SGDrawingElementArrow)sGDrawingElementArray[i];
                sGDrawingElementArrow.setHeadCloseAngle(f);
            }
        }
        return true;
    }

    public Color getColor() {
        return this.getColor(0);
    }

    public boolean setColor(Color color) {
        super.setColor(color);
        SGDrawingElement[] sGDrawingElementArray = this.mDrawingElementArray;
        if (sGDrawingElementArray != null) {
            for (int i = 0; i < sGDrawingElementArray.length; ++i) {
                SGDrawingElementArrow sGDrawingElementArrow = (SGDrawingElementArrow)sGDrawingElementArray[i];
                sGDrawingElementArrow.setColor(color);
            }
        }
        return true;
    }

    public boolean setStartHeadType(int n) {
        this.mStartHeadType = n;
        SGDrawingElement[] sGDrawingElementArray = this.mDrawingElementArray;
        if (sGDrawingElementArray != null) {
            for (int i = 0; i < sGDrawingElementArray.length; ++i) {
                SGDrawingElementArrow sGDrawingElementArrow = (SGDrawingElementArrow)sGDrawingElementArray[i];
                sGDrawingElementArrow.setStartHeadType(n);
            }
        }
        return true;
    }

    public boolean setEndHeadType(int n) {
        this.mEndHeadType = n;
        SGDrawingElement[] sGDrawingElementArray = this.mDrawingElementArray;
        if (sGDrawingElementArray != null) {
            for (int i = 0; i < sGDrawingElementArray.length; ++i) {
                SGDrawingElementArrow sGDrawingElementArrow = (SGDrawingElementArrow)sGDrawingElementArray[i];
                sGDrawingElementArrow.setEndHeadType(n);
            }
        }
        return true;
    }

    public SGDrawingElement getDrawingElement() {
        SGDrawingElementArrow sGDrawingElementArrow = (SGDrawingElementArrow)this.createDrawingElementInstance();
        sGDrawingElementArrow.setVisible(this.isVisible());
        sGDrawingElementArrow.setLineType(this.getLineType());
        sGDrawingElementArrow.setLineWidth(this.getLineWidth());
        sGDrawingElementArrow.setColorList(this.getColorList());
        sGDrawingElementArrow.setHeadSize(this.getHeadSize());
        sGDrawingElementArrow.setHeadOpenAngle(this.getHeadOpenAngle());
        sGDrawingElementArrow.setHeadCloseAngle(this.getHeadCloseAngle());
        sGDrawingElementArrow.setStartHeadType(this.getStartHeadType());
        sGDrawingElementArrow.setEndHeadType(this.getEndHeadType());
        return sGDrawingElementArrow;
    }

    public boolean setProperty(SGDrawingElement sGDrawingElement) {
        if (!(sGDrawingElement instanceof SGDrawingElementArrow)) {
            return false;
        }
        if (!super.setProperty(sGDrawingElement)) {
            return false;
        }
        SGDrawingElementArrow sGDrawingElementArrow = (SGDrawingElementArrow)sGDrawingElement;
        this.setLineType(sGDrawingElementArrow.getLineType());
        this.setLineWidth(sGDrawingElementArrow.getLineWidth());
        this.setHeadSize(sGDrawingElementArrow.getHeadSize());
        this.setHeadOpenAngle(sGDrawingElementArrow.getHeadOpenAngle());
        this.setHeadCloseAngle(sGDrawingElementArrow.getHeadCloseAngle());
        this.setStartHeadType(sGDrawingElementArrow.getStartHeadType());
        this.setEndHeadType(sGDrawingElementArrow.getEndHeadType());
        return true;
    }

    public boolean paintElement(Graphics2D graphics2D, Rectangle2D rectangle2D) {
        SGDrawingElement[] sGDrawingElementArray = this.mDrawingElementArray;
        if (sGDrawingElementArray == null) {
            return true;
        }
        for (int i = 0; i < sGDrawingElementArray.length; ++i) {
            SGDrawingElementArrow2D sGDrawingElementArrow2D = (SGDrawingElementArrow2D)sGDrawingElementArray[i];
            if (!sGDrawingElementArrow2D.isVisible()) continue;
            sGDrawingElementArrow2D.paint(graphics2D, rectangle2D);
        }
        return true;
    }

    public static String getSymbolTypeName(int n) {
        String string = null;
        switch (n) {
            case 1: {
                string = "Circle";
                break;
            }
            case 2: {
                string = "Square";
                break;
            }
            case 4: {
                string = "Triangle";
                break;
            }
            case 6: {
                string = "Cross";
                break;
            }
            case 8: {
                string = "Transverse Line";
                break;
            }
            case 10: {
                string = "Arrow Head";
                break;
            }
            case -1: {
                string = "No Symbol";
                break;
            }
        }
        return string;
    }

    public String getTagName() {
        return "Arrow";
    }

    public boolean writeProperty(Element element) {
        element.setAttribute("Width", Float.toString(this.getLineWidth()) + "pt");
        element.setAttribute("Type", SGDrawingElementLine.getLineTypeName(this.getLineType()));
        element.setAttribute("HeadSize", Float.toString(this.getHeadSize() * 0.035277776f) + "cm");
        element.setAttribute("StartHeadType", SGDrawingElementArrow.getSymbolTypeName(this.getStartHeadType()));
        element.setAttribute("EndHeadType", SGDrawingElementArrow.getSymbolTypeName(this.getEndHeadType()));
        element.setAttribute("HeadOpenAngle", Double.toString(this.getHeadOpenAngle() / ((float)Math.PI / 180)) + SGIConstants.degree);
        element.setAttribute("HeadCloseAngle", Double.toString(this.getHeadCloseAngle() / ((float)Math.PI / 180)) + SGIConstants.degree);
        element.setAttribute("Color", SGUtilityText.getColorListString(this.mColorList));
        return true;
    }

    public boolean readProperty(Element element) {
        float f;
        StringBuffer stringBuffer;
        String string = null;
        Number number = null;
        Object var5_4 = null;
        Object var6_5 = null;
        List list = null;
        string = element.getAttribute("Width");
        if (string.length() != 0) {
            stringBuffer = new StringBuffer();
            number = SGUtilityText.getNumber(string, stringBuffer);
            if (number == null) {
                return false;
            }
            f = number.floatValue();
            if (!this.setLineWidth(f, stringBuffer.toString())) {
                return false;
            }
        }
        if ((string = element.getAttribute("Type")).length() != 0) {
            number = SGDrawingElementLine.getLineTypeFromName(string);
            if (number == null) {
                return false;
            }
            int n = number.intValue();
            if (!this.setLineType(n)) {
                return false;
            }
        }
        if ((string = element.getAttribute("HeadSize")).length() != 0) {
            stringBuffer = new StringBuffer();
            number = SGUtilityText.getNumber(string, stringBuffer);
            if (number == null) {
                return false;
            }
            f = number.floatValue();
            if (!this.setHeadSize(f, stringBuffer.toString())) {
                return false;
            }
        }
        if ((string = element.getAttribute("StartHeadType")).length() != 0) {
            number = SGDrawingElementArrow.getSymbolTypeFromName(string);
            if (number == null) {
                return false;
            }
            int n = number.intValue();
            if (!this.setStartHeadType(n)) {
                return false;
            }
        }
        if ((string = element.getAttribute("EndHeadType")).length() != 0) {
            number = SGDrawingElementArrow.getSymbolTypeFromName(string);
            if (number == null) {
                return false;
            }
            int n = number.intValue();
            if (!this.setEndHeadType(n)) {
                return false;
            }
        }
        if ((string = element.getAttribute("HeadOpenAngle")).length() != 0) {
            number = SGUtilityText.getFloat(string, SGIConstants.degree);
            if (number == null) {
                return false;
            }
            float f2 = number.floatValue() * ((float)Math.PI / 180);
            if (!this.setHeadOpenAngle(f2)) {
                return false;
            }
        }
        if ((string = element.getAttribute("HeadCloseAngle")).length() != 0) {
            number = SGUtilityText.getFloat(string, SGIConstants.degree);
            if (number == null) {
                return false;
            }
            float f3 = number.floatValue() * ((float)Math.PI / 180);
            if (!this.setHeadCloseAngle(f3)) {
                return false;
            }
        }
        if ((string = element.getAttribute("Color")).length() != 0) {
            list = SGUtilityText.getColorList(string);
            if (list == null) {
                return false;
            }
            if (!this.setColorList(list)) {
                return false;
            }
        }
        return true;
    }

    protected SGDrawingElement createDrawingElementInstance() {
        return new SGDrawingElementArrow2D();
    }

    protected boolean initDrawingElement(SGTuple2f[] sGTuple2fArray, SGTuple2f[] sGTuple2fArray2) {
        int n = sGTuple2fArray.length;
        if (!this.initDrawingElement(n)) {
            return false;
        }
        SGDrawingElement[] sGDrawingElementArray = this.mDrawingElementArray;
        for (int i = 0; i < n; ++i) {
            ((SGDrawingElementArrow)sGDrawingElementArray[i]).setTermPoints(sGTuple2fArray[i], sGTuple2fArray2[i]);
        }
        return true;
    }

    public boolean setLocation(SGTuple2f[] sGTuple2fArray, SGTuple2f[] sGTuple2fArray2) {
        if (sGTuple2fArray == null || sGTuple2fArray2 == null) {
            throw new IllegalArgumentException("startArray==null || endArray==null");
        }
        if (sGTuple2fArray.length != sGTuple2fArray2.length) {
            throw new IllegalArgumentException("startArray.length != endArray.length");
        }
        if (sGTuple2fArray.length != this.mDrawingElementArray.length) {
            throw new IllegalArgumentException("startArray.length != this.mDrawingElementArray.length");
        }
        SGDrawingElement[] sGDrawingElementArray = this.mDrawingElementArray;
        for (int i = 0; i < sGDrawingElementArray.length; ++i) {
            boolean bl = !sGTuple2fArray[i].isInfinite() && !sGTuple2fArray[i].isNaN() && !sGTuple2fArray2[i].isInfinite() && !sGTuple2fArray2[i].isNaN();
            SGDrawingElementArrow sGDrawingElementArrow = (SGDrawingElementArrow)sGDrawingElementArray[i];
            sGDrawingElementArrow.setVisible(bl);
            if (!bl) continue;
            sGDrawingElementArrow.setTermPoints(sGTuple2fArray[i], sGTuple2fArray2[i]);
        }
        return true;
    }

    public boolean setPropertiesOfDrawingElements() {
        SGDrawingElement[] sGDrawingElementArray = this.mDrawingElementArray;
        for (int i = 0; i < sGDrawingElementArray.length; ++i) {
            SGDrawingElementArrow sGDrawingElementArrow = (SGDrawingElementArrow)sGDrawingElementArray[i];
            sGDrawingElementArrow.setMagnification(this.mMagnification);
            sGDrawingElementArrow.setColorList(this.mColorList);
            sGDrawingElementArrow.setLineWidth(this.mLineWidth);
            sGDrawingElementArrow.setLineType(this.mLineType);
            sGDrawingElementArrow.setHeadSize(this.mHeadSize);
            sGDrawingElementArrow.setStartHeadType(this.mStartHeadType);
            sGDrawingElementArrow.setEndHeadType(this.mEndHeadType);
            sGDrawingElementArrow.setHeadOpenAngle(this.mHeadOpenAngle);
            sGDrawingElementArrow.setHeadCloseAngle(this.mHeadCloseAngle);
        }
        return true;
    }

    public SGProperties getProperties() {
        ArrowProperties arrowProperties = new ArrowProperties();
        if (!this.getProperties(arrowProperties)) {
            return null;
        }
        return arrowProperties;
    }

    public boolean getProperties(SGProperties sGProperties) {
        if (sGProperties == null) {
            return false;
        }
        if (!(sGProperties instanceof ArrowProperties)) {
            return false;
        }
        if (!super.getProperties(sGProperties)) {
            return false;
        }
        ArrowProperties arrowProperties = (ArrowProperties)sGProperties;
        arrowProperties.setLineWidth(this.getLineWidth());
        arrowProperties.setLineType(this.getLineType());
        arrowProperties.setHeadSize(this.getHeadSize());
        arrowProperties.setStartHeadType(this.getStartHeadType());
        arrowProperties.setEndHeadType(this.getEndHeadType());
        arrowProperties.setHeadOpenAngle(this.getHeadOpenAngle());
        arrowProperties.setHeadCloseAngle(this.getHeadCloseAngle());
        return true;
    }

    public boolean setProperties(SGProperties sGProperties) {
        if (!(sGProperties instanceof ArrowProperties)) {
            return false;
        }
        if (!super.setProperties(sGProperties)) {
            return false;
        }
        ArrowProperties arrowProperties = (ArrowProperties)sGProperties;
        Float f = arrowProperties.getLineWidth();
        if (f == null) {
            return false;
        }
        this.setLineWidth(f.floatValue());
        Integer n = arrowProperties.getLineType();
        if (n == null) {
            return false;
        }
        this.setLineType(n);
        Float f2 = arrowProperties.getHeadSize();
        if (f2 == null) {
            return false;
        }
        this.setHeadSize(f2.floatValue());
        Integer n2 = arrowProperties.getStartHeadType();
        if (n2 == null) {
            return false;
        }
        this.setStartHeadType(n2);
        Integer n3 = arrowProperties.getEndHeadType();
        if (n3 == null) {
            return false;
        }
        this.setEndHeadType(n3);
        Float f3 = arrowProperties.getHeadOpenAngle();
        if (f3 == null) {
            return false;
        }
        this.setHeadOpenAngle(f3.floatValue());
        Float f4 = arrowProperties.getHeadCloseAngle();
        if (f4 == null) {
            return false;
        }
        this.setHeadCloseAngle(f4.floatValue());
        return true;
    }

    public static class ArrowProperties
    extends SGElementGroup.ElementGroupProperties {
        private SGDrawingElementArrow.ArrowProperties mArrowProperties = new SGDrawingElementArrow.ArrowProperties();

        public boolean equals(Object object) {
            if (!(object instanceof ArrowProperties)) {
                return false;
            }
            if (!super.equals(object)) {
                return false;
            }
            ArrowProperties arrowProperties = (ArrowProperties)object;
            return this.mArrowProperties.equals(arrowProperties.mArrowProperties);
        }

        public Float getLineWidth() {
            return this.mArrowProperties.getLineWidth();
        }

        public Integer getLineType() {
            return this.mArrowProperties.getLineType();
        }

        public Float getHeadLineWidth() {
            return this.mArrowProperties.getLineWidth();
        }

        public Float getHeadSize() {
            return this.mArrowProperties.getHeadSize();
        }

        public Integer getStartHeadType() {
            return this.mArrowProperties.getStartHeadType();
        }

        public Integer getEndHeadType() {
            return this.mArrowProperties.getEndHeadType();
        }

        public Float getHeadOpenAngle() {
            return this.mArrowProperties.getHeadOpenAngle();
        }

        public Float getHeadCloseAngle() {
            return this.mArrowProperties.getHeadCloseAngle();
        }

        public void setLineWidth(float f) {
            this.mArrowProperties.setLineWidth(f);
        }

        public void setLineType(int n) {
            this.mArrowProperties.setLineType(n);
        }

        public void setStartHeadType(int n) {
            this.mArrowProperties.setStartHeadType(n);
        }

        public void setEndHeadType(int n) {
            this.mArrowProperties.setEndHeadType(n);
        }

        public void setHeadSize(float f) {
            this.mArrowProperties.setHeadSize(f);
        }

        public void setHeadOpenAngle(float f) {
            this.mArrowProperties.setHeadOpenAngle(f);
        }

        public void setHeadCloseAngle(float f) {
            this.mArrowProperties.setHeadCloseAngle(f);
        }

        public void setColor(Color color) {
            super.setColor(color);
            this.mArrowProperties.setColor(color);
        }

        public void setColor(ArrayList arrayList) {
            super.setColor(arrayList);
            this.mArrowProperties.setColor(arrayList);
        }
    }
}

