
package jp.riken.brain.ni.samuraigraph.figure;

import jp.riken.brain.ni.samuraigraph.base.SGIDrawingElementConstants;
import jp.riken.brain.ni.samuraigraph.base.SGProperties;


/**
 * Drawing element of bar.
 * This element is the extension of the rectangle: it has axis values for the baseline and width.
 */
public abstract class SGDrawingElementBar extends SGDrawingElementRectangle
	implements SGIBarConstants, SGIDrawingElementConstants
{

	/**
	 * The axis value of baseline.
	 */
	private double mBaselineValue;


	/**
	 * The axis value of width of bar.
	 */
	private double mWidthValue;


	/**
	 * A flag whether this bar is horizontal.
	 */
	private boolean mHorizontalFlag = false;


	/**
	 * 
	 */
	public SGDrawingElementBar()
	{
		super();
	}


	/**
	 * 
	 */
	public double getBaselineValue()
	{
		return this.mBaselineValue;
	}


	/**
	 * 
	 */
	public boolean setBaselineValue( final double value )
	{
		this.mBaselineValue = value;
		return true;
	}


	/**
	 * @return
	 */
	public double getWidthValue()
	{
		return this.mWidthValue;
	}


	/**
	 * @param d
	 */
	public void setWidthValue( final double d )
	{
		this.mWidthValue = d;
	}


	/**
	 * @return
	 */
	public boolean isHorizontal()
	{
		return this.mHorizontalFlag;
	}


	/**
	 * @param b
	 */
	public void setHorizontal( boolean b )
	{
		this.mHorizontalFlag = b;
	}


	/**
	 * 
	 */
	public SGProperties getProperties()
	{
		BarProperties p = new BarProperties();
		if( this.getProperties(p) == false ) return null;
		return p;
	}


	/**
	 * 
	 */
	public boolean getProperties( SGProperties p )
	{
		if( p==null ) return false;
		if( ( p instanceof BarProperties ) == false ) return false;
		if( super.getProperties(p) == false ) return false;

		BarProperties bp = (BarProperties)p;
		bp.setBaselineValue( this.getBaselineValue() );
		bp.setWidthValue( this.getWidthValue() );

		return true;
	}



	/**
	 * 
	 */
	public static class BarProperties extends RectangleProperties
	{
		private double mBaselineValue;

		private double mWidthValue;

		/**
		 * 
		 */
		public BarProperties()
		{
			super();
		}


		/**
		 * 
		 */
		public boolean equals( final Object obj )
		{
			if( ( obj instanceof BarProperties ) == false )
			{
				return false;
			}

			if( super.equals(obj) == false ) return false;

			BarProperties p = (BarProperties)obj;
			if( this.mBaselineValue!=p.mBaselineValue ) return false;
			if( this.mWidthValue!=p.mWidthValue ) return false;

			return true;
		}

		public Double getBaselineValue()
		{
			return new Double( this.mBaselineValue );
		}

		public boolean setBaselineValue( final double value )
		{
			this.mBaselineValue = value;
			return true;
		}

		public Double getWidthValue()
		{
			return new Double( this.mWidthValue );
		}

		public boolean setWidthValue( final double value )
		{
			this.mWidthValue = value;
			return true;
		}

	}

}

