
package jp.riken.brain.ni.samuraigraph.figure;

import java.awt.Color;
import java.awt.Font;

import jp.riken.brain.ni.samuraigraph.base.SGIFigureElementAxis;
import jp.riken.brain.ni.samuraigraph.base.SGIConstants;

/**
 * Constants for the legend.
 */
public interface SGILegendConstants extends SGIConstants
{

	public static final String SYMBOL_SPAN_UNIT = cm;
	public static final double SYMBOL_SPAN_MIN = 0.50;
	public static final double SYMBOL_SPAN_MAX = 6.0;



	//
	// Default Values
	//

	// Scale Reference
	public static final String DEFAULT_LEGEND_SCALE_REFERENCE
		= SGIFigureElementAxis.LEFT_BOTTOM;

	// Visible
	public static final boolean DEFAULT_LEGEND_VISIBLE = true;

	// Opaque
	public static final boolean DEFAULT_LEGEND_TRANSPARENT = false;


	//
	// Font
	//

	public static final String DEFAULT_LEGEND_FONT_NAME = "Serif";
	public static final int DEFAULT_LEGEND_FONT_STYLE = Font.PLAIN;
	public static final float DEFAULT_LEGEND_FONT_SIZE = 16.0f;
	public static final Color DEFAULT_LEGEND_FONT_COLOR = Color.BLACK;


	//
	// Frame
	//
	
	// Visible
	public static final boolean DEFAULT_LEGEND_FRAME_VISIBLE = true;

	// Width
	public static final float DEFAULT_LEGEND_FRAME_WIDTH = 0.5f;

	// Color
	public static final Color DEFAULT_LEGEND_FRAME_COLOR = Color.BLACK;

	// BG Color
	public static final Color DEFAULT_LEGEND_BACKGROUND_COLOR = Color.WHITE;


	//
	// Axes
	//
	
	// Horizontal Axis
	public static final String DEFAULT_LEGEND_HORIZONTAL_AXIS = SGIFigureElementAxis.AXIS_BOTTOM;
	
	// Perpendicular Axis
	public static final String DEFAULT_LEGEND_PERPENDICULAR_AXIS = SGIFigureElementAxis.AXIS_LEFT;


	//
	// Symbol span
	//
	
	public static final float DEFAULT_LEGEND_SYMBOL_SPAN = 2.0f;

}

