/*
 * Decompiled with CFR 0.152.
 */
package jp.riken.brain.ni.samuraigraph.application;

import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipOutputStream;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;
import javax.swing.plaf.FileChooserUI;
import javax.swing.plaf.basic.BasicFileChooserUI;
import jp.riken.brain.ni.samuraigraph.application.SGApplicationUtility;
import jp.riken.brain.ni.samuraigraph.application.SGIArchiveFileConstants;
import jp.riken.brain.ni.samuraigraph.base.SGDrawingWindow;
import jp.riken.brain.ni.samuraigraph.base.SGExtensionFileFilter;
import jp.riken.brain.ni.samuraigraph.base.SGFileChooser;
import jp.riken.brain.ni.samuraigraph.base.SGIConstants;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SGArchiveFileCreator
implements SGIConstants,
SGIArchiveFileConstants {
    private String mCurrentFilePath;
    private String mCurrentFileName;
    protected static final int EOF = -1;

    public SGArchiveFileCreator() {
        this.init();
    }

    private void init() {
        String string = USER_HOME;
        String string2 = "My Documents";
        File file = new File(string);
        String[] stringArray = file.list();
        if (stringArray == null) {
            throw new Error();
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(string);
        for (int i = 0; i < stringArray.length; ++i) {
            if (!stringArray[i].endsWith(string2)) continue;
            stringBuffer.append(FILE_SEPARATOR);
            stringBuffer.append(string2);
            break;
        }
        this.mCurrentFilePath = string = stringBuffer.toString();
        this.mCurrentFileName = SGApplicationUtility.appendExtension("dataset", "sga");
    }

    public int create(SGDrawingWindow sGDrawingWindow, String string, String string2) {
        File file = new File(string2);
        return this.create(sGDrawingWindow, string, file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public int create(SGDrawingWindow sGDrawingWindow, String string, File file) {
        File file2 = new File(string);
        if (!file2.isDirectory()) {
            return -1;
        }
        List<File> list = SGArchiveFileCreator.getFileList(file2);
        if (list.size() == 0) {
            return -2;
        }
        String string2 = file2.getAbsolutePath() + File.separator;
        ByteArrayOutputStream byteArrayOutputStream = null;
        ZipOutputStream zipOutputStream = null;
        FileOutputStream fileOutputStream = null;
        FilterOutputStream filterOutputStream = null;
        try {
            Object object;
            Object object2;
            String string3;
            Object object3;
            Object object4;
            byteArrayOutputStream = new ByteArrayOutputStream();
            zipOutputStream = new ZipOutputStream(byteArrayOutputStream);
            ArrayList<Object> arrayList = new ArrayList<Object>();
            for (int i = 0; i < list.size(); ++i) {
                object4 = list.get(i);
                object3 = ((File)object4).getAbsolutePath();
                string3 = ((String)object3).substring(string2.length());
                object2 = new ZipEntry(string3);
                arrayList.add(object2);
                SGArchiveFileCreator.writeFileEntry(zipOutputStream, (File)object4, (ZipEntry)object2);
            }
            SGDrawingWindow.BackgroundImage backgroundImage = sGDrawingWindow.getBackgroundImage();
            object4 = null;
            object3 = null;
            if (backgroundImage != null) {
                object4 = backgroundImage.getByteArray();
                string3 = backgroundImage.getExtension();
                object2 = new StringBuffer();
                ((StringBuffer)object2).append("img");
                ((StringBuffer)object2).append('.');
                ((StringBuffer)object2).append(string3);
                object = ((StringBuffer)object2).toString();
                object3 = new ZipEntry((String)object);
                SGArchiveFileCreator.writeFileEntry(zipOutputStream, (byte[])object4, (ZipEntry)object3);
            }
            zipOutputStream.close();
            byteArrayOutputStream.close();
            byteArrayOutputStream = new ByteArrayOutputStream();
            zipOutputStream = new ZipOutputStream(byteArrayOutputStream);
            for (int i = 0; i < list.size(); ++i) {
                object2 = list.get(i);
                object = (ZipEntry)arrayList.get(i);
                SGArchiveFileCreator.writeFileEntry(zipOutputStream, (File)object2, (ZipEntry)object);
            }
            if (backgroundImage != null) {
                SGArchiveFileCreator.writeFileEntry(zipOutputStream, (byte[])object4, (ZipEntry)object3);
            }
            zipOutputStream.finish();
            byte[] byArray = byteArrayOutputStream.toByteArray();
            fileOutputStream = new FileOutputStream(file);
            filterOutputStream = new BufferedOutputStream(fileOutputStream);
            ((BufferedOutputStream)filterOutputStream).write(byArray, 0, byArray.length);
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace();
            int n = -1;
            return n;
        }
        catch (ZipException zipException) {
            zipException.printStackTrace();
            int n = -1;
            return n;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            int n = -1;
            return n;
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            try {
                zipOutputStream.close();
            }
            catch (Exception exception) {}
            try {
                byteArrayOutputStream.close();
            }
            catch (Exception exception) {}
            try {
                filterOutputStream.close();
            }
            catch (Exception exception) {}
            try {
                fileOutputStream.close();
            }
            catch (Exception exception) {}
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static byte[] _getFileBytes(File file) {
        FileInputStream fileInputStream = null;
        BufferedInputStream bufferedInputStream = null;
        try {
            int n = (int)file.length();
            fileInputStream = new FileInputStream(file);
            bufferedInputStream = new BufferedInputStream(fileInputStream, n);
            byte[] byArray = new byte[n];
            bufferedInputStream.read(byArray, 0, n);
            byte[] byArray2 = byArray;
            return byArray2;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        finally {
            try {
                if (bufferedInputStream != null) {
                    bufferedInputStream.close();
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            try {
                if (fileInputStream != null) {
                    fileInputStream.close();
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return null;
    }

    public ArchiveFile getArchiveFileFromFileChooser(Component component) {
        SGFileChooser sGFileChooser = new SGFileChooser();
        SGExtensionFileFilter sGExtensionFileFilter = new SGExtensionFileFilter();
        sGExtensionFileFilter.setDescription("Samurai Graph Archive File 1.0.7");
        sGExtensionFileFilter.addExtension("sga");
        sGFileChooser.setFileFilter(sGExtensionFileFilter);
        SGExtensionFileFilter sGExtensionFileFilter2 = new SGExtensionFileFilter();
        sGExtensionFileFilter2.setDescription("Samurai Graph Archive File");
        sGExtensionFileFilter2.addExtension("sga");
        sGFileChooser.setFileFilter(sGExtensionFileFilter2);
        SGExtensionFileFilter sGExtensionFileFilter3 = new SGExtensionFileFilter();
        sGExtensionFileFilter3.setDescription("Samurai Graph netCDF Archive File");
        sGExtensionFileFilter3.addExtension("nc");
        sGFileChooser.setFileFilter(sGExtensionFileFilter3);
        sGFileChooser.setCurrentDirectory(new File(this.mCurrentFilePath));
        String string = SGApplicationUtility.getPathName(this.mCurrentFilePath, this.mCurrentFileName);
        if (sGFileChooser.getFileFilter().getDescription().startsWith("Samurai Graph Archive File 1.0.7") || sGFileChooser.getFileFilter().getDescription().startsWith("Samurai Graph Archive File")) {
            if (string.endsWith(".nc")) {
                string = string.substring(0, string.length() - 2) + "sga";
            }
        } else if (sGFileChooser.getFileFilter().getDescription().startsWith("Samurai Graph netCDF Archive File") && string.endsWith(".sga")) {
            string = string.substring(0, string.length() - 3) + "nc";
        }
        File file = new File(string);
        ((JFileChooser)sGFileChooser).setSelectedFile(file);
        FileFileterPropertyChangeListenr fileFileterPropertyChangeListenr = new FileFileterPropertyChangeListenr(sGFileChooser, file);
        sGFileChooser.addPropertyChangeListener(fileFileterPropertyChangeListenr);
        int n = sGFileChooser.showSaveDialog(component);
        ArchiveFile archiveFile = new ArchiveFile();
        if (n == 0) {
            File file2 = null;
            file2 = sGFileChooser.getSelectedFile();
            this.mCurrentFilePath = file2.getParent();
            this.mCurrentFileName = file2.getName();
            FileFilter fileFilter = sGFileChooser.getFileFilter();
            String string2 = fileFilter.getDescription();
            archiveFile.file = file2;
            archiveFile.desc = string2;
        }
        return archiveFile;
    }

    public File getSelectedFile() {
        return new File(this.mCurrentFilePath, this.mCurrentFileName);
    }

    public File setFile(String string, String string2) {
        if (string2 != null) {
            this.mCurrentFileName = string2;
        }
        this.mCurrentFilePath = string;
        String string3 = SGApplicationUtility.getPathName(this.mCurrentFilePath, this.mCurrentFileName);
        File file = new File(string3);
        return file;
    }

    private static List<File> _getDirFileList(String string) {
        ArrayList<File> arrayList = new ArrayList<File>();
        File file = new File(string);
        if (!file.isDirectory()) {
            return arrayList;
        }
        File[] fileArray = file.listFiles();
        for (int i = 0; i < fileArray.length; ++i) {
            if (fileArray[i].isFile()) {
                arrayList.add(fileArray[i]);
                continue;
            }
            if (!fileArray[i].isDirectory()) continue;
            String string2 = SGApplicationUtility.getPathName(string, fileArray[i].getName());
            List<File> list = SGArchiveFileCreator._getDirFileList(string2);
            arrayList.addAll(list);
        }
        return arrayList;
    }

    private static List<File> getFileList(File file) {
        String string = file.getAbsolutePath();
        ArrayList<File> arrayList = new ArrayList<File>();
        List<File> list = SGArchiveFileCreator._getDirFileList(string);
        for (int i = 0; i < list.size(); ++i) {
            File file2 = list.get(i);
            String string2 = file2.getAbsolutePath();
            if (!file2.isFile() || !string2.startsWith(string)) continue;
            file2 = new File(string2);
            arrayList.add(file2);
        }
        return arrayList;
    }

    private static void writeFileEntry(ZipOutputStream zipOutputStream, File file, ZipEntry zipEntry) throws ZipException, IOException {
        byte[] byArray = SGArchiveFileCreator._getFileBytes(file);
        zipOutputStream.putNextEntry(zipEntry);
        zipOutputStream.write(byArray, 0, byArray.length);
        zipOutputStream.closeEntry();
    }

    private static void writeFileEntry(ZipOutputStream zipOutputStream, byte[] byArray, ZipEntry zipEntry) throws ZipException, IOException {
        zipOutputStream.putNextEntry(zipEntry);
        zipOutputStream.write(byArray, 0, byArray.length);
        zipOutputStream.closeEntry();
    }

    public static class FileFileterPropertyChangeListenr
    implements PropertyChangeListener {
        private final SGFileChooser chooser;
        private File currentFile = null;

        public FileFileterPropertyChangeListenr(SGFileChooser sGFileChooser, File file) {
            this.chooser = sGFileChooser;
            this.currentFile = file;
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string = propertyChangeEvent.getPropertyName();
            FileChooserUI fileChooserUI = this.chooser.getUI();
            BasicFileChooserUI basicFileChooserUI = null;
            if (fileChooserUI instanceof BasicFileChooserUI) {
                basicFileChooserUI = (BasicFileChooserUI)fileChooserUI;
            }
            if (basicFileChooserUI == null) {
                return;
            }
            if (string.equals("fileFilterChanged")) {
                FileFilter fileFilter = this.chooser.getFileFilter();
                String string2 = fileFilter.getDescription();
                File file = this.chooser.getSelectedFile();
                if (null != file) {
                    this.currentFile = file;
                    return;
                }
                this.currentFile = new File(this.currentFile.getParentFile(), basicFileChooserUI.getFileName());
                if (null != this.currentFile) {
                    String string3 = this.currentFile.getAbsolutePath();
                    if (string3.endsWith(".sga")) {
                        if (string2.startsWith("Samurai Graph netCDF Archive File")) {
                            File file2;
                            this.currentFile = file2 = new File(string3.substring(0, string3.length() - 3) + "nc");
                            this.chooser.firePropertyChange("SelectedFileChangedProperty", file, file2);
                        }
                    } else if (string3.endsWith(".nc") && (string2.startsWith("Samurai Graph Archive File 1.0.7") || string2.startsWith("Samurai Graph Archive File"))) {
                        File file3;
                        this.currentFile = file3 = new File(string3.substring(0, string3.length() - 2) + "sga");
                        this.chooser.firePropertyChange("SelectedFileChangedProperty", file, file3);
                    }
                }
            }
        }
    }

    public static class ArchiveFile {
        public File file = null;
        public String desc = null;
    }
}

