/*
 * Decompiled with CFR 0.152.
 */
package jp.riken.brain.ni.samuraigraph.application;

import java.awt.Component;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import jp.riken.brain.ni.samuraigraph.application.SGIApplicationTextConstants;
import jp.riken.brain.ni.samuraigraph.application.SGWizardDialog;
import jp.riken.brain.ni.samuraigraph.base.SGButton;
import jp.riken.brain.ni.samuraigraph.base.SGDataColumnInfoSet;
import jp.riken.brain.ni.samuraigraph.base.SGTextField;
import jp.riken.brain.ni.samuraigraph.base.SGUtility;
import jp.riken.brain.ni.samuraigraph.data.SGArrayDataColumnSelectionPanel;
import jp.riken.brain.ni.samuraigraph.data.SGDataUtility;
import jp.riken.brain.ni.samuraigraph.data.SGIDataColumnTypeConstants;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SGArrayDataColumnSelectionWizardDialog
extends SGWizardDialog
implements SGIDataColumnTypeConstants,
PropertyChangeListener,
SGIApplicationTextConstants {
    private static final long serialVersionUID = -3351323186366134225L;
    public static final String TITLE = "Select the Data Columns";
    private JPanel mButtonPanel;
    private SGButton mCancelButton;
    private SGArrayDataColumnSelectionPanel mDataColumnSelectionPanel;
    private JLabel mDataNameLabel;
    private JPanel mDataNamePanel;
    private SGTextField mDataNameTextField;
    private SGButton mNextButton;
    private SGButton mOKButton;
    private SGButton mPreviousButton;

    public SGArrayDataColumnSelectionWizardDialog() {
        this.initComponents();
        this.initProperty();
    }

    public SGArrayDataColumnSelectionWizardDialog(Frame frame, boolean bl) {
        super(frame, bl);
        this.initComponents();
        this.initProperty();
    }

    private void initComponents() {
        this.mButtonPanel = new JPanel();
        this.mPreviousButton = new SGButton();
        this.mNextButton = new SGButton();
        this.mOKButton = new SGButton();
        this.mCancelButton = new SGButton();
        this.mDataColumnSelectionPanel = new SGArrayDataColumnSelectionPanel();
        this.mDataNamePanel = new JPanel();
        this.mDataNameLabel = new JLabel();
        this.mDataNameTextField = new SGTextField();
        this.setDefaultCloseOperation(2);
        this.getContentPane().setLayout(new GridBagLayout());
        this.mButtonPanel.setFont(new Font("Dialog", 0, 11));
        this.mPreviousButton.setText("<Prev");
        this.mPreviousButton.setFont(new Font("Dialog", 1, 12));
        this.mButtonPanel.add(this.mPreviousButton);
        this.mNextButton.setText("Next>");
        this.mNextButton.setFont(new Font("Dialog", 1, 12));
        this.mButtonPanel.add(this.mNextButton);
        this.mOKButton.setText("OK");
        this.mOKButton.setFont(new Font("Dialog", 1, 12));
        this.mButtonPanel.add(this.mOKButton);
        this.mCancelButton.setText("Cancel");
        this.mCancelButton.setFont(new Font("Dialog", 1, 12));
        this.mButtonPanel.add(this.mCancelButton);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        this.getContentPane().add((Component)this.mButtonPanel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.mDataColumnSelectionPanel, gridBagConstraints);
        this.mDataNamePanel.setLayout(new GridBagLayout());
        this.mDataNameLabel.setFont(new Font("Dialog", 1, 12));
        this.mDataNameLabel.setText("Data Name");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.mDataNamePanel.add((Component)this.mDataNameLabel, gridBagConstraints);
        this.mDataNameTextField.setColumns(20);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.mDataNamePanel.add((Component)this.mDataNameTextField, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.mDataNamePanel, gridBagConstraints);
        this.pack();
    }

    @Override
    protected JButton getPreviousButton() {
        return this.mPreviousButton;
    }

    @Override
    protected JButton getNextButton() {
        return this.mNextButton;
    }

    @Override
    protected JButton getOKButton() {
        return this.mOKButton;
    }

    @Override
    protected JButton getCancelButton() {
        return this.mCancelButton;
    }

    private boolean initProperty() {
        this.setTitle(TITLE);
        this.mDataColumnSelectionPanel.getRestoreButton().addActionListener(this);
        this.mDataColumnSelectionPanel.getClearButton().addActionListener(this);
        this.mDataColumnSelectionPanel.getComplementButton().addActionListener(this);
        this.mDataColumnSelectionPanel.getTable().addPropertyChangeListener(this);
        this.mDataNameTextField.addActionListener(this);
        return true;
    }

    public void clear() {
        this.mDataColumnSelectionPanel.clear();
    }

    public boolean setData(String string, SGDataColumnInfoSet sGDataColumnInfoSet, Map<String, Object> map, boolean bl) {
        if (!this.mDataColumnSelectionPanel.setData(string, sGDataColumnInfoSet, map, bl)) {
            return false;
        }
        String string2 = (String)map.get("Data Name");
        this.setDataName(string2);
        if (SGDataUtility.isSXYTypeData(string)) {
            this.getNextButton().setVisible(true);
        } else {
            this.getNextButton().setVisible(false);
        }
        this.getOKButton().setEnabled(true);
        this.getNextButton().setEnabled(true);
        return true;
    }

    public SGDataColumnInfoSet getDataColumnInfoSet() {
        return this.mDataColumnSelectionPanel.getDataColumnInfoSet();
    }

    @Override
    public void componentResized(ComponentEvent componentEvent) {
        super.componentResized(componentEvent);
        this.updateTable();
    }

    @Override
    public void componentShown(ComponentEvent componentEvent) {
        super.componentShown(componentEvent);
        this.updateTable();
    }

    private void updateTable() {
        this.mDataColumnSelectionPanel.updateTable();
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        super.actionPerformed(actionEvent);
        Object object = actionEvent.getSource();
        if (object.equals(this.mDataColumnSelectionPanel.getClearButton())) {
            this.getOKButton().setEnabled(false);
            this.getNextButton().setEnabled(false);
        } else if (object.equals(this.mDataColumnSelectionPanel.getRestoreButton())) {
            this.getOKButton().setEnabled(true);
            this.getNextButton().setEnabled(true);
        } else if (object.equals(this.mDataColumnSelectionPanel.getComplementButton())) {
            this.getOKButton().setEnabled(true);
            this.getNextButton().setEnabled(true);
        } else if (object.equals(this.mDataNameTextField)) {
            this.onOK();
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        String string;
        Object object = propertyChangeEvent.getSource();
        if (object.equals(this.mDataColumnSelectionPanel.getTable()) && "tableCellEditor".equals(string = propertyChangeEvent.getPropertyName())) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    SGArrayDataColumnSelectionWizardDialog.this.mDataColumnSelectionPanel.updateSelectedItems();
                }
            });
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    boolean bl = SGArrayDataColumnSelectionWizardDialog.this.mDataColumnSelectionPanel.checkSelectedItems();
                    SGArrayDataColumnSelectionWizardDialog.this.getOKButton().setEnabled(bl);
                    SGArrayDataColumnSelectionWizardDialog.this.getNextButton().setEnabled(bl);
                }
            });
        }
    }

    public String getDataName() {
        return this.mDataNameTextField.getText();
    }

    public void setDataName(String string) {
        this.mDataNameTextField.setText(string);
    }

    @Override
    protected boolean onOK() {
        boolean bl = true;
        String string = this.getDataName();
        if (string == null || "".equals(string)) {
            bl = false;
        }
        if (!bl) {
            SGUtility.showMessageDialog(this, "Input value is invalid.", "Error", 0);
            return false;
        }
        return super.onOK();
    }
}

