/*
 * Decompiled with CFR 0.152.
 */
package jp.riken.brain.ni.samuraigraph.application;

import java.awt.Component;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.MediaTracker;
import java.awt.event.ActionEvent;
import java.util.HashMap;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JToggleButton;
import jp.riken.brain.ni.samuraigraph.application.SGDataTypeSelectionWizardDialog;
import jp.riken.brain.ni.samuraigraph.base.SGButton;
import jp.riken.brain.ni.samuraigraph.base.SGCheckBox;
import jp.riken.brain.ni.samuraigraph.base.SGTextField;
import jp.riken.brain.ni.samuraigraph.base.SGUtility;
import jp.riken.brain.ni.samuraigraph.base.SGUtilityText;

public class SGArrayDataTypeSelectionWizardDialog
extends SGDataTypeSelectionWizardDialog {
    private static final long serialVersionUID = -9169068127709202582L;
    private JPanel mButtonPanel;
    protected SGButton mCancelButton;
    private JToggleButton mMultipleButton;
    private JLabel mMultipleLabel;
    protected SGButton mNextButton;
    protected SGButton mOKButton;
    private JToggleButton mOrthogonalButton;
    private JLabel mOrthogonalLabel;
    private JPanel mPanel;
    private JToggleButton mPolarButton;
    private JLabel mPolarLabel;
    protected SGButton mPreviousButton;
    private JToggleButton mPseudocolorMapButton;
    private JLabel mPseudocolorMapLabel;
    private JPanel mSXYButtonPanel;
    private JPanel mSXYPanel;
    private JPanel mSXYZButtonPanel;
    private JPanel mSXYZPanel;
    private JPanel mSamplingPanel;
    SGCheckBox mSamplingRateCheckBox;
    private SGTextField mSamplingRateField;
    private JLabel mSamplingUnitLabel;
    private JToggleButton mSingleButton;
    private JLabel mSingleLabel;
    private JPanel mVXYButtonPanel;
    private JPanel mVXYPanel;

    public SGArrayDataTypeSelectionWizardDialog() {
        this.initComponents();
        this.initProperty();
    }

    public SGArrayDataTypeSelectionWizardDialog(Frame frame, boolean bl) {
        super(frame, bl);
        this.initComponents();
        this.initProperty();
    }

    private void initComponents() {
        this.mButtonPanel = new JPanel();
        this.mPreviousButton = new SGButton();
        this.mNextButton = new SGButton();
        this.mOKButton = new SGButton();
        this.mCancelButton = new SGButton();
        this.mPanel = new JPanel();
        this.mSXYPanel = new JPanel();
        this.mSXYButtonPanel = new JPanel();
        this.mMultipleLabel = new JLabel();
        this.mSingleLabel = new JLabel();
        this.mSingleButton = new JToggleButton();
        this.mMultipleButton = new JToggleButton();
        this.mSamplingPanel = new JPanel();
        this.mSamplingRateCheckBox = new SGCheckBox();
        this.mSamplingRateField = new SGTextField();
        this.mSamplingUnitLabel = new JLabel();
        this.mVXYPanel = new JPanel();
        this.mVXYButtonPanel = new JPanel();
        this.mOrthogonalLabel = new JLabel();
        this.mPolarLabel = new JLabel();
        this.mOrthogonalButton = new JToggleButton();
        this.mPolarButton = new JToggleButton();
        this.mSXYZPanel = new JPanel();
        this.mSXYZButtonPanel = new JPanel();
        this.mPseudocolorMapLabel = new JLabel();
        this.mPseudocolorMapButton = new JToggleButton();
        this.getContentPane().setLayout(new GridBagLayout());
        this.mPreviousButton.setText("<Prev");
        this.mPreviousButton.setFont(new Font("Dialog", 1, 12));
        this.mButtonPanel.add(this.mPreviousButton);
        this.mNextButton.setText("Next>");
        this.mNextButton.setFont(new Font("Dialog", 1, 12));
        this.mButtonPanel.add(this.mNextButton);
        this.mOKButton.setText("OK");
        this.mOKButton.setFont(new Font("Dialog", 1, 12));
        this.mButtonPanel.add(this.mOKButton);
        this.mCancelButton.setText("Cancel");
        this.mCancelButton.setFont(new Font("Dialog", 1, 12));
        this.mButtonPanel.add(this.mCancelButton);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.getContentPane().add((Component)this.mButtonPanel, gridBagConstraints);
        this.mPanel.setLayout(new GridBagLayout());
        this.mSXYPanel.setBorder(BorderFactory.createTitledBorder(null, "Scalar", 0, 0, new Font("Dialog", 0, 12)));
        this.mSXYPanel.setFont(new Font("Dialog", 0, 12));
        this.mSXYPanel.setLayout(new GridBagLayout());
        this.mSXYButtonPanel.setLayout(new GridBagLayout());
        this.mMultipleLabel.setText("Multiple");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(0, 1, 0, 0);
        this.mSXYButtonPanel.add((Component)this.mMultipleLabel, gridBagConstraints);
        this.mSingleLabel.setText("Single");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(0, 0, 0, 1);
        this.mSXYButtonPanel.add((Component)this.mSingleLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        this.mSXYButtonPanel.add((Component)this.mSingleButton, gridBagConstraints);
        this.mSXYButtonPanel.add((Component)this.mMultipleButton, new GridBagConstraints());
        this.mSXYPanel.add((Component)this.mSXYButtonPanel, new GridBagConstraints());
        this.mSamplingPanel.setLayout(new GridBagLayout());
        this.mSamplingRateCheckBox.setText("Use Sampling Rate");
        this.mSamplingRateCheckBox.setFont(new Font("Dialog", 0, 12));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 5, 2, 10);
        this.mSamplingPanel.add((Component)this.mSamplingRateCheckBox, gridBagConstraints);
        this.mSamplingRateField.setColumns(3);
        this.mSamplingRateField.setFont(new Font("Dialog", 0, 12));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(0, 0, 0, 10);
        this.mSamplingPanel.add((Component)this.mSamplingRateField, gridBagConstraints);
        this.mSamplingUnitLabel.setFont(new Font("Dialog", 0, 12));
        this.mSamplingUnitLabel.setText("Hz");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 0, 10);
        this.mSamplingPanel.add((Component)this.mSamplingUnitLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(0, 5, 5, 5);
        this.mSXYPanel.add((Component)this.mSamplingPanel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.mPanel.add((Component)this.mSXYPanel, gridBagConstraints);
        this.mVXYPanel.setBorder(BorderFactory.createTitledBorder(null, "Vector", 0, 0, new Font("Dialog", 0, 12)));
        this.mVXYPanel.setLayout(new GridBagLayout());
        this.mVXYButtonPanel.setLayout(new GridBagLayout());
        this.mOrthogonalLabel.setText("Orthogonal");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(0, 0, 0, 1);
        this.mVXYButtonPanel.add((Component)this.mOrthogonalLabel, gridBagConstraints);
        this.mPolarLabel.setText("Polar");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(0, 1, 0, 0);
        this.mVXYButtonPanel.add((Component)this.mPolarLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        this.mVXYButtonPanel.add((Component)this.mOrthogonalButton, gridBagConstraints);
        this.mVXYButtonPanel.add((Component)this.mPolarButton, new GridBagConstraints());
        this.mVXYPanel.add((Component)this.mVXYButtonPanel, new GridBagConstraints());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.mPanel.add((Component)this.mVXYPanel, gridBagConstraints);
        this.mSXYZPanel.setBorder(BorderFactory.createTitledBorder(null, "Other", 0, 0, new Font("Dialog", 0, 12)));
        this.mSXYZPanel.setLayout(new GridBagLayout());
        this.mSXYZButtonPanel.setLayout(new GridBagLayout());
        this.mPseudocolorMapLabel.setText("Pseudocolor Map");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        this.mSXYZButtonPanel.add((Component)this.mPseudocolorMapLabel, gridBagConstraints);
        this.mSXYZButtonPanel.add((Component)this.mPseudocolorMapButton, new GridBagConstraints());
        this.mSXYZPanel.add((Component)this.mSXYZButtonPanel, new GridBagConstraints());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.mPanel.add((Component)this.mSXYZPanel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(10, 10, 0, 10);
        this.getContentPane().add((Component)this.mPanel, gridBagConstraints);
        this.pack();
    }

    private boolean initProperty() {
        this.setTitle("Select The Data Type");
        String[] stringArray = ICON_FILENAME_ARRAY;
        int n = stringArray.length;
        ImageIcon[] imageIconArray = new ImageIcon[n];
        for (int i = 0; i < n; ++i) {
            imageIconArray[i] = this.createIcon(stringArray[i]);
        }
        MediaTracker mediaTracker = new MediaTracker(this);
        for (int i = 0; i < n; ++i) {
            mediaTracker.addImage(imageIconArray[i].getImage(), i);
        }
        try {
            mediaTracker.waitForAll();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        HashMap<String, ImageIcon> hashMap = new HashMap<String, ImageIcon>();
        for (int i = 0; i < n; ++i) {
            hashMap.put(stringArray[i], imageIconArray[i]);
        }
        this.setupButton(this.mSingleButton, hashMap, "SingleSXY.png", "Single Scalar-XY");
        this.setupButton(this.mMultipleButton, hashMap, "MultipleSXY.png", "Multiple Scalar-XY");
        this.setupButton(this.mOrthogonalButton, hashMap, "OrthogonalVXY.png", "Orthogonal Vector-XY");
        this.setupButton(this.mPolarButton, hashMap, "PolarVXY.png", "Polar Vector-XY");
        this.setupButton(this.mPseudocolorMapButton, hashMap, "PseudocolorMap.png", "Pseudocolor Map");
        this.pack();
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.mSingleButton);
        buttonGroup.add(this.mMultipleButton);
        buttonGroup.add(this.mOrthogonalButton);
        buttonGroup.add(this.mPolarButton);
        buttonGroup.add(this.mPseudocolorMapButton);
        this.mSamplingRateField.setEnabled(false);
        this.mSamplingRateField.setText(Double.toString(1.0));
        this.mSingleButton.setSelected(true);
        this.mSingleButton.requestFocusInWindow();
        this.mSingleButton.addActionListener(this);
        this.mMultipleButton.addActionListener(this);
        this.mOrthogonalButton.addActionListener(this);
        this.mPolarButton.addActionListener(this);
        this.mPseudocolorMapButton.addActionListener(this);
        this.mSamplingRateCheckBox.addActionListener(this);
        this.mSamplingRateField.addActionListener(this);
        this.mDataTypeButtonArray = new SGDataTypeSelectionWizardDialog.DataTypeButton[5];
        this.mDataTypeButtonArray[0] = new SGDataTypeSelectionWizardDialog.DataTypeButton("SXY", this.mSingleButton);
        this.mDataTypeButtonArray[1] = new SGDataTypeSelectionWizardDialog.DataTypeButton("SXY", this.mMultipleButton);
        this.mDataTypeButtonArray[2] = new SGDataTypeSelectionWizardDialog.DataTypeButton("VXY", this.mOrthogonalButton);
        this.mDataTypeButtonArray[3] = new SGDataTypeSelectionWizardDialog.DataTypeButton("VXY", this.mPolarButton);
        this.mDataTypeButtonArray[4] = new SGDataTypeSelectionWizardDialog.DataTypeButton("SXYZ", this.mPseudocolorMapButton);
        return true;
    }

    protected JButton getPreviousButton() {
        return this.mPreviousButton;
    }

    protected JButton getNextButton() {
        return this.mNextButton;
    }

    protected JButton getOKButton() {
        return this.mOKButton;
    }

    protected JButton getCancelButton() {
        return this.mCancelButton;
    }

    protected AbstractButton getSingleSXYGraphButton() {
        return this.mSingleButton;
    }

    protected AbstractButton getMultipleSXYGraphButton() {
        return this.mMultipleButton;
    }

    protected AbstractButton getOrthogonalVectorGraphButton() {
        return this.mOrthogonalButton;
    }

    protected AbstractButton getPolarVectorGraphButton() {
        return this.mPolarButton;
    }

    protected AbstractButton getPseudocolorMapButton() {
        return this.mPseudocolorMapButton;
    }

    public Double getSamplingRate() {
        if (!this.mSamplingRateCheckBox.isSelected()) {
            return null;
        }
        String string = this.mSamplingRateField.getText();
        return SGUtilityText.getDouble(string);
    }

    protected void updateComponents() {
        super.updateComponents();
        boolean bl = this.mSingleButton.isSelected() || this.mMultipleButton.isSelected();
        this.mSamplingRateCheckBox.setEnabled(bl);
        this.mSamplingRateField.setEnabled(bl && this.mSamplingRateCheckBox.isSelected());
    }

    protected boolean onOK() {
        if (this.mSamplingRateCheckBox.isSelected()) {
            boolean bl = true;
            Double d = this.getSamplingRate();
            if (d == null) {
                bl = false;
            } else {
                double d2 = d;
                if (d2 <= 0.0) {
                    bl = false;
                }
            }
            if (!bl) {
                SGUtility.showMessageDialog(this, "Input value is invalid.", "Error", 0);
                return false;
            }
        }
        return super.onOK();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object.equals(this.mSamplingRateField)) {
            this.onOK();
            return;
        }
        super.actionPerformed(actionEvent);
    }

    public void setSamplingRateSelected(boolean bl) {
        this.mSamplingRateCheckBox.setSelected(bl);
    }
}

