/*
 * Decompiled with CFR 0.152.
 */
package jp.riken.brain.ni.samuraigraph.application;

import java.awt.EventQueue;
import java.awt.Point;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import jp.riken.brain.ni.samuraigraph.application.SGApplicationUtility;
import jp.riken.brain.ni.samuraigraph.application.SGIApplicationCommandConstants;
import jp.riken.brain.ni.samuraigraph.application.SGMainFunctions;
import jp.riken.brain.ni.samuraigraph.application.SGMainFunctionsSplitMerge;
import jp.riken.brain.ni.samuraigraph.application.SGWindowManager;
import jp.riken.brain.ni.samuraigraph.base.SGData;
import jp.riken.brain.ni.samuraigraph.base.SGDataColumnInfo;
import jp.riken.brain.ni.samuraigraph.base.SGDataColumnInfoSet;
import jp.riken.brain.ni.samuraigraph.base.SGDrawingWindow;
import jp.riken.brain.ni.samuraigraph.base.SGFigure;
import jp.riken.brain.ni.samuraigraph.base.SGIFigureElement;
import jp.riken.brain.ni.samuraigraph.base.SGIFigureElementAxisBreak;
import jp.riken.brain.ni.samuraigraph.base.SGIFigureElementGraph;
import jp.riken.brain.ni.samuraigraph.base.SGIFigureElementLegend;
import jp.riken.brain.ni.samuraigraph.base.SGIFigureElementShape;
import jp.riken.brain.ni.samuraigraph.base.SGIFigureElementSignificantDifference;
import jp.riken.brain.ni.samuraigraph.base.SGIFigureElementString;
import jp.riken.brain.ni.samuraigraph.base.SGIFigureElementTimingLine;
import jp.riken.brain.ni.samuraigraph.base.SGPropertyMap;
import jp.riken.brain.ni.samuraigraph.base.SGPropertyResults;
import jp.riken.brain.ni.samuraigraph.base.SGUtility;
import jp.riken.brain.ni.samuraigraph.base.SGUtilityText;
import jp.riken.brain.ni.samuraigraph.data.SGDataUtility;
import jp.riken.brain.ni.samuraigraph.data.SGIDataColumnTypeConstants;
import jp.riken.brain.ni.samuraigraph.data.SGNetCDFDataColumnInfo;
import jp.riken.brain.ni.samuraigraph.data.SGNetCDFFile;
import jp.riken.brain.ni.samuraigraph.figure.SGIAxisBreakConstants;
import jp.riken.brain.ni.samuraigraph.figure.SGILegendConstants;
import jp.riken.brain.ni.samuraigraph.figure.SGIShapeConstants;
import jp.riken.brain.ni.samuraigraph.figure.SGISignificantDifferenceConstants;
import jp.riken.brain.ni.samuraigraph.figure.SGIStringConstants;
import jp.riken.brain.ni.samuraigraph.figure.SGITimingLineConstants;
import ucar.nc2.NetcdfFile;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class SGCommandManager
implements SGIApplicationCommandConstants,
SGIDataColumnTypeConstants,
SGILegendConstants,
SGIStringConstants,
SGISignificantDifferenceConstants,
SGIAxisBreakConstants,
SGITimingLineConstants,
SGIShapeConstants {
    private SGMainFunctions mMain = null;
    private SGWindowManager mWindowManager = null;
    private int mReturnedValue;
    private Map<String, Alias> mAliasMap = new HashMap<String, Alias>();

    SGCommandManager(SGMainFunctions sGMainFunctions) {
        this.mMain = sGMainFunctions;
        this.mWindowManager = sGMainFunctions.mWindowManager;
    }

    private SGPropertyMap getPropertiesMap(String string, List<String> list) {
        SGPropertyMap sGPropertyMap = new SGPropertyMap();
        for (String string2 : list) {
            String string3;
            String string4;
            int n = string2.indexOf(61);
            if (n == -1 || n == 0) {
                return null;
            }
            int n2 = string2.length();
            String string5 = string2.substring(0, n);
            String string6 = n == n2 - 1 ? "" : string2.substring(n + 1, n2);
            Alias alias = this.mAliasMap.get(string6);
            if (alias != null && ((string4 = alias.getCommand()) == null || string.equalsIgnoreCase(string4)) && ((string3 = alias.getKey()) == null || string5.equalsIgnoreCase(string3)) && alias.getRepr().equals(string6)) {
                string6 = alias.getValue();
            }
            sGPropertyMap.putValue(string5, string6);
        }
        return sGPropertyMap;
    }

    private boolean isCommandBringToFront(String string) {
        return string.toUpperCase().startsWith("BringToFront".toUpperCase());
    }

    private boolean isCommandBringForward(String string) {
        return string.toUpperCase().startsWith("BringForward".toUpperCase());
    }

    private boolean isCommandSendBackward(String string) {
        return string.toUpperCase().startsWith("SendBackward".toUpperCase());
    }

    private boolean isCommandSendToBack(String string) {
        return string.toUpperCase().startsWith("SendToBack".toUpperCase());
    }

    private String getCommandEndToMove(String string, String string2) {
        return string.substring(string2.length(), string.length());
    }

    private SGIFigureElement getFigureElementToMove(String string, SGFigure sGFigure) {
        String string2 = string.toUpperCase();
        Class clazz = null;
        if (string2.endsWith("Data".toUpperCase())) {
            clazz = SGIFigureElementGraph.class;
        } else if (string2.endsWith("Label".toUpperCase())) {
            clazz = SGIFigureElementString.class;
        } else if (string2.endsWith("SignificantDifference".toUpperCase())) {
            clazz = SGIFigureElementSignificantDifference.class;
        } else if (string2.endsWith("AxisBreak".toUpperCase())) {
            clazz = SGIFigureElementAxisBreak.class;
        } else if (string2.endsWith("TimingLine".toUpperCase())) {
            clazz = SGIFigureElementTimingLine.class;
        } else if (string2.endsWith("Shape".toUpperCase())) {
            clazz = SGIFigureElementShape.class;
        } else {
            return null;
        }
        SGIFigureElement sGIFigureElement = sGFigure.getIFigureElement(clazz);
        return sGIFigureElement;
    }

    private Integer getId(List<String> list) {
        if (list.size() < 1) {
            return null;
        }
        String string = list.get(0);
        Integer n = SGUtilityText.getInteger(string);
        if (n == null) {
            return null;
        }
        if (n <= 0) {
            return null;
        }
        BigInteger bigInteger = new BigInteger(string);
        BigInteger bigInteger2 = new BigInteger(Integer.toString(Integer.MAX_VALUE));
        if (bigInteger.compareTo(bigInteger2) > 0) {
            return null;
        }
        return n;
    }

    private String parseCommand(String string, List<String> list) {
        int n;
        int n2;
        int n3 = string.indexOf(40);
        int n4 = string.lastIndexOf(41);
        if (n3 == -1 || n4 == -1) {
            return string;
        }
        if (n3 > n4) {
            return string;
        }
        if (n3 == 0) {
            return string;
        }
        String string2 = string.substring(0, n3);
        String string3 = string.substring(n3 + 1, n4);
        int n5 = string3.length();
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        int n6 = 0;
        int n7 = 0;
        for (n2 = 0; n2 < n5; ++n2) {
            char c = string3.charAt(n2);
            if (c == '\"') {
                ++n6;
                continue;
            }
            if (c == '(') {
                if (n6 % 2 != 0) continue;
                ++n7;
                continue;
            }
            if (c == ')') {
                if (n6 % 2 != 0) continue;
                --n7;
                continue;
            }
            if (c != ',' || n6 % 2 != 0 || n7 != 0) continue;
            arrayList.add(n2);
        }
        n2 = 0;
        ArrayList<String> arrayList2 = new ArrayList<String>();
        for (n = 0; n < arrayList.size(); ++n) {
            int n8 = (Integer)arrayList.get(n);
            String string4 = string3.substring(n2, n8);
            string4 = string4.trim();
            arrayList2.add(string4);
            n2 = n8 + 1;
            if (n2 < n5) continue;
            arrayList2.add("");
            break;
        }
        arrayList2.add(string3.substring(n2, n5).trim());
        for (n = 0; n < arrayList2.size(); ++n) {
            int n9;
            int n10;
            char c;
            String string5 = (String)arrayList2.get(n);
            int n11 = string5.indexOf(34);
            if (n11 == -1) {
                list.add(string5);
                continue;
            }
            int n12 = string5.lastIndexOf(34);
            if (n12 == n11) {
                return null;
            }
            if (n12 != string5.length() - 1) {
                return null;
            }
            String string6 = string5.substring(0, n11);
            String string7 = string5.substring(n11 + 1, n12);
            for (int i = 0; i < string7.length(); ++i) {
                c = string7.charAt(i);
                if (c != '\"') continue;
                if (i == string7.length() - 1) {
                    return null;
                }
                n10 = string7.charAt(i + 1);
                if (n10 != 34) {
                    return null;
                }
                ++i;
            }
            ArrayList<Character> arrayList3 = new ArrayList<Character>();
            c = '\u0000';
            for (n10 = 0; n10 < string7.length(); ++n10) {
                n9 = string7.charAt(n10);
                if (n9 == 34) {
                    if (c == '\u0000') {
                        c = '\u0001';
                        continue;
                    }
                    arrayList3.add(Character.valueOf((char)n9));
                    c = '\u0000';
                    continue;
                }
                arrayList3.add(Character.valueOf((char)n9));
            }
            char[] cArray = new char[arrayList3.size()];
            for (n9 = 0; n9 < cArray.length; ++n9) {
                cArray[n9] = ((Character)arrayList3.get(n9)).charValue();
            }
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(string6);
            stringBuffer.append('\"');
            stringBuffer.append(new String(cArray));
            stringBuffer.append('\"');
            list.add(stringBuffer.toString());
        }
        return string2;
    }

    int exec(String string) {
        final ArrayList<String> arrayList = new ArrayList<String>();
        final String string2 = this.parseCommand(string, arrayList);
        if (string2 == null) {
            return -1;
        }
        if ("Sleep".equalsIgnoreCase(string2)) {
            int n = arrayList.size();
            if (n == 0) {
                return -1;
            }
            int[] nArray = new int[n];
            ArrayList<Double> arrayList2 = new ArrayList<Double>();
            for (int i = 0; i < nArray.length; ++i) {
                String string3 = (String)arrayList.get(i);
                Double d = SGUtilityText.getDouble(string3);
                if (null == d) continue;
                arrayList2.add(d);
            }
            if (arrayList2.size() != 1) {
                return -1;
            }
            if (n != arrayList2.size()) {
                return -1;
            }
            try {
                Thread.sleep(Math.round(Math.abs((Double)arrayList2.get(0)) * 1000.0));
            }
            catch (InterruptedException interruptedException) {
                return -1;
            }
            return 0;
        }
        try {
            EventQueue.invokeAndWait(new Runnable(){

                public void run() {
                    SGCommandManager.this.mReturnedValue = SGCommandManager.this.execImageCommand(string2, arrayList);
                }
            });
        }
        catch (InterruptedException interruptedException) {
        }
        catch (InvocationTargetException invocationTargetException) {
            // empty catch block
        }
        if (this.mReturnedValue != 1) {
            return this.mReturnedValue;
        }
        try {
            EventQueue.invokeAndWait(new Runnable(){

                public void run() {
                    SGCommandManager.this.mReturnedValue = SGCommandManager.this.execWindowCommand(string2, arrayList);
                }
            });
        }
        catch (InterruptedException interruptedException) {
        }
        catch (InvocationTargetException invocationTargetException) {
            // empty catch block
        }
        if (this.mReturnedValue != 1) {
            return this.mReturnedValue;
        }
        try {
            EventQueue.invokeAndWait(new Runnable(){

                public void run() {
                    SGCommandManager.this.mReturnedValue = SGCommandManager.this.execMenuBarCommandFile(string2, arrayList);
                }
            });
        }
        catch (InterruptedException interruptedException) {
        }
        catch (InvocationTargetException invocationTargetException) {
            // empty catch block
        }
        if (this.mReturnedValue != 1) {
            return this.mReturnedValue;
        }
        try {
            EventQueue.invokeAndWait(new Runnable(){

                public void run() {
                    SGCommandManager.this.mReturnedValue = SGCommandManager.this.execFigureCommand(string2, arrayList);
                }
            });
        }
        catch (InterruptedException interruptedException) {
        }
        catch (InvocationTargetException invocationTargetException) {
            // empty catch block
        }
        if (this.mReturnedValue != 1) {
            return this.mReturnedValue;
        }
        try {
            EventQueue.invokeAndWait(new Runnable(){

                public void run() {
                    SGCommandManager.this.mReturnedValue = SGCommandManager.this.execFigureElementCommand(string2, arrayList);
                }
            });
        }
        catch (InterruptedException interruptedException) {
        }
        catch (InvocationTargetException invocationTargetException) {
            // empty catch block
        }
        if (this.mReturnedValue != 1) {
            return this.mReturnedValue;
        }
        return 1;
    }

    private int execMenuBarCommandFile(String string, List<String> list) {
        int n = list.size();
        SGDrawingWindow sGDrawingWindow = this.mWindowManager.getCurrentWindow();
        if (sGDrawingWindow == null) {
            return -1;
        }
        if ("LoadDataSet".equalsIgnoreCase(string)) {
            File file;
            if (n < 1) {
                return -1;
            }
            String string2 = list.get(0);
            if (string2.startsWith("\"")) {
                string2 = string2.substring(1);
            }
            if (string2.endsWith("\"")) {
                string2 = string2.substring(0, string2.length() - 1);
            }
            if (!(file = new File(string2)).exists()) {
                return -1;
            }
            if (!this.mMain.mDataSetManager.loadDataSetFromEventDispatchThread(sGDrawingWindow, file)) {
                return -1;
            }
            return 0;
        }
        if ("SaveDataSet".equalsIgnoreCase(string)) {
            String[] stringArray;
            if (n < 2) {
                return -1;
            }
            if (sGDrawingWindow.getVisibleFigureList().size() == 0) {
                return -1;
            }
            String string3 = null;
            String string4 = null;
            SGPropertyMap sGPropertyMap = this.getPropertiesMap(string, list);
            if (sGPropertyMap == null) {
                return -1;
            }
            Iterator<String> iterator = sGPropertyMap.getKeyIterator();
            while (iterator.hasNext()) {
                stringArray = iterator.next();
                if ("FilePath".equalsIgnoreCase((String)stringArray)) {
                    string3 = sGPropertyMap.getValueString((String)stringArray);
                    continue;
                }
                if (!"Type".equalsIgnoreCase((String)stringArray)) continue;
                string4 = sGPropertyMap.getValueString((String)stringArray);
            }
            stringArray = new String[]{"sga", "sga107", "netCDF"};
            string4 = SGApplicationUtility.getExactTypeString(stringArray, string4);
            if (string3 == null || string4 == null) {
                return -1;
            }
            if (this.mMain.mDataSetManager.saveDataSet(sGDrawingWindow, string3, string4) == 0) {
                sGDrawingWindow.setSaved(true);
                return 0;
            }
            sGDrawingWindow.setSaved(false);
            return -1;
        }
        if ("Exit".equalsIgnoreCase(string)) {
            if (n != 0 && !(n == 1 && list.get(0).trim().length() == 0)) {
                return -1;
            }
            this.mWindowManager.closeAllWindowWithoutConfirmation();
            return 0;
        }
        return 1;
    }

    private int execWindowCommand(String string, List<String> list) {
        int n = list.size();
        if ("Window".equalsIgnoreCase(string)) {
            Object object;
            SGDrawingWindow sGDrawingWindow;
            Integer n2 = this.getId(list);
            if (n2 == null) {
                return -1;
            }
            ArrayList<String> arrayList = new ArrayList<String>(list.subList(1, n));
            if (this.mWindowManager.getWindow(n2) == null) {
                sGDrawingWindow = this.mWindowManager.createNewWindow(n2);
                if (sGDrawingWindow == null) {
                    return -1;
                }
                sGDrawingWindow.setVisible(true);
            }
            if (!this.mWindowManager.setCurrentWindow(n2)) {
                return -1;
            }
            sGDrawingWindow = this.mWindowManager.getCurrentWindow();
            SGPropertyMap sGPropertyMap = this.getPropertiesMap(string, arrayList);
            if (sGPropertyMap == null) {
                return -1;
            }
            String string2 = sGPropertyMap.getValueString("ImageFilePath");
            if (!"".equals(string2)) {
                if (!sGPropertyMap.isDoubleQuoted("ImageFilePath")) {
                    return -1;
                }
                object = new File(string2);
                if (!((File)object).exists()) {
                    return -1;
                }
                byte[] byArray = SGApplicationUtility.toByteArray((File)object);
                String string3 = SGApplicationUtility.getExtension((File)object);
                if (string3 == null) {
                    return -1;
                }
                if (!sGDrawingWindow.setImage(byArray, string3, true)) {
                    return -1;
                }
                sGPropertyMap.removeValue("ImageFilePath");
            }
            if ((object = sGDrawingWindow.setProperties(sGPropertyMap)) == null) {
                return -1;
            }
            return this.afterSetProperties(sGPropertyMap, (SGPropertyResults)object);
        }
        if ("CloseWindow".equalsIgnoreCase(string)) {
            Integer n3 = this.getId(list);
            if (n3 == null) {
                return -1;
            }
            if (!this.mMain.closeWindowWithoutConfirmation(n3)) {
                return -1;
            }
            return 0;
        }
        return 1;
    }

    private int execFigureCommand(String string, List<String> list) {
        int n = list.size();
        SGDrawingWindow sGDrawingWindow = this.mWindowManager.getCurrentWindow();
        if (sGDrawingWindow == null) {
            return -1;
        }
        if ("Figure".equalsIgnoreCase(string)) {
            SGIFigureElement[] sGIFigureElementArray;
            Integer n2 = this.getId(list);
            if (n2 == null) {
                return -1;
            }
            ArrayList<String> arrayList = new ArrayList<String>(list.subList(1, n));
            SGFigure sGFigure = sGDrawingWindow.getFigure(n2);
            if (sGFigure == null) {
                sGFigure = this.mMain.mFigureCreator.createEmptyFigure(n2, sGDrawingWindow);
                if (sGFigure == null) {
                    sGDrawingWindow.endProgress();
                    return -1;
                }
                if (!sGDrawingWindow.addFigure(sGFigure, new Point())) {
                    return -1;
                }
                sGFigure.setFigureX(2.0f, "cm");
                sGFigure.setFigureY(1.0f, "cm");
                sGFigure.setVisible(true);
                sGIFigureElementArray = sGFigure.getIFigureElementArray();
                for (int i = 0; i < sGIFigureElementArray.length; ++i) {
                    if (sGIFigureElementArray[i].initPropertiesHistory()) continue;
                    sGDrawingWindow.endProgress();
                    return -1;
                }
                sGFigure.initPropertiesHistory();
                sGDrawingWindow.updateItemsByFigureNumbers();
                sGDrawingWindow.setChanged(true);
            }
            if (!this.mWindowManager.setCurrentFigure(sGDrawingWindow.getID(), sGFigure)) {
                return -1;
            }
            sGIFigureElementArray = this.getPropertiesMap(string, arrayList);
            if (sGIFigureElementArray == null) {
                return -1;
            }
            SGPropertyResults sGPropertyResults = sGFigure.setProperties((SGPropertyMap)sGIFigureElementArray);
            if (sGPropertyResults == null) {
                return -1;
            }
            return this.afterSetProperties((SGPropertyMap)sGIFigureElementArray, sGPropertyResults);
        }
        if ("BringToFrontFigure".equalsIgnoreCase(string)) {
            Integer n3 = this.getId(list);
            if (n3 == null) {
                return -1;
            }
            if (!sGDrawingWindow.moveFigureToEnd(n3, true)) {
                return -1;
            }
            return 0;
        }
        if ("BringForwardFigure".equalsIgnoreCase(string)) {
            Integer n4 = this.getId(list);
            if (n4 == null) {
                return -1;
            }
            if (!sGDrawingWindow.moveFigure(n4, true)) {
                return -1;
            }
            return 0;
        }
        if ("SendBackwardFigure".equalsIgnoreCase(string)) {
            Integer n5 = this.getId(list);
            if (n5 == null) {
                return -1;
            }
            if (!sGDrawingWindow.moveFigure(n5, false)) {
                return -1;
            }
            return 0;
        }
        if ("SendToBackFigure".equalsIgnoreCase(string)) {
            Integer n6 = this.getId(list);
            if (n6 == null) {
                return -1;
            }
            if (!sGDrawingWindow.moveFigureToEnd(n6, false)) {
                return -1;
            }
            return 0;
        }
        return 1;
    }

    private int execFigureElementCommand(String string, List<String> list) {
        SGFigure sGFigure = this.mWindowManager.getCurrentFigure();
        if (sGFigure == null) {
            return -1;
        }
        if ("Data".equalsIgnoreCase(string)) {
            Object object;
            int n = list.size();
            if (n < 2) {
                return -1;
            }
            Integer n2 = this.getId(list);
            if (n2 == null) {
                return -1;
            }
            ArrayList<String> arrayList = new ArrayList<String>(list.subList(1, n));
            SGPropertyMap sGPropertyMap = this.getPropertiesMap(string, arrayList);
            if (sGPropertyMap == null) {
                return -1;
            }
            if (!sGFigure.isDataVisible(n2)) {
                String[] stringArray;
                object = null;
                String string2 = null;
                Iterator<String> iterator = sGPropertyMap.getKeyIterator();
                while (iterator.hasNext()) {
                    stringArray = iterator.next();
                    if ("FilePath".equalsIgnoreCase((String)stringArray)) {
                        object = sGPropertyMap.getValueString((String)stringArray);
                        continue;
                    }
                    if (!"DataType".equalsIgnoreCase((String)stringArray)) continue;
                    string2 = sGPropertyMap.getValueString((String)stringArray);
                }
                stringArray = new String[]{"SXY", "SXY_MULTIPLE", "SXY_SAMPLING", "VXY", "SXY_DATE", "SXYZ", "SXY_NETCDF", "SXY_MULTIPLE_NETCDF", "SXY_MULTIPLE_NETCDF_PICKUP", "VXY_NETCDF", "SXYZ_NETCDF"};
                string2 = SGApplicationUtility.getExactTypeString(stringArray, string2);
                if (object == null || string2 == null) {
                    return -1;
                }
                if (!sGPropertyMap.isDoubleQuoted("FilePath")) {
                    return -1;
                }
                SGDrawingWindow sGDrawingWindow = sGFigure.getWindow();
                if (!SGDataUtility.isValidData(string2)) {
                    return -1;
                }
                boolean bl = SGDataUtility.isNetCDFData(string2);
                Map<String, Object> map = this.mMain.createInfoMap(string2, sGPropertyMap);
                if (map == null) {
                    return -1;
                }
                NetcdfFile netcdfFile = null;
                SGNetCDFFile sGNetCDFFile = null;
                if (bl) {
                    try {
                        netcdfFile = NetcdfFile.open((String)object);
                    }
                    catch (IOException iOException) {
                        return -1;
                    }
                    sGNetCDFFile = new SGNetCDFFile(netcdfFile);
                    map.put("Data Source", sGNetCDFFile);
                }
                SGDataColumnInfoSet sGDataColumnInfoSet = null;
                sGDataColumnInfoSet = bl ? this.mMain.getNetCDFDefaultDataColumnInfo(sGNetCDFFile, string2, map) : this.mMain.getDefaultDataColumnInfo((String)object, string2, map, false, null);
                if (sGDataColumnInfoSet == null) {
                    return -1;
                }
                if (bl && SGDataUtility.isNetCDFDimensionData(string2)) {
                    SGDataColumnInfo[] sGDataColumnInfoArray = sGDataColumnInfoSet.getDataColumnInfoArray();
                    SGNetCDFDataColumnInfo[] sGNetCDFDataColumnInfoArray = new SGNetCDFDataColumnInfo[sGDataColumnInfoArray.length];
                    for (int i = 0; i < sGNetCDFDataColumnInfoArray.length; ++i) {
                        sGNetCDFDataColumnInfoArray[i] = (SGNetCDFDataColumnInfo)sGDataColumnInfoArray[i];
                    }
                    if (!SGDataUtility.updatePickupParameters(map, sGNetCDFDataColumnInfoArray)) {
                        return -1;
                    }
                }
                if (!this.mMain.drawGraph(sGDrawingWindow, sGFigure.getID(), sGDataColumnInfoSet, map, (String)object, new Integer[]{n2}, false, null)) {
                    return -1;
                }
                sGDrawingWindow.setChanged(true);
                sGDrawingWindow.notifyToRoot();
                sGPropertyMap.removeValue("FilePath");
                sGPropertyMap.removeValue("DataType");
                sGPropertyMap.removeValue("SamplingRate");
                sGPropertyMap.removeValue("Polar");
                if (netcdfFile != null) {
                    try {
                        netcdfFile.close();
                    }
                    catch (IOException iOException) {
                        return -1;
                    }
                }
            }
            if ((object = sGFigure.getGraphElement().setChildProperties(n2, sGPropertyMap)) == null) {
                return -1;
            }
            return this.afterSetProperties(sGPropertyMap, (SGPropertyResults)object);
        }
        if (this.isCommandBringToFront(string)) {
            Integer n = this.getId(list);
            if (n == null) {
                return -1;
            }
            String string3 = this.getCommandEndToMove(string, "BringToFront");
            SGIFigureElement sGIFigureElement = this.getFigureElementToMove(string3, sGFigure);
            if (!sGIFigureElement.moveChildToEnd(n, true)) {
                return -1;
            }
            return 0;
        }
        if (this.isCommandBringForward(string)) {
            Integer n = this.getId(list);
            if (n == null) {
                return -1;
            }
            String string4 = this.getCommandEndToMove(string, "BringForward");
            SGIFigureElement sGIFigureElement = this.getFigureElementToMove(string4, sGFigure);
            if (!sGIFigureElement.moveChild(n, true)) {
                return -1;
            }
            return 0;
        }
        if (this.isCommandSendBackward(string)) {
            Integer n = this.getId(list);
            if (n == null) {
                return -1;
            }
            String string5 = this.getCommandEndToMove(string, "SendBackward");
            SGIFigureElement sGIFigureElement = this.getFigureElementToMove(string5, sGFigure);
            if (!sGIFigureElement.moveChild(n, false)) {
                return -1;
            }
            return 0;
        }
        if (this.isCommandSendToBack(string)) {
            Integer n = this.getId(list);
            if (n == null) {
                return -1;
            }
            String string6 = this.getCommandEndToMove(string, "SendToBack");
            SGIFigureElement sGIFigureElement = this.getFigureElementToMove(string6, sGFigure);
            if (!sGIFigureElement.moveChildToEnd(n, false)) {
                return -1;
            }
            return 0;
        }
        if ("MoveToTopData".equalsIgnoreCase(string)) {
            Integer n = this.getId(list);
            if (n == null) {
                return -1;
            }
            SGIFigureElementLegend sGIFigureElementLegend = sGFigure.getLegendElement();
            if (!sGIFigureElementLegend.moveLegendToEnd(n, true)) {
                return -1;
            }
            return 0;
        }
        if ("MoveToUpperData".equalsIgnoreCase(string)) {
            Integer n = this.getId(list);
            if (n == null) {
                return -1;
            }
            SGIFigureElementLegend sGIFigureElementLegend = sGFigure.getLegendElement();
            if (!sGIFigureElementLegend.moveLegend(n, true)) {
                return -1;
            }
            return 0;
        }
        if ("MoveToLowerData".equalsIgnoreCase(string)) {
            Integer n = this.getId(list);
            if (n == null) {
                return -1;
            }
            SGIFigureElementLegend sGIFigureElementLegend = sGFigure.getLegendElement();
            if (!sGIFigureElementLegend.moveLegend(n, false)) {
                return -1;
            }
            return 0;
        }
        if ("MoveToBottomData".equalsIgnoreCase(string)) {
            Integer n = this.getId(list);
            if (n == null) {
                return -1;
            }
            SGIFigureElementLegend sGIFigureElementLegend = sGFigure.getLegendElement();
            if (!sGIFigureElementLegend.moveLegendToEnd(n, false)) {
                return -1;
            }
            return 0;
        }
        if ("DeleteData".equalsIgnoreCase(string)) {
            int n;
            int n3 = list.size();
            int[] nArray = new int[n3];
            ArrayList<Integer> arrayList = new ArrayList<Integer>();
            for (n = 0; n < nArray.length; ++n) {
                String string7 = list.get(n);
                Integer n4 = SGUtilityText.getInteger(string7);
                if (null == n4) continue;
                arrayList.add(n4);
            }
            if (n3 != arrayList.size()) {
                return -1;
            }
            for (n = 0; n < n3; ++n) {
                nArray[n] = (Integer)arrayList.get(n);
            }
            if (!sGFigure.hideData(nArray)) {
                return -1;
            }
            if (nArray.length != 0) {
                SGDrawingWindow sGDrawingWindow = sGFigure.getWindow();
                sGDrawingWindow.setChanged(true);
                sGDrawingWindow.notifyToRoot();
            }
            return 0;
        }
        if ("FitAxes".equalsIgnoreCase(string)) {
            int n;
            int n5 = list.size();
            if (n5 == 0) {
                return -1;
            }
            int[] nArray = new int[n5];
            ArrayList<Integer> arrayList = new ArrayList<Integer>();
            for (n = 0; n < nArray.length; ++n) {
                String string8 = list.get(n);
                Integer n6 = SGUtilityText.getInteger(string8);
                if (null == n6) continue;
                arrayList.add(n6);
            }
            if (arrayList.size() == 0) {
                if (!sGFigure.fitAxisRangeToVisibleData()) {
                    return -1;
                }
                return 0;
            }
            if (n5 != arrayList.size()) {
                return -1;
            }
            for (n = 0; n < n5; ++n) {
                nArray[n] = (Integer)arrayList.get(n);
            }
            if (!sGFigure.fitAxisRangeToData(nArray)) {
                return -1;
            }
            return 0;
        }
        if ("AlignBars".equalsIgnoreCase(string)) {
            int n = list.size();
            if (n != 1) {
                return -1;
            }
            String string9 = list.get(0);
            if (string9.trim().equals("")) {
                if (!sGFigure.alignVisibleBars()) {
                    return -1;
                }
            } else {
                return -1;
            }
            return 0;
        }
        if ("Split".equalsIgnoreCase(string)) {
            int n;
            int n7 = list.size();
            if (n7 == 0) {
                return -1;
            }
            int[] nArray = new int[n7];
            ArrayList<Integer> arrayList = new ArrayList<Integer>();
            for (n = 0; n < nArray.length; ++n) {
                String string10 = list.get(n);
                Integer n8 = SGUtilityText.getInteger(string10);
                if (null == n8) continue;
                arrayList.add(n8);
            }
            if (arrayList.size() == 0) {
                return -1;
            }
            if (n7 != arrayList.size()) {
                return -1;
            }
            for (n = 0; n < n7; ++n) {
                nArray[n] = (Integer)arrayList.get(n);
            }
            List<SGData> list2 = SGMainFunctionsSplitMerge.splitDataInFigure(sGFigure, nArray);
            if (list2 == null || list2.size() == 0) {
                return -1;
            }
            return 0;
        }
        if ("Merge".equalsIgnoreCase(string)) {
            int n;
            int n9 = list.size();
            if (n9 == 0) {
                return -1;
            }
            int[] nArray = new int[n9];
            ArrayList<Integer> arrayList = new ArrayList<Integer>();
            for (n = 0; n < nArray.length; ++n) {
                String string11 = list.get(n);
                Integer n10 = SGUtilityText.getInteger(string11);
                if (null == n10) continue;
                arrayList.add(n10);
            }
            if (arrayList.size() <= 1) {
                return -1;
            }
            if (n9 != arrayList.size()) {
                return -1;
            }
            for (n = 0; n < n9; ++n) {
                nArray[n] = (Integer)arrayList.get(n);
            }
            List<SGData> list3 = SGMainFunctionsSplitMerge.mergeDataInFigure(sGFigure, nArray);
            if (list3 == null || list3.size() == 0) {
                return -1;
            }
            return 0;
        }
        if ("InsertNetCDFDataLabel".equalsIgnoreCase(string)) {
            int n;
            int n11 = list.size();
            if (n11 == 0) {
                return -1;
            }
            int[] nArray = new int[n11];
            ArrayList<Integer> arrayList = new ArrayList<Integer>();
            for (n = 0; n < nArray.length; ++n) {
                String string12 = list.get(n);
                Integer n12 = SGUtilityText.getInteger(string12);
                if (null == n12) continue;
                arrayList.add(n12);
            }
            if (arrayList.size() == 0) {
                return -1;
            }
            if (n11 != arrayList.size()) {
                return -1;
            }
            for (n = 0; n < n11; ++n) {
                nArray[n] = (Integer)arrayList.get(n);
            }
            if (!sGFigure.insertNetCDFLabels(nArray)) {
                return -1;
            }
            return 0;
        }
        if ("Axis".equalsIgnoreCase(string)) {
            if (list.size() < 1) {
                return -1;
            }
            String string13 = list.get(0);
            int n = SGUtility.getAxisLocation(string13);
            SGPropertyResults sGPropertyResults = null;
            SGPropertyMap sGPropertyMap = null;
            if (n != -1) {
                ArrayList<String> arrayList = new ArrayList<String>(list.subList(1, list.size()));
                sGPropertyMap = this.getPropertiesMap(string, arrayList);
                if (sGPropertyMap == null) {
                    return -1;
                }
                sGPropertyResults = sGFigure.getAxisElement().setChildProperties(n, sGPropertyMap);
                if (sGPropertyResults == null) {
                    return -1;
                }
            } else {
                sGPropertyMap = this.getPropertiesMap(string, list);
                if (sGPropertyMap == null) {
                    return -1;
                }
                sGPropertyResults = sGFigure.getAxisElement().setProperties(sGPropertyMap);
                if (sGPropertyResults == null) {
                    return -1;
                }
            }
            return this.afterSetProperties(sGPropertyMap, sGPropertyResults);
        }
        if ("ColorBar".equalsIgnoreCase(string)) {
            SGPropertyMap sGPropertyMap = this.getPropertiesMap(string, list);
            if (sGPropertyMap == null) {
                return -1;
            }
            SGPropertyResults sGPropertyResults = sGFigure.getAxisElement().setChildProperties(4, sGPropertyMap);
            if (sGPropertyResults == null) {
                return -1;
            }
            return this.afterSetProperties(sGPropertyMap, sGPropertyResults);
        }
        if ("Legend".equalsIgnoreCase(string)) {
            SGPropertyMap sGPropertyMap = this.getPropertiesMap(string, list);
            if (sGPropertyMap == null) {
                return -1;
            }
            SGPropertyResults sGPropertyResults = sGFigure.getLegendElement().setProperties(sGPropertyMap);
            if (sGPropertyResults == null) {
                return -1;
            }
            return this.afterSetProperties(sGPropertyMap, sGPropertyResults);
        }
        if ("Label".equalsIgnoreCase(string) || "SignificantDifference".equalsIgnoreCase(string) || "AxisBreak".equalsIgnoreCase(string) || "TimingLine".equalsIgnoreCase(string) || "Shape".equalsIgnoreCase(string)) {
            Class clazz = null;
            if ("Label".equalsIgnoreCase(string)) {
                clazz = SGIFigureElementString.class;
            } else if ("SignificantDifference".equalsIgnoreCase(string)) {
                clazz = SGIFigureElementSignificantDifference.class;
            } else if ("AxisBreak".equalsIgnoreCase(string)) {
                clazz = SGIFigureElementAxisBreak.class;
            } else if ("TimingLine".equalsIgnoreCase(string)) {
                clazz = SGIFigureElementTimingLine.class;
            } else if ("Shape".equalsIgnoreCase(string)) {
                clazz = SGIFigureElementShape.class;
            } else {
                return -1;
            }
            Integer n = this.getId(list);
            if (n == null) {
                return -1;
            }
            int n13 = list.size();
            ArrayList<String> arrayList = new ArrayList<String>(list.subList(1, n13));
            SGPropertyMap sGPropertyMap = this.getPropertiesMap(string, arrayList);
            if (sGPropertyMap == null) {
                return -1;
            }
            SGIFigureElement sGIFigureElement = sGFigure.getIFigureElement(clazz);
            if (sGIFigureElement == null) {
                return -1;
            }
            SGPropertyResults sGPropertyResults = sGIFigureElement.setChildProperties(n, sGPropertyMap);
            if (sGPropertyResults == null) {
                return -1;
            }
            return this.afterSetProperties(sGPropertyMap, sGPropertyResults);
        }
        return 1;
    }

    private int execImageCommand(String string, List<String> list) {
        if ("ExportAsImage".equalsIgnoreCase(string)) {
            String[] stringArray;
            SGDrawingWindow sGDrawingWindow = this.mWindowManager.getCurrentWindow();
            if (sGDrawingWindow == null) {
                return -1;
            }
            if (sGDrawingWindow.getVisibleFigureList().size() == 0) {
                return -1;
            }
            SGPropertyMap sGPropertyMap = this.getPropertiesMap(string, list);
            if (sGPropertyMap == null) {
                return -1;
            }
            String string2 = null;
            String string3 = null;
            Iterator<String> iterator = sGPropertyMap.getKeyIterator();
            while (iterator.hasNext()) {
                stringArray = iterator.next();
                if ("FilePath".equalsIgnoreCase((String)stringArray)) {
                    string2 = sGPropertyMap.getValueString((String)stringArray);
                    continue;
                }
                if (!"ImageType".equalsIgnoreCase((String)stringArray)) continue;
                string3 = sGPropertyMap.getValueString((String)stringArray);
            }
            stringArray = new String[]{"EMF", "EPS", "PS", "PDF", "SVG", "CGM", "SWF", "JPG", "JPEG", "GIF", "PNG", "RAW", "PPM"};
            string3 = SGApplicationUtility.getExactTypeString(stringArray, string3);
            if (string2 == null || string3 == null) {
                return -1;
            }
            if (!sGPropertyMap.isDoubleQuoted("FilePath")) {
                return -1;
            }
            File file = new File(string2);
            File file2 = new File(file.getParent());
            if (!file2.exists()) {
                return -1;
            }
            sGPropertyMap.removeValue("FilePath");
            sGPropertyMap.removeValue("ImageType");
            SGPropertyResults sGPropertyResults = sGDrawingWindow.exportAsImage(sGPropertyMap, string3, string2, true);
            if (sGPropertyResults == null) {
                return -1;
            }
            return this.afterSetProperties(sGPropertyMap, sGPropertyResults);
        }
        return 1;
    }

    private int afterSetProperties(SGPropertyMap sGPropertyMap, SGPropertyResults sGPropertyResults) {
        Integer n;
        String string;
        Iterator<String> iterator = sGPropertyMap.getKeyIterator();
        while (iterator.hasNext()) {
            string = iterator.next();
            n = sGPropertyResults.getResult(string);
            if (n != null) continue;
            sGPropertyResults.putResult(string, 2);
        }
        sGPropertyResults.showResults();
        iterator = sGPropertyMap.getKeyIterator();
        while (iterator.hasNext()) {
            string = iterator.next();
            n = sGPropertyResults.getResult(string);
            if (n != 1 && n != 2) continue;
            return 2;
        }
        return 0;
    }

    public void addAlias(String string, String string2, String string3, String string4) {
        Alias alias = new Alias(string, string2, string3, string4);
        this.mAliasMap.put(string3, alias);
    }

    public void removeAlias(String string) {
        this.mAliasMap.remove(string);
    }

    static class Alias {
        private String mCommand = null;
        private String mKey = null;
        private String mRepr = null;
        private String mValue = null;

        public Alias(String string, String string2, String string3, String string4) {
            if (string3 == null || string4 == null) {
                throw new IllegalArgumentException("repr == null || value == null");
            }
            this.mCommand = string;
            this.mKey = string2;
            this.mRepr = string3;
            this.mValue = string4;
        }

        public String getCommand() {
            return this.mCommand;
        }

        public String getKey() {
            return this.mKey;
        }

        public String getRepr() {
            return this.mRepr;
        }

        public String getValue() {
            return this.mValue;
        }
    }
}

