/*
 * Decompiled with CFR 0.152.
 */
package jp.riken.brain.ni.samuraigraph.application;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Serializable;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import jp.riken.brain.ni.samuraigraph.base.SGBufferedFileReader;
import jp.riken.brain.ni.samuraigraph.base.SGCSVTokenizer;
import jp.riken.brain.ni.samuraigraph.base.SGData;
import jp.riken.brain.ni.samuraigraph.base.SGDataColumnInfo;
import jp.riken.brain.ni.samuraigraph.base.SGDataColumnInfoSet;
import jp.riken.brain.ni.samuraigraph.base.SGIConstants;
import jp.riken.brain.ni.samuraigraph.base.SGIDataSource;
import jp.riken.brain.ni.samuraigraph.base.SGIProgressControl;
import jp.riken.brain.ni.samuraigraph.base.SGUtility;
import jp.riken.brain.ni.samuraigraph.base.SGUtilityText;
import jp.riken.brain.ni.samuraigraph.data.SGDataColumn;
import jp.riken.brain.ni.samuraigraph.data.SGDataSourceObserver;
import jp.riken.brain.ni.samuraigraph.data.SGDataUtility;
import jp.riken.brain.ni.samuraigraph.data.SGDate;
import jp.riken.brain.ni.samuraigraph.data.SGDateDataColumn;
import jp.riken.brain.ni.samuraigraph.data.SGDateVariable;
import jp.riken.brain.ni.samuraigraph.data.SGIDataColumnTypeConstants;
import jp.riken.brain.ni.samuraigraph.data.SGNetCDFData;
import jp.riken.brain.ni.samuraigraph.data.SGNetCDFDataColumnInfo;
import jp.riken.brain.ni.samuraigraph.data.SGNetCDFFile;
import jp.riken.brain.ni.samuraigraph.data.SGNumberDataColumn;
import jp.riken.brain.ni.samuraigraph.data.SGSXYData;
import jp.riken.brain.ni.samuraigraph.data.SGSXYMultipleData;
import jp.riken.brain.ni.samuraigraph.data.SGSXYMultipleDimensionNetCDFData;
import jp.riken.brain.ni.samuraigraph.data.SGSXYMultipleVariableNetCDFData;
import jp.riken.brain.ni.samuraigraph.data.SGSXYNetCDFData;
import jp.riken.brain.ni.samuraigraph.data.SGSXYNetCDFDateData;
import jp.riken.brain.ni.samuraigraph.data.SGSXYZData;
import jp.riken.brain.ni.samuraigraph.data.SGSXYZNetCDFData;
import jp.riken.brain.ni.samuraigraph.data.SGSamplingDataColumn;
import jp.riken.brain.ni.samuraigraph.data.SGTextDataColumn;
import jp.riken.brain.ni.samuraigraph.data.SGTextDataFile;
import jp.riken.brain.ni.samuraigraph.data.SGVXYData;
import jp.riken.brain.ni.samuraigraph.data.SGVXYNetCDFData;
import ucar.nc2.Dimension;
import ucar.nc2.NetcdfFile;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SGDataCreator
implements SGIConstants,
SGIDataColumnTypeConstants {
    private static final String PROGRESS_MESSAGE_READFILE = "Read File";
    private static final String PROGRESS_MESSAGE_CREATEDATA = "Create Data";
    private SGDataSourceObserver mDataSourceObserver = new SGDataSourceObserver();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CreatedDataSet create(String string, SGDataColumnInfoSet sGDataColumnInfoSet, Map<String, Object> map, SGIProgressControl sGIProgressControl, String string2, int n) throws FileNotFoundException {
        sGIProgressControl.setIndeterminateProgress(true);
        CreatedDataSet createdDataSet = null;
        sGIProgressControl.startProgress();
        try {
            if (string == null || map == null) {
                CreatedDataSet createdDataSet2 = null;
                return createdDataSet2;
            }
            if (map.size() == 0) {
                CreatedDataSet createdDataSet3 = null;
                return createdDataSet3;
            }
            SGIDataSource sGIDataSource = null;
            String string3 = (String)map.get("DataType");
            if (SGDataUtility.isArrayData(string3)) {
                sGIProgressControl.setProgressMessage(PROGRESS_MESSAGE_READFILE);
                List<String>[] listArray = this.createListArray(string);
                if (listArray == null) {
                    CreatedDataSet createdDataSet4 = null;
                    return createdDataSet4;
                }
                sGIProgressControl.setProgressMessage(PROGRESS_MESSAGE_CREATEDATA);
                SGDataColumnInfo[] sGDataColumnInfoArray = sGDataColumnInfoSet.getDataColumnInfoArray();
                if (sGDataColumnInfoArray.length < listArray.length) {
                    CreatedDataSet createdDataSet5 = null;
                    return createdDataSet5;
                }
                SGDataColumn[] sGDataColumnArray = this.createColumnArray(sGDataColumnInfoArray, listArray, map);
                if (sGDataColumnArray == null) {
                    CreatedDataSet createdDataSet6 = null;
                    return createdDataSet6;
                }
                if (string2 != null && n == 2 && "".equals(string2)) {
                    int n2 = -1;
                    int n3 = -1;
                    for (int i = 0; i < sGDataColumnInfoArray.length; ++i) {
                        String string4 = sGDataColumnInfoArray[i].getColumnType();
                        if (string4.startsWith("Lower Error")) {
                            n2 = i;
                        }
                        if (!string4.startsWith("Upper Error")) continue;
                        n3 = i;
                    }
                    if (n2 != -1 && n3 != -1) {
                        SGDataColumn sGDataColumn = sGDataColumnArray[n2];
                        sGDataColumnArray[n2] = sGDataColumnArray[n3];
                        sGDataColumnArray[n3] = sGDataColumn;
                    }
                }
                sGIDataSource = new SGTextDataFile(string, sGDataColumnArray);
            } else if (SGDataUtility.isNetCDFData(string3)) {
                NetcdfFile netcdfFile = null;
                try {
                    netcdfFile = NetcdfFile.open((String)string);
                }
                catch (IOException iOException) {
                    CreatedDataSet createdDataSet7 = null;
                    sGIProgressControl.endProgress();
                    return createdDataSet7;
                }
                sGIDataSource = new SGNetCDFFile(netcdfFile);
            } else {
                CreatedDataSet createdDataSet8 = null;
                return createdDataSet8;
            }
            createdDataSet = this.createData(sGIDataSource, sGDataColumnInfoSet, map, sGIProgressControl);
        }
        finally {
            sGIProgressControl.endProgress();
        }
        return createdDataSet;
    }

    private SGDataColumn[] createColumnArray(SGDataColumnInfo[] sGDataColumnInfoArray, List<String>[] listArray, Map<String, Object> map) {
        String string = (String)map.get("DataType");
        int n = listArray[0].size();
        for (int i = 1; i < listArray.length; ++i) {
            if (listArray[i].size() == n) continue;
            return null;
        }
        SGDataColumn[] sGDataColumnArray = new SGDataColumn[sGDataColumnInfoArray.length];
        for (int i = 0; i < sGDataColumnArray.length; ++i) {
            int n2;
            Object object;
            Object object2;
            String string2 = sGDataColumnInfoArray[i].getTitle();
            String string3 = sGDataColumnInfoArray[i].getValueType();
            if (SGUtilityText.isEqualString("Number", string3)) {
                Object[] objectArray;
                object2 = listArray[i];
                if (SGDataUtility.hasTickLabels(string)) {
                    for (int j = 0; j < n; ++j) {
                        String string4 = object2.get(j);
                        object = SGUtilityText.getDouble(string4);
                        if (object != null) continue;
                        return null;
                    }
                    objectArray = new String[n];
                    for (n2 = 0; n2 < n; ++n2) {
                        objectArray[n2] = (double)((String)object2.get(n2));
                    }
                    sGDataColumnArray[i] = new SGNumberDataColumn(string2, (String[])objectArray);
                    continue;
                }
                objectArray = new double[n];
                for (n2 = 0; n2 < n; ++n2) {
                    object = object2.get(n2);
                    Double d = SGUtilityText.getDouble((String)object);
                    if (d == null) {
                        return null;
                    }
                    objectArray[n2] = d;
                }
                sGDataColumnArray[i] = new SGNumberDataColumn(string2, (double[])objectArray);
                continue;
            }
            if (SGUtilityText.isEqualString("Text", string3)) {
                object2 = listArray[i];
                String[] stringArray = new String[n];
                for (n2 = 0; n2 < n; ++n2) {
                    stringArray[n2] = (String)object2.get(n2);
                }
                sGDataColumnArray[i] = new SGTextDataColumn(string2, stringArray);
                continue;
            }
            if (SGUtilityText.isEqualString("Date", string3)) {
                object2 = listArray[i];
                SGDate[] sGDateArray = new SGDate[n];
                for (n2 = 0; n2 < n; ++n2) {
                    object = (String)object2.get(n2);
                    try {
                        sGDateArray[n2] = new SGDate((String)object);
                        continue;
                    }
                    catch (ParseException parseException) {
                        return null;
                    }
                }
                sGDataColumnArray[i] = new SGDateDataColumn(string2, sGDateArray);
                continue;
            }
            if (SGUtilityText.isEqualString("Sampling Rate", string3)) {
                object2 = this.getSamplingRate(map);
                if (object2 == null) {
                    return null;
                }
                double d = ((Number)object2).doubleValue();
                sGDataColumnArray[i] = new SGSamplingDataColumn(d, n);
                continue;
            }
            throw new Error("Illegal value type: " + string3);
        }
        return sGDataColumnArray;
    }

    private CreatedDataSet createSingleSXYData(SGIDataSource sGIDataSource, SGIProgressControl sGIProgressControl, SGDataColumnInfoSet sGDataColumnInfoSet, Map<String, Object> map) {
        int n;
        Object object;
        Object object2;
        Object object3;
        Integer n2;
        Object object4;
        Object object5;
        Serializable serializable;
        HashMap<Integer, Integer> hashMap;
        HashMap<Integer, Integer> hashMap2;
        HashMap<Integer, Integer> hashMap3;
        ArrayList<Integer> arrayList;
        ArrayList<Integer> arrayList2;
        SGTextDataFile sGTextDataFile = (SGTextDataFile)sGIDataSource;
        SGDataColumnInfo[] sGDataColumnInfoArray = sGDataColumnInfoSet.getDataColumnInfoArray();
        if (!SGDataUtility.getSXYColumnType(sGDataColumnInfoArray, arrayList2 = new ArrayList<Integer>(), arrayList = new ArrayList<Integer>(), hashMap3 = new HashMap<Integer, Integer>(), hashMap2 = new HashMap<Integer, Integer>(), hashMap = new HashMap<Integer, Integer>())) {
            return null;
        }
        if (arrayList2.size() != 1 && arrayList.size() != 1) {
            return null;
        }
        ArrayList<Object> arrayList3 = new ArrayList<Object>();
        Serializable serializable2 = new ArrayList();
        if (arrayList2.size() == 1 && arrayList.size() == 1) {
            Serializable serializable3;
            Integer n3;
            Serializable serializable4;
            serializable = (Integer)arrayList2.get(0);
            Integer n4 = (Integer)arrayList.get(0);
            object5 = (Integer)hashMap3.get(serializable);
            object4 = (Integer)hashMap3.get(n4);
            n2 = (Integer)hashMap2.get(serializable);
            object3 = (Integer)hashMap2.get(n4);
            if (object5 != null && n2 != null) {
                object2 = object5;
                object = n2;
                serializable4 = serializable;
            } else if (object4 != null && object3 != null) {
                object2 = object4;
                object = object3;
                serializable4 = n4;
            } else {
                object2 = null;
                object = null;
                serializable4 = null;
            }
            Integer n5 = (Integer)hashMap.get(serializable);
            Integer n6 = (Integer)hashMap.get(n4);
            if (n5 != null) {
                n3 = n5;
                serializable3 = serializable;
            } else if (n6 != null) {
                n3 = n6;
                serializable3 = n4;
            } else {
                n3 = null;
                serializable3 = null;
            }
            SGSXYData sGSXYData = new SGSXYData(sGTextDataFile, this.mDataSourceObserver, (Integer)serializable, n4, (Integer)object2, (Integer)object, (Integer)serializable4, n3, (Integer)serializable3);
            arrayList3.add(sGSXYData);
            serializable2.add(null);
        } else if (arrayList2.size() == 1) {
            serializable = (Integer)arrayList2.get(0);
            for (int i = 0; i < arrayList.size(); ++i) {
                object5 = (Integer)arrayList.get(i);
                object4 = (Integer)hashMap3.get(object5);
                n2 = (Integer)hashMap2.get(object5);
                object3 = (Integer)hashMap.get(object5);
                object2 = new SGSXYData(sGTextDataFile, this.mDataSourceObserver, (Integer)serializable, (Integer)object5, (Integer)object4, n2, (Integer)object5, (Integer)object3, (Integer)object5);
                arrayList3.add(object2);
                object = sGDataColumnInfoArray[(Integer)object5].getTitle();
                if (object == null || "".equals(object)) {
                    object = Integer.valueOf((Integer)object5 + 1).toString();
                }
                serializable2.add(object);
            }
        } else {
            serializable = (Integer)arrayList.get(0);
            for (int i = 0; i < arrayList2.size(); ++i) {
                object5 = (Integer)arrayList2.get(i);
                object4 = (Integer)hashMap3.get(object5);
                n2 = (Integer)hashMap2.get(object5);
                object3 = (Integer)hashMap.get(object5);
                object2 = new SGSXYData(sGTextDataFile, this.mDataSourceObserver, (Integer)object5, (Integer)serializable, (Integer)object4, n2, (Integer)object5, (Integer)object3, (Integer)object5);
                arrayList3.add(object2);
                object = sGDataColumnInfoArray[(Integer)object5].getTitle();
                if (object == null || "".equals(object)) {
                    object = Integer.valueOf((Integer)object5 + 1).toString();
                }
                serializable2.add(object);
            }
        }
        serializable = new ArrayList();
        for (int i = 0; i < serializable2.size(); ++i) {
            object5 = (String)serializable2.get(i);
            if (object5 == null) {
                serializable.add(null);
                continue;
            }
            object5 = SGUtility.addEscapeChar((String)object5);
            serializable.add(object5);
        }
        serializable2 = serializable;
        SGData[] sGDataArray = new SGData[arrayList3.size()];
        for (int i = 0; i < sGDataArray.length; ++i) {
            object4 = (SGSXYData)arrayList3.get(i);
            sGDataArray[i] = (SGData)((Object)((SGSXYData)object4).toMultiple());
        }
        String[] stringArray = serializable2.toArray(new String[serializable2.size()]);
        object4 = new CreatedDataSet();
        for (n = 0; n < stringArray.length; ++n) {
            ((CreatedDataSet)object4).addData(sGDataArray[n], stringArray[n]);
        }
        for (n = 0; n < sGDataArray.length; ++n) {
            object3 = (SGData)arrayList3.get(n);
            ((SGData)object3).dispose();
        }
        return object4;
    }

    private CreatedDataSet createMultipleSXYData(SGIDataSource sGIDataSource, SGIProgressControl sGIProgressControl, SGDataColumnInfoSet sGDataColumnInfoSet, Map<String, Object> map) {
        Object object;
        Object object2;
        HashMap<Integer, Integer> hashMap;
        HashMap<Integer, Integer> hashMap2;
        HashMap<Integer, Integer> hashMap3;
        ArrayList<Integer> arrayList;
        ArrayList<Integer> arrayList2;
        SGTextDataFile sGTextDataFile = (SGTextDataFile)sGIDataSource;
        SGDataColumnInfo[] sGDataColumnInfoArray = sGDataColumnInfoSet.getDataColumnInfoArray();
        if (!SGDataUtility.getSXYColumnType(sGDataColumnInfoArray, arrayList2 = new ArrayList<Integer>(), arrayList = new ArrayList<Integer>(), hashMap3 = new HashMap<Integer, Integer>(), hashMap2 = new HashMap<Integer, Integer>(), hashMap = new HashMap<Integer, Integer>())) {
            return null;
        }
        if (arrayList2.size() != 1 && arrayList.size() != 1) {
            return null;
        }
        Integer[] integerArray = new Integer[arrayList2.size()];
        integerArray = arrayList2.toArray(integerArray);
        Integer[] integerArray2 = new Integer[arrayList.size()];
        integerArray2 = arrayList.toArray(integerArray2);
        Integer[] integerArray3 = null;
        Integer[] integerArray4 = null;
        Integer[] integerArray5 = null;
        Integer[] integerArray6 = null;
        Integer[] integerArray7 = null;
        if (arrayList2.size() == 1 && arrayList.size() == 1) {
            object2 = (Integer)arrayList2.get(0);
            object = (Integer)arrayList.get(0);
            Integer n = (Integer)hashMap3.get(object2);
            Integer n2 = (Integer)hashMap3.get(object);
            Integer n3 = (Integer)hashMap2.get(object2);
            Integer n4 = (Integer)hashMap2.get(object);
            Integer n5 = null;
            Integer n6 = null;
            Serializable serializable = null;
            if (n != null && n3 != null) {
                n5 = n;
                n6 = n3;
                serializable = object2;
            } else if (n2 != null && n4 != null) {
                n5 = n2;
                n6 = n4;
                serializable = object;
            }
            if (n5 != null && n6 != null && serializable != null) {
                integerArray3 = new Integer[]{n5};
                integerArray4 = new Integer[]{n6};
                integerArray5 = new Integer[]{serializable};
            }
            Integer n7 = (Integer)hashMap.get(object2);
            Integer n8 = (Integer)hashMap.get(object);
            Integer n9 = null;
            Serializable serializable2 = null;
            if (n7 != null) {
                n9 = n7;
                serializable2 = object2;
            } else if (n8 != null) {
                n9 = n8;
                serializable2 = object;
            }
            if (n9 != null) {
                integerArray6 = new Integer[]{n9};
                integerArray7 = new Integer[]{serializable2};
            }
        } else if (arrayList2.size() == 1) {
            object2 = new ArrayList();
            object = new ArrayList();
            ArrayList<Integer> arrayList3 = new ArrayList<Integer>();
            ArrayList<Integer> arrayList4 = new ArrayList<Integer>();
            ArrayList<Integer> arrayList5 = new ArrayList<Integer>();
            for (int i = 0; i < arrayList.size(); ++i) {
                Integer n;
                Integer n10 = (Integer)arrayList.get(i);
                Integer n11 = (Integer)hashMap3.get(n10);
                Integer n12 = (Integer)hashMap2.get(n10);
                if (n11 != null && n12 != null) {
                    object2.add(n11);
                    object.add(n12);
                    arrayList3.add(n10);
                }
                if ((n = (Integer)hashMap.get(n10)) == null) continue;
                arrayList4.add(n);
                arrayList5.add(n10);
            }
            integerArray3 = object2.toArray(new Integer[object2.size()]);
            integerArray4 = object.toArray(new Integer[object.size()]);
            integerArray5 = arrayList3.toArray(new Integer[arrayList3.size()]);
            integerArray6 = arrayList4.toArray(new Integer[arrayList4.size()]);
            integerArray7 = arrayList5.toArray(new Integer[arrayList5.size()]);
        } else {
            object2 = new ArrayList();
            object = new ArrayList();
            ArrayList<Integer> arrayList6 = new ArrayList<Integer>();
            ArrayList<Integer> arrayList7 = new ArrayList<Integer>();
            ArrayList<Integer> arrayList8 = new ArrayList<Integer>();
            for (int i = 0; i < arrayList2.size(); ++i) {
                Integer n;
                Integer n13 = (Integer)arrayList2.get(i);
                Integer n14 = (Integer)hashMap3.get(n13);
                Integer n15 = (Integer)hashMap2.get(n13);
                if (n14 != null && n15 != null) {
                    object2.add(n14);
                    object.add(n15);
                    arrayList6.add(n13);
                }
                if ((n = (Integer)hashMap.get(n13)) == null) continue;
                arrayList7.add(n);
                arrayList8.add(n13);
            }
            integerArray3 = object2.toArray(new Integer[object2.size()]);
            integerArray4 = object.toArray(new Integer[object.size()]);
            integerArray5 = arrayList6.toArray(new Integer[arrayList6.size()]);
            integerArray6 = arrayList7.toArray(new Integer[arrayList7.size()]);
            integerArray7 = arrayList8.toArray(new Integer[arrayList8.size()]);
        }
        object2 = new SGSXYMultipleData(sGTextDataFile, this.mDataSourceObserver, integerArray, integerArray2, integerArray3, integerArray4, integerArray5, integerArray6, integerArray7);
        object = new CreatedDataSet();
        ((CreatedDataSet)object).addData((SGData)object2);
        return object;
    }

    private CreatedDataSet createVXYData(SGIDataSource sGIDataSource, SGIProgressControl sGIProgressControl, SGDataColumnInfoSet sGDataColumnInfoSet, Map<String, Object> map) {
        Object object;
        SGTextDataFile sGTextDataFile = (SGTextDataFile)sGIDataSource;
        SGDataColumnInfo[] sGDataColumnInfoArray = sGDataColumnInfoSet.getDataColumnInfoArray();
        if (map.size() <= 1) {
            return null;
        }
        Object object2 = map.get("Polar selected");
        if (!(object2 instanceof Boolean)) {
            return null;
        }
        Boolean bl = (Boolean)object2;
        boolean bl2 = bl;
        String string = bl2 ? "Magnitude" : "X-Component";
        String string2 = bl2 ? "Angle" : "Y-Component";
        Integer n = null;
        Integer n2 = null;
        Integer n3 = null;
        Integer n4 = null;
        for (int i = 0; i < sGDataColumnInfoArray.length; ++i) {
            object = sGDataColumnInfoArray[i].getColumnType();
            if (SGUtilityText.isEqualString("X-Coordinate", (String)object)) {
                n = i;
                continue;
            }
            if (SGUtilityText.isEqualString("Y-Coordinate", (String)object)) {
                n2 = i;
                continue;
            }
            if (SGUtilityText.isEqualString(string, (String)object)) {
                n3 = i;
                continue;
            }
            if (SGUtilityText.isEqualString(string2, (String)object)) {
                n4 = i;
                continue;
            }
            if ("".equals(object)) continue;
            throw new Error("Illegal Column Type: " + (String)object);
        }
        SGVXYData sGVXYData = new SGVXYData(sGTextDataFile, this.mDataSourceObserver, n, n2, n3, n4, bl2);
        object = new CreatedDataSet();
        ((CreatedDataSet)object).addData(sGVXYData);
        return object;
    }

    private CreatedDataSet createSXYZData(SGIDataSource sGIDataSource, SGIProgressControl sGIProgressControl, SGDataColumnInfoSet sGDataColumnInfoSet, Map<String, Object> map) {
        Object object;
        SGTextDataFile sGTextDataFile = (SGTextDataFile)sGIDataSource;
        SGDataColumnInfo[] sGDataColumnInfoArray = sGDataColumnInfoSet.getDataColumnInfoArray();
        Integer n = null;
        Integer n2 = null;
        Integer n3 = null;
        for (int i = 0; i < sGDataColumnInfoArray.length; ++i) {
            object = sGDataColumnInfoArray[i].getColumnType();
            if (SGUtilityText.isEqualString("X", (String)object)) {
                n = i;
                continue;
            }
            if (SGUtilityText.isEqualString("Y", (String)object)) {
                n2 = i;
                continue;
            }
            if (SGUtilityText.isEqualString("Z", (String)object)) {
                n3 = i;
                continue;
            }
            if ("".equals(object)) continue;
            throw new Error("Illegal Column Type: " + (String)object);
        }
        SGSXYZData sGSXYZData = new SGSXYZData(sGTextDataFile, this.mDataSourceObserver, n, n2, n3);
        object = new CreatedDataSet();
        ((CreatedDataSet)object).addData(sGSXYZData);
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private List<String>[] createListArray(String string) throws FileNotFoundException {
        int n;
        List[] listArray = null;
        int n2 = -1;
        SGBufferedFileReader sGBufferedFileReader = null;
        try {
            String string2;
            sGBufferedFileReader = new SGBufferedFileReader(string);
            BufferedReader bufferedReader = sGBufferedFileReader.getBufferedReader();
            n = 1;
            while ((string2 = SGUtilityText.readLine(bufferedReader)) != null) {
                Object object;
                int n3;
                ArrayList<SGCSVTokenizer.Token> arrayList = new ArrayList<SGCSVTokenizer.Token>();
                if (!SGUtilityText.tokenize(string2, arrayList, true)) {
                    List<String>[] listArray2 = null;
                    return listArray2;
                }
                if (arrayList.size() == 0) continue;
                if (n2 == -1) {
                    n2 = arrayList.size();
                    listArray = new List[n2];
                    for (n3 = 0; n3 < listArray.length; ++n3) {
                        listArray[n3] = new ArrayList();
                    }
                } else if (arrayList.size() != n2) {
                    if (arrayList.size() == 0) continue;
                    List<String>[] listArray3 = null;
                    return listArray3;
                }
                n3 = 1;
                for (int i = 0; i < n2; ++i) {
                    SGCSVTokenizer.Token token = (SGCSVTokenizer.Token)arrayList.get(i);
                    object = token.getString();
                    char[] cArray = ((String)object).toCharArray();
                    for (int j = 0; j < cArray.length; ++j) {
                        if (Character.isSpaceChar(cArray[j])) continue;
                        n3 = 0;
                        break;
                    }
                    if (n3 == 0) break;
                }
                if (n3 != 0) continue;
                List<Integer> list = SGDataUtility.getColumnIndexListOfNumber(arrayList);
                if (n != 0) {
                    n = 0;
                    if (this.evaluteTitleList(list)) continue;
                }
                for (int i = 0; i < n2; ++i) {
                    object = (SGCSVTokenizer.Token)arrayList.get(i);
                    listArray[i].add(((SGCSVTokenizer.Token)object).getString());
                }
            }
        }
        catch (IOException iOException) {
            List<String>[] listArray4 = null;
            return listArray4;
        }
        finally {
            if (sGBufferedFileReader != null) {
                sGBufferedFileReader.close();
            }
        }
        int n4 = listArray[0].size();
        n = 1;
        while (n < listArray.length) {
            if (listArray[n].size() != n4) {
                return null;
            }
            ++n;
        }
        return listArray;
    }

    private boolean evaluteTitleList(List<Integer> list) {
        boolean bl = true;
        if (list.size() == 0) {
            return false;
        }
        for (int i = 0; i < list.size(); ++i) {
            Integer n = list.get(i);
            if (n == 0) continue;
            bl = false;
        }
        return bl;
    }

    public boolean getDataTypeCandidateList(String string, List<String> list) throws FileNotFoundException {
        return this.getTextDataTypeCandidateList(string, list);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean getTextDataTypeCandidateList(String string, List<String> list) throws FileNotFoundException {
        SGBufferedFileReader sGBufferedFileReader = null;
        try {
            int n;
            List<String>[] listArray;
            sGBufferedFileReader = new SGBufferedFileReader(string);
            BufferedReader bufferedReader = sGBufferedFileReader.getBufferedReader();
            List<SGCSVTokenizer.Token> list2 = SGUtilityText.getFirstTokenList(bufferedReader);
            if (list2 == null) {
                boolean bl = false;
                return bl;
            }
            List<Integer> list3 = SGDataUtility.getColumnIndexListOfNumber(list2);
            if (this.evaluteTitleList(list3)) {
                list2 = SGUtilityText.getFirstTokenList(bufferedReader);
                if (list2 == null) {
                    boolean bl = false;
                    return bl;
                }
                list3 = SGDataUtility.getColumnIndexListOfNumber(list2);
            }
            if ((listArray = this.createListArray(string)) == null) {
                boolean bl = false;
                return bl;
            }
            ArrayList<Integer> arrayList = new ArrayList<Integer>();
            for (n = 0; n < listArray.length; ++n) {
                Integer n2 = list3.get(n);
                List<String> list4 = listArray[n];
                if (n2 != 0) {
                    boolean bl = false;
                    for (int i = 0; i < list4.size(); ++i) {
                        String string2 = list4.get(i);
                        if (SGUtilityText.getDouble(string2) != null) continue;
                        bl = true;
                        break;
                    }
                    if (bl) {
                        arrayList.add(0);
                        continue;
                    }
                    arrayList.add(1);
                    continue;
                }
                arrayList.add(0);
            }
            if (!SGDataUtility.getDataTypeCandidateList(list2, arrayList, list)) {
                n = 0;
                return n != 0;
            }
        }
        catch (IOException iOException) {
            boolean bl = false;
            return bl;
        }
        finally {
            if (sGBufferedFileReader != null) {
                sGBufferedFileReader.close();
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FileColumn[] parseFileComlumnType(String string, String string2, boolean bl, String string3) throws FileNotFoundException {
        List<SGCSVTokenizer.Token> list;
        FileColumn[] fileColumnArray = null;
        SGBufferedFileReader sGBufferedFileReader = null;
        try {
            Serializable serializable;
            Object object;
            int n;
            sGBufferedFileReader = new SGBufferedFileReader(string);
            BufferedReader bufferedReader = sGBufferedFileReader.getBufferedReader();
            list = SGUtilityText.getFirstTokenList(bufferedReader);
            if (list == null) {
                FileColumn[] fileColumnArray2 = null;
                return fileColumnArray2;
            }
            int n2 = list.size();
            fileColumnArray = new FileColumn[n2];
            List<Integer> list2 = SGDataUtility.getColumnIndexListOfNumber(list);
            String[] stringArray = new String[n2];
            if (this.evaluteTitleList(list2)) {
                for (n = 0; n < n2; ++n) {
                    object = list.get(n);
                    stringArray[n] = ((SGCSVTokenizer.Token)object).getString();
                }
                list = SGUtilityText.getFirstTokenList(bufferedReader);
                if (list == null) {
                    FileColumn[] fileColumnArray3 = null;
                    return fileColumnArray3;
                }
                if (list.size() != n2) {
                    FileColumn[] fileColumnArray4 = null;
                    return fileColumnArray4;
                }
            } else {
                for (n = 0; n < n2; ++n) {
                    stringArray[n] = null;
                }
            }
            for (n = 0; n < n2; ++n) {
                Date date;
                fileColumnArray[n] = new FileColumn();
                fileColumnArray[n].index = n;
                fileColumnArray[n].title = stringArray[n];
                object = null;
                SGCSVTokenizer.Token token = list.get(n);
                object = token.isDoubleQuoted() ? ((serializable = SGUtilityText.getDate(token.getString())) != null ? "Date" : "Text") : ((serializable = SGUtilityText.getDouble(token.getString())) != null ? "Number" : ((date = SGUtilityText.getDate(token.getString())) != null ? "Date" : "Text"));
                fileColumnArray[n].valueType = object;
            }
            ArrayList<Integer> arrayList = new ArrayList<Integer>();
            object = new ArrayList();
            for (int i = 0; i < n2; ++i) {
                if (SGUtilityText.isEqualString("Number", fileColumnArray[i].valueType)) {
                    arrayList.add(i);
                    continue;
                }
                if (!SGUtilityText.isEqualString("Date", fileColumnArray[i].valueType)) continue;
                object.add(i);
            }
            if (arrayList.size() != 0 || object.size() != 0) {
                int n3;
                Object object2;
                int n4;
                Object object3;
                List<String>[] listArray = this.createListArray(string);
                if (listArray == null) {
                    serializable = null;
                    return serializable;
                }
                serializable = new ArrayList();
                for (int i = 0; i < arrayList.size(); ++i) {
                    Integer n5 = (Integer)arrayList.get(i);
                    object3 = listArray[n5];
                    boolean bl2 = true;
                    for (n4 = 0; n4 < object3.size(); ++n4) {
                        String string4 = (String)object3.get(n4);
                        object2 = SGUtilityText.getDouble(string4);
                        if (object2 != null) continue;
                        bl2 = false;
                    }
                    if (bl2) continue;
                    serializable.add(n5);
                }
                ArrayList<Object> arrayList2 = new ArrayList<Object>();
                for (n3 = 0; n3 < object.size(); ++n3) {
                    object3 = (Integer)object.get(n3);
                    List<String> list3 = listArray[(Integer)object3];
                    n4 = 1;
                    for (int i = 0; i < list3.size(); ++i) {
                        object2 = list3.get(i);
                        Date date = SGUtilityText.getDate((String)object2);
                        if (date != null) continue;
                        n4 = 0;
                    }
                    if (n4 != 0) continue;
                    arrayList2.add(object3);
                }
                for (n3 = 0; n3 < serializable.size(); ++n3) {
                    object3 = (Integer)serializable.get(n3);
                    fileColumnArray[((Integer)object3).intValue()].valueType = "Text";
                }
                for (n3 = 0; n3 < arrayList2.size(); ++n3) {
                    object3 = (Integer)arrayList2.get(n3);
                    fileColumnArray[((Integer)object3).intValue()].valueType = "Text";
                }
            }
            if (bl && string3 != null && "".equals(string3) && SGDataUtility.hasTickLabels(string2) && (n2 == 3 || n2 == 5)) {
                fileColumnArray[n2 - 1].valueType = "Text";
            }
        }
        catch (IOException iOException) {
            list = null;
            return list;
        }
        finally {
            if (sGBufferedFileReader != null) {
                sGBufferedFileReader.close();
            }
        }
        return fileColumnArray;
    }

    private CreatedDataSet createSingleVariableSXYNetCDFData(SGIDataSource sGIDataSource, SGIProgressControl sGIProgressControl, SGDataColumnInfoSet sGDataColumnInfoSet, Map<String, Object> map) {
        int n;
        Object object;
        Object object2;
        String string;
        Object object3;
        String string2;
        Object object4;
        ArrayList<String> arrayList;
        ArrayList<String> arrayList2;
        HashMap<String, String> hashMap;
        HashMap<String, String> hashMap2;
        HashMap<String, String> hashMap3;
        ArrayList<String> arrayList3;
        ArrayList<String> arrayList4;
        SGNetCDFFile sGNetCDFFile = (SGNetCDFFile)sGIDataSource;
        NetcdfFile netcdfFile = sGNetCDFFile.getNetcdfFile();
        SGDataColumnInfo[] sGDataColumnInfoArray = sGDataColumnInfoSet.getDataColumnInfoArray();
        if (!SGDataUtility.getSXYNetCDFColumnType(sGDataColumnInfoArray, arrayList4 = new ArrayList<String>(), arrayList3 = new ArrayList<String>(), hashMap3 = new HashMap<String, String>(), hashMap2 = new HashMap<String, String>(), hashMap = new HashMap<String, String>(), arrayList2 = new ArrayList<String>(), arrayList = new ArrayList<String>())) {
            return null;
        }
        if (arrayList4.size() != 1 && arrayList3.size() != 1) {
            return null;
        }
        String string3 = null;
        if (arrayList2.size() != 0) {
            string3 = (String)arrayList2.get(0);
        }
        String string4 = null;
        if (arrayList.size() != 0) {
            string4 = (String)arrayList.get(0);
        }
        ArrayList<Object> arrayList5 = new ArrayList<Object>();
        Object object5 = new ArrayList();
        if (arrayList4.size() == 1 && arrayList3.size() == 1) {
            Object object6;
            String string5;
            Object object7;
            String string6;
            object4 = (String)arrayList4.get(0);
            String string7 = (String)arrayList3.get(0);
            string2 = (String)hashMap3.get(object4);
            object3 = (String)hashMap3.get(string7);
            string = (String)hashMap2.get(object4);
            object2 = (String)hashMap2.get(string7);
            if (string2 != null && string != null) {
                object = string2;
                string6 = string;
                object7 = object4;
            } else if (object3 != null && object2 != null) {
                object = object3;
                string6 = object2;
                object7 = string7;
            } else {
                object = null;
                string6 = null;
                object7 = null;
            }
            String string8 = (String)hashMap.get(object4);
            String string9 = (String)hashMap.get(string7);
            if (string8 != null) {
                string5 = string8;
                object6 = object4;
            } else if (string9 != null) {
                string5 = string9;
                object6 = string7;
            } else {
                string5 = null;
                object6 = null;
            }
            SGSXYNetCDFData sGSXYNetCDFData = sGNetCDFFile.findVariable((String)object4) instanceof SGDateVariable || sGNetCDFFile.findVariable(string7) instanceof SGDateVariable ? new SGSXYNetCDFDateData(sGNetCDFFile, this.mDataSourceObserver, (String)object4, string7, (String)object, string6, (String)object7, string5, (String)object6, string3, string4) : new SGSXYNetCDFData(sGNetCDFFile, this.mDataSourceObserver, (String)object4, string7, (String)object, string6, (String)object7, string5, (String)object6, string3, string4);
            arrayList5.add(sGSXYNetCDFData);
            object5.add(null);
            this.setOrigin(sGDataColumnInfoArray, netcdfFile, sGSXYNetCDFData);
        } else if (arrayList4.size() == 1) {
            object4 = (String)arrayList4.get(0);
            for (int i = 0; i < arrayList3.size(); ++i) {
                string2 = (String)arrayList3.get(i);
                object3 = (String)hashMap3.get(string2);
                string = (String)hashMap2.get(string2);
                object2 = (String)hashMap.get(string2);
                object = new SGSXYNetCDFData(sGNetCDFFile, this.mDataSourceObserver, (String)object4, string2, (String)object3, string, string2, (String)object2, string2, string3, string4);
                arrayList5.add(object);
                object5.add(string2);
                this.setOrigin(sGDataColumnInfoArray, netcdfFile, (SGNetCDFData)object);
            }
        } else {
            object4 = (String)arrayList3.get(0);
            for (int i = 0; i < arrayList4.size(); ++i) {
                string2 = (String)arrayList4.get(i);
                object3 = (String)hashMap3.get(string2);
                string = (String)hashMap2.get(string2);
                object2 = (String)hashMap.get(object4);
                object = new SGSXYNetCDFData(sGNetCDFFile, this.mDataSourceObserver, string2, (String)object4, (String)object3, string, string2, (String)object2, string2, string3, string4);
                arrayList5.add(object);
                object5.add(string2);
                this.setOrigin(sGDataColumnInfoArray, netcdfFile, (SGNetCDFData)object);
            }
        }
        object4 = new ArrayList();
        for (int i = 0; i < object5.size(); ++i) {
            string2 = (String)object5.get(i);
            if (string2 == null) {
                object4.add(null);
                continue;
            }
            string2 = SGUtility.addEscapeChar(string2);
            object4.add(string2);
        }
        object5 = object4;
        SGData[] sGDataArray = new SGData[arrayList5.size()];
        for (int i = 0; i < sGDataArray.length; ++i) {
            object3 = (SGSXYNetCDFData)arrayList5.get(i);
            sGDataArray[i] = (SGData)((Object)((SGSXYNetCDFData)object3).toMultiple());
        }
        String[] stringArray = object5.toArray(new String[object5.size()]);
        object3 = new CreatedDataSet();
        for (n = 0; n < stringArray.length; ++n) {
            ((CreatedDataSet)object3).addData(sGDataArray[n], stringArray[n]);
        }
        for (n = 0; n < sGDataArray.length; ++n) {
            object2 = (SGData)arrayList5.get(n);
            ((SGData)object2).dispose();
        }
        return object3;
    }

    private CreatedDataSet createMultipleVariableSXYNetCDFData(SGIDataSource sGIDataSource, SGIProgressControl sGIProgressControl, SGDataColumnInfoSet sGDataColumnInfoSet, Map<String, Object> map) {
        SGNetCDFFile sGNetCDFFile = (SGNetCDFFile)sGIDataSource;
        NetcdfFile netcdfFile = sGNetCDFFile.getNetcdfFile();
        SGDataColumnInfo[] sGDataColumnInfoArray = sGDataColumnInfoSet.getDataColumnInfoArray();
        SGSXYMultipleVariableNetCDFData sGSXYMultipleVariableNetCDFData = SGDataUtility.createVariableNetCDFData(sGNetCDFFile, this.mDataSourceObserver, sGDataColumnInfoArray);
        this.setOrigin(sGDataColumnInfoArray, netcdfFile, sGSXYMultipleVariableNetCDFData);
        CreatedDataSet createdDataSet = new CreatedDataSet();
        createdDataSet.addData(sGSXYMultipleVariableNetCDFData);
        return createdDataSet;
    }

    private CreatedDataSet createDimensionSXYNetCDFData(SGIDataSource sGIDataSource, SGIProgressControl sGIProgressControl, SGDataColumnInfoSet sGDataColumnInfoSet, Map<String, Object> map, boolean bl) {
        Dimension dimension;
        ArrayList<String> arrayList;
        ArrayList<String> arrayList2;
        ArrayList<String> arrayList3;
        ArrayList<String> arrayList4;
        ArrayList<String> arrayList5;
        ArrayList<String> arrayList6;
        ArrayList<String> arrayList7;
        ArrayList<String> arrayList8;
        SGNetCDFFile sGNetCDFFile = (SGNetCDFFile)sGIDataSource;
        NetcdfFile netcdfFile = sGNetCDFFile.getNetcdfFile();
        SGDataColumnInfo[] sGDataColumnInfoArray = sGDataColumnInfoSet.getDataColumnInfoArray();
        if (!SGDataUtility.getSXYNetCDFColumnType(sGDataColumnInfoArray, arrayList8 = new ArrayList<String>(), arrayList7 = new ArrayList<String>(), arrayList6 = new ArrayList<String>(), arrayList5 = new ArrayList<String>(), arrayList4 = new ArrayList<String>(), arrayList3 = new ArrayList<String>(), arrayList2 = new ArrayList<String>(), arrayList = new ArrayList<String>())) {
            return null;
        }
        if (arrayList8.size() != 1) {
            return null;
        }
        if (arrayList7.size() != 1) {
            return null;
        }
        if (arrayList3.size() != 1) {
            return null;
        }
        if (!(arrayList6.size() == 0 && arrayList5.size() == 0 || arrayList6.size() == 1 && arrayList5.size() == 1)) {
            return null;
        }
        String string = (String)arrayList8.get(0);
        String string2 = (String)arrayList7.get(0);
        String string3 = null;
        if (arrayList6.size() > 0) {
            string3 = (String)arrayList6.get(0);
        }
        String string4 = null;
        if (arrayList5.size() > 0) {
            string4 = (String)arrayList5.get(0);
        }
        String string5 = null;
        if (arrayList4.size() > 0) {
            string5 = (String)arrayList4.get(0);
        }
        String string6 = (String)arrayList3.get(0);
        String string7 = null;
        if (arrayList2.size() != 0) {
            string7 = (String)arrayList2.get(0);
        }
        String string8 = null;
        if (arrayList.size() != 0) {
            string8 = (String)arrayList.get(0);
        }
        if ((dimension = netcdfFile.findDimension(string6)) == null) {
            return null;
        }
        int n = dimension.getLength();
        Integer n2 = (Integer)map.get("Multiple dimension start");
        if (n2 == null) {
            return null;
        }
        if (n2 < 0 || n2 >= n) {
            return null;
        }
        Integer n3 = (Integer)map.get("Multiple dimension end");
        if (n3 == null) {
            return null;
        }
        if (n3 < 0 || n3 >= n || n3 < n2) {
            return null;
        }
        Integer n4 = (Integer)map.get("Multiple dimension step");
        if (n4 == null) {
            return null;
        }
        CreatedDataSet createdDataSet = new CreatedDataSet();
        if (bl) {
            SGSXYMultipleDimensionNetCDFData sGSXYMultipleDimensionNetCDFData = new SGSXYMultipleDimensionNetCDFData(sGNetCDFFile, this.mDataSourceObserver, string, string2, string3, string4, string5, string6, n2, n3, n4, string7, string8);
            this.setOrigin(sGDataColumnInfoArray, netcdfFile, sGSXYMultipleDimensionNetCDFData);
            createdDataSet.addData(sGSXYMultipleDimensionNetCDFData);
        } else {
            Integer[] integerArray = SGDataUtility.calcDimIndices(dimension, n2, n3, n4);
            for (int i = 0; i < integerArray.length; ++i) {
                SGSXYMultipleDimensionNetCDFData sGSXYMultipleDimensionNetCDFData = new SGSXYMultipleDimensionNetCDFData(sGNetCDFFile, this.mDataSourceObserver, string, string2, string3, string4, string5, string6, integerArray[i], integerArray[i], 0, string7, string8);
                this.setOrigin(sGDataColumnInfoArray, netcdfFile, sGSXYMultipleDimensionNetCDFData);
                String string9 = this.getDimensionDataName(sGSXYMultipleDimensionNetCDFData, i, string6, integerArray[i]);
                createdDataSet.addData(sGSXYMultipleDimensionNetCDFData, "(" + string9 + ")");
            }
            createdDataSet.setMiddleString(" ");
        }
        return createdDataSet;
    }

    private String getDimensionDataName(SGSXYMultipleDimensionNetCDFData sGSXYMultipleDimensionNetCDFData, int n, String string, Integer n2) {
        if (null == n2) {
            return Integer.toString(n);
        }
        Double d = sGSXYMultipleDimensionNetCDFData.getDimensionValue(n2);
        if (null == d) {
            return Integer.toString(n);
        }
        double d2 = d;
        String string2 = string + "=" + SGUtility.getNumberName(d2);
        return string2;
    }

    private CreatedDataSet createVXYNetCDFData(SGIDataSource sGIDataSource, SGIProgressControl sGIProgressControl, SGDataColumnInfoSet sGDataColumnInfoSet, Map<String, Object> map) {
        Object object;
        SGNetCDFFile sGNetCDFFile = (SGNetCDFFile)sGIDataSource;
        NetcdfFile netcdfFile = sGNetCDFFile.getNetcdfFile();
        SGDataColumnInfo[] sGDataColumnInfoArray = sGDataColumnInfoSet.getDataColumnInfoArray();
        if (map.size() <= 1) {
            return null;
        }
        Object object2 = map.get("Polar selected");
        if (!(object2 instanceof Boolean)) {
            return null;
        }
        Boolean bl = (Boolean)object2;
        boolean bl2 = bl;
        sGIProgressControl.setProgressMessage(PROGRESS_MESSAGE_CREATEDATA);
        String string = bl2 ? "Magnitude" : "X-Component";
        String string2 = bl2 ? "Angle" : "Y-Component";
        String string3 = null;
        String string4 = null;
        String string5 = null;
        String string6 = null;
        String string7 = null;
        String string8 = null;
        for (int i = 0; i < sGDataColumnInfoArray.length; ++i) {
            object = (SGNetCDFDataColumnInfo)sGDataColumnInfoArray[i];
            String string9 = ((SGDataColumnInfo)object).getColumnType();
            String string10 = ((SGNetCDFDataColumnInfo)object).getVariableName();
            if (SGUtilityText.isEqualString("X-Coordinate", string9)) {
                string3 = string10;
                continue;
            }
            if (SGUtilityText.isEqualString("Y-Coordinate", string9)) {
                string4 = string10;
                continue;
            }
            if (SGUtilityText.isEqualString(string, string9)) {
                string5 = string10;
                continue;
            }
            if (SGUtilityText.isEqualString(string2, string9)) {
                string6 = string10;
                continue;
            }
            if (SGUtilityText.isEqualString("Time", string9)) {
                string7 = string10;
                continue;
            }
            if (SGUtilityText.isEqualString("SerialNumbers", string9)) {
                string8 = string10;
                continue;
            }
            if ("".equals(string9)) continue;
            throw new Error("Illegal Column Type: " + string9);
        }
        SGVXYNetCDFData sGVXYNetCDFData = new SGVXYNetCDFData(sGNetCDFFile, this.mDataSourceObserver, string3, string4, string5, string6, bl2, string7, string8);
        this.setOrigin(sGDataColumnInfoArray, netcdfFile, sGVXYNetCDFData);
        object = new CreatedDataSet();
        ((CreatedDataSet)object).addData(sGVXYNetCDFData);
        return object;
    }

    private CreatedDataSet createSXYZNetCDFData(SGIDataSource sGIDataSource, SGIProgressControl sGIProgressControl, SGDataColumnInfoSet sGDataColumnInfoSet, Map<String, Object> map) {
        Object object;
        SGNetCDFFile sGNetCDFFile = (SGNetCDFFile)sGIDataSource;
        NetcdfFile netcdfFile = sGNetCDFFile.getNetcdfFile();
        SGDataColumnInfo[] sGDataColumnInfoArray = sGDataColumnInfoSet.getDataColumnInfoArray();
        String string = null;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        String string5 = null;
        for (int i = 0; i < sGDataColumnInfoArray.length; ++i) {
            object = (SGNetCDFDataColumnInfo)sGDataColumnInfoArray[i];
            String string6 = ((SGDataColumnInfo)object).getColumnType();
            String string7 = ((SGNetCDFDataColumnInfo)object).getVariableName();
            if (SGUtilityText.isEqualString("X", string6)) {
                string = string7;
                continue;
            }
            if (SGUtilityText.isEqualString("Y", string6)) {
                string2 = string7;
                continue;
            }
            if (SGUtilityText.isEqualString("Z", string6)) {
                string3 = string7;
                continue;
            }
            if (SGUtilityText.isEqualString("Time", string6)) {
                string4 = string7;
                continue;
            }
            if (SGUtilityText.isEqualString("SerialNumbers", string6)) {
                string5 = string7;
                continue;
            }
            if ("".equals(string6)) continue;
            throw new Error("Illegal Column Type: " + string6);
        }
        SGSXYZNetCDFData sGSXYZNetCDFData = new SGSXYZNetCDFData(sGNetCDFFile, this.mDataSourceObserver, string, string2, string3, string4, string5);
        this.setOrigin(sGDataColumnInfoArray, netcdfFile, sGSXYZNetCDFData);
        object = new CreatedDataSet();
        ((CreatedDataSet)object).addData(sGSXYZNetCDFData);
        return object;
    }

    private Number getSamplingRate(Map<String, Object> map) {
        Object object = map.get("Sampling rate");
        if (object == null) {
            return null;
        }
        if (!(object instanceof Number)) {
            return null;
        }
        return (Number)object;
    }

    private void setOrigin(SGDataColumnInfo[] sGDataColumnInfoArray, NetcdfFile netcdfFile, SGNetCDFData sGNetCDFData) {
        for (int i = 0; i < sGDataColumnInfoArray.length; ++i) {
            SGNetCDFDataColumnInfo sGNetCDFDataColumnInfo = (SGNetCDFDataColumnInfo)sGDataColumnInfoArray[i];
            String string = sGNetCDFDataColumnInfo.getVariableName();
            int n = sGNetCDFDataColumnInfo.getOrigin();
            if (netcdfFile.findDimension(string) == null) continue;
            sGNetCDFData.setOrigin(string, n);
        }
    }

    public CreatedDataSet create(SGIDataSource sGIDataSource, SGDataColumnInfoSet sGDataColumnInfoSet, Map<String, Object> map, SGIProgressControl sGIProgressControl) {
        return this.createData(sGIDataSource, sGDataColumnInfoSet, map, sGIProgressControl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CreatedDataSet createData(SGIDataSource sGIDataSource, SGDataColumnInfoSet sGDataColumnInfoSet, Map<String, Object> map, SGIProgressControl sGIProgressControl) {
        CreatedDataSet createdDataSet;
        block25: {
            sGIProgressControl.setProgressMessage(PROGRESS_MESSAGE_CREATEDATA);
            createdDataSet = null;
            sGIProgressControl.startProgress();
            try {
                if (sGIDataSource == null || sGDataColumnInfoSet == null || map == null) {
                    CreatedDataSet createdDataSet2 = null;
                    return createdDataSet2;
                }
                if (map.size() == 0) {
                    CreatedDataSet createdDataSet3 = null;
                    return createdDataSet3;
                }
                String string = (String)map.get("DataType");
                if (SGDataUtility.isArrayData(string)) {
                    SGTextDataFile sGTextDataFile = (SGTextDataFile)sGIDataSource;
                    if (SGDataUtility.isSXYTypeData(string)) {
                        Boolean bl = (Boolean)map.get("Multiple");
                        if (bl == null) {
                            CreatedDataSet createdDataSet4 = null;
                            return createdDataSet4;
                        }
                        createdDataSet = bl.booleanValue() ? this.createMultipleSXYData(sGTextDataFile, sGIProgressControl, sGDataColumnInfoSet, map) : this.createSingleSXYData(sGTextDataFile, sGIProgressControl, sGDataColumnInfoSet, map);
                    } else if (SGUtilityText.isEqualString(string, "VXY")) {
                        createdDataSet = this.createVXYData(sGTextDataFile, sGIProgressControl, sGDataColumnInfoSet, map);
                    } else if (SGUtilityText.isEqualString(string, "SXYZ")) {
                        createdDataSet = this.createSXYZData(sGTextDataFile, sGIProgressControl, sGDataColumnInfoSet, map);
                    }
                    break block25;
                }
                if (SGDataUtility.isNetCDFData(string)) {
                    SGNetCDFFile sGNetCDFFile = (SGNetCDFFile)sGIDataSource;
                    if (SGDataUtility.isSXYTypeData(string)) {
                        Boolean bl = (Boolean)map.get("Multiple");
                        if (bl == null) {
                            CreatedDataSet createdDataSet5 = null;
                            return createdDataSet5;
                        }
                        Boolean bl2 = (Boolean)map.get("Graphs for multiple variables");
                        if (bl2 == null) {
                            CreatedDataSet createdDataSet6 = null;
                            return createdDataSet6;
                        }
                        createdDataSet = bl2.booleanValue() ? (bl.booleanValue() ? this.createMultipleVariableSXYNetCDFData(sGNetCDFFile, sGIProgressControl, sGDataColumnInfoSet, map) : this.createSingleVariableSXYNetCDFData(sGNetCDFFile, sGIProgressControl, sGDataColumnInfoSet, map)) : this.createDimensionSXYNetCDFData(sGNetCDFFile, sGIProgressControl, sGDataColumnInfoSet, map, bl);
                    } else if (SGUtilityText.isEqualString(string, "VXY_NETCDF")) {
                        createdDataSet = this.createVXYNetCDFData(sGNetCDFFile, sGIProgressControl, sGDataColumnInfoSet, map);
                    } else if (SGUtilityText.isEqualString(string, "SXYZ_NETCDF")) {
                        createdDataSet = this.createSXYZNetCDFData(sGNetCDFFile, sGIProgressControl, sGDataColumnInfoSet, map);
                    }
                    break block25;
                }
                CreatedDataSet createdDataSet7 = null;
                return createdDataSet7;
            }
            finally {
                sGIProgressControl.endProgress();
            }
        }
        return createdDataSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CreatedDataSet createForNetCDFDataSet(SGIDataSource sGIDataSource, String string, SGDataColumnInfoSet sGDataColumnInfoSet, Map<String, Object> map, SGIProgressControl sGIProgressControl) {
        sGIProgressControl.setProgressMessage(PROGRESS_MESSAGE_CREATEDATA);
        CreatedDataSet createdDataSet = null;
        sGIProgressControl.startProgress();
        try {
            Boolean bl;
            Object object;
            if (sGIDataSource == null || sGDataColumnInfoSet == null || map == null) {
                CreatedDataSet createdDataSet2 = null;
                return createdDataSet2;
            }
            if (map.size() == 0) {
                CreatedDataSet createdDataSet3 = null;
                return createdDataSet3;
            }
            if (SGDataUtility.isArrayData(string)) {
                object = (Boolean)map.get("Multiple");
                if (object == null) {
                    map.put("Multiple", Boolean.FALSE);
                }
                if ((bl = (Boolean)map.get("Graphs for multiple variables")) == null) {
                    map.put("Graphs for multiple variables", Boolean.TRUE);
                }
            }
            object = (SGNetCDFFile)sGIDataSource;
            if (SGDataUtility.isSXYTypeData(string)) {
                bl = (Boolean)map.get("Multiple");
                if (bl == null) {
                    CreatedDataSet createdDataSet4 = null;
                    return createdDataSet4;
                }
                Boolean bl2 = (Boolean)map.get("Graphs for multiple variables");
                if (bl2 == null) {
                    CreatedDataSet createdDataSet5 = null;
                    return createdDataSet5;
                }
                createdDataSet = bl2.booleanValue() ? (bl.booleanValue() ? this.createMultipleVariableSXYNetCDFData((SGIDataSource)object, sGIProgressControl, sGDataColumnInfoSet, map) : this.createSingleVariableSXYNetCDFData((SGIDataSource)object, sGIProgressControl, sGDataColumnInfoSet, map)) : this.createDimensionSXYNetCDFData((SGIDataSource)object, sGIProgressControl, sGDataColumnInfoSet, map, bl);
            } else if (SGUtilityText.isEqualString(string, "VXY_NETCDF") || SGUtilityText.isEqualString(string, "VXY")) {
                createdDataSet = this.createVXYNetCDFData((SGIDataSource)object, sGIProgressControl, sGDataColumnInfoSet, map);
            } else if (SGUtilityText.isEqualString(string, "SXYZ_NETCDF") || SGUtilityText.isEqualString(string, "SXYZ")) {
                createdDataSet = this.createSXYZNetCDFData((SGIDataSource)object, sGIProgressControl, sGDataColumnInfoSet, map);
            }
        }
        finally {
            sGIProgressControl.endProgress();
        }
        return createdDataSet;
    }

    class FileColumn {
        int index = -1;
        String title = null;
        String valueType = null;

        FileColumn() {
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append('[');
            stringBuffer.append("index=");
            stringBuffer.append(this.index);
            stringBuffer.append(", title=");
            stringBuffer.append(this.title);
            stringBuffer.append(", valueType=");
            stringBuffer.append(this.valueType);
            stringBuffer.append(']');
            return stringBuffer.toString();
        }
    }

    public static class CreatedDataSet {
        private List<CreatedData> mDataList = new ArrayList<CreatedData>();
        private String mMiddleString = "\\_";

        public boolean addData(SGData sGData, String string) {
            this.mDataList.add(new CreatedData(sGData, string));
            return true;
        }

        public boolean addData(SGData sGData) {
            return this.addData(sGData, null);
        }

        public int getDataLength() {
            return this.mDataList.size();
        }

        public CreatedData getData(int n) {
            if (n < 0 || n >= this.mDataList.size()) {
                throw new IllegalArgumentException("Index out of bounds: " + n);
            }
            return this.mDataList.get(n);
        }

        public String getMiddleString() {
            return this.mMiddleString;
        }

        public void setMiddleString(String string) {
            this.mMiddleString = string;
        }
    }

    public static class CreatedData {
        private SGData mData = null;
        private String mTitle = null;

        public CreatedData(SGData sGData, String string) {
            if (sGData == null) {
                throw new IllegalArgumentException("data == null");
            }
            this.mTitle = string;
            this.mData = sGData;
        }

        public String getTitle() {
            return this.mTitle;
        }

        public SGData getData() {
            return this.mData;
        }
    }
}

