/*
 * Decompiled with CFR 0.152.
 */
package jp.riken.brain.ni.samuraigraph.application;

import foxtrot.Task;
import foxtrot.Worker;
import java.awt.Component;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JOptionPane;
import jp.riken.brain.ni.samuraigraph.application.SGApplicationUtility;
import jp.riken.brain.ni.samuraigraph.application.SGArchiveFileCreator;
import jp.riken.brain.ni.samuraigraph.application.SGArchiveFileExtractor;
import jp.riken.brain.ni.samuraigraph.application.SGIApplicationConstants;
import jp.riken.brain.ni.samuraigraph.application.SGIApplicationTextConstants;
import jp.riken.brain.ni.samuraigraph.application.SGIArchiveFileConstants;
import jp.riken.brain.ni.samuraigraph.application.SGIImageConstants;
import jp.riken.brain.ni.samuraigraph.application.SGMainFunctions;
import jp.riken.brain.ni.samuraigraph.application.SGNetCDFDataSetManager;
import jp.riken.brain.ni.samuraigraph.application.SGPropertyFileData;
import jp.riken.brain.ni.samuraigraph.application.SGSplashWindow;
import jp.riken.brain.ni.samuraigraph.base.SGData;
import jp.riken.brain.ni.samuraigraph.base.SGDrawingWindow;
import jp.riken.brain.ni.samuraigraph.base.SGFigure;
import jp.riken.brain.ni.samuraigraph.base.SGIConstants;
import jp.riken.brain.ni.samuraigraph.base.SGIPropertyFileConstants;
import jp.riken.brain.ni.samuraigraph.base.SGUtility;
import jp.riken.brain.ni.samuraigraph.base.SGUtilityText;
import jp.riken.brain.ni.samuraigraph.data.SGNetCDFData;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class SGDataSetManager
implements SGIConstants,
SGIApplicationConstants,
SGIPropertyFileConstants,
SGIApplicationTextConstants,
SGIArchiveFileConstants {
    private static final String DATASET_TEMPDIR_NAME = "SamuraiGraphArcvhive";
    private static final String DATASET_PROPERTY_FILENAME = "property.sgp";
    private static final String MSG_SAVE_DATASET_FAILED = "Failed save dataset";
    private static final String MSG_LOAD_DATASET_FAILED = "Failed load dataset";
    private SGArchiveFileExtractor mArchiveFileExtractor = null;
    private SGArchiveFileCreator mArchiveFileCreator = null;
    private SGMainFunctions mMain = null;
    public static final String ERRMSG_NETCDF_DATASET = "Cannot create a data set with netCDF data.";

    SGDataSetManager(SGMainFunctions sGMainFunctions, SGSplashWindow sGSplashWindow, float f, float f2) {
        this.mMain = sGMainFunctions;
        float f3 = (f2 - f) / 3.0f;
        sGSplashWindow.setProgressValue(f + f3);
        this.mArchiveFileExtractor = new SGArchiveFileExtractor();
        sGSplashWindow.setProgressValue(f + f3 * 2.0f);
        this.mArchiveFileCreator = new SGArchiveFileCreator();
    }

    public boolean loadDataSetFromDialog(SGDrawingWindow sGDrawingWindow) {
        return this.loadDataSetFromEventDispatchThread(sGDrawingWindow, null);
    }

    private boolean loadArchiveDataSet(SGDrawingWindow sGDrawingWindow, File file) {
        File file2;
        int n;
        File file3;
        String string;
        File file4 = this._createTemporaryDirectory(sGDrawingWindow);
        if (file4 == null) {
            return false;
        }
        int n2 = -1;
        n2 = this.mArchiveFileExtractor.extract(sGDrawingWindow, file4.getPath(), file);
        if (n2 == -1 || n2 == -2) {
            this.mArchiveFileExtractor.deleteExtractedFiles();
            file4.delete();
            return false;
        }
        if (n2 == 1) {
            this.mArchiveFileExtractor.deleteExtractedFiles();
            file4.delete();
            return true;
        }
        ArrayList<File> arrayList = this.mArchiveFileExtractor.getExtractedFileList();
        if (!arrayList.contains(new File(string = SGApplicationUtility.getPathName(file4.getAbsolutePath(), DATASET_PROPERTY_FILENAME)))) {
            this.mArchiveFileExtractor.deleteExtractedFiles();
            file4.delete();
            return false;
        }
        int n3 = 0;
        for (int i = 0; i < arrayList.size(); ++i) {
            file3 = arrayList.get(i);
            String string2 = file3.getPath();
            if (!string2.endsWith(".csv")) continue;
            ++n3;
        }
        ArrayList<String> arrayList2 = new ArrayList<String>();
        this._sortDataList(file4, arrayList, n3, arrayList2);
        file3 = null;
        for (n = 0; n < arrayList.size(); n += 1) {
            file2 = arrayList.get(n);
            String string3 = file2.getPath();
            String[] stringArray = SGIImageConstants.DRAWABLE_IMAGE_EXTENSIONS;
            for (int i = 0; i < stringArray.length; ++i) {
                String string4 = "." + stringArray[i];
                if (!string3.toLowerCase().endsWith(string4)) continue;
                file3 = file2;
                break;
            }
            if (file3 != null) break;
        }
        n = this._loadDataSet(sGDrawingWindow, string, arrayList2, file3) ? 1 : 0;
        this.mArchiveFileExtractor.deleteExtractedFiles();
        file4.delete();
        file2 = this.mArchiveFileExtractor.getSelectedFile();
        if (file2 != null) {
            this.mMain.updateCurrentFile(file2, 2);
        }
        return n != 0;
    }

    boolean loadDataSet(SGDrawingWindow sGDrawingWindow, File file) {
        int n = -1;
        File file2 = file;
        if (file2 == null) {
            file2 = this.mArchiveFileExtractor.getArchiveFileFromFileChooser(sGDrawingWindow);
        }
        if (file2 == null) {
            n = 1;
            return true;
        }
        if (file2.getName().endsWith("sga")) {
            return this.loadArchiveDataSet(sGDrawingWindow, file2);
        }
        if (SGApplicationUtility.isNetCDFFile(file2.getAbsolutePath())) {
            SGNetCDFDataSetManager sGNetCDFDataSetManager = new SGNetCDFDataSetManager(this.mMain);
            try {
                n = sGNetCDFDataSetManager.load(sGDrawingWindow, file2);
            }
            catch (IOException iOException) {
                return false;
            }
            if (n == 0) {
                File file3 = this.mArchiveFileExtractor.getSelectedFile();
                if (file3 != null) {
                    this.mMain.updateCurrentFile(file3, 2);
                }
                return true;
            }
            return false;
        }
        return false;
    }

    boolean loadDataSetFromEventDispatchThread(final SGDrawingWindow sGDrawingWindow, final File file) {
        sGDrawingWindow.setWaitCursor(true);
        Boolean bl = Boolean.FALSE;
        if (!SGMainFunctions.USE_FOXTROT) {
            if (this.loadDataSet(sGDrawingWindow, file)) {
                bl = Boolean.TRUE;
            }
        } else {
            try {
                bl = (Boolean)Worker.post(new Task(){

                    public Object run() throws Exception {
                        if (!SGDataSetManager.this.loadDataSet(sGDrawingWindow, file)) {
                            return Boolean.FALSE;
                        }
                        return Boolean.TRUE;
                    }
                });
            }
            catch (Exception exception) {
                bl = Boolean.FALSE;
            }
        }
        sGDrawingWindow.setWaitCursor(false);
        return bl;
    }

    private File getDataSetTempDir() {
        String string = SGApplicationUtility.getPathName(TMP_DIR, DATASET_TEMPDIR_NAME);
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(string);
        stringBuffer.append(System.currentTimeMillis());
        File file = new File(stringBuffer.toString());
        return file;
    }

    private File _createTemporaryDirectory(Component component) {
        String string = MSG_LOAD_DATASET_FAILED;
        File file = this.getDataSetTempDir();
        if (!file.mkdir()) {
            JOptionPane.showMessageDialog(component, string);
            return null;
        }
        return file;
    }

    private void _sortDataList(File file, ArrayList<File> arrayList, int n, ArrayList<String> arrayList2) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(file.getAbsolutePath());
        stringBuffer.append(FILE_SEPARATOR);
        stringBuffer.append("id");
        String string = stringBuffer.toString();
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n; ++j) {
                stringBuffer.setLength(0);
                stringBuffer.append(string);
                stringBuffer.append(i);
                stringBuffer.append('-');
                stringBuffer.append(j);
                stringBuffer.append(".csv");
                String string2 = stringBuffer.toString();
                if (!arrayList.contains(new File(string2))) break;
                arrayList2.add(string2);
                ++n2;
            }
            if (n2 >= n) break;
        }
    }

    private boolean _loadDataSet(SGDrawingWindow sGDrawingWindow, String string, ArrayList<String> arrayList, File file) {
        File file2 = new File(string);
        if (!file2.exists()) {
            return false;
        }
        String string2 = SGUtility.getCanonicalPath(file2.getPath());
        if (string2 == null) {
            return false;
        }
        URL uRL = null;
        try {
            uRL = file2.toURI().toURL();
        }
        catch (MalformedURLException malformedURLException) {
            return false;
        }
        Document document = SGUtilityText.getDocument(uRL);
        if (document == null) {
            return false;
        }
        Element element = document.getDocumentElement();
        String string3 = element.getAttribute("Version");
        Element element2 = this.mMain.mPropertyFileManager.getWindowElement(document);
        NodeList nodeList = element2.getElementsByTagName("Figure");
        int n = nodeList.getLength();
        int n2 = 0;
        int[] nArray = new int[n];
        for (int i = 0; i < n; ++i) {
            Node node = nodeList.item(i);
            if (!(node instanceof Element)) {
                return false;
            }
            Element element3 = (Element)node;
            NodeList nodeList2 = element3.getElementsByTagName("Data");
            nArray[i] = nodeList2.getLength();
            n2 += nArray[i];
        }
        if (n2 != arrayList.size()) {
            return false;
        }
        SGMainFunctions.WrappedData[] wrappedDataArray = new SGMainFunctions.WrappedData[arrayList.size()];
        n2 = 0;
        for (int i = 0; i < n; ++i) {
            int n3 = nArray[i];
            for (int j = 0; j < n3; ++j) {
                String string4 = arrayList.get(n2);
                int n4 = i + 1;
                SGPropertyFileData sGPropertyFileData = new SGPropertyFileData(n4, null, null, null);
                sGPropertyFileData.setFileName(string4);
                wrappedDataArray[n2] = new SGMainFunctions.WrappedData(sGPropertyFileData);
                ++n2;
            }
        }
        sGDrawingWindow.deleteImage();
        sGDrawingWindow.clearUndoBuffer();
        sGDrawingWindow.removeAllFigures();
        if (file != null) {
            byte[] byArray = SGApplicationUtility.toByteArray(file);
            String string5 = SGApplicationUtility.getExtension(file);
            if (string5 == null) {
                return false;
            }
            if (!sGDrawingWindow.setImage(byArray, string5, false)) {
                return false;
            }
        }
        if (!this.mMain.mPropertyFileManager.setPropertyFile(sGDrawingWindow, document, wrappedDataArray, true, string3, 2)) {
            return false;
        }
        sGDrawingWindow.updateClientRect();
        return true;
    }

    private boolean checkNetCDFExists(SGDrawingWindow sGDrawingWindow) {
        ArrayList<SGFigure> arrayList = sGDrawingWindow.getVisibleFigureList();
        for (SGFigure sGFigure : arrayList) {
            List<SGData> list = sGFigure.getVisibleDataList();
            for (SGData sGData : list) {
                if (!(sGData instanceof SGNetCDFData)) continue;
                return true;
            }
        }
        return false;
    }

    public int saveDataSet(SGDrawingWindow sGDrawingWindow) {
        String string = this.mMain.getCurrentFileDirectory();
        String string2 = this.mMain.mCurrentArchiveFileName;
        File file = this.getDataSetTempDir();
        if (!file.mkdir()) {
            JOptionPane.showMessageDialog(sGDrawingWindow, MSG_SAVE_DATASET_FAILED);
            return -1;
        }
        this.mArchiveFileCreator.setFile(string, string2);
        SGArchiveFileCreator.ArchiveFile archiveFile = this.mArchiveFileCreator.getArchiveFileFromFileChooser(sGDrawingWindow);
        if (archiveFile == null) {
            return 1;
        }
        String string3 = archiveFile.desc;
        if (string3 != null) {
            if (string3.startsWith("Samurai Graph Archive File 1.0.7") || string3.startsWith("Samurai Graph Archive File")) {
                if (this.checkNetCDFExists(sGDrawingWindow)) {
                    SGUtility.showErrorMessageDialog(sGDrawingWindow, ERRMSG_NETCDF_DATASET, "Error");
                    return -1;
                }
                ArrayList<File> arrayList = string3.startsWith("Samurai Graph Archive File 1.0.7") ? this._dumpDataSet(sGDrawingWindow, file, 6) : this._dumpDataSet(sGDrawingWindow, file, 2);
                if (arrayList == null) {
                    JOptionPane.showMessageDialog(sGDrawingWindow, MSG_SAVE_DATASET_FAILED);
                    file.delete();
                    return -1;
                }
                int n = this.mArchiveFileCreator.create(sGDrawingWindow, file.getPath(), archiveFile.file);
                for (int i = 0; i < arrayList.size(); ++i) {
                    File file2 = arrayList.get(i);
                    file2.delete();
                }
                file.delete();
                if (n != 0) {
                    return n;
                }
                File file3 = this.mArchiveFileCreator.getSelectedFile();
                if (file3 != null) {
                    this.mMain.updateCurrentFile(file3, 2);
                }
                return 0;
            }
            if (string3.startsWith("Samurai Graph netCDF Archive File")) {
                File[] fileArray;
                String string4 = this.mMain.mAppProp.getVersionString();
                SGNetCDFDataSetManager sGNetCDFDataSetManager = new SGNetCDFDataSetManager(this.mMain);
                int n = sGNetCDFDataSetManager.save(sGDrawingWindow, string4, file, archiveFile.file);
                for (File file2 : fileArray = file.listFiles()) {
                    file2.delete();
                }
                file.delete();
                if (n != 0) {
                    JOptionPane.showMessageDialog(sGDrawingWindow, MSG_SAVE_DATASET_FAILED);
                    return n;
                }
                File file3 = this.mArchiveFileCreator.getSelectedFile();
                if (file3 != null) {
                    this.mMain.updateCurrentFile(file3, 2);
                }
                return 0;
            }
            return -1;
        }
        return -1;
    }

    public int saveDataSet(SGDrawingWindow sGDrawingWindow, String string, String string2) {
        ArrayList<File> arrayList = null;
        File file = this.getDataSetTempDir();
        if (!file.mkdir()) {
            return -1;
        }
        File file2 = new File(string);
        if ("sga".equalsIgnoreCase(string2) || "sga107".equalsIgnoreCase(string2)) {
            if (this.checkNetCDFExists(sGDrawingWindow)) {
                return -1;
            }
            if ("sga".equalsIgnoreCase(string2)) {
                arrayList = this._dumpDataSet(sGDrawingWindow, file, 6);
            } else if ("sga107".equalsIgnoreCase(string2)) {
                arrayList = this._dumpDataSet(sGDrawingWindow, file, 2);
            }
            if (arrayList == null) {
                file.delete();
                return -1;
            }
            int n = this.mArchiveFileCreator.create(sGDrawingWindow, file.getPath(), file2);
            for (int i = 0; i < arrayList.size(); ++i) {
                File file3 = arrayList.get(i);
                file3.delete();
            }
            file.delete();
            if (n != 0) {
                return n;
            }
            this.mMain.updateCurrentFile(file2, 2);
            return 0;
        }
        if ("netCDF".equalsIgnoreCase(string2)) {
            File[] fileArray;
            String string3 = this.mMain.mAppProp.getVersionString();
            SGNetCDFDataSetManager sGNetCDFDataSetManager = new SGNetCDFDataSetManager(this.mMain);
            int n = sGNetCDFDataSetManager.save(sGDrawingWindow, string3, file, file2);
            for (File file4 : fileArray = file.listFiles()) {
                file4.delete();
            }
            file.delete();
            if (n != 0) {
                return n;
            }
            this.mMain.updateCurrentFile(file2, 2);
            return 0;
        }
        return -1;
    }

    private ArrayList<File> _dumpDataSet(SGDrawingWindow sGDrawingWindow, File file, int n) {
        ArrayList<File> arrayList = new ArrayList<File>();
        String string = SGApplicationUtility.getPathName(file.getPath(), DATASET_PROPERTY_FILENAME);
        int n2 = this.mMain.mPropertyFileManager.saveProperties(sGDrawingWindow, string, n);
        if (n2 != 0) {
            return null;
        }
        arrayList.add(new File(string));
        ArrayList<SGFigure> arrayList2 = sGDrawingWindow.getVisibleFigureList();
        for (int i = 0; i < arrayList2.size(); ++i) {
            SGFigure sGFigure = arrayList2.get(i);
            List<SGData> list = sGFigure.getVisibleDataList();
            for (int j = 0; j < list.size(); ++j) {
                SGData sGData = list.get(j);
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append(file.getPath());
                stringBuffer.append(FILE_SEPARATOR);
                stringBuffer.append("id");
                stringBuffer.append(i);
                stringBuffer.append('-');
                stringBuffer.append(j);
                stringBuffer.append(".csv");
                String string2 = stringBuffer.toString();
                File file2 = new File(string2);
                if (!sGData.saveData(file2, n)) {
                    for (int k = 0; k < arrayList.size(); ++k) {
                        File file3 = arrayList.get(k);
                        file3.delete();
                    }
                    return null;
                }
                arrayList.add(file2);
            }
        }
        return arrayList;
    }
}

