/*
 * Decompiled with CFR 0.152.
 */
package jp.riken.brain.ni.samuraigraph.application;

import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.ImageIcon;
import javax.swing.JRadioButton;
import jp.riken.brain.ni.samuraigraph.application.SGIApplicationTextConstants;
import jp.riken.brain.ni.samuraigraph.application.SGWizardDialog;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SGDataTypeSelectionWizardDialog
extends SGWizardDialog
implements SGIApplicationTextConstants {
    private static final long serialVersionUID = 871471670381557184L;
    public static final String TITLE = "Select The Data Type";
    protected static final String SINGLE_XY_ICON_FILENAME = "SingleSXY.png";
    protected static final String MULTIPLE_XY_ICON_FILENAME = "MultipleSXY.png";
    protected static final String ORTHOGONAL_ICON_FILENAME = "OrthogonalVXY.png";
    protected static final String POLAR_ICON_FILENAME = "PolarVXY.png";
    protected static final String PSEUDOCOLOR_MAP_ICON_FILENAME = "PseudocolorMap.png";
    protected static final String[] ICON_FILENAME_ARRAY = new String[]{"SingleSXY.png", "MultipleSXY.png", "OrthogonalVXY.png", "PolarVXY.png", "PseudocolorMap.png"};
    protected static final String SINGLE_SXY = "Single Scalar-XY";
    protected static final String MULTIPLE_SXY = "Multiple Scalar-XY";
    protected static final String ORTHOGONAL_VXY = "Orthogonal Vector-XY";
    protected static final String POLAR_VXY = "Polar Vector-XY";
    protected static final String PSEUDOCOLOR_MAP = "Pseudocolor Map";
    protected DataTypeButton[] mDataTypeButtonArray = null;
    private List<String> mAvailableDataTypeList = new ArrayList<String>();

    public SGDataTypeSelectionWizardDialog() {
    }

    public SGDataTypeSelectionWizardDialog(Frame frame, boolean bl) {
        super(frame, bl);
    }

    public String getSelectedDataType() {
        String string = null;
        for (int i = 0; i < this.mDataTypeButtonArray.length; ++i) {
            if (!this.mDataTypeButtonArray[i].btn.isSelected()) continue;
            string = this.mDataTypeButtonArray[i].dataType;
            break;
        }
        return string;
    }

    public boolean setAvailableDataType(List<String> list) {
        DataTypeButton dataTypeButton;
        int n;
        if (list == null) {
            return false;
        }
        this.mAvailableDataTypeList.clear();
        for (n = 0; n < this.mDataTypeButtonArray.length; ++n) {
            dataTypeButton = this.mDataTypeButtonArray[n];
            boolean bl = list.contains(dataTypeButton.dataType);
            dataTypeButton.btn.setEnabled(bl);
        }
        for (n = 0; n < this.mDataTypeButtonArray.length; ++n) {
            dataTypeButton = this.mDataTypeButtonArray[n];
            if (!list.contains(dataTypeButton.dataType)) continue;
            dataTypeButton.btn.setSelected(true);
            break;
        }
        this.mAvailableDataTypeList.addAll(list);
        return true;
    }

    public String getDataType(JRadioButton jRadioButton) {
        String string = null;
        for (int i = 0; i < this.mDataTypeButtonArray.length; ++i) {
            if (!this.mDataTypeButtonArray[i].btn.equals(jRadioButton)) continue;
            string = this.mDataTypeButtonArray[i].dataType;
            break;
        }
        return string;
    }

    public AbstractButton getButton(String string) {
        AbstractButton abstractButton = null;
        for (int i = 0; i < this.mDataTypeButtonArray.length; ++i) {
            if (!this.mDataTypeButtonArray[i].dataType.equals(string)) continue;
            abstractButton = this.mDataTypeButtonArray[i].btn;
            break;
        }
        return abstractButton;
    }

    protected abstract AbstractButton getSingleSXYGraphButton();

    protected abstract AbstractButton getMultipleSXYGraphButton();

    protected abstract AbstractButton getOrthogonalVectorGraphButton();

    protected abstract AbstractButton getPolarVectorGraphButton();

    protected abstract AbstractButton getPseudocolorMapButton();

    public boolean isPolarSelected() {
        return this.getPolarVectorGraphButton().isSelected();
    }

    @Override
    public void setVisible(boolean bl) {
        this.updateComponents();
        super.setVisible(bl);
    }

    protected void updateComponents() {
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        this.updateComponents();
        super.actionPerformed(actionEvent);
    }

    public Boolean isMultipleSelected() {
        AbstractButton abstractButton = this.getMultipleSXYGraphButton();
        if (abstractButton.isEnabled()) {
            return abstractButton.isSelected();
        }
        return null;
    }

    protected ImageIcon createIcon(String string) {
        URL uRL = this.getClass().getResource("/resources/" + string);
        ImageIcon imageIcon = new ImageIcon(uRL);
        return imageIcon;
    }

    protected void setupButton(AbstractButton abstractButton, Map<String, ImageIcon> map, String string, String string2) {
        abstractButton.setIcon(map.get(string));
        abstractButton.setToolTipText(string2);
    }

    protected static class DataTypeButton {
        String dataType;
        AbstractButton btn;

        DataTypeButton(String string, AbstractButton abstractButton) {
            this.dataType = string;
            this.btn = abstractButton;
        }
    }
}

