/*
 * Decompiled with CFR 0.152.
 */
package jp.riken.brain.ni.samuraigraph.application;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JOptionPane;
import javax.swing.UIManager;
import jp.riken.brain.ni.samuraigraph.application.SGApplicationProperties;
import jp.riken.brain.ni.samuraigraph.application.SGIApplicationConstants;
import jp.riken.brain.ni.samuraigraph.application.SGIApplicationTextConstants;
import jp.riken.brain.ni.samuraigraph.application.SGMainFunctions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SGDrawingServer
implements SGIApplicationConstants,
SGIApplicationTextConstants {
    private static String mLookAndFeel = null;
    private static SGMainFunctions mAppMain = null;
    private static SGApplicationProperties mAppProp = null;

    public static void main(String[] stringArray) {
        Map<String, Object> map = SGDrawingServer.interpretCommands(stringArray);
        mAppProp = new SGApplicationProperties();
        if (!mAppProp.getStatus()) {
            System.exit(1);
        }
        if (!SGDrawingServer.setLookAndFeel()) {
            System.exit(1);
        }
        SGMainFunctions sGMainFunctions = new SGMainFunctions(mAppProp, map);
        try {
            sGMainFunctions.waitInit();
            mAppMain = sGMainFunctions;
            SGDrawingServer.MacOSXRegistration();
        }
        catch (Exception exception) {
            JOptionPane.showOptionDialog(null, "Failed to start up Samurai Graph.", "Error", -1, 2, null, null, null);
        }
    }

    private static Map<String, Object> interpretCommands(String[] stringArray) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        String string = null;
        String string2 = null;
        String string3 = null;
        boolean bl = false;
        boolean bl2 = false;
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].equals("-prop") || stringArray[i].equals("-p")) {
                if (i >= stringArray.length - 1) continue;
                string = stringArray[i + 1];
                ++i;
                continue;
            }
            if (stringArray[i].equals("-dataset") || stringArray[i].equals("-a")) {
                if (i >= stringArray.length - 1) continue;
                string2 = stringArray[i + 1];
                ++i;
                continue;
            }
            if (stringArray[i].equals("-i")) {
                bl = true;
                continue;
            }
            if (stringArray[i].equals("-s")) {
                if (i >= stringArray.length - 1) continue;
                bl = true;
                string3 = stringArray[i + 1];
                ++i;
                continue;
            }
            if (stringArray[i].equals("-dev")) {
                bl2 = true;
                continue;
            }
            arrayList.add(stringArray[i]);
        }
        String string4 = null;
        int n = -1;
        if (string != null) {
            string4 = string;
            n = 1;
        }
        if (string2 != null) {
            string4 = string2;
            n = 2;
        }
        if (arrayList.size() != 0) {
            string4 = (String)arrayList.get(0);
            n = 0;
        }
        if (string3 != null) {
            string4 = string3;
            n = 5;
        }
        if (string4 != null) {
            hashMap.put("fileName", string4);
            hashMap.put("fileType", n);
        }
        hashMap.put("commandMode", bl);
        hashMap.put("developerMode", bl2);
        return hashMap;
    }

    private static boolean setLookAndFeel() {
        try {
            if (mLookAndFeel == null) {
                UIManager.getInstalledLookAndFeels();
                UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
            } else {
                UIManager.setLookAndFeel(mLookAndFeel);
            }
        }
        catch (Exception exception) {
            return false;
        }
        return true;
    }

    private static void MacOSXRegistration() {
        boolean bl = System.getProperty("os.name").toLowerCase().startsWith("mac os x");
        if (bl) {
            try {
                Class<?> clazz = Class.forName("jp.riken.brain.ni.samuraigraph.platform.macosx.SGMacOSXAdapter");
                Method method = clazz.getMethod("registerMacOSXApplication", null);
                if (method != null) {
                    method.invoke(clazz, (Object[])null);
                }
            }
            catch (NoClassDefFoundError noClassDefFoundError) {
                System.err.println("This version of Mac OS X does not support the Apple EAWT.  Application Menu handling has been disabled (" + noClassDefFoundError + ")");
            }
            catch (ClassNotFoundException classNotFoundException) {
                System.err.println("This version of Mac OS X does not support the Apple EAWT.  Application Menu handling has been disabled (" + classNotFoundException + ")");
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    public static boolean quitHandler() {
        if (mAppMain == null) {
            return false;
        }
        mAppMain.exit();
        return true;
    }

    public static boolean aboutHandler() {
        if (mAppMain == null) {
            return false;
        }
        return mAppMain.showAboutDialog(null);
    }

    public static boolean openFileHandler(String string) {
        if (mAppMain == null) {
            return false;
        }
        return mAppMain.openFile(null, string);
    }
}

