/*
 * Decompiled with CFR 0.152.
 */
package jp.riken.brain.ni.samuraigraph.application;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import jp.riken.brain.ni.samuraigraph.application.SGWizardDialog;
import jp.riken.brain.ni.samuraigraph.base.SGButton;
import jp.riken.brain.ni.samuraigraph.base.SGComboBox;
import jp.riken.brain.ni.samuraigraph.base.SGRadioButton;

public class SGFigureIDSelectionWizardDialog
extends SGWizardDialog {
    private static final long serialVersionUID = 8059862285692736832L;
    public static final String TITLE = "Figure ID";
    private SGRadioButton mAddRadioButton;
    private JPanel mButtonPanel;
    private SGButton mCancelButton;
    private SGRadioButton mCreateRadioButton;
    private SGComboBox mFigureIDComboBox;
    private JLabel mFigureIDLabel;
    private SGButton mNextButton;
    private SGButton mOKButton;
    private JPanel mPanel;
    private SGButton mPreviousButton;
    private int mNewFigureId = -1;

    public SGFigureIDSelectionWizardDialog() {
        this.initComponents();
        this.initProperty();
    }

    public SGFigureIDSelectionWizardDialog(Frame frame, boolean bl) {
        super(frame, bl);
        this.initComponents();
        this.initProperty();
    }

    private void initComponents() {
        this.mButtonPanel = new JPanel();
        this.mPreviousButton = new SGButton();
        this.mNextButton = new SGButton();
        this.mOKButton = new SGButton();
        this.mCancelButton = new SGButton();
        this.mPanel = new JPanel();
        this.mFigureIDLabel = new JLabel();
        this.mFigureIDComboBox = new SGComboBox();
        this.mCreateRadioButton = new SGRadioButton();
        this.mAddRadioButton = new SGRadioButton();
        this.getContentPane().setLayout(new GridBagLayout());
        this.mPreviousButton.setText("<Prev");
        this.mPreviousButton.setFont(new Font("Dialog", 1, 12));
        this.mButtonPanel.add(this.mPreviousButton);
        this.mNextButton.setText("Next>");
        this.mNextButton.setFont(new Font("Dialog", 1, 12));
        this.mButtonPanel.add(this.mNextButton);
        this.mOKButton.setText("OK");
        this.mOKButton.setFont(new Font("Dialog", 1, 12));
        this.mButtonPanel.add(this.mOKButton);
        this.mCancelButton.setText("Cancel");
        this.mCancelButton.setFont(new Font("Dialog", 1, 12));
        this.mButtonPanel.add(this.mCancelButton);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.getContentPane().add((Component)this.mButtonPanel, gridBagConstraints);
        this.mPanel.setLayout(new GridBagLayout());
        this.mFigureIDLabel.setFont(new Font("Dialog", 0, 12));
        this.mFigureIDLabel.setText(TITLE);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 20, 10, 5);
        this.mPanel.add((Component)this.mFigureIDLabel, gridBagConstraints);
        this.mFigureIDComboBox.setPreferredSize(new Dimension(80, 21));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.insets = new Insets(5, 10, 10, 20);
        this.mPanel.add((Component)this.mFigureIDComboBox, gridBagConstraints);
        this.mCreateRadioButton.setText("Create a New Figure");
        this.mCreateRadioButton.setFont(new Font("Dialog", 0, 12));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(10, 5, 5, 5);
        this.mPanel.add((Component)this.mCreateRadioButton, gridBagConstraints);
        this.mAddRadioButton.setText("Add to an Existing Figure");
        this.mAddRadioButton.setFont(new Font("Dialog", 0, 12));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.mPanel.add((Component)this.mAddRadioButton, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(10, 10, 5, 10);
        this.getContentPane().add((Component)this.mPanel, gridBagConstraints);
        this.pack();
    }

    private void initProperty() {
        this.setTitle(TITLE);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.mCreateRadioButton);
        buttonGroup.add(this.mAddRadioButton);
        this.mCreateRadioButton.addActionListener(this);
        this.mAddRadioButton.addActionListener(this);
        this.mOKButton.setVisible(false);
    }

    public void setIDNumbers(int[] nArray) {
        int n;
        if (nArray == null) {
            throw new IllegalArgumentException("idArray == null");
        }
        int n2 = nArray.length;
        String[] stringArray = new String[n2];
        for (n = 0; n < n2; ++n) {
            stringArray[n] = Integer.toString(nArray[n]);
        }
        if (n2 == 0) {
            this.mCreateRadioButton.setSelected(true);
            this.enableItems(true);
            this.mAddRadioButton.setEnabled(false);
        } else {
            if (!this.mCreateRadioButton.isSelected() && !this.mAddRadioButton.isSelected()) {
                this.mAddRadioButton.setSelected(true);
                this.enableItems(false);
            }
            this.mAddRadioButton.setEnabled(true);
        }
        this.mFigureIDComboBox.removeAllItems();
        for (n = 0; n < stringArray.length; ++n) {
            this.mFigureIDComboBox.addItem(stringArray[n]);
        }
        this.mNewFigureId = n2 == 0 ? 1 : nArray[n2 - 1] + 1;
    }

    private void enableItems(boolean bl) {
        this.mFigureIDLabel.setEnabled(!bl);
        this.mFigureIDComboBox.setEnabled(!bl);
    }

    public int getFigureID() {
        if (this.mCreateRadioButton.isSelected()) {
            return this.mNewFigureId;
        }
        Object object = this.mFigureIDComboBox.getSelectedItem();
        String string = (String)object;
        Integer n = Integer.valueOf(string);
        return n;
    }

    protected JButton getPreviousButton() {
        return this.mPreviousButton;
    }

    protected JButton getNextButton() {
        return this.mNextButton;
    }

    protected JButton getOKButton() {
        return this.mOKButton;
    }

    protected JButton getCancelButton() {
        return this.mCancelButton;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        super.actionPerformed(actionEvent);
        Object object = actionEvent.getSource();
        if (object.equals(this.mCreateRadioButton)) {
            this.enableItems(true);
        } else if (object.equals(this.mAddRadioButton)) {
            this.enableItems(false);
        }
    }
}

