/*
 * Decompiled with CFR 0.152.
 */
package jp.riken.brain.ni.samuraigraph.application;

import java.io.IOException;
import java.io.InputStream;
import java.util.Hashtable;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SGJarClassLoader
extends ClassLoader {
    private final ZipFile mZipFile;
    private static Hashtable<String, Object> mHash = new Hashtable();
    private boolean mDelegateFirst = false;
    private static final Object CLASS_OBJECT = new Object();

    public SGJarClassLoader(ZipFile zipFile) {
        this.mZipFile = zipFile;
    }

    public void setDelegateFirst(boolean bl) {
        this.mDelegateFirst = bl;
    }

    @Override
    public Class<?> loadClass(String string, boolean bl) throws ClassNotFoundException {
        if (this.mDelegateFirst) {
            return this.loadFromParent(string);
        }
        Object object = mHash.get(string);
        if (object instanceof SGJarClassLoader) {
            SGJarClassLoader sGJarClassLoader = (SGJarClassLoader)object;
            try {
                return sGJarClassLoader._loadClass(this.mZipFile, string, bl);
            }
            catch (ClassNotFoundException classNotFoundException) {
                mHash.put(string, CLASS_OBJECT);
                throw classNotFoundException;
            }
        }
        return this._loadClass(this.mZipFile, string, bl);
    }

    private synchronized Class<?> _loadClass(ZipFile zipFile, String string, boolean bl) throws ClassNotFoundException {
        mHash.put(string, this);
        this.mDelegateFirst = true;
        SGJarClassLoader sGJarClassLoader = this;
        synchronized (sGJarClassLoader) {
            Class<?> clazz = super.findLoadedClass(string);
            if (clazz != null) {
                if (bl) {
                    super.resolveClass(clazz);
                }
                return clazz;
            }
            try {
                this.definePackage(string);
                byte[] byArray = this.getClassBytesFromZipFile(zipFile, string);
                clazz = super.defineClass(string, byArray, 0, byArray.length);
                if (bl) {
                    super.resolveClass(clazz);
                }
                return clazz;
            }
            catch (IOException iOException) {
                throw new ClassNotFoundException(string);
            }
        }
    }

    private byte[] getClassBytesFromZipFile(ZipFile zipFile, String string) throws ClassNotFoundException, IOException {
        String string2 = SGJarClassLoader.classToFile(string);
        ZipEntry zipEntry = zipFile.getEntry(string2);
        if (zipEntry == null) {
            throw new ClassNotFoundException(string);
        }
        InputStream inputStream = zipFile.getInputStream(zipEntry);
        int n = (int)zipEntry.getSize();
        byte[] byArray = new byte[n];
        int n2 = 0;
        int n3 = 0;
        while (n2 < n) {
            if (-1 != (n2 = inputStream.read(byArray, n3 += n2, n -= n2))) continue;
            throw new ClassNotFoundException(string);
        }
        return byArray;
    }

    private void definePackage(String string) throws IOException {
        String string2;
        int n = string.lastIndexOf(46);
        if (n != -1 && this.getPackage(string2 = string.substring(0, n)) == null) {
            this.definePackage(string2, null, null, null, null, null, null, null);
            return;
        }
    }

    private Class<?> loadFromParent(String string) throws ClassNotFoundException {
        ClassLoader classLoader = this.getClass().getClassLoader();
        Class<?> clazz = classLoader != null ? classLoader.loadClass(string) : this.findSystemClass(string);
        return clazz;
    }

    public static String classToFile(String string) {
        return string.replace('.', '/').concat(".class");
    }
}

