/*
 * Decompiled with CFR 0.152.
 */
package jp.riken.brain.ni.samuraigraph.application;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import jp.riken.brain.ni.samuraigraph.application.SGApplicationUtility;
import jp.riken.brain.ni.samuraigraph.application.SGDataCreator;
import jp.riken.brain.ni.samuraigraph.application.SGIArchiveFileConstants;
import jp.riken.brain.ni.samuraigraph.application.SGMainFunctions;
import jp.riken.brain.ni.samuraigraph.application.SGPropertyFileCreator;
import jp.riken.brain.ni.samuraigraph.base.SGData;
import jp.riken.brain.ni.samuraigraph.base.SGDataColumnInfoSet;
import jp.riken.brain.ni.samuraigraph.base.SGDrawingWindow;
import jp.riken.brain.ni.samuraigraph.base.SGFigure;
import jp.riken.brain.ni.samuraigraph.base.SGIConstants;
import jp.riken.brain.ni.samuraigraph.base.SGIFigureElement;
import jp.riken.brain.ni.samuraigraph.base.SGIFigureElementAxis;
import jp.riken.brain.ni.samuraigraph.base.SGIFigureElementLegend;
import jp.riken.brain.ni.samuraigraph.base.SGIProgressControl;
import jp.riken.brain.ni.samuraigraph.base.SGUtility;
import jp.riken.brain.ni.samuraigraph.base.SGUtilityText;
import jp.riken.brain.ni.samuraigraph.data.SGArrayData;
import jp.riken.brain.ni.samuraigraph.data.SGDataColumn;
import jp.riken.brain.ni.samuraigraph.data.SGDataUtility;
import jp.riken.brain.ni.samuraigraph.data.SGDate;
import jp.riken.brain.ni.samuraigraph.data.SGNetCDFFile;
import jp.riken.brain.ni.samuraigraph.data.SGNumberDataColumn;
import jp.riken.brain.ni.samuraigraph.data.SGSXYMultipleDimensionNetCDFData;
import jp.riken.brain.ni.samuraigraph.data.SGSXYMultipleVariableNetCDFData;
import jp.riken.brain.ni.samuraigraph.data.SGSXYZNetCDFData;
import jp.riken.brain.ni.samuraigraph.data.SGVXYNetCDFData;
import jp.riken.brain.ni.samuraigraph.figure.SGXYFigure;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import ucar.ma2.Array;
import ucar.ma2.ArrayByte;
import ucar.ma2.DataType;
import ucar.ma2.Index;
import ucar.ma2.InvalidRangeException;
import ucar.nc2.Attribute;
import ucar.nc2.Dimension;
import ucar.nc2.Group;
import ucar.nc2.NetcdfFile;
import ucar.nc2.NetcdfFileWriteable;
import ucar.nc2.Variable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class SGNetCDFDataSetManager
implements SGIArchiveFileConstants {
    private final SGMainFunctions mMain;
    static final String ATTRIBUTE_KEY_LONG_NAME = "long_name";
    static final String SERIAL_NUMBER_DIMENSION_NAME = "SerialNumbers";
    static final String ATTRIBUTE_KEY_IMAGE_FILE_EXTENSION = "extension";
    static final String DIMENSION_NAME_BACKGROUND_IMAGE_BYTE_INDEX = "byte_index";
    static final String VARIABLE_NAME_BACKGROUND_IMAGE = "background_image";
    static final String ATTRIBUTE_NAME_PROPERTY = "samurai_graph_property";

    SGNetCDFDataSetManager(SGMainFunctions sGMainFunctions) {
        this.mMain = sGMainFunctions;
    }

    private String createGroupName(int n, int n2) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("id");
        stringBuffer.append(n);
        stringBuffer.append('-');
        stringBuffer.append(n2);
        return stringBuffer.toString();
    }

    private String getGroupVariableName(String string, String string2) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(string);
        stringBuffer.append('/');
        stringBuffer.append(string2);
        return stringBuffer.toString();
    }

    private String getGroupNameFromDataFile(File file) {
        return file.getName().substring(0, file.getName().length() - 3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean saveArrayDataVXYToTempNetCDFFiles(SGArrayData sGArrayData, File file, String string, SGDrawingWindow sGDrawingWindow) throws IOException, InvalidRangeException {
        int n = sGArrayData.getPointsNumber();
        SGDataColumn[] sGDataColumnArray = sGArrayData.getDataSetColumnsClone();
        if (sGDataColumnArray.length < 4) {
            return false;
        }
        SGNumberDataColumn sGNumberDataColumn = (SGNumberDataColumn)sGDataColumnArray[0];
        SGNumberDataColumn sGNumberDataColumn2 = (SGNumberDataColumn)sGDataColumnArray[1];
        SGNumberDataColumn sGNumberDataColumn3 = (SGNumberDataColumn)sGDataColumnArray[2];
        SGNumberDataColumn sGNumberDataColumn4 = (SGNumberDataColumn)sGDataColumnArray[3];
        double[] dArray = sGNumberDataColumn.getNumberArray();
        double[] dArray2 = sGNumberDataColumn2.getNumberArray();
        double[] dArray3 = sGNumberDataColumn3.getNumberArray();
        double[] dArray4 = sGNumberDataColumn4.getNumberArray();
        NetcdfFileWriteable netcdfFileWriteable = null;
        try {
            String[] stringArray;
            netcdfFileWriteable = NetcdfFileWriteable.createNew((String)file.getAbsolutePath(), (boolean)true);
            Dimension dimension = this.addSerialNumberDimension(netcdfFileWriteable, n);
            String string2 = dimension.getName();
            Variable variable = this.addSerialNumberVarialbe(netcdfFileWriteable, dimension);
            variable.addAttribute(SGDataUtility.getValueTypeAttribute("Number"));
            Variable variable2 = new Variable((NetcdfFile)netcdfFileWriteable, null, null, "column0", DataType.DOUBLE, string2);
            Variable variable3 = new Variable((NetcdfFile)netcdfFileWriteable, null, null, "column1", DataType.DOUBLE, string2);
            Variable variable4 = new Variable((NetcdfFile)netcdfFileWriteable, null, null, "column2", DataType.DOUBLE, string2);
            Variable variable5 = new Variable((NetcdfFile)netcdfFileWriteable, null, null, "column3", DataType.DOUBLE, string2);
            String string3 = sGNumberDataColumn.getTitle();
            if (null != string3 && !"".equals(string3.trim())) {
                stringArray = new Attribute(ATTRIBUTE_KEY_LONG_NAME, string3);
                variable2.addAttribute((Attribute)stringArray);
            }
            if (null != (string3 = sGNumberDataColumn2.getTitle()) && !"".equals(string3.trim())) {
                stringArray = new Attribute(ATTRIBUTE_KEY_LONG_NAME, string3);
                variable3.addAttribute((Attribute)stringArray);
            }
            if (null != (string3 = sGNumberDataColumn3.getTitle()) && !"".equals(string3.trim())) {
                stringArray = new Attribute(ATTRIBUTE_KEY_LONG_NAME, string3);
                variable4.addAttribute((Attribute)stringArray);
            }
            if (null != (string3 = sGNumberDataColumn4.getTitle()) && !"".equals(string3.trim())) {
                stringArray = new Attribute(ATTRIBUTE_KEY_LONG_NAME, string3);
                variable5.addAttribute((Attribute)stringArray);
            }
            netcdfFileWriteable.addVariable(null, variable2);
            netcdfFileWriteable.addVariable(null, variable3);
            netcdfFileWriteable.addVariable(null, variable4);
            netcdfFileWriteable.addVariable(null, variable5);
            stringArray = new String[sGDataColumnArray.length];
            stringArray[0] = variable2.getName();
            stringArray[1] = variable3.getName();
            stringArray[2] = variable4.getName();
            stringArray[3] = variable5.getName();
            variable2.addAttribute(SGDataUtility.getValueTypeAttribute(sGNumberDataColumn.getValueType()));
            variable3.addAttribute(SGDataUtility.getValueTypeAttribute(sGNumberDataColumn2.getValueType()));
            variable4.addAttribute(SGDataUtility.getValueTypeAttribute(sGNumberDataColumn3.getValueType()));
            variable5.addAttribute(SGDataUtility.getValueTypeAttribute(sGNumberDataColumn4.getValueType()));
            netcdfFileWriteable.create();
            Array array = Array.factory((DataType)DataType.DOUBLE, (int[])new int[]{n});
            for (int i = 0; i < dArray.length; ++i) {
                array.setDouble(i, dArray[i]);
            }
            netcdfFileWriteable.write(stringArray[0], array);
            Array array2 = Array.factory((DataType)DataType.DOUBLE, (int[])new int[]{n});
            for (int i = 0; i < dArray2.length; ++i) {
                array2.setDouble(i, dArray2[i]);
            }
            netcdfFileWriteable.write(stringArray[1], array2);
            Array array3 = Array.factory((DataType)DataType.DOUBLE, (int[])new int[]{n});
            for (int i = 0; i < dArray3.length; ++i) {
                array3.setDouble(i, dArray3[i]);
            }
            netcdfFileWriteable.write(stringArray[2], array3);
            Array array4 = Array.factory((DataType)DataType.DOUBLE, (int[])new int[]{n});
            for (int i = 0; i < dArray4.length; ++i) {
                array4.setDouble(i, dArray4[i]);
            }
            netcdfFileWriteable.write(stringArray[3], array4);
            this.writeSerialNumberVarialbe(netcdfFileWriteable, variable);
        }
        finally {
            if (null != netcdfFileWriteable) {
                netcdfFileWriteable.close();
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean saveArrayDataSXYZToTempNetCDFFiles(SGArrayData sGArrayData, File file, String string, SGDrawingWindow sGDrawingWindow) throws IOException, InvalidRangeException {
        int n = sGArrayData.getPointsNumber();
        SGDataColumn[] sGDataColumnArray = sGArrayData.getDataSetColumnsClone();
        if (sGDataColumnArray.length < 3) {
            return false;
        }
        SGNumberDataColumn sGNumberDataColumn = (SGNumberDataColumn)sGDataColumnArray[0];
        SGNumberDataColumn sGNumberDataColumn2 = (SGNumberDataColumn)sGDataColumnArray[1];
        SGNumberDataColumn sGNumberDataColumn3 = (SGNumberDataColumn)sGDataColumnArray[2];
        double[] dArray = sGNumberDataColumn.getNumberArray();
        double[] dArray2 = sGNumberDataColumn2.getNumberArray();
        double[] dArray3 = sGNumberDataColumn3.getNumberArray();
        NetcdfFileWriteable netcdfFileWriteable = null;
        try {
            String[] stringArray;
            netcdfFileWriteable = NetcdfFileWriteable.createNew((String)file.getAbsolutePath(), (boolean)true);
            Dimension dimension = this.addSerialNumberDimension(netcdfFileWriteable, n);
            String string2 = dimension.getName();
            Variable variable = this.addSerialNumberVarialbe(netcdfFileWriteable, dimension);
            variable.addAttribute(SGDataUtility.getValueTypeAttribute("Number"));
            Variable variable2 = new Variable((NetcdfFile)netcdfFileWriteable, null, null, "column0", DataType.DOUBLE, string2);
            Variable variable3 = new Variable((NetcdfFile)netcdfFileWriteable, null, null, "column1", DataType.DOUBLE, string2);
            Variable variable4 = new Variable((NetcdfFile)netcdfFileWriteable, null, null, "column2", DataType.DOUBLE, string2);
            String string3 = sGNumberDataColumn.getTitle();
            if (null != string3 && !"".equals(string3.trim())) {
                stringArray = new Attribute(ATTRIBUTE_KEY_LONG_NAME, string3);
                variable2.addAttribute((Attribute)stringArray);
            }
            if (null != (string3 = sGNumberDataColumn2.getTitle()) && !"".equals(string3.trim())) {
                stringArray = new Attribute(ATTRIBUTE_KEY_LONG_NAME, string3);
                variable3.addAttribute((Attribute)stringArray);
            }
            if (null != (string3 = sGNumberDataColumn3.getTitle()) && !"".equals(string3.trim())) {
                stringArray = new Attribute(ATTRIBUTE_KEY_LONG_NAME, string3);
                variable4.addAttribute((Attribute)stringArray);
            }
            netcdfFileWriteable.addVariable(null, variable2);
            netcdfFileWriteable.addVariable(null, variable3);
            netcdfFileWriteable.addVariable(null, variable4);
            stringArray = new String[sGDataColumnArray.length];
            stringArray[0] = variable2.getName();
            stringArray[1] = variable3.getName();
            stringArray[2] = variable4.getName();
            variable2.addAttribute(SGDataUtility.getValueTypeAttribute(sGNumberDataColumn.getValueType()));
            variable3.addAttribute(SGDataUtility.getValueTypeAttribute(sGNumberDataColumn2.getValueType()));
            variable4.addAttribute(SGDataUtility.getValueTypeAttribute(sGNumberDataColumn3.getValueType()));
            netcdfFileWriteable.create();
            Array array = Array.factory((DataType)DataType.DOUBLE, (int[])new int[]{n});
            for (int i = 0; i < dArray.length; ++i) {
                array.setDouble(i, dArray[i]);
            }
            netcdfFileWriteable.write(stringArray[0], array);
            Array array2 = Array.factory((DataType)DataType.DOUBLE, (int[])new int[]{n});
            for (int i = 0; i < dArray2.length; ++i) {
                array2.setDouble(i, dArray2[i]);
            }
            netcdfFileWriteable.write(stringArray[1], array2);
            Array array3 = Array.factory((DataType)DataType.DOUBLE, (int[])new int[]{n});
            for (int i = 0; i < dArray3.length; ++i) {
                array3.setDouble(i, dArray3[i]);
            }
            netcdfFileWriteable.write(stringArray[2], array3);
            this.writeSerialNumberVarialbe(netcdfFileWriteable, variable);
        }
        finally {
            if (null != netcdfFileWriteable) {
                netcdfFileWriteable.close();
            }
        }
        return true;
    }

    private Dimension addSerialNumberDimension(NetcdfFileWriteable netcdfFileWriteable, int n) {
        Dimension dimension = new Dimension(SERIAL_NUMBER_DIMENSION_NAME, n);
        netcdfFileWriteable.addDimension(null, dimension);
        return dimension;
    }

    private Variable addSerialNumberVarialbe(NetcdfFileWriteable netcdfFileWriteable, Dimension dimension) {
        Variable variable = new Variable((NetcdfFile)netcdfFileWriteable, null, null, SERIAL_NUMBER_DIMENSION_NAME, DataType.INT, dimension.getName());
        netcdfFileWriteable.addVariable(null, variable);
        return variable;
    }

    private void writeSerialNumberVarialbe(NetcdfFileWriteable netcdfFileWriteable, Variable variable) throws IOException, InvalidRangeException {
        int n = variable.getDimension(0).getLength();
        Array array = Array.factory((DataType)DataType.INT, (int[])new int[]{n});
        for (int i = 0; i < n; ++i) {
            array.setInt(i, i);
        }
        netcdfFileWriteable.write(variable.getName(), array);
    }

    private ByteData createImageVariable(NetcdfFileWriteable netcdfFileWriteable, SGDrawingWindow sGDrawingWindow) throws IOException, InvalidRangeException {
        SGDrawingWindow.BackgroundImage backgroundImage = sGDrawingWindow.getBackgroundImage();
        if (backgroundImage == null) {
            return null;
        }
        byte[] byArray = backgroundImage.getByteArray();
        if (byArray == null) {
            return null;
        }
        Dimension dimension = new Dimension(DIMENSION_NAME_BACKGROUND_IMAGE_BYTE_INDEX, byArray.length);
        netcdfFileWriteable.addDimension(null, dimension);
        Variable variable = new Variable((NetcdfFile)netcdfFileWriteable, null, null, VARIABLE_NAME_BACKGROUND_IMAGE, DataType.BYTE, dimension.getName());
        netcdfFileWriteable.addVariable(null, variable);
        variable.addAttribute(SGDataUtility.getValueTypeAttribute("Byte Data"));
        variable.addAttribute(new Attribute(ATTRIBUTE_KEY_IMAGE_FILE_EXTENSION, backgroundImage.getExtension()));
        ByteData byteData = new ByteData();
        byteData.var = variable;
        byteData.byteArray = byArray;
        netcdfFileWriteable.create();
        return byteData;
    }

    private void writeImageData(NetcdfFileWriteable netcdfFileWriteable, ByteData byteData) throws IOException, InvalidRangeException {
        Variable variable = byteData.var;
        byte[] byArray = byteData.byteArray;
        ArrayByte arrayByte = new ArrayByte(new int[]{byArray.length});
        Index index = arrayByte.getIndex();
        for (int i = 0; i < byArray.length; ++i) {
            arrayByte.setByte(index.set(i), byArray[i]);
        }
        netcdfFileWriteable.write(variable.getName(), (Array)arrayByte);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean saveArrayDataSXYToTempNetCDFFiles(SGArrayData sGArrayData, File file, String string, SGDrawingWindow sGDrawingWindow) throws IOException, InvalidRangeException {
        NetcdfFileWriteable netcdfFileWriteable = null;
        try {
            Object object;
            Object object2;
            int n;
            String string2;
            Object object3;
            Object object4;
            netcdfFileWriteable = NetcdfFileWriteable.createNew((String)file.getAbsolutePath(), (boolean)true);
            int n2 = sGArrayData.getPointsNumber();
            Dimension dimension = this.addSerialNumberDimension(netcdfFileWriteable, n2);
            String string3 = dimension.getName();
            Variable variable = this.addSerialNumberVarialbe(netcdfFileWriteable, dimension);
            variable.addAttribute(SGDataUtility.getValueTypeAttribute("Number"));
            SGDataColumn[] sGDataColumnArray = sGArrayData.getDataSetColumnsClone();
            String[] stringArray = new String[sGDataColumnArray.length];
            int[] nArray = new int[sGDataColumnArray.length];
            Arrays.fill(nArray, 0);
            for (int i = 0; i < sGDataColumnArray.length; ++i) {
                SGDataColumn sGDataColumn = sGDataColumnArray[i];
                if (!"Text".equals(sGDataColumn.getValueType()) && !"Date".equals(sGDataColumn.getValueType())) continue;
                object4 = sGDataColumn.getStringArray();
                int n3 = 0;
                for (int j = 0; j < ((Object)object4).length; ++j) {
                    object3 = ((String)object4[j]).getBytes("UTF-8");
                    if (n3 >= ((byte[])object3).length) continue;
                    n3 = ((byte[])object3).length;
                }
                string2 = "clen" + i;
                object3 = new Dimension(string2, n3);
                netcdfFileWriteable.addDimension(null, (Dimension)object3);
                stringArray[i] = string2;
                nArray[i] = n3;
            }
            String[] stringArray2 = new String[sGDataColumnArray.length];
            for (n = 0; n < sGDataColumnArray.length; ++n) {
                object4 = sGDataColumnArray[n];
                String string4 = ((SGDataColumn)object4).getValueType();
                string2 = "column" + n;
                object3 = null;
                if ("Number".equals(string4) || "Sampling Rate".equals(string4)) {
                    object3 = new Variable((NetcdfFile)netcdfFileWriteable, null, null, string2, DataType.DOUBLE, string3);
                    object3.addAttribute(SGDataUtility.getValueTypeAttribute(((SGDataColumn)object4).getValueType()));
                } else if ("Text".equals(string4) || "Date".equals(string4)) {
                    object2 = new StringBuffer();
                    ((StringBuffer)object2).append(string3);
                    ((StringBuffer)object2).append(' ');
                    ((StringBuffer)object2).append(stringArray[n]);
                    object = ((StringBuffer)object2).toString();
                    object3 = new Variable((NetcdfFile)netcdfFileWriteable, null, null, string2, DataType.CHAR, (String)object);
                    String string5 = "Text".equals(string4) ? "Text" : "Date";
                    object3.addAttribute(SGDataUtility.getValueTypeAttribute(string5));
                } else {
                    throw new Error("Illegal value type=" + ((SGDataColumn)object4).getValueType() + ", (" + ((SGDataColumn)object4).getTitle() + ", " + ((SGDataColumn)object4).getColumnType() + ")");
                }
                object2 = ((SGDataColumn)object4).getTitle();
                if (null != object2 && !"".equals(((String)object2).trim())) {
                    object = new Attribute(ATTRIBUTE_KEY_LONG_NAME, (String)object2);
                    object3.addAttribute((Attribute)object);
                }
                stringArray2[n] = object3.getName();
                netcdfFileWriteable.addVariable(null, (Variable)object3);
            }
            netcdfFileWriteable.create();
            for (n = 0; n < sGDataColumnArray.length; ++n) {
                int n4;
                object4 = sGDataColumnArray[n];
                String string6 = ((SGDataColumn)object4).getValueType();
                if ("Number".equals(string6) || "Sampling Rate".equals(string6)) {
                    Array array = Array.factory((DataType)DataType.DOUBLE, (int[])new int[]{n2});
                    for (int i = 0; i < n2; ++i) {
                        object2 = ((SGDataColumn)object4).getValue(i);
                        if (object2 instanceof Double) {
                            array.setDouble(i, ((Double)object2).doubleValue());
                            continue;
                        }
                        array.setDouble(i, Double.NaN);
                    }
                    netcdfFileWriteable.write(stringArray2[n], array);
                    continue;
                }
                if (!"Text".equals(string6) && !"Date".equals(string6)) continue;
                int n5 = 0;
                byte[][] byArrayArray = new byte[n2][];
                for (int i = 0; i < n2; ++i) {
                    object = ((SGDataColumn)object4).getValue(i);
                    String string7 = object instanceof String ? (String)object : (object instanceof SGDate ? ((SGDate)object).toString() : "");
                    byArrayArray[i] = string7.getBytes("UTF-8");
                    n4 = byArrayArray[i].length;
                    if (n4 <= n5) continue;
                    n5 = n4;
                }
                object2 = new ArrayByte(new int[]{n2, n5});
                object = object2.getIndex();
                for (int i = 0; i < n2; ++i) {
                    for (n4 = 0; n4 < byArrayArray[i].length; ++n4) {
                        object2.setByte(object.set(i, n4), byArrayArray[i][n4]);
                    }
                }
                netcdfFileWriteable.write(stringArray2[n], (Array)object2);
            }
            this.writeSerialNumberVarialbe(netcdfFileWriteable, variable);
        }
        finally {
            if (null != netcdfFileWriteable) {
                netcdfFileWriteable.close();
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File saveImageToFile(SGDrawingWindow sGDrawingWindow, File file) throws IOException, InvalidRangeException {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(file);
        stringBuffer.append(SGIConstants.FILE_SEPARATOR);
        stringBuffer.append("img");
        stringBuffer.append(".nc");
        String string = stringBuffer.toString();
        File file2 = new File(string);
        NetcdfFileWriteable netcdfFileWriteable = null;
        try {
            netcdfFileWriteable = NetcdfFileWriteable.createNew((String)file2.getAbsolutePath(), (boolean)true);
            ByteData byteData = this.createImageVariable(netcdfFileWriteable, sGDrawingWindow);
            if (byteData != null) {
                this.writeImageData(netcdfFileWriteable, byteData);
            }
        }
        finally {
            if (netcdfFileWriteable != null) {
                netcdfFileWriteable.close();
            }
        }
        return file2;
    }

    private List<File> saveDataToFiles(SGDrawingWindow sGDrawingWindow, File file) throws IOException, InvalidRangeException {
        ArrayList<File> arrayList = new ArrayList<File>();
        ArrayList<SGFigure> arrayList2 = sGDrawingWindow.getVisibleFigureList();
        for (int i = 0; i < arrayList2.size(); ++i) {
            SGFigure sGFigure = arrayList2.get(i);
            List<SGData> list = sGFigure.getVisibleDataList();
            for (int j = 0; j < list.size(); ++j) {
                SGData sGData = list.get(j);
                String string = this.createGroupName(i, j);
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append(file.getPath());
                stringBuffer.append(SGIConstants.FILE_SEPARATOR);
                stringBuffer.append(string);
                stringBuffer.append(".nc");
                String string2 = stringBuffer.toString();
                File file2 = new File(string2);
                boolean bl = false;
                if (SGDataUtility.isArrayData(sGData)) {
                    bl = SGUtilityText.isEqualString(sGData.getDataType(), "VXY") ? this.saveArrayDataVXYToTempNetCDFFiles((SGArrayData)sGData, file2, string, sGDrawingWindow) : (SGUtilityText.isEqualString(sGData.getDataType(), "SXYZ") ? this.saveArrayDataSXYZToTempNetCDFFiles((SGArrayData)sGData, file2, string, sGDrawingWindow) : this.saveArrayDataSXYToTempNetCDFFiles((SGArrayData)sGData, file2, string, sGDrawingWindow));
                } else if (SGDataUtility.isNetCDFData(sGData)) {
                    bl = sGData.saveData(file2, 7);
                }
                if (!bl) {
                    file2.delete();
                    file2 = null;
                }
                if (null == file2) continue;
                arrayList.add(file2);
            }
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copyNetcdfTempFileHeaderToOutFile(File[] fileArray, NetcdfFileWriteable netcdfFileWriteable) throws IOException {
        for (int i = 0; i < fileArray.length; ++i) {
            File file = fileArray[i];
            String string = this.getGroupNameFromDataFile(file);
            NetcdfFile netcdfFile = null;
            Group group = new Group((NetcdfFile)netcdfFileWriteable, null, string);
            try {
                String string2;
                netcdfFile = NetcdfFile.open((String)file.getAbsolutePath());
                List list = netcdfFile.getGlobalAttributes();
                List list2 = netcdfFile.getDimensions();
                List list3 = netcdfFile.getVariables();
                for (Dimension dimension : list2) {
                    string2 = dimension.getName();
                    dimension.setName(this.getGroupVariableName(string, string2));
                    netcdfFileWriteable.addDimension(null, dimension);
                }
                for (Dimension dimension : list) {
                    group.addAttribute((Attribute)dimension);
                }
                for (Dimension dimension : list3) {
                    string2 = dimension.getName();
                    String[] stringArray = string2.split("/");
                    if (stringArray.length >= 2) {
                        Group group2 = group;
                        for (int j = 0; j < stringArray.length - 1; ++j) {
                            Group group3 = group2.findGroup(stringArray[j]);
                            if (group3 == null) {
                                group3 = new Group((NetcdfFile)netcdfFileWriteable, group2, stringArray[j]);
                                group2.addGroup(group3);
                            }
                            group2 = group3;
                        }
                        dimension.setName(stringArray[stringArray.length - 1]);
                        group2.addVariable((Variable)dimension);
                        continue;
                    }
                    group.addVariable((Variable)dimension);
                }
                netcdfFileWriteable.addGroup(null, group);
                continue;
            }
            finally {
                if (null != netcdfFile) {
                    netcdfFile.close();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copyNetcdfTempFileArrayToOutFile(File[] fileArray, NetcdfFileWriteable netcdfFileWriteable) throws IOException, InvalidRangeException {
        for (int i = 0; i < fileArray.length; ++i) {
            File file = fileArray[i];
            String string = this.getGroupNameFromDataFile(file);
            NetcdfFile netcdfFile = null;
            try {
                netcdfFile = NetcdfFile.open((String)file.getAbsolutePath());
                List list = netcdfFile.getVariables();
                for (Variable variable : list) {
                    Array array = variable.read();
                    netcdfFileWriteable.write(this.getGroupVariableName(string, variable.getName()), array);
                }
                continue;
            }
            finally {
                if (null != netcdfFile) {
                    netcdfFile.close();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copyNetcdfTempFileToOutFile(String string, File file, File file2) throws IOException, InvalidRangeException {
        File[] fileArray = file.listFiles();
        NetcdfFileWriteable netcdfFileWriteable = null;
        try {
            netcdfFileWriteable = NetcdfFileWriteable.createNew((String)file2.getAbsolutePath());
            netcdfFileWriteable.addGlobalAttribute(ATTRIBUTE_NAME_PROPERTY, string);
            this.copyNetcdfTempFileHeaderToOutFile(fileArray, netcdfFileWriteable);
            netcdfFileWriteable.create();
            this.copyNetcdfTempFileArrayToOutFile(fileArray, netcdfFileWriteable);
        }
        finally {
            if (null != netcdfFileWriteable) {
                netcdfFileWriteable.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getPropertyString(SGDrawingWindow sGDrawingWindow, String string) throws IOException {
        SGPropertyFileCreator sGPropertyFileCreator = new SGPropertyFileCreator();
        ByteArrayOutputStream byteArrayOutputStream = null;
        try {
            byteArrayOutputStream = new ByteArrayOutputStream();
            sGPropertyFileCreator.create(sGDrawingWindow, byteArrayOutputStream, 7, string);
            String string2 = byteArrayOutputStream.toString("UTF-8");
            return string2;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            String string3 = null;
            return string3;
        }
        finally {
            if (null != byteArrayOutputStream) {
                byteArrayOutputStream.close();
            }
        }
    }

    public int save(SGDrawingWindow sGDrawingWindow, String string, File file, File file2) {
        try {
            this.saveDataToFiles(sGDrawingWindow, file);
            this.saveImageToFile(sGDrawingWindow, file);
            String string2 = this.getPropertyString(sGDrawingWindow, string);
            this.copyNetcdfTempFileToOutFile(string2, file, file2);
        }
        catch (IOException iOException) {
            return -1;
        }
        catch (InvalidRangeException invalidRangeException) {
            return -1;
        }
        catch (Exception exception) {
            return -1;
        }
        return 0;
    }

    private void setupNetCDFGroup(NetcdfFile netcdfFile) {
        String string;
        List list = netcdfFile.getDimensions();
        HashSet<String> hashSet = new HashSet<String>();
        for (int i = 0; i < list.size(); ++i) {
            Dimension object = (Dimension)list.get(i);
            string = object.getName();
            String[] stringArray = string.split("/");
            String string2 = stringArray[0].trim();
            if ("".equals(string2)) continue;
            hashSet.add(string2);
        }
        for (String string3 : hashSet) {
            string = new Group(netcdfFile, null, string3);
            netcdfFile.addGroup(null, (Group)string);
        }
    }

    private int getNumberOfDataInNetcdfFile(NetcdfFile netcdfFile, int n) {
        Group group = netcdfFile.getRootGroup();
        List list = group.getGroups();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("id");
        stringBuffer.append(n);
        stringBuffer.append('-');
        String string = stringBuffer.toString();
        int n2 = 0;
        for (int i = 0; i < list.size(); ++i) {
            if (!((Group)list.get(i)).getName().startsWith(string)) continue;
            ++n2;
        }
        return n2;
    }

    private boolean setupFigureFromProperty(Element element, SGDrawingWindow sGDrawingWindow, SGFigure sGFigure) {
        SGIFigureElementAxis sGIFigureElementAxis;
        float f;
        StringBuffer stringBuffer;
        int n = sGDrawingWindow.assignFigureId();
        sGFigure.setID(n);
        if (!sGFigure.readProperty(element)) {
            return false;
        }
        if (this.mMain.mFigureCreator.createFigureElementFromPropertyFile(sGFigure, element) == 1) {
            return false;
        }
        String string = null;
        Number number = null;
        string = element.getAttribute("SpaceAxisLineAndNumber");
        if (string.length() != 0) {
            stringBuffer = new StringBuffer();
            number = SGUtilityText.getNumber(string, stringBuffer);
            if (number == null) {
                return false;
            }
            f = number.floatValue();
            sGIFigureElementAxis = sGFigure.getAxisElement();
            sGIFigureElementAxis.setSpaceAxisLineAndNumber(f, stringBuffer.toString());
            if (!sGFigure.setSpaceAxisLineAndNumber(f, stringBuffer.toString())) {
                return false;
            }
        }
        if ((string = element.getAttribute("SpaceNumberAndTitle")).length() != 0) {
            stringBuffer = new StringBuffer();
            number = SGUtilityText.getNumber(string, stringBuffer);
            if (number == null) {
                return false;
            }
            f = number.floatValue();
            sGIFigureElementAxis = sGFigure.getAxisElement();
            sGIFigureElementAxis.setSpaceNumberAndTitle(f, stringBuffer.toString());
            if (!sGFigure.setSpaceNumberAndTitle(f, stringBuffer.toString())) {
                return false;
            }
        }
        return true;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private SGData getDataInstanceFromProperty(String string, Element element) {
        void var3_15;
        String string2;
        Object var3_3 = null;
        if (SGDataUtility.isArrayData(string)) {
            if (SGDataUtility.isSXYTypeData(string)) {
                string2 = element.getAttribute("PickupDimensionName");
                if (null == string2 || string2.trim().length() == 0) {
                    Class<SGSXYMultipleVariableNetCDFData> clazz = SGSXYMultipleVariableNetCDFData.class;
                } else {
                    Class<SGSXYMultipleDimensionNetCDFData> clazz = SGSXYMultipleDimensionNetCDFData.class;
                }
            } else if ("VXY".equals(string)) {
                Class<SGVXYNetCDFData> clazz = SGVXYNetCDFData.class;
            } else {
                if (!"SXYZ".equals(string)) return null;
                Class<SGSXYZNetCDFData> clazz = SGSXYZNetCDFData.class;
            }
        } else {
            if (!SGDataUtility.isNetCDFData(string)) return null;
            if (SGDataUtility.isSXYTypeData(string)) {
                if (SGDataUtility.isNetCDFDimensionData(string)) {
                    Class<SGSXYMultipleDimensionNetCDFData> clazz = SGSXYMultipleDimensionNetCDFData.class;
                } else {
                    string2 = element.getAttribute("PickupDimensionName");
                    if (null == string2 || string2.trim().length() == 0) {
                        Class<SGSXYMultipleVariableNetCDFData> clazz = SGSXYMultipleVariableNetCDFData.class;
                    } else {
                        Class<SGSXYMultipleDimensionNetCDFData> clazz = SGSXYMultipleDimensionNetCDFData.class;
                    }
                }
            } else if ("VXY_NETCDF".equals(string)) {
                Class<SGVXYNetCDFData> clazz = SGVXYNetCDFData.class;
            } else {
                if (!"SXYZ_NETCDF".equals(string)) return null;
                Class<SGSXYZNetCDFData> clazz = SGSXYZNetCDFData.class;
            }
        }
        string2 = var3_15.getName();
        Class<?> clazz = null;
        try {
            clazz = Class.forName(string2);
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
        if (clazz == null) {
            return null;
        }
        SGData sGData = null;
        try {
            Object obj = clazz.newInstance();
            if (!(obj instanceof SGData)) return sGData;
            return (SGData)obj;
        }
        catch (Exception exception) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int createDataObjectsFromPropertyFile(Element element, SGFigure sGFigure, int n, NetcdfFile netcdfFile, SGIProgressControl sGIProgressControl, boolean bl, String string) {
        NodeList nodeList = element.getElementsByTagName("Data");
        int n2 = nodeList.getLength();
        if (n2 != this.getNumberOfDataInNetcdfFile(netcdfFile, n)) {
            return 1;
        }
        int[] nArray = new int[n2];
        SGData[] sGDataArray = new SGData[n2];
        boolean bl2 = true;
        for (int i = 0; i < n2; ++i) {
            Object object;
            Object object2;
            String string2 = this.createGroupName(n, i);
            Node node = nodeList.item(i);
            if (!(node instanceof Element)) continue;
            Element element2 = (Element)node;
            String string3 = element2.getAttribute("Type");
            if (string3 == null) {
                return 1;
            }
            if (SGDataUtility.isArrayData(string3 = SGApplicationUtility.getArrayDataType(string3))) {
                if (SGDataUtility.isSXYTypeData(string3)) {
                    string3 = "SXY_MULTIPLE_NETCDF";
                } else if (SGDataUtility.isVXYTypeData(string3)) {
                    string3 = "VXY_NETCDF";
                } else if ("SXYZ".equals(string3)) {
                    string3 = "SXYZ_NETCDF";
                }
            }
            if ("XY".equals(sGFigure.getClassType())) {
                object2 = null;
                object2 = SGDataUtility.isVXYTypeData(string3) ? "VXY" : "SXY";
                sGFigure.setClassType((String)object2);
            }
            if ((object2 = this.getDataInstanceFromProperty(string3, element2)) == null) {
                return 1;
            }
            Map<String, Object> map = this.mMain.createInfoMap(string3, element2);
            map.put("GroupName", string2);
            if (this.getNumberOfDataInNetcdfFile(netcdfFile, n) == 0) {
                return 3;
            }
            SGDataColumnInfoSet sGDataColumnInfoSet = null;
            SGNetCDFFile sGNetCDFFile = null;
            try {
                object = NetcdfFile.open((String)netcdfFile.getLocation());
                sGNetCDFFile = new SGNetCDFFile((NetcdfFile)object);
            }
            catch (IOException iOException) {
                return 2;
            }
            map.put("Data Source", sGNetCDFFile);
            sGDataColumnInfoSet = this.mMain.getNetCDFDefaultDataColumnInfo(sGNetCDFFile, string3, map);
            if (sGDataColumnInfoSet == null) {
                return 2;
            }
            object = null;
            object = this.mMain.mDataCreator.createForNetCDFDataSet(sGNetCDFFile, string3, sGDataColumnInfoSet, map, sGIProgressControl);
            if (object == null) {
                return 2;
            }
            if (((SGDataCreator.CreatedDataSet)object).getDataLength() == 0) {
                return 2;
            }
            SGDataCreator.CreatedData createdData = ((SGDataCreator.CreatedDataSet)object).getData(0);
            SGData sGData = createdData.getData();
            try {
                if (!((SGData)object2).setData(sGData)) {
                    int n3 = 2;
                    return n3;
                }
            }
            finally {
                sGData.dispose();
            }
            String string4 = element2.getAttribute("IndexInLegend");
            if (string4.length() != 0) {
                Integer n4 = SGUtilityText.getInteger(string4);
                if (n4 == null) {
                    return 1;
                }
                nArray[i] = n4;
                sGDataArray[i] = object2;
            } else {
                bl2 = false;
            }
            if (sGFigure.createDataObjectFromPropertyFile(element2, (SGData)object2, bl)) continue;
            return 1;
        }
        if (bl2) {
            SGIFigureElementLegend sGIFigureElementLegend = sGFigure.getLegendElement();
            sGIFigureElementLegend.sortLegend(sGDataArray, nArray);
        }
        SGIFigureElement[] sGIFigureElementArray = sGFigure.getIFigureElementArray();
        for (int i = 0; i < sGIFigureElementArray.length; ++i) {
            sGIFigureElementArray[i].initPropertiesHistory();
        }
        return 0;
    }

    private int createSingleFigureFromPropertyFile(Element element, SGDrawingWindow sGDrawingWindow, int n, NetcdfFile netcdfFile, boolean bl, String string) {
        String string2 = null;
        string2 = element.getAttribute("Type");
        if (string2.length() == 0) {
            return 1;
        }
        SGXYFigure sGXYFigure = null;
        if (!("SXY".equals(string2) || "VXY".equals(string2) || "XY".equals(string2))) {
            return 1;
        }
        sGXYFigure = new SGXYFigure(sGDrawingWindow);
        sGXYFigure.setClassType(string2);
        if (!this.setupFigureFromProperty(element, sGDrawingWindow, sGXYFigure)) {
            return 1;
        }
        int n2 = this.createDataObjectsFromPropertyFile(element, sGXYFigure, n, netcdfFile, sGDrawingWindow, bl, string);
        if (n2 != 0) {
            return n2;
        }
        sGDrawingWindow.addFigure(sGXYFigure);
        sGXYFigure.initPropertiesHistory();
        return 0;
    }

    int createFiguresFromPropertyFile(Element element, SGDrawingWindow sGDrawingWindow, NetcdfFile netcdfFile, boolean bl, String string) {
        NodeList nodeList = element.getElementsByTagName("Figure");
        int n = nodeList.getLength();
        for (int i = 0; i < n; ++i) {
            int n2;
            Element element2;
            int n3;
            Node node = nodeList.item(i);
            if (!(node instanceof Element) || (n3 = this.createSingleFigureFromPropertyFile(element2 = (Element)node, sGDrawingWindow, n2 = i, netcdfFile, bl, string)) == 0) continue;
            return n3;
        }
        return 0;
    }

    private boolean setWindowProperty(SGDrawingWindow sGDrawingWindow, Element element, String string, NetcdfFile netcdfFile) {
        int n;
        sGDrawingWindow.startProgress();
        sGDrawingWindow.setProgressMessage("Read Property");
        boolean bl = sGDrawingWindow.readProperty(element, 0.0f, 1.0f);
        sGDrawingWindow.endProgress();
        if (!bl) {
            n = 1;
        } else {
            n = this.createFiguresFromPropertyFile(element, sGDrawingWindow, netcdfFile, true, string);
            if (n == 0) {
                sGDrawingWindow.initPropertiesHistory();
                sGDrawingWindow.initSavedHistory();
                sGDrawingWindow.setSaved(true);
            }
        }
        String string2 = null;
        switch (n) {
            case 0: {
                string2 = "Successful completion.";
                break;
            }
            case 3: {
                string2 = "Data number shortage.";
                break;
            }
            case 4: {
                string2 = "Data number excess.";
                break;
            }
            case 5: {
                string2 = "Cannot open the selected file.";
                break;
            }
            case 1: {
                string2 = "The property file is invalid.";
                break;
            }
            case 2: {
                string2 = "The data file is invalid.";
                break;
            }
            default: {
                string2 = "Unknown error occured";
            }
        }
        if (string2 != "Successful completion.") {
            SGUtility.showMessageDialog(null, string2, "Property file", 0);
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean loadSub(SGDrawingWindow sGDrawingWindow, Document document, NetcdfFile netcdfFile) {
        Object object;
        ByteArrayOutputStream byteArrayOutputStream;
        Object object2;
        Object object32;
        Element element = document.getDocumentElement();
        String string = element.getAttribute("Version");
        Element element2 = this.mMain.mPropertyFileManager.getWindowElement(document);
        NodeList nodeList = element2.getElementsByTagName("Figure");
        int n = nodeList.getLength();
        int n2 = 0;
        int[] nArray = new int[n];
        for (int i = 0; i < n; ++i) {
            Node node = nodeList.item(i);
            if (!(node instanceof Element)) {
                return false;
            }
            object32 = (Element)node;
            object2 = object32.getElementsByTagName("Data");
            nArray[i] = object2.getLength();
            n2 += nArray[i];
        }
        Element element3 = null;
        for (Object object32 : netcdfFile.getVariables()) {
            if (!DataType.BYTE.equals((Object)object32.getDataType()) || !object32.getName().startsWith("img")) continue;
            element3 = object32;
            break;
        }
        boolean bl = true;
        object32 = null;
        object2 = null;
        if (element3 != null) {
            Object object4;
            byteArrayOutputStream = null;
            try {
                byteArrayOutputStream = new ByteArrayOutputStream();
                object = element3.read();
                if (!(object instanceof ArrayByte)) {
                    boolean bl2 = false;
                    return bl2;
                }
                object4 = (ArrayByte)object;
                Index index = object4.getIndex();
                int n3 = 0;
                while ((long)n3 < object4.getSize()) {
                    byte by = object4.get(index.set(n3));
                    byteArrayOutputStream.write(by);
                    ++n3;
                }
                object32 = byteArrayOutputStream.toByteArray();
            }
            catch (IOException iOException) {
                boolean bl3 = false;
                return bl3;
            }
            finally {
                if (byteArrayOutputStream != null) {
                    try {
                        byteArrayOutputStream.close();
                    }
                    catch (IOException iOException) {}
                }
            }
            object = element3.findAttribute(ATTRIBUTE_KEY_IMAGE_FILE_EXTENSION);
            if (object == null) {
                return false;
            }
            object4 = object.getStringValue();
            if (object4 == null) {
                return false;
            }
            object2 = SGApplicationUtility.findExtension((String)object4);
            if (object2 == null) {
                return false;
            }
        } else {
            bl = false;
        }
        if (bl) {
            ++n2;
        }
        this.setupNetCDFGroup(netcdfFile);
        byteArrayOutputStream = netcdfFile.getRootGroup();
        object = byteArrayOutputStream.getGroups();
        if (n2 != object.size()) {
            return false;
        }
        sGDrawingWindow.deleteImage();
        sGDrawingWindow.clearUndoBuffer();
        sGDrawingWindow.removeAllFigures();
        if (bl && !sGDrawingWindow.setImage((byte[])object32, (String)object2, false)) {
            return false;
        }
        if (!this.setWindowProperty(sGDrawingWindow, element2, string, netcdfFile)) {
            return false;
        }
        sGDrawingWindow.updateClientRect();
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int load(SGDrawingWindow sGDrawingWindow, File file) throws IOException {
        NetcdfFile netcdfFile = null;
        try {
            netcdfFile = NetcdfFile.open((String)file.getAbsolutePath());
            Attribute attribute = netcdfFile.findGlobalAttribute(ATTRIBUTE_NAME_PROPERTY);
            if (null == attribute) {
                int n = -1;
                return n;
            }
            String string = attribute.getStringValue();
            if (null == string || string.length() == 0) {
                int n = -1;
                return n;
            }
            Document document = SGUtilityText.getDocumentFromString(string);
            if (document == null) {
                int n = -1;
                return n;
            }
            if (!this.loadSub(sGDrawingWindow, document, netcdfFile)) {
                int n = -1;
                return n;
            }
        }
        finally {
            if (null != netcdfFile) {
                netcdfFile.close();
            }
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isNetCDFDatasetFile(String string) {
        NetcdfFile netcdfFile = null;
        try {
            netcdfFile = NetcdfFile.open((String)string);
            List list = netcdfFile.getGlobalAttributes();
            for (Attribute attribute : list) {
                if (!ATTRIBUTE_NAME_PROPERTY.equals(attribute.getName()) || !attribute.isString() || attribute.getStringValue().length() <= 0) continue;
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        catch (Exception exception) {
            boolean bl = false;
            return bl;
        }
        finally {
            if (netcdfFile != null) {
                try {
                    netcdfFile.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private static class ByteData {
        Variable var = null;
        byte[] byteArray = null;

        private ByteData() {
        }
    }
}

