/*
 * Decompiled with CFR 0.152.
 */
package jp.riken.brain.ni.samuraigraph.application;

import java.awt.Component;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;
import jp.riken.brain.ni.samuraigraph.application.SGApplicationUtility;
import jp.riken.brain.ni.samuraigraph.application.SGIPluginOutputDataToFile;
import jp.riken.brain.ni.samuraigraph.application.SGJarClassLoader;
import jp.riken.brain.ni.samuraigraph.application.SGMainFunctions;
import jp.riken.brain.ni.samuraigraph.base.SGData;
import jp.riken.brain.ni.samuraigraph.base.SGExtensionFileFilter;
import jp.riken.brain.ni.samuraigraph.base.SGFileChooser;
import jp.riken.brain.ni.samuraigraph.base.SGIConstants;
import jp.riken.brain.ni.samuraigraph.base.SGIDisposable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SGPluginManager
implements SGIDisposable {
    private SGMainFunctions mMain = null;
    protected final List<Class<?>> mClassList = new ArrayList();
    protected final List<PluginException> mExceptionList = new ArrayList<PluginException>();
    private boolean mDisposed = false;
    private String mCurrentFilePath;
    private String mCurrentFileName;
    public static final String DEFAULT_OUTPUT_FILE_NAME = "output";
    public static final String DEFAULT_OUTPUT_FILE_EXT = "txt";

    SGPluginManager(SGMainFunctions sGMainFunctions) {
        this.mMain = sGMainFunctions;
    }

    boolean loadPlugins(String string) {
        this.mClassList.clear();
        this.mExceptionList.clear();
        File file = null;
        URL uRL = ClassLoader.getSystemClassLoader().getResource(string);
        if (null != uRL) {
            file = new File(uRL.getFile());
        }
        if (file == null || !file.exists()) {
            return true;
        }
        ArrayList<File> arrayList = new ArrayList<File>();
        File[] fileArray = file.listFiles();
        if (fileArray.length == 0) {
            return true;
        }
        for (int i = 0; i < fileArray.length; ++i) {
            if (!fileArray[i].getName().endsWith(".jar")) continue;
            arrayList.add(fileArray[i]);
        }
        return this.loadJars(arrayList.toArray(new File[arrayList.size()]));
    }

    private boolean loadJars(File[] fileArray) {
        boolean bl = true;
        for (int i = 0; i < fileArray.length; ++i) {
            try {
                this.loadJar(fileArray[i], this.mClassList);
                continue;
            }
            catch (Exception exception) {
                this.mExceptionList.add(new PluginException(exception, fileArray[i].getName()));
                bl = false;
            }
        }
        return bl;
    }

    private void loadJar(File file, List<Class<?>> list) throws ClassNotFoundException, ZipException, IOException, InstantiationException, IllegalAccessException {
        ZipFile zipFile = new ZipFile(file);
        SGJarClassLoader sGJarClassLoader = new SGJarClassLoader(zipFile);
        ArrayList arrayList = new ArrayList();
        Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
        while (enumeration.hasMoreElements()) {
            String string;
            ZipEntry zipEntry = enumeration.nextElement();
            if (zipEntry.isDirectory() || !(string = zipEntry.getName()).endsWith(".class")) continue;
            sGJarClassLoader.setDelegateFirst(false);
            String string2 = string.substring(0, string.length() - 6).replace('/', '.');
            Class<?> clazz = sGJarClassLoader.loadClass(string2, false);
            arrayList.add(clazz);
            if (!SGIPluginOutputDataToFile.class.isAssignableFrom(clazz)) continue;
            clazz.newInstance();
        }
        list.addAll(arrayList);
    }

    @Override
    public void dispose() {
        this.mDisposed = true;
        this.mClassList.clear();
        this.mExceptionList.clear();
    }

    @Override
    public boolean isDisposed() {
        return this.mDisposed;
    }

    public boolean hasOutputPlugins() {
        for (int i = 0; i < this.mClassList.size(); ++i) {
            if (!SGIPluginOutputDataToFile.class.isAssignableFrom(this.mClassList.get(i))) continue;
            return true;
        }
        return false;
    }

    public void doOutputToFile(Component component, SGData sGData) throws IOException {
        Map<FileFilter, SGIPluginOutputDataToFile> map = this.getPluginFilterMap();
        JFileChooser jFileChooser = this.getFileChooser(map.keySet());
        int n = jFileChooser.showSaveDialog(component);
        if (n == 0) {
            File file = jFileChooser.getSelectedFile();
            this.mCurrentFilePath = file.getParent();
            this.mCurrentFileName = file.getName();
            FileFilter fileFilter = jFileChooser.getFileFilter();
            for (FileFilter fileFilter2 : map.keySet()) {
                if (!fileFilter2.equals(fileFilter)) continue;
                map.get(fileFilter2).writeData(file, sGData);
                this.mMain.updateCurrentFile(file, 6);
                break;
            }
        }
    }

    private Map<FileFilter, SGIPluginOutputDataToFile> getPluginFilterMap() {
        ArrayList arrayList = new ArrayList();
        for (int i = 0; i < this.mClassList.size(); ++i) {
            if (!SGIPluginOutputDataToFile.class.isAssignableFrom(this.mClassList.get(i))) continue;
            arrayList.add(this.mClassList.get(i));
        }
        HashMap<FileFilter, SGIPluginOutputDataToFile> hashMap = new HashMap<FileFilter, SGIPluginOutputDataToFile>();
        for (int i = 0; i < arrayList.size(); ++i) {
            try {
                Object t = ((Class)arrayList.get(i)).newInstance();
                SGIPluginOutputDataToFile sGIPluginOutputDataToFile = (SGIPluginOutputDataToFile)t;
                SGExtensionFileFilter sGExtensionFileFilter = new SGExtensionFileFilter();
                sGExtensionFileFilter.setDescription(sGIPluginOutputDataToFile.getDescription());
                sGExtensionFileFilter.addExtension(sGIPluginOutputDataToFile.getExtension());
                hashMap.put(sGExtensionFileFilter, sGIPluginOutputDataToFile);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return hashMap;
    }

    private JFileChooser getFileChooser(Set<FileFilter> set) {
        SGFileChooser sGFileChooser = new SGFileChooser();
        sGFileChooser.setAcceptAllFileFilterUsed(false);
        for (FileFilter object2 : set) {
            sGFileChooser.setFileFilter(object2);
        }
        sGFileChooser.setCurrentDirectory(new File(this.getCurrentFilePath()));
        String string = SGApplicationUtility.getPathName(this.getCurrentFilePath(), this.getCurrentFileName());
        File file = new File(string);
        ((JFileChooser)sGFileChooser).setSelectedFile(file);
        return sGFileChooser;
    }

    public String getFirstExceptionJarFilename() {
        if (this.mExceptionList.size() == 0) {
            return "";
        }
        return this.mExceptionList.get(0).getFilename();
    }

    private String getCurrentFilePath() {
        if (this.mCurrentFilePath == null || this.mCurrentFilePath.equals("")) {
            this.mCurrentFilePath = SGIConstants.USER_HOME;
        }
        return this.mCurrentFilePath;
    }

    private String getCurrentFileName() {
        if (this.mCurrentFileName == null || this.mCurrentFileName.equals("")) {
            this.mCurrentFileName = SGApplicationUtility.appendExtension(DEFAULT_OUTPUT_FILE_NAME, DEFAULT_OUTPUT_FILE_EXT);
        }
        return this.mCurrentFileName;
    }

    private static class PluginException
    extends Exception {
        private static final long serialVersionUID = -924108456633860433L;
        private final String mFilename;

        PluginException(Exception exception, String string) {
            super(exception);
            this.mFilename = string;
        }

        public String getFilename() {
            return this.mFilename;
        }
    }
}

