/*
 * Decompiled with CFR 0.152.
 */
package jp.riken.brain.ni.samuraigraph.application;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.prefs.Preferences;
import javax.swing.AbstractCellEditor;
import javax.swing.BorderFactory;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import jp.riken.brain.ni.samuraigraph.application.SGApplicationUtility;
import jp.riken.brain.ni.samuraigraph.application.SGDataCreator;
import jp.riken.brain.ni.samuraigraph.application.SGNetCDFDataFileChooserPanel;
import jp.riken.brain.ni.samuraigraph.application.SGPropertyFileArrayDataDialog;
import jp.riken.brain.ni.samuraigraph.application.SGPropertyFileData;
import jp.riken.brain.ni.samuraigraph.application.SGPropertyFileDataDialog;
import jp.riken.brain.ni.samuraigraph.application.SGPropertyFileNetCDFDataDialog;
import jp.riken.brain.ni.samuraigraph.application.SGSingleDataFileChooserWizardDialog;
import jp.riken.brain.ni.samuraigraph.application.SGWizardDialog;
import jp.riken.brain.ni.samuraigraph.base.SGButton;
import jp.riken.brain.ni.samuraigraph.base.SGDataColumnInfo;
import jp.riken.brain.ni.samuraigraph.base.SGDataColumnInfoSet;
import jp.riken.brain.ni.samuraigraph.base.SGUtility;
import jp.riken.brain.ni.samuraigraph.data.SGDataTypeConstants;
import jp.riken.brain.ni.samuraigraph.data.SGDataUtility;
import jp.riken.brain.ni.samuraigraph.data.SGIDataColumnTypeConstants;
import jp.riken.brain.ni.samuraigraph.data.SGNetCDFFile;
import jp.riken.brain.ni.samuraigraph.data.SGVariable;
import ucar.nc2.NetcdfFile;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SGPropertyDataFileChooserWizardDialog
extends SGWizardDialog
implements TableModelListener,
DropTargetListener,
ComponentListener,
CellEditorListener,
MouseListener,
MouseMotionListener,
MouseWheelListener,
SGIDataColumnTypeConstants {
    private static final long serialVersionUID = 1614748084851553730L;
    public static final String TITLE = "Select the Data Files";
    private JPanel mButtonPanel;
    private SGButton mCancelButton;
    private SGButton mNextButton;
    private SGButton mOKButton;
    private JPanel mPanel;
    private SGButton mPreviousButton;
    private JScrollPane mScrollPane;
    protected JTable mTable;
    public static final String COLUMN_NAME_FIGURE_ID = "Figure ID";
    public static final String COLUMN_NAME_DATA_TYPE = "Data Type";
    public static final String COLUMN_NAME_DATA_NAME = "Data Name";
    public static final String COLUMN_NAME_FILE_NAME = "File Name";
    public static final String COLUMN_NAME_BUTTON = "";
    public static final String NO_DATA = "NO_DATA";
    public static final String[] COLUMN_NAME_ARRAY = new String[]{"Figure ID", "Data Type", "Data Name", "File Name", ""};
    public static final int ROW_HEIGHT = 20;
    private static final int[] PREFERRED_COLUMN_WIDTH_ARRAY = new int[]{50, 80, 80, 120, 20};
    private static final int SCROLL_BAR_UNIT_INCREMENT = 20;
    private static final int SCROLL_BAR_BLOCK_INCREMENT = 80;
    private DefaultTableModel mTableModel = null;
    private DataFile[] mDataFileArray = null;
    private SGDataCreator mDataCreator = null;
    private SGPropertyFileDataDialog mPropertyFileDataDialog = null;
    private SGSingleDataFileChooserWizardDialog mSingleDataFileChooserWizardDilaog = null;
    private int mCurDataSetupRowIndex = -1;
    private int mFocusedRowIndex = -1;
    private String mVersionNumber = null;

    public SGPropertyDataFileChooserWizardDialog() {
        this.initComponents();
        this.initProperty();
    }

    public SGPropertyDataFileChooserWizardDialog(Frame frame, boolean bl) {
        super(frame, bl);
        this.initComponents();
        this.initProperty();
    }

    private void initComponents() {
        this.mPanel = new JPanel();
        this.mScrollPane = new JScrollPane();
        this.mTable = this.createTableInstance();
        this.mButtonPanel = new JPanel();
        this.mPreviousButton = new SGButton();
        this.mNextButton = new SGButton();
        this.mOKButton = new SGButton();
        this.mCancelButton = new SGButton();
        this.getContentPane().setLayout(new GridBagLayout());
        this.mPanel.setFont(new Font("SansSerif", 0, 11));
        this.mPanel.setLayout(new GridBagLayout());
        this.mScrollPane.setFont(new Font("Dialog", 0, 11));
        this.mScrollPane.setPreferredSize(new Dimension(468, 200));
        this.mTable.setFont(new Font("Dialog", 0, 11));
        this.mScrollPane.setViewportView(this.mTable);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(4, 0, 0, 0);
        this.mPanel.add((Component)this.mScrollPane, gridBagConstraints);
        this.getContentPane().add((Component)this.mPanel, new GridBagConstraints());
        this.mButtonPanel.setFont(new Font("Dialog", 0, 11));
        this.mPreviousButton.setText("<Prev");
        this.mPreviousButton.setFont(new Font("Dialog", 1, 12));
        this.mButtonPanel.add(this.mPreviousButton);
        this.mNextButton.setText("Next>");
        this.mNextButton.setFont(new Font("Dialog", 1, 12));
        this.mButtonPanel.add(this.mNextButton);
        this.mOKButton.setText("OK");
        this.mOKButton.setFont(new Font("Dialog", 1, 12));
        this.mButtonPanel.add(this.mOKButton);
        this.mCancelButton.setText("Cancel");
        this.mCancelButton.setFont(new Font("Dialog", 1, 12));
        this.mButtonPanel.add(this.mCancelButton);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        this.getContentPane().add((Component)this.mButtonPanel, gridBagConstraints);
        this.pack();
    }

    private boolean initProperty() {
        this.setTitle(TITLE);
        this.mTableModel = new OriginalTableModel();
        this.mTable.setModel(this.mTableModel);
        this.mTableModel.addTableModelListener(this);
        this.mTable.setRowHeight(20);
        this.mDataCreator = new SGDataCreator();
        DropTarget dropTarget = new DropTarget(this.mTable, 3, this, true);
        this.setDropTarget(dropTarget);
        this.mTable.addComponentListener(this);
        this.mTable.addMouseListener(this);
        this.mTable.addMouseMotionListener(this);
        this.mTable.addMouseWheelListener(this);
        JScrollBar jScrollBar = this.mScrollPane.getVerticalScrollBar();
        jScrollBar.setUnitIncrement(20);
        jScrollBar.setBlockIncrement(80);
        return true;
    }

    @Override
    public void componentResized(ComponentEvent componentEvent) {
        super.componentResized(componentEvent);
        this.updateTable();
    }

    @Override
    public void componentShown(ComponentEvent componentEvent) {
        super.componentShown(componentEvent);
        this.updateTable();
    }

    private void updateTable() {
        int n = this.mTable.getHeight();
        if (n != 0) {
            this.setPreferredColumnWidth();
        }
    }

    public int getDataNum() {
        if (this.mDataFileArray == null) {
            return 0;
        }
        return this.mDataFileArray.length;
    }

    public SGPropertyFileData[] getPropertyFileDataArray() {
        int n = this.getDataNum();
        SGPropertyFileData[] sGPropertyFileDataArray = new SGPropertyFileData[n];
        for (int i = 0; i < n; ++i) {
            DataFile dataFile = this.mDataFileArray[i];
            sGPropertyFileDataArray[i] = new SGPropertyFileData(dataFile.figureId, dataFile.dataType, dataFile.dataName, dataFile.infoMap);
            sGPropertyFileDataArray[i].setColumnInfoSet(dataFile.dataColInfoSet);
            sGPropertyFileDataArray[i].setFileName(dataFile.fileName);
        }
        return sGPropertyFileDataArray;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        String string = actionEvent.getActionCommand();
        if (object.equals(this.mPropertyFileDataDialog)) {
            if (string.equals("OK")) {
                SGPropertyFileDataDialog sGPropertyFileDataDialog = (SGPropertyFileDataDialog)object;
                String string2 = sGPropertyFileDataDialog.getFileName();
                SGDataColumnInfoSet sGDataColumnInfoSet = sGPropertyFileDataDialog.getDataColumnInfoSet();
                DataFile dataFile = this.mDataFileArray[this.mCurDataSetupRowIndex];
                dataFile.dataColInfoSet = sGDataColumnInfoSet;
                dataFile.fileName = string2;
                if (this.mPropertyFileDataDialog instanceof SGPropertyFileNetCDFDataDialog) {
                    SGPropertyFileNetCDFDataDialog sGPropertyFileNetCDFDataDialog = (SGPropertyFileNetCDFDataDialog)sGPropertyFileDataDialog;
                    Integer n = sGPropertyFileNetCDFDataDialog.getMultipleDimensionStart();
                    Integer n2 = sGPropertyFileNetCDFDataDialog.getMultipleDimensionEnd();
                    Integer n3 = sGPropertyFileNetCDFDataDialog.getMultipleDimensionStep();
                    Map<String, Object> map = dataFile.infoMap;
                    if (n != null && n2 != null && n3 != null) {
                        map.put("Multiple dimension start", n);
                        map.put("Multiple dimension end", n2);
                        map.put("Multiple dimension step", n3);
                    }
                }
                int n = this.getFileNameColumnIndex();
                this.mTable.setValueAt(string2, this.mCurDataSetupRowIndex, n);
                this.updateAvailableButtons();
            } else if (string.equals("Cancel") && this.mSingleDataFileChooserWizardDilaog != null) {
                this.mSingleDataFileChooserWizardDilaog.setVisible(true);
            }
            this.mCurDataSetupRowIndex = -1;
        } else if (object.equals(this.mSingleDataFileChooserWizardDilaog) && string.equals("OK")) {
            if (this.mSingleDataFileChooserWizardDilaog == null) {
                return;
            }
            this.mSingleDataFileChooserWizardDilaog.setVisible(false);
            DataFile dataFile = this.mDataFileArray[this.mCurDataSetupRowIndex];
            String string3 = dataFile.dataType;
            Map<String, Object> map = dataFile.infoMap;
            SGDataColumnInfoSet sGDataColumnInfoSet = dataFile.dataColInfoSet;
            boolean bl = SGDataUtility.isArrayData(string3);
            String string4 = this.mSingleDataFileChooserWizardDilaog.getFileName();
            if (!this.showPropertyFileDataDialog(string4, bl, string3, sGDataColumnInfoSet, map)) {
                this.mSingleDataFileChooserWizardDilaog.setVisible(true);
            }
        }
        super.actionPerformed(actionEvent);
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
        int n = mouseWheelEvent.getScrollAmount() * mouseWheelEvent.getWheelRotation();
        JScrollBar jScrollBar = this.mScrollPane.getVerticalScrollBar();
        int n2 = jScrollBar.getValue() + n * 6;
        jScrollBar.setValue(n2);
    }

    public int getColumnIndex(String string) {
        return this.mTable.getColumnModel().getColumnIndex(string);
    }

    @Override
    public void tableChanged(TableModelEvent tableModelEvent) {
        int n = tableModelEvent.getType();
        if (n == 0) {
            int n2;
            if (tableModelEvent.getFirstRow() == -1) {
                return;
            }
            int n3 = tableModelEvent.getFirstRow();
            Object object = this.mTableModel.getValueAt(n3, n2 = this.getFileNameColumnIndex());
            if (object != null && !this.mDataFileArray[n3].hasData) {
                String string = (String)object;
                File file = new File(string);
                this.setSelectedFile(n3, file.getPath());
                this.updateAvailableButtons();
            }
        }
    }

    private void updateAvailableButtons() {
        boolean bl = true;
        int n = this.getFileNameColumnIndex();
        for (int i = 0; i < this.mDataFileArray.length; ++i) {
            if (!this.mDataFileArray[i].hasData) continue;
            String string = (String)this.mTableModel.getValueAt(i, n);
            if (string == null || string.trim().equals(COLUMN_NAME_BUTTON)) {
                bl = false;
                break;
            }
            if (SGApplicationUtility.isNetCDFFile(string)) continue;
            File file = new File(string);
            if (this.isAcceptable(file)) {
                bl = true;
                continue;
            }
            bl = false;
            break;
        }
        this.mOKButton.setEnabled(bl);
    }

    public JTable getTable() {
        return this.mTable;
    }

    public TableModel getTableModel() {
        return this.mTable.getModel();
    }

    public boolean setTableModel(TableModel tableModel) {
        JTable jTable = this.mTable;
        jTable.setModel(tableModel);
        return true;
    }

    public int getFigureIDColumnIndex() {
        return this.getColumnIndex(COLUMN_NAME_FIGURE_ID);
    }

    public int getDataNameColumnIndex() {
        return this.getColumnIndex(COLUMN_NAME_DATA_NAME);
    }

    public int getDataTypeColumnIndex() {
        return this.getColumnIndex(COLUMN_NAME_DATA_TYPE);
    }

    public int getFileNameColumnIndex() {
        return this.getColumnIndex(COLUMN_NAME_FILE_NAME);
    }

    public int getButtonColumnIndex() {
        return this.getColumnIndex(COLUMN_NAME_BUTTON);
    }

    public void setData(List<SGPropertyFileData> list, String string) {
        int n;
        this.mVersionNumber = string;
        int n2 = list.size();
        this.initTable(n2);
        int[] nArray = new int[n2];
        String[] stringArray = new String[n2];
        String[] stringArray2 = new String[n2];
        String[] stringArray3 = new String[n2];
        SGButton[] sGButtonArray = new SGButton[n2];
        Map[] mapArray = new Map[n2];
        for (n = 0; n < n2; ++n) {
            SGPropertyFileData sGPropertyFileData = list.get(n);
            nArray[n] = sGPropertyFileData.getFigureId();
            String string2 = sGPropertyFileData.getDataType();
            if (string2 != null) {
                stringArray[n] = string2;
                stringArray2[n] = sGPropertyFileData.getDataName();
                stringArray3[n] = COLUMN_NAME_BUTTON;
            } else {
                stringArray[n] = COLUMN_NAME_BUTTON;
                stringArray2[n] = COLUMN_NAME_BUTTON;
                stringArray3[n] = NO_DATA;
            }
            sGButtonArray[n] = new SGButton(" ");
            mapArray[n] = new HashMap<String, Object>(sGPropertyFileData.getInfoMap());
        }
        this.mDataFileArray = new DataFile[n2];
        for (n = 0; n < n2; ++n) {
            this.mDataFileArray[n] = new DataFile(nArray[n], stringArray[n], stringArray2[n], mapArray[n]);
            this.mDataFileArray[n].hasData = !NO_DATA.equals(stringArray3[n]);
        }
        n = this.getFigureIDColumnIndex();
        int n3 = this.getDataTypeColumnIndex();
        int n4 = this.getDataNameColumnIndex();
        int n5 = this.getFileNameColumnIndex();
        int n6 = this.getButtonColumnIndex();
        for (int i = 0; i < n2; ++i) {
            this.mTable.setValueAt(Integer.toString(nArray[i]), i, n);
            String string3 = SGDataTypeConstants.getLongDataTypeConstant(stringArray[i]);
            this.mTable.setValueAt(string3, i, n3);
            this.mTable.setValueAt(stringArray2[i], i, n4);
            this.mTable.setValueAt(stringArray3[i], i, n5);
            this.mTable.setValueAt(sGButtonArray[i], i, n6);
            this.mTable.getCellEditor(i, n5).addCellEditorListener(this);
        }
        this.updateAvailableButtons();
    }

    private void setPreferredColumnWidth() {
        JTable jTable = this.mTable;
        int[] nArray = PREFERRED_COLUMN_WIDTH_ARRAY;
        for (int i = 0; i < COLUMN_NAME_ARRAY.length; ++i) {
            TableColumn tableColumn = jTable.getColumn(COLUMN_NAME_ARRAY[i]);
            tableColumn.setPreferredWidth(nArray[i]);
        }
    }

    private void initTable(int n) {
        int n2;
        Object[][] objectArray = new Object[n][];
        int n3 = COLUMN_NAME_ARRAY.length;
        for (n2 = 0; n2 < objectArray.length; ++n2) {
            objectArray[n2] = new Object[n3];
        }
        this.mTableModel.setDataVector(objectArray, COLUMN_NAME_ARRAY);
        n2 = this.getColumnIndex(COLUMN_NAME_BUTTON);
        TableColumn tableColumn = this.mTable.getColumnModel().getColumn(n2);
        ButtonColumn buttonColumn = new ButtonColumn();
        tableColumn.setMinWidth(20);
        tableColumn.setMaxWidth(20);
        tableColumn.setResizable(false);
        tableColumn.setCellEditor(buttonColumn);
        tableColumn.setCellRenderer(buttonColumn);
        int n4 = this.getColumnIndex(COLUMN_NAME_FILE_NAME);
        TableColumn tableColumn2 = this.mTable.getColumnModel().getColumn(n4);
        JTextField jTextField = new JTextField();
        jTextField.setBorder(BorderFactory.createEmptyBorder());
        FileNameColumnCellEditor fileNameColumnCellEditor = new FileNameColumnCellEditor(jTextField);
        tableColumn2.setCellEditor(fileNameColumnCellEditor);
        FileNameColumnCellRenderer fileNameColumnCellRenderer = new FileNameColumnCellRenderer();
        tableColumn2.setCellRenderer(fileNameColumnCellRenderer);
    }

    public TreeMap<Object, Object> getSelectedFilePathListMap() {
        int n = this.getFigureIDColumnIndex();
        int n2 = this.getFileNameColumnIndex();
        TreeMap<Object, Object> treeMap = new TreeMap<Object, Object>();
        int n3 = this.mTable.getRowCount();
        for (int i = 0; i < n3; ++i) {
            Object object = this.mTable.getValueAt(i, n);
            ArrayList arrayList = treeMap.get(object);
            if (arrayList == null) {
                arrayList = new ArrayList();
                treeMap.put(object, arrayList);
            }
            ArrayList arrayList2 = arrayList;
            Object object2 = this.mTable.getValueAt(i, n2);
            arrayList2.add(object2);
        }
        return treeMap;
    }

    public String[] getSelectedFileNames() {
        JTable jTable = this.getTable();
        int n = this.getFileNameColumnIndex();
        int n2 = jTable.getRowCount();
        String[] stringArray = new String[n2];
        for (int i = 0; i < n2; ++i) {
            stringArray[i] = (String)jTable.getValueAt(i, n);
        }
        return stringArray;
    }

    @Override
    protected JButton getPreviousButton() {
        return this.mPreviousButton;
    }

    @Override
    protected JButton getNextButton() {
        return this.mNextButton;
    }

    @Override
    protected JButton getOKButton() {
        return this.mOKButton;
    }

    @Override
    protected JButton getCancelButton() {
        return this.mCancelButton;
    }

    @Override
    public void dragEnter(DropTargetDragEvent dropTargetDragEvent) {
        dropTargetDragEvent.acceptDrag(3);
    }

    @Override
    public void dragExit(DropTargetEvent dropTargetEvent) {
    }

    @Override
    public void dragOver(DropTargetDragEvent dropTargetDragEvent) {
    }

    @Override
    public void drop(DropTargetDropEvent dropTargetDropEvent) {
        JTable jTable = this.mTable;
        JTableHeader jTableHeader = jTable.getTableHeader();
        JViewport jViewport = this.mScrollPane.getViewport();
        Point point = jViewport.getViewPosition();
        Point point2 = dropTargetDropEvent.getLocation();
        Insets insets = this.getInsets();
        int n = insets.left - point.x;
        int n2 = insets.top + this.mScrollPane.getY() - point.y + jTableHeader.getHeight();
        Point point3 = new Point(point2.x - n, point2.y - n2);
        int n3 = this.getFileNameColumnIndex();
        int n4 = jTable.rowAtPoint(point3);
        if (n4 == -1) {
            return;
        }
        if (!this.mDataFileArray[n4].hasData) {
            return;
        }
        List list = SGApplicationUtility.getDroppedFileList(dropTargetDropEvent);
        if (list == null || list.size() == 0) {
            return;
        }
        File file = (File)list.get(0);
        jTable.setValueAt(file.getPath(), n4, n3);
        this.setSelectedFile(n4, file.getPath());
        this.updateAvailableButtons();
    }

    private void setSelectedFile(int n, String string) {
        if (!string.equals(this.mDataFileArray[n].fileName)) {
            this.mDataFileArray[n].fileName = string;
            this.mDataFileArray[n].dataColInfoSet = null;
        }
    }

    protected boolean isAcceptable(File file) {
        return file.exists() && file.isFile();
    }

    @Override
    public void dropActionChanged(DropTargetDragEvent dropTargetDragEvent) {
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        Point point = mouseEvent.getPoint();
        int n = this.getButtonColumnIndex();
        int n2 = this.getFileNameColumnIndex();
        int n3 = this.mTable.columnAtPoint(point);
        int n4 = this.mTable.rowAtPoint(point);
        if (n3 == n) {
            this.mCurDataSetupRowIndex = n4;
            if (!this.mDataFileArray[n4].hasData) {
                return;
            }
            DataFile dataFile = this.mDataFileArray[n4];
            String string = dataFile.fileName;
            String string2 = dataFile.dataType;
            boolean bl = SGDataUtility.isArrayData(string2);
            this.createPropertyFileDataDialog(bl);
            if (this.mSingleDataFileChooserWizardDilaog == null) {
                this.mSingleDataFileChooserWizardDilaog = new PropertySingleDataFileChooserDialog(this.getOwnerWindow(), true);
                this.mSingleDataFileChooserWizardDilaog.setPrevious(null);
                this.mSingleDataFileChooserWizardDilaog.setNext(null);
            }
            if (bl) {
                this.mSingleDataFileChooserWizardDilaog.setVisibleUrlOfNetCDF(false);
            } else {
                this.mSingleDataFileChooserWizardDilaog.setVisibleUrlOfNetCDF(true);
            }
            this.mSingleDataFileChooserWizardDilaog.addActionListener(this);
            if (null == string || string.equals(COLUMN_NAME_BUTTON)) {
                String string3 = this.getCurrentFileDirectory();
                this.mSingleDataFileChooserWizardDilaog.setSelectedFile(string3, string);
            } else {
                File file = new File(string);
                if (file.exists()) {
                    this.mSingleDataFileChooserWizardDilaog.setSelectedFile(file);
                    this.mSingleDataFileChooserWizardDilaog.setFileName(string);
                } else {
                    String string4 = this.getCurrentFileDirectory();
                    this.mSingleDataFileChooserWizardDilaog.setSelectedFile(string4, string);
                    this.mSingleDataFileChooserWizardDilaog.setFileName(string);
                }
            }
            this.mSingleDataFileChooserWizardDilaog.pack();
            this.mSingleDataFileChooserWizardDilaog.setLocation(this.getX() + 20, this.getY() + 20);
            this.mSingleDataFileChooserWizardDilaog.setVisible(true);
        } else if (n3 == n2) {
            this.mFocusedRowIndex = n4;
        }
    }

    String getCurrentFileDirectory() {
        Comparable<File> comparable;
        Preferences preferences = Preferences.userNodeForPackage(this.getClass());
        String string = preferences.get("Current Directory", null);
        boolean bl = false;
        if (string == null) {
            bl = true;
        } else {
            comparable = new File(string);
            if (!((File)comparable).exists()) {
                bl = true;
            }
        }
        if (bl) {
            String string2;
            comparable = new StringBuffer();
            ((StringBuffer)comparable).append(USER_HOME);
            if (SGUtility.identifyOS("windows")) {
                ((StringBuffer)comparable).append(FILE_SEPARATOR);
                ((StringBuffer)comparable).append("My Documents");
            }
            string = string2 = ((StringBuffer)comparable).toString();
        }
        return string;
    }

    private void createPropertyFileDataDialog(boolean bl) {
        this.mPropertyFileDataDialog = bl ? new SGPropertyFileArrayDataDialog((Dialog)this, true) : new SGPropertyFileNetCDFDataDialog((Dialog)this, true);
        this.mPropertyFileDataDialog.addActionListener(this);
    }

    private boolean showPropertyFileDataDialog(String string, boolean bl, String string2, SGDataColumnInfoSet sGDataColumnInfoSet, Map<String, Object> map) {
        if (string != null && !COLUMN_NAME_BUTTON.equals(string)) {
            if (!this.setPropertyFileDataDialog(string, bl, string2, sGDataColumnInfoSet, map)) {
                return false;
            }
        } else {
            this.mPropertyFileDataDialog.clear();
            this.mPropertyFileDataDialog.setDataType(string2, map);
        }
        this.mPropertyFileDataDialog.setPrevious(this.mSingleDataFileChooserWizardDilaog);
        this.mPropertyFileDataDialog.pack();
        this.mPropertyFileDataDialog.setLocation(this.getX() + 20, this.getY() + 20);
        this.mPropertyFileDataDialog.setVisible(true);
        return true;
    }

    private boolean setPropertyFileDataDialog(String string, boolean bl, String string2, SGDataColumnInfoSet sGDataColumnInfoSet, Map<String, Object> map) {
        NetcdfFile netcdfFile = null;
        if (sGDataColumnInfoSet != null) {
            if (bl) {
                SGPropertyFileArrayDataDialog sGPropertyFileArrayDataDialog = (SGPropertyFileArrayDataDialog)this.mPropertyFileDataDialog;
                if (!sGPropertyFileArrayDataDialog.setData(string, string2, sGDataColumnInfoSet, map, false, this.mVersionNumber)) {
                    return false;
                }
            } else {
                SGPropertyFileNetCDFDataDialog sGPropertyFileNetCDFDataDialog = (SGPropertyFileNetCDFDataDialog)this.mPropertyFileDataDialog;
                try {
                    netcdfFile = NetcdfFile.open((String)string);
                }
                catch (Exception exception) {
                    SGUtility.showMessageDialog(this, "Failed to open netCDF file.", "Error", 2);
                    return false;
                }
                if (!sGPropertyFileNetCDFDataDialog.setData(string, new SGNetCDFFile(netcdfFile), string2, sGDataColumnInfoSet, map, false)) {
                    return false;
                }
            }
        } else {
            boolean bl2;
            SGDataCreator.FileColumn[] fileColumnArray;
            block25: {
                fileColumnArray = null;
                bl2 = true;
                if (bl) {
                    try {
                        fileColumnArray = this.mDataCreator.parseFileComlumnType(string, string2, true, this.mVersionNumber);
                        if (fileColumnArray == null) {
                            bl2 = false;
                            SGUtility.showMessageDialog(this, "Data file is invalid.", "Error", 2);
                            return false;
                        }
                        break block25;
                    }
                    catch (FileNotFoundException fileNotFoundException) {
                        bl2 = false;
                        SGUtility.showMessageDialog(this, "Data file is not found.", "Error", 2);
                        return false;
                    }
                }
                try {
                    netcdfFile = NetcdfFile.open((String)string);
                }
                catch (Exception exception) {
                    bl2 = false;
                    SGUtility.showMessageDialog(this, "Failed to open netCDF file.", "Error", 2);
                    return false;
                }
            }
            if (bl2) {
                SGDataColumnInfo[] sGDataColumnInfoArray = null;
                if (bl) {
                    int n = fileColumnArray.length;
                    sGDataColumnInfoArray = new SGDataColumnInfo[n];
                    for (int i = 0; i < n; ++i) {
                        sGDataColumnInfoArray[i] = new SGDataColumnInfo(fileColumnArray[i].title, fileColumnArray[i].valueType);
                    }
                    SGDataColumnInfoSet sGDataColumnInfoSet2 = SGApplicationUtility.getArrayDataColInfoSet(fileColumnArray, string2, map);
                    SGPropertyFileArrayDataDialog sGPropertyFileArrayDataDialog = (SGPropertyFileArrayDataDialog)this.mPropertyFileDataDialog;
                    String string3 = SGApplicationUtility.getArrayDataType(string2);
                    if (!sGPropertyFileArrayDataDialog.setData(string, string3, sGDataColumnInfoSet2, map, true, this.mVersionNumber)) {
                        return false;
                    }
                } else {
                    SGPropertyFileNetCDFDataDialog sGPropertyFileNetCDFDataDialog = (SGPropertyFileNetCDFDataDialog)this.mPropertyFileDataDialog;
                    SGNetCDFFile sGNetCDFFile = new SGNetCDFFile(netcdfFile);
                    List<SGVariable> list = sGNetCDFFile.getVariables();
                    sGDataColumnInfoArray = SGDataUtility.getNetCDFDataColumnInfo(list, map);
                    SGDataColumnInfoSet sGDataColumnInfoSet3 = new SGDataColumnInfoSet(sGDataColumnInfoArray);
                    if (!sGPropertyFileNetCDFDataDialog.setData(string, sGNetCDFFile, string2, sGDataColumnInfoSet3, map, true)) {
                        return false;
                    }
                }
            } else {
                this.mPropertyFileDataDialog.clear();
                this.mPropertyFileDataDialog.setDataType(string2, map);
                if (null != string) {
                    this.mPropertyFileDataDialog.setFileName(string);
                }
            }
        }
        if (netcdfFile != null) {
            try {
                netcdfFile.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return true;
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public String getSelectedFilepath() {
        if (this.mPropertyFileDataDialog != null) {
            return this.mPropertyFileDataDialog.getFileName();
        }
        return null;
    }

    public File setSelectedFile(String string, String string2) {
        if (this.mPropertyFileDataDialog != null) {
            return this.mPropertyFileDataDialog.setSelectedFile(string, string2);
        }
        return null;
    }

    long lastUsed() {
        if (this.mPropertyFileDataDialog != null) {
            return this.mPropertyFileDataDialog.lastUsed();
        }
        return 0L;
    }

    @Override
    public void editingStopped(ChangeEvent changeEvent) {
        Object object = changeEvent.getSource();
        if (object instanceof DefaultCellEditor) {
            if (this.mFocusedRowIndex == -1) {
                return;
            }
            DefaultCellEditor defaultCellEditor = (DefaultCellEditor)object;
            String string = (String)defaultCellEditor.getCellEditorValue();
            if (!SGNetCDFDataFileChooserPanel.isNetcdfUrl(string)) {
                File file = new File(string);
                this.setSelectedFile(this.mFocusedRowIndex, file.getPath());
            } else {
                this.setSelectedFile(this.mFocusedRowIndex, string);
            }
            this.updateAvailableButtons();
        }
    }

    @Override
    public void editingCanceled(ChangeEvent changeEvent) {
        Object object = changeEvent.getSource();
        if (object instanceof DefaultCellEditor) {
            this.mFocusedRowIndex = -1;
        }
    }

    private JTable createTableInstance() {
        return new JTable(){
            private static final long serialVersionUID = 8123021601129253077L;

            public String getToolTipText(MouseEvent mouseEvent) {
                int n = this.rowAtPoint(mouseEvent.getPoint());
                int n2 = this.columnAtPoint(mouseEvent.getPoint());
                if (n2 == 4) {
                    return null;
                }
                Object object = this.getModel().getValueAt(n, n2);
                if (object != null && !SGPropertyDataFileChooserWizardDialog.COLUMN_NAME_BUTTON.equals(object.toString())) {
                    return object.toString();
                }
                return null;
            }
        };
    }

    private class PropertySingleDataFileChooserDialog
    extends SGSingleDataFileChooserWizardDialog {
        private static final long serialVersionUID = -224248041535744923L;

        PropertySingleDataFileChooserDialog(Frame frame, boolean bl) {
            super(frame, bl);
            this.initProperty();
        }

        void initProperty() {
            this.getOKButton().setVisible(true);
        }

        public void checkNetCDFURLTextField() {
            this.onOK();
        }

        protected void acceptFile(boolean bl) {
            this.getOKButton().setEnabled(bl);
        }

        public void acceptNetCDFUrl(boolean bl) {
            this.acceptFile(bl);
        }
    }

    private class FileNameColumnCellRenderer
    extends DefaultTableCellRenderer {
        private static final long serialVersionUID = -1161211373077578663L;

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            Color color;
            Object object2;
            if (object != null) {
                object2 = SGUtility.getFileName(object.toString());
                this.setValue(object2);
            }
            if (bl) {
                object2 = jTable.getSelectionBackground();
                color = jTable.getSelectionForeground();
            } else {
                object2 = jTable.getBackground();
                color = jTable.getForeground();
            }
            this.setBackground((Color)object2);
            this.setForeground(color);
            return this;
        }
    }

    private class FileNameColumnCellEditor
    extends DefaultCellEditor {
        private static final long serialVersionUID = -7226073642075293006L;

        public FileNameColumnCellEditor(JTextField jTextField) {
            super(jTextField);
        }

        public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
            final JTextField jTextField = (JTextField)super.getTableCellEditorComponent(jTable, object, bl, n, n2);
            if (object != null) {
                String string = object.toString();
                final int n3 = string.length();
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        jTextField.setCaretPosition(n3);
                    }
                });
            }
            return jTextField;
        }
    }

    private class ButtonColumn
    extends AbstractCellEditor
    implements TableCellRenderer,
    TableCellEditor {
        private static final long serialVersionUID = 4671694450428631643L;
        private static final String BUTTON_TEXT = " ";
        private final JButton renderButton = new SGButton(" ");
        private final JButton editorButton = new SGButton(" ");

        public ButtonColumn() {
            this.editorButton.setFocusPainted(false);
            this.editorButton.setRolloverEnabled(false);
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            this.renderButton.setEnabled(((SGPropertyDataFileChooserWizardDialog)SGPropertyDataFileChooserWizardDialog.this).mDataFileArray[n].hasData);
            return this.renderButton;
        }

        public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
            return this.editorButton;
        }

        public Object getCellEditorValue() {
            return BUTTON_TEXT;
        }
    }

    private class OriginalTableModel
    extends DefaultTableModel {
        private static final long serialVersionUID = -7588229760968586164L;

        public boolean isCellEditable(int n, int n2) {
            JTable jTable = SGPropertyDataFileChooserWizardDialog.this.mTable;
            String string = jTable.getColumnName(n2);
            boolean bl = true;
            if (string.equals(SGPropertyDataFileChooserWizardDialog.COLUMN_NAME_FILE_NAME)) {
                if (!((SGPropertyDataFileChooserWizardDialog)SGPropertyDataFileChooserWizardDialog.this).mDataFileArray[n].hasData) {
                    bl = false;
                }
            } else {
                bl = false;
            }
            return bl;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class DataFile {
        int figureId = -1;
        String dataType = null;
        String dataName = null;
        String fileName = null;
        Map<String, Object> infoMap = new HashMap<String, Object>();
        SGDataColumnInfoSet dataColInfoSet = null;
        boolean hasData = true;

        DataFile(int n, String string, String string2, Map<String, Object> map) {
            this.figureId = n;
            this.dataType = string;
            this.dataName = string2;
            this.infoMap = map;
        }
    }
}

