/*
 * Decompiled with CFR 0.152.
 */
package jp.riken.brain.ni.samuraigraph.application;

import java.awt.Dialog;
import java.awt.Frame;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.ActionEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.JTextComponent;
import jp.riken.brain.ni.samuraigraph.application.SGApplicationUtility;
import jp.riken.brain.ni.samuraigraph.application.SGFileChooserWizardDialog;

public abstract class SGSingleFileChooserWizardDialog
extends SGFileChooserWizardDialog
implements DropTargetListener,
DocumentListener {
    public SGSingleFileChooserWizardDialog() {
        this.initProperty();
    }

    public SGSingleFileChooserWizardDialog(Frame frame, boolean bl) {
        super(frame, bl);
        this.initProperty();
    }

    public SGSingleFileChooserWizardDialog(Dialog dialog, boolean bl) {
        super(dialog, bl);
        this.initProperty();
    }

    private void initProperty() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                String string;
                DropTarget dropTarget = new DropTarget(SGSingleFileChooserWizardDialog.this.getFileNameTextComponent(), 3, SGSingleFileChooserWizardDialog.this, true);
                SGSingleFileChooserWizardDialog.this.setDropTarget(dropTarget);
                SGSingleFileChooserWizardDialog.this.acceptFile(false);
                if (null != SGSingleFileChooserWizardDialog.this.getFileNameTextComponent()) {
                    SGSingleFileChooserWizardDialog.this.getFileNameTextComponent().getDocument().addDocumentListener(SGSingleFileChooserWizardDialog.this);
                }
                if (null != SGSingleFileChooserWizardDialog.this.getFileChooserButton()) {
                    SGSingleFileChooserWizardDialog.this.getFileChooserButton().addActionListener(SGSingleFileChooserWizardDialog.this);
                }
                if (SGSingleFileChooserWizardDialog.this.isAcceptable(string = SGSingleFileChooserWizardDialog.this.getFileName())) {
                    SGSingleFileChooserWizardDialog.this.acceptFile(true);
                }
            }
        });
    }

    protected abstract JTextComponent getFileNameTextComponent();

    protected abstract JButton getFileChooserButton();

    public void dragEnter(DropTargetDragEvent dropTargetDragEvent) {
        dropTargetDragEvent.acceptDrag(3);
    }

    public void dragExit(DropTargetEvent dropTargetEvent) {
    }

    public void dragOver(DropTargetDragEvent dropTargetDragEvent) {
    }

    public void drop(DropTargetDropEvent dropTargetDropEvent) {
        List list = SGApplicationUtility.getDroppedFileList(dropTargetDropEvent);
        if (list == null || list.size() == 0) {
            return;
        }
        File file = (File)list.get(0);
        this.setFileName(file);
    }

    public void dropActionChanged(DropTargetDragEvent dropTargetDragEvent) {
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object.equals(this.getFileChooserButton())) {
            ArrayList arrayList = this.openFileChooser();
            if (arrayList == null) {
                return;
            }
            if (arrayList.size() != 1) {
                return;
            }
            File file = (File)arrayList.get(0);
            this.setFileName(file);
            if (this.isAcceptable(file)) {
                this.acceptFile(true);
            }
        }
        super.actionPerformed(actionEvent);
    }

    protected void setFileName(File file) {
        this.setFileName(file.getPath());
    }

    protected void setFileName(String string) {
        this.getFileNameTextComponent().setText(string);
    }

    protected String getFileName() {
        return this.getFileNameTextComponent().getText();
    }

    public File setSelectedFile(String string) {
        File file = super.setSelectedFile(string);
        if (file.isFile()) {
            this.setFileName(file);
        }
        return file;
    }

    protected void acceptFile(boolean bl) {
        this.getNextButton().setEnabled(bl);
    }

    public void changedUpdate(DocumentEvent documentEvent) {
    }

    public void insertUpdate(DocumentEvent documentEvent) {
        this.onEdited(documentEvent);
    }

    public void removeUpdate(DocumentEvent documentEvent) {
        this.onEdited(documentEvent);
    }

    protected void onEdited(DocumentEvent documentEvent) {
        String string = this.getFileName();
        boolean bl = this.isAcceptable(string);
        this.acceptFile(bl);
    }
}

