/*
 * Decompiled with CFR 0.152.
 */
package jp.riken.brain.ni.samuraigraph.application;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import jp.riken.brain.ni.samuraigraph.base.SGButton;
import jp.riken.brain.ni.samuraigraph.base.SGComboBox;
import jp.riken.brain.ni.samuraigraph.base.SGDialog;

public class SGUpgradeDialog
extends SGDialog {
    private static final long serialVersionUID = -8581885673785013955L;
    public static final String TITLE = "Auto Upgrade Settings";
    private JPanel mButtonPanel;
    private SGButton mCancelButton;
    private SGButton mOKButton;
    private JPanel mPanel;
    private SGButton mUpgradeButton;
    private SGComboBox mUpgradeCycleComboBox;
    private JLabel mUpgradeCycleLabel;
    public static final String NO_UPGRADE = "No Upgrade";
    public static final String EVERY_TIME = "Every Time";
    public static final String EVERY_DAY = "Every Day";
    public static final String EVERY_WEEK = "Every Week";
    public static final String EVERY_MONTH = "Every Month";
    public static final String UPGRADE_NOW = "Check for Update Now";
    private String mUpgrade = null;

    public SGUpgradeDialog() {
        this.initComponents();
        this.initProperty();
    }

    public SGUpgradeDialog(Frame frame, boolean bl) {
        super(frame, bl);
        this.initComponents();
        this.initProperty();
    }

    private void initComponents() {
        this.mPanel = new JPanel();
        this.mUpgradeCycleComboBox = new SGComboBox();
        this.mUpgradeButton = new SGButton();
        this.mUpgradeCycleLabel = new JLabel();
        this.mButtonPanel = new JPanel();
        this.mOKButton = new SGButton();
        this.mCancelButton = new SGButton();
        this.getContentPane().setLayout(new GridBagLayout());
        this.mPanel.setBorder(BorderFactory.createTitledBorder(null, "Configure Auto Upgrade", 0, 0, new Font("Dialog", 1, 12)));
        this.mPanel.setLayout(new GridBagLayout());
        this.mUpgradeCycleComboBox.setFont(new Font("Dialog", 0, 12));
        this.mUpgradeCycleComboBox.setPreferredSize(new Dimension(111, 25));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(10, 5, 0, 10);
        this.mPanel.add((Component)this.mUpgradeCycleComboBox, gridBagConstraints);
        this.mUpgradeButton.setText(UPGRADE_NOW);
        this.mUpgradeButton.setFont(new Font("Dialog", 1, 12));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.ipadx = 1;
        gridBagConstraints.insets = new Insets(13, 10, 10, 10);
        this.mPanel.add((Component)this.mUpgradeButton, gridBagConstraints);
        this.mUpgradeCycleLabel.setFont(new Font("Dialog", 0, 12));
        this.mUpgradeCycleLabel.setText("Update Check Cycle");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(10, 10, 0, 5);
        this.mPanel.add((Component)this.mUpgradeCycleLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(10, 10, 0, 10);
        this.getContentPane().add((Component)this.mPanel, gridBagConstraints);
        this.mButtonPanel.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.mOKButton.setText("OK");
        this.mOKButton.setFont(new Font("Dialog", 1, 12));
        this.mButtonPanel.add(this.mOKButton);
        this.mCancelButton.setText("Cancel");
        this.mCancelButton.setFont(new Font("Dialog", 1, 12));
        this.mButtonPanel.add(this.mCancelButton);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.getContentPane().add((Component)this.mButtonPanel, gridBagConstraints);
        this.pack();
    }

    private boolean initProperty() {
        this.setTitle(TITLE);
        String[] stringArray = new String[]{NO_UPGRADE, EVERY_TIME, EVERY_DAY, EVERY_WEEK, EVERY_MONTH};
        for (int i = 0; i < stringArray.length; ++i) {
            this.mUpgradeCycleComboBox.addItem(stringArray[i]);
        }
        this.pack();
        this.mOKButton.addActionListener(this);
        this.mCancelButton.addActionListener(this);
        this.mUpgradeButton.addActionListener(this);
        this.mUpgradeCycleComboBox.addActionListener(this);
        return true;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals("OK")) {
            this.onOK();
        } else if (string.equals("Cancel")) {
            this.onCanceled();
        } else if (string.equals(UPGRADE_NOW)) {
            this.notifyToListener(string);
        }
    }

    public String getUpgradeCycle() {
        return this.mUpgrade;
    }

    public void setUpgradeCycle(String string) {
        this.mUpgrade = string;
    }

    public void setVisible(boolean bl) {
        this.mUpgradeCycleComboBox.setSelectedItem(this.mUpgrade);
        super.setVisible(bl);
    }

    protected boolean onOK() {
        this.mUpgrade = (String)this.mUpgradeCycleComboBox.getSelectedItem();
        this.setVisible(false);
        this.notifyToListener("OK");
        return true;
    }

    protected boolean onCanceled() {
        this.setVisible(false);
        this.notifyToListener("Cancel");
        return true;
    }

    protected void onEscKeyTyped() {
        this.onCanceled();
    }
}

