/*
 * Decompiled with CFR 0.152.
 */
package jp.riken.brain.ni.samuraigraph.application;

import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Point;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.prefs.Preferences;
import javax.swing.JFileChooser;
import javax.swing.SwingUtilities;
import jp.riken.brain.ni.samuraigraph.application.SGApplicationUtility;
import jp.riken.brain.ni.samuraigraph.application.SGIApplicationConstants;
import jp.riken.brain.ni.samuraigraph.application.SGIApplicationTextConstants;
import jp.riken.brain.ni.samuraigraph.application.SGIImageConstants;
import jp.riken.brain.ni.samuraigraph.application.SGIPreferencesConstants;
import jp.riken.brain.ni.samuraigraph.application.SGImageExportManager;
import jp.riken.brain.ni.samuraigraph.application.SGMainFunctions;
import jp.riken.brain.ni.samuraigraph.application.SGSplashWindow;
import jp.riken.brain.ni.samuraigraph.base.SGCSVTokenizer;
import jp.riken.brain.ni.samuraigraph.base.SGDrawingWindow;
import jp.riken.brain.ni.samuraigraph.base.SGExtensionFileFilter;
import jp.riken.brain.ni.samuraigraph.base.SGFigure;
import jp.riken.brain.ni.samuraigraph.base.SGFileChooser;
import jp.riken.brain.ni.samuraigraph.base.SGIRootObjectConstants;
import jp.riken.brain.ni.samuraigraph.base.SGPluginsQueryMessage;
import jp.riken.brain.ni.samuraigraph.base.SGUtility;
import jp.riken.brain.ni.samuraigraph.base.SGUtilityText;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class SGWindowManager
implements ActionListener,
DropTargetListener,
PropertyChangeListener,
WindowListener,
SGIRootObjectConstants,
SGIPreferencesConstants,
SGIApplicationTextConstants,
SGIApplicationConstants,
SGIImageConstants {
    private SGImageExportManager mImageFileCreator = null;
    private TreeMap<Integer, SGDrawingWindow> mWndMap = null;
    private SGDrawingWindow mCurrentWindow = null;
    private SGMainFunctions mMain = null;
    public static final String WINDOW_TITLE_PREFIX = "Samurai Graph - Window : ";
    private Map<Integer, SGFigure> mCurrentFigureMap = new HashMap<Integer, SGFigure>();

    SGWindowManager(SGMainFunctions sGMainFunctions, SGSplashWindow sGSplashWindow, float f, float f2) {
        this.mMain = sGMainFunctions;
        float f3 = (f2 - f) / 3.0f;
        sGSplashWindow.setProgressValue(f + f3);
        this.mWndMap = new TreeMap();
        sGSplashWindow.setProgressValue(f + f3 * 2.0f);
        this.mImageFileCreator = new SGImageExportManager();
    }

    private SGDrawingWindow createWindow(int n) {
        String[] stringArray;
        SGDrawingWindow sGDrawingWindow = new SGDrawingWindow();
        sGDrawingWindow.setID(n);
        this.mWndMap.put(n, sGDrawingWindow);
        sGDrawingWindow.setDefaultCloseOperation(0);
        String string = WINDOW_TITLE_PREFIX + sGDrawingWindow.getID();
        sGDrawingWindow.setTitle(string);
        sGDrawingWindow.addActionListener(this);
        sGDrawingWindow.addWindowListener(this);
        sGDrawingWindow.addPropertyChangeListener(this);
        DropTarget dropTarget = new DropTarget(sGDrawingWindow, 3, this, true);
        sGDrawingWindow.setDropTarget(dropTarget);
        sGDrawingWindow.setImageFileCreator(this.mImageFileCreator);
        Preferences preferences = Preferences.userNodeForPackage(this.getClass());
        String string2 = preferences.get("Tool Bar Pattern", null);
        if (string2 != null) {
            ArrayList<SGCSVTokenizer.Token> arrayList = new ArrayList<SGCSVTokenizer.Token>();
            if (SGUtilityText.tokenize(string2, arrayList, false)) {
                int n2;
                ArrayList<String> arrayList2 = new ArrayList<String>();
                for (n2 = 0; n2 < arrayList.size(); ++n2) {
                    SGCSVTokenizer.Token token = arrayList.get(n2);
                    if (token == null) continue;
                    arrayList2.add(token.getString());
                }
                stringArray = new String[arrayList2.size()];
                for (n2 = 0; n2 < arrayList2.size(); ++n2) {
                    stringArray[n2] = (String)arrayList2.get(n2);
                }
            } else {
                stringArray = SGIRootObjectConstants.TOOLBAR_MENUCMD_ARRAY;
            }
        } else {
            stringArray = new String[]{"File", "Insert", "Zoom"};
            this.mMain.updateToolBarPatternInPreferences(stringArray);
        }
        sGDrawingWindow.setToolBarPattern(stringArray);
        sGDrawingWindow.setLocation(100, 100);
        if (!sGDrawingWindow.init()) {
            return null;
        }
        this.setPasteMenuEnabled();
        return sGDrawingWindow;
    }

    public SGDrawingWindow getWindow(int n) {
        return this.mWndMap.get(n);
    }

    public SGDrawingWindow getCurrentWindow() {
        return this.mCurrentWindow;
    }

    public SGFigure getCurrentFigure() {
        if (this.mCurrentWindow == null) {
            return null;
        }
        return this.mCurrentFigureMap.get(this.mCurrentWindow.getID());
    }

    public boolean setCurrentFigure(int n, SGFigure sGFigure) {
        this.mCurrentFigureMap.put(n, sGFigure);
        return true;
    }

    private int assignWindowID() {
        ArrayList<Integer> arrayList = new ArrayList<Integer>(this.mWndMap.keySet());
        int n = SGUtility.assignIdNumber(arrayList);
        return n;
    }

    public int getWindowNumber() {
        return this.mWndMap.size();
    }

    public SGDrawingWindow createNewWindow() {
        int n = this.assignWindowID();
        SGDrawingWindow sGDrawingWindow = this.createWindow(n);
        if (sGDrawingWindow == null) {
            return null;
        }
        sGDrawingWindow.initPropertiesHistory();
        return sGDrawingWindow;
    }

    public SGDrawingWindow createNewWindow(int n) {
        if (this.getWindow(n) != null) {
            return null;
        }
        SGDrawingWindow sGDrawingWindow = this.createWindow(n);
        if (sGDrawingWindow == null) {
            return null;
        }
        sGDrawingWindow.initPropertiesHistory();
        return sGDrawingWindow;
    }

    public boolean closeWindowWithoutConfirmation(int n) {
        SGDrawingWindow sGDrawingWindow = this.getWindow(n);
        if (sGDrawingWindow == null) {
            return false;
        }
        return this.removeWindow(sGDrawingWindow);
    }

    public boolean closeWindow(int n) {
        SGDrawingWindow sGDrawingWindow = this.getWindow(n);
        if (sGDrawingWindow == null) {
            return false;
        }
        this.closeWindow(sGDrawingWindow);
        return true;
    }

    public int closeWindow(SGDrawingWindow sGDrawingWindow) {
        if (sGDrawingWindow.needsConfirmationBeforeDiscard()) {
            int n = this.mMain.confirmBeforeClosing(sGDrawingWindow);
            if (n == 0) {
                this.removeWindow(sGDrawingWindow);
            } else {
                if (n == 1 || n == -1) {
                    return 1;
                }
                if (n == 2) {
                    int n2 = this.mMain.mPropertyFileManager.savePropertiesByDialog(sGDrawingWindow);
                    if (n2 == 0) {
                        this.removeWindow(sGDrawingWindow);
                    }
                    return n2;
                }
            }
        } else {
            this.removeWindow(sGDrawingWindow);
        }
        return 0;
    }

    void closeAllWindow() {
        SGDrawingWindow sGDrawingWindow;
        int n;
        ArrayList<SGDrawingWindow> arrayList = new ArrayList<SGDrawingWindow>(this.mWndMap.values());
        for (int i = arrayList.size() - 1; i >= 0 && (n = this.closeWindow(sGDrawingWindow = (SGDrawingWindow)arrayList.get(i))) != 1; --i) {
        }
    }

    void closeAllWindowWithoutConfirmation() {
        List<SGDrawingWindow> list = this.getWindowList();
        for (int i = list.size() - 1; i >= 0; --i) {
            SGDrawingWindow sGDrawingWindow = list.get(i);
            this.removeWindow(sGDrawingWindow);
        }
    }

    public boolean setCurrentWindow(int n) {
        SGDrawingWindow sGDrawingWindow = this.getWindow(n);
        if (sGDrawingWindow == null) {
            return false;
        }
        this.mCurrentWindow = sGDrawingWindow;
        return true;
    }

    public void setCurrentWindow(SGDrawingWindow sGDrawingWindow) {
        this.mCurrentWindow = sGDrawingWindow;
    }

    void setPasteMenuEnabled() {
        boolean bl = this.mMain.mClipBoardManager.getPasteMenuStatus();
        ArrayList<SGDrawingWindow> arrayList = new ArrayList<SGDrawingWindow>(this.mWndMap.values());
        for (int i = 0; i < arrayList.size(); ++i) {
            SGDrawingWindow sGDrawingWindow = (SGDrawingWindow)arrayList.get(i);
            sGDrawingWindow.setPasteMenuEnabled(bl);
        }
    }

    private boolean removeWindow(final SGDrawingWindow sGDrawingWindow) {
        sGDrawingWindow.removeWindowListener(this);
        sGDrawingWindow.removeActionListener(this);
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                int n = sGDrawingWindow.getID();
                SGWindowManager.this.mWndMap.remove(n);
                sGDrawingWindow.setVisible(false);
                sGDrawingWindow.dispose();
                if (sGDrawingWindow.equals(SGWindowManager.this.mCurrentWindow)) {
                    SGWindowManager.this.mCurrentWindow = null;
                }
                SGWindowManager.this.mCurrentFigureMap.remove(n);
                System.gc();
                if (SGWindowManager.this.mWndMap.size() == 0) {
                    SGWindowManager.this.mMain.exitApplication(0);
                }
            }
        });
        return true;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        String string = actionEvent.getActionCommand();
        if (object instanceof SGDrawingWindow) {
            SGDrawingWindow sGDrawingWindow = (SGDrawingWindow)object;
            if (string.equals("Create New Window")) {
                SGDrawingWindow sGDrawingWindow2 = this.createNewWindow();
                if (sGDrawingWindow2 == null) {
                    return;
                }
                sGDrawingWindow2.setVisible(true);
            } else if (string.equals("Close Window")) {
                this.closeWindow(sGDrawingWindow);
            } else if (string.equals("Exit")) {
                this.closeAllWindow();
            } else if (string.equals("Draw Graph")) {
                this.mMain.drawGraphFromDialog(sGDrawingWindow);
            } else if (string.equals("Save Property")) {
                int n = this.mMain.mPropertyFileManager.savePropertiesByDialog(sGDrawingWindow);
                sGDrawingWindow.setSaved(n == 0);
            } else if (string.equals("Load Property")) {
                int n;
                if (sGDrawingWindow.needsConfirmationBeforeDiscard() && (n = this.mMain.beforeDiscard(sGDrawingWindow)) == 1) {
                    return;
                }
                this.mMain.mPropertyFileManager.loadPropertyFromDialog(sGDrawingWindow);
            } else if (string.equals("Save Data Set")) {
                int n = this.mMain.mDataSetManager.saveDataSet(sGDrawingWindow);
                sGDrawingWindow.setSaved(n == 0);
            } else if (string.equals("Load Data Set")) {
                boolean bl;
                if (sGDrawingWindow.needsConfirmationBeforeDiscard() && (bl = this.mMain.beforeDiscard(sGDrawingWindow))) {
                    return;
                }
                bl = this.mMain.mDataSetManager.loadDataSetFromDialog(sGDrawingWindow);
                if (!bl) {
                    SGUtility.showErrorMessageDialog(sGDrawingWindow, "Failed to open the selected data set file.", "Error");
                }
                sGDrawingWindow.setSaved(bl);
            } else if (string.equals("Load Background Image")) {
                SGFileChooser sGFileChooser = new SGFileChooser();
                SGExtensionFileFilter sGExtensionFileFilter = new SGExtensionFileFilter();
                sGExtensionFileFilter.setDescription("Image File");
                String[] stringArray = DRAWABLE_IMAGE_EXTENSIONS;
                for (int i = 0; i < stringArray.length; ++i) {
                    sGExtensionFileFilter.addExtension(stringArray[i]);
                }
                sGFileChooser.setFileFilter(sGExtensionFileFilter);
                String string2 = this.mMain.getCurrentFileDirectory();
                String string3 = null;
                string3 = this.mMain.mCurrentImageFileName != null ? SGApplicationUtility.getPathName(string2, this.mMain.mCurrentImageFileName) : string2;
                ((JFileChooser)sGFileChooser).setSelectedFile(new File(string3));
                int n = sGFileChooser.showOpenDialog(sGDrawingWindow);
                File file = null;
                if (n == 0) {
                    file = sGFileChooser.getSelectedFile();
                }
                if (file != null) {
                    this.mMain.updateCurrentFile(file, 3);
                    byte[] byArray = SGApplicationUtility.toByteArray(file);
                    String string4 = SGApplicationUtility.getExtension(file);
                    if (string4 == null) {
                        return;
                    }
                    if (!sGDrawingWindow.setImage(byArray, string4, true)) {
                        SGUtility.showErrorMessageDialog(sGDrawingWindow, "Cannot open the selected file.", "File open failure");
                        return;
                    }
                }
            } else if (string.equals("Cut")) {
                this.mMain.mClipBoardManager.cutAndCopy(sGDrawingWindow, false);
            } else if (string.equals("Copy")) {
                this.mMain.mClipBoardManager.cutAndCopy(sGDrawingWindow, true);
            } else if (string.equals("Paste")) {
                this.mMain.mClipBoardManager.pasteToWindow(sGDrawingWindow);
            } else if (string.equals("Duplicate")) {
                this.mMain.duplicateFocusedFigures(sGDrawingWindow);
                this.mMain.duplicateFocusedData(sGDrawingWindow);
            } else if (string.equals("Export as Image")) {
                this.mImageFileCreator.setBaseDirectory(this.mMain.getCurrentFileDirectory());
                sGDrawingWindow.exportAsImage(false);
                this.mMain.setCurrentFileDirectory(this.mImageFileCreator.getBaseDirectory());
            } else if (string.equals("Print")) {
                sGDrawingWindow.printImage(false);
            } else if (string.equals("Upgrade")) {
                this.mMain.mUpgradeManager.showUpgradeDialog(sGDrawingWindow);
            } else if (string.equals("Change Log")) {
                this.mMain.showChangeLogDialog(sGDrawingWindow);
            } else if (string.equals("Proxy")) {
                this.mMain.mProxyManager.showProxySettingDialog(sGDrawingWindow);
            } else if (string.equals("Memory Info")) {
                this.mMain.showMemoryInfo(sGDrawingWindow);
            } else if (string.equals("About")) {
                this.mMain.showAboutDialog(sGDrawingWindow);
            } else if (string.equals("Split")) {
                this.mMain.splitSXYData(sGDrawingWindow);
            } else if (string.equals("Transform")) {
                this.mMain.transformData(sGDrawingWindow);
            } else if (string.equals("Merge")) {
                this.mMain.mergeSXYData(sGDrawingWindow);
            }
        } else if (object instanceof SGPluginsQueryMessage) {
            this.mMain.updatePluginsMessage((SGPluginsQueryMessage)object);
        }
    }

    @Override
    public void dragEnter(DropTargetDragEvent dropTargetDragEvent) {
        dropTargetDragEvent.acceptDrag(3);
    }

    @Override
    public void dragOver(DropTargetDragEvent dropTargetDragEvent) {
    }

    @Override
    public void dropActionChanged(DropTargetDragEvent dropTargetDragEvent) {
    }

    @Override
    public void dragExit(DropTargetEvent dropTargetEvent) {
    }

    @Override
    public void drop(DropTargetDropEvent dropTargetDropEvent) {
        List list = SGApplicationUtility.getDroppedFileList(dropTargetDropEvent);
        if (list != null && list.size() != 0) {
            new DropEventHandler(this.mMain, dropTargetDropEvent, list);
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        Object object = propertyChangeEvent.getSource();
        String string = propertyChangeEvent.getPropertyName();
        if (object instanceof SGDrawingWindow && "Tool Bar".equals(string)) {
            SGDrawingWindow sGDrawingWindow = (SGDrawingWindow)object;
            this.mMain.updateToolBarPatternInPreferences(sGDrawingWindow.getToolBarPattern());
        }
    }

    @Override
    public void windowOpened(WindowEvent windowEvent) {
    }

    @Override
    public void windowClosing(WindowEvent windowEvent) {
        SGDrawingWindow sGDrawingWindow = (SGDrawingWindow)windowEvent.getSource();
        this.closeWindow(sGDrawingWindow);
    }

    @Override
    public void windowClosed(WindowEvent windowEvent) {
    }

    @Override
    public void windowIconified(WindowEvent windowEvent) {
    }

    @Override
    public void windowDeiconified(WindowEvent windowEvent) {
    }

    @Override
    public void windowActivated(WindowEvent windowEvent) {
        windowEvent.getWindow().repaint();
    }

    @Override
    public void windowDeactivated(WindowEvent windowEvent) {
        windowEvent.getWindow().repaint();
    }

    public List<SGDrawingWindow> getWindowList() {
        ArrayList<SGDrawingWindow> arrayList = new ArrayList<SGDrawingWindow>(this.mWndMap.values());
        return arrayList;
    }

    static class DropEventHandler
    extends Thread {
        private List mDroppedFileList = null;
        private Point mDroppedPoint = null;
        private SGDrawingWindow mDroppedWindow = null;
        private SGMainFunctions mMain = null;

        DropEventHandler(SGMainFunctions sGMainFunctions, DropTargetDropEvent dropTargetDropEvent, List list) {
            this.mMain = sGMainFunctions;
            this.mDroppedFileList = list;
            DropTarget dropTarget = (DropTarget)dropTargetDropEvent.getSource();
            Component component = dropTarget.getComponent();
            SGDrawingWindow sGDrawingWindow = (SGDrawingWindow)component;
            this.mDroppedPoint = dropTargetDropEvent.getLocation();
            this.mDroppedWindow = sGDrawingWindow;
            this.start();
        }

        public void run() {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    DropEventHandler.this.mMain.fromDragAndDrop(((DropEventHandler)DropEventHandler.this).mDroppedPoint.x, ((DropEventHandler)DropEventHandler.this).mDroppedPoint.y, DropEventHandler.this.mDroppedWindow, DropEventHandler.this.mDroppedFileList);
                    DropEventHandler.this.mDroppedWindow.getContentPane().repaint();
                    DropEventHandler.this.mDroppedFileList = null;
                    DropEventHandler.this.mDroppedPoint = null;
                    DropEventHandler.this.mDroppedWindow = null;
                }
            });
        }
    }
}

