/*
 * Decompiled with CFR 0.152.
 */
package jp.riken.brain.ni.samuraigraph.base;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.SwingUtilities;
import jp.riken.brain.ni.samuraigraph.base.SGIAnimation;
import jp.riken.brain.ni.samuraigraph.base.SGIDisposable;

public class SGAnimationThread
extends Thread
implements SGIDisposable {
    protected SGIAnimation mAnimation = null;
    protected boolean mPlayFlag = false;
    protected boolean mLoopPlaybackFlag = false;
    protected int mStep = 1;
    protected int mTimeInterval = 1000;
    private static final long MIN_SLEEP_TIME = 10L;
    private boolean mDisposed = false;
    private List<AnimationThreadObserver> mObserverList = new ArrayList<AnimationThreadObserver>();

    public SGAnimationThread(SGIAnimation sGIAnimation) {
        if (sGIAnimation == null) {
            throw new IllegalArgumentException("animation == null");
        }
        this.mAnimation = sGIAnimation;
    }

    public SGAnimationThread(SGAnimationThread sGAnimationThread) {
        this.mAnimation = sGAnimationThread.mAnimation;
        this.mTimeInterval = sGAnimationThread.mTimeInterval;
        this.mStep = sGAnimationThread.mStep;
        this.mLoopPlaybackFlag = sGAnimationThread.mLoopPlaybackFlag;
        this.mPlayFlag = sGAnimationThread.mPlayFlag;
        this.mObserverList = new ArrayList<AnimationThreadObserver>(sGAnimationThread.mObserverList);
    }

    public SGIAnimation getAnimation() {
        return this.mAnimation;
    }

    public void run() {
        int n = this.mAnimation.getFrameNumber();
        PlayInfo playInfo = this.getPlayInfo();
        while (this.mPlayFlag) {
            int n2;
            int n3 = this.mAnimation.getCurrentFrameIndex();
            int n4 = n3 + this.mStep;
            boolean bl = false;
            if (this.mStep > 0) {
                if (n4 >= n) {
                    bl = true;
                }
            } else if (n4 < 0) {
                bl = true;
            }
            if (bl) {
                if (this.mLoopPlaybackFlag) {
                    if (this.mStep > 0) {
                        n4 %= n;
                    } else {
                        n2 = Math.abs(n4) / n + 1;
                        n4 += n2 * n;
                    }
                } else {
                    this.mPlayFlag = false;
                    continue;
                }
            }
            n2 = n4;
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    public void run() {
                        SGAnimationThread.this.mAnimation.setCurrentFrameIndex(n2);
                    }
                });
            }
            catch (InterruptedException interruptedException) {
            }
            catch (InvocationTargetException invocationTargetException) {
                // empty catch block
            }
            for (AnimationThreadObserver animationThreadObserver : this.mObserverList) {
                animationThreadObserver.updated(this);
            }
            try {
                long l = System.currentTimeMillis();
                boolean bl2 = false;
                for (int i = 0; i < playInfo.repeatNum; ++i) {
                    playInfo = this.getPlayInfo();
                    if (!this.mPlayFlag) break;
                    Thread.sleep(10L);
                    long l2 = System.currentTimeMillis();
                    long l3 = l2 - l;
                    if (l3 <= (long)this.mTimeInterval) continue;
                    bl2 = true;
                    break;
                }
                if (bl2) continue;
                playInfo = this.getPlayInfo();
                if (!this.mPlayFlag) break;
                Thread.sleep(playInfo.remainedTime);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    private PlayInfo getPlayInfo() {
        long l;
        int n;
        if ((long)this.mTimeInterval < 10L) {
            n = 0;
            l = this.mTimeInterval;
        } else {
            n = (int)((long)this.mTimeInterval / 10L);
            l = (long)this.mTimeInterval - (long)n * 10L;
        }
        PlayInfo playInfo = new PlayInfo();
        playInfo.repeatNum = n;
        playInfo.remainedTime = l;
        return playInfo;
    }

    public boolean isPlaying() {
        return this.mPlayFlag;
    }

    public void setPlaying(boolean bl) {
        this.mPlayFlag = bl;
    }

    public boolean isLoopPlaybackEnabled() {
        return this.mLoopPlaybackFlag;
    }

    public void setLoopPlaybackEnabled(boolean bl) {
        this.mLoopPlaybackFlag = bl;
    }

    public int getStep() {
        return this.mStep;
    }

    public void setStep(int n) {
        if (n == 0) {
            throw new IllegalArgumentException("s == 0");
        }
        this.mStep = n;
    }

    public long getTimeInterval() {
        return this.mTimeInterval;
    }

    public void setTimeInterval(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("t < 0");
        }
        this.mTimeInterval = n;
    }

    public void dispose() {
        this.mDisposed = true;
        this.mObserverList.clear();
    }

    public boolean isDisposed() {
        return this.mDisposed;
    }

    public int getFrameNumber() {
        return this.mAnimation.getFrameNumber();
    }

    public int getCurrentFrameIndex() {
        return this.mAnimation.getCurrentFrameIndex();
    }

    public void setCurrentFrameIndex(int n) {
        this.mAnimation.setCurrentFrameIndex(n);
    }

    public void addAnimationThreadObserver(AnimationThreadObserver animationThreadObserver) {
        this.mObserverList.add(animationThreadObserver);
    }

    public void removeAnimationThreadObserver(AnimationThreadObserver animationThreadObserver) {
        this.mObserverList.remove(animationThreadObserver);
    }

    public static interface AnimationThreadObserver {
        public void updated(SGAnimationThread var1);
    }

    private static class PlayInfo {
        int repeatNum;
        long remainedTime;

        private PlayInfo() {
        }
    }
}

