/*
 * Decompiled with CFR 0.152.
 */
package jp.riken.brain.ni.samuraigraph.base;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.SwingUtilities;
import javax.swing.border.LineBorder;
import jp.riken.brain.ni.samuraigraph.base.SGButton;

public class SGColorSelectionButton
extends SGButton {
    private static final long serialVersionUID = -875675138016036356L;
    private boolean mColorSetFlag = true;

    public SGColorSelectionButton() {
        this.setBorder(new LineBorder(Color.BLACK, 1));
    }

    public Color getColor() {
        return this.mColorSetFlag ? this.getBackground() : null;
    }

    public void setColor(final Color color) {
        this.mColorSetFlag = color != null;
        this.setBackground(color);
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                StringBuffer stringBuffer = new StringBuffer();
                if (color != null) {
                    stringBuffer.append(color.getRed());
                    stringBuffer.append(", ");
                    stringBuffer.append(color.getGreen());
                    stringBuffer.append(", ");
                    stringBuffer.append(color.getBlue());
                } else {
                    stringBuffer.append("null");
                }
                SGColorSelectionButton.this.setToolTipText(stringBuffer.toString());
            }
        });
    }

    public void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        if (graphics != null && this.getModel().isEnabled()) {
            Insets insets = this.getInsets();
            Dimension dimension = this.getSize();
            int n = dimension.width - (insets.left + insets.right);
            int n2 = dimension.height - (insets.bottom + insets.top);
            graphics.setColor(this.getBackground());
            graphics.fillRect(insets.left, insets.top, n, n2);
        }
    }
}

