/*
 * Decompiled with CFR 0.152.
 */
package jp.riken.brain.ni.samuraigraph.base;

import java.awt.Dialog;
import java.awt.Frame;
import java.awt.GraphicsConfiguration;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.ArrayList;
import javax.swing.AbstractAction;
import javax.swing.InputMap;
import javax.swing.JDialog;
import javax.swing.KeyStroke;
import javax.swing.text.JTextComponent;
import jp.riken.brain.ni.samuraigraph.base.SGDrawingWindow;
import jp.riken.brain.ni.samuraigraph.base.SGIConstants;
import jp.riken.brain.ni.samuraigraph.base.SGUtility;
import jp.riken.brain.ni.samuraigraph.base.SGUtilityText;

public abstract class SGDialog
extends JDialog
implements ActionListener,
WindowListener,
ComponentListener,
SGIConstants {
    private static final long serialVersionUID = 5190851306204747759L;
    public static final String OK_BUTTON_TEXT = "OK";
    public static final String CANCEL_BUTTON_TEXT = "Cancel";
    public static final String PREVIEW_BUTTON_TEXT = "Preview";
    public static final String YES_BUTTON_TEXT = "Yes";
    public static final String NO_BUTTON_TEXT = "No";
    public static final String PREVIOUS_BUTTON_TEXT = "<Prev";
    public static final String NEXT_BUTTON_TEXT = "Next>";
    private ArrayList mActionListenerList = new ArrayList();
    private int mCloseOption = -1;

    public SGDialog() {
        this.initialize();
    }

    public SGDialog(Dialog dialog) {
        super(dialog);
        this.initialize();
    }

    public SGDialog(Dialog dialog, boolean bl) {
        super(dialog, bl);
        this.initialize();
    }

    public SGDialog(Dialog dialog, String string) {
        super(dialog, string);
        this.initialize();
    }

    public SGDialog(Dialog dialog, String string, boolean bl) {
        super(dialog, string, bl);
        this.initialize();
    }

    public SGDialog(Dialog dialog, String string, boolean bl, GraphicsConfiguration graphicsConfiguration) {
        super(dialog, string, bl, graphicsConfiguration);
        this.initialize();
    }

    public SGDialog(Frame frame) {
        super(frame);
        this.initialize();
    }

    public SGDialog(Frame frame, boolean bl) {
        super(frame, bl);
        this.initialize();
    }

    public SGDialog(Frame frame, String string) {
        super(frame, string);
        this.initialize();
    }

    public SGDialog(Frame frame, String string, boolean bl) {
        super(frame, string, bl);
        this.initialize();
    }

    public SGDialog(Frame frame, String string, boolean bl, GraphicsConfiguration graphicsConfiguration) {
        super(frame, string, bl, graphicsConfiguration);
        this.initialize();
    }

    private void initialize() {
        this.setResizable(false);
        this.addComponentListener(this);
        this.addWindowListener(this);
        AbstractAction abstractAction = new AbstractAction(""){
            private static final long serialVersionUID = -2720225923746562702L;

            public void actionPerformed(ActionEvent actionEvent) {
                SGDialog.this.onEscKeyTyped();
            }
        };
        InputMap inputMap = this.getRootPane().getInputMap(1);
        inputMap.put(KeyStroke.getKeyStroke(27, 0), "close-it");
        this.getRootPane().getActionMap().put("close-it", abstractAction);
    }

    protected abstract void onEscKeyTyped();

    public void componentShown(ComponentEvent componentEvent) {
    }

    public void componentHidden(ComponentEvent componentEvent) {
    }

    public void componentMoved(ComponentEvent componentEvent) {
        Window window = this.getOwner();
        if (window != null) {
            window.repaint();
        }
    }

    public void componentResized(ComponentEvent componentEvent) {
    }

    public void windowActivated(WindowEvent windowEvent) {
        this.repaint();
    }

    public void windowDeactivated(WindowEvent windowEvent) {
        this.repaint();
    }

    public void windowIconified(WindowEvent windowEvent) {
    }

    public void windowDeiconified(WindowEvent windowEvent) {
    }

    public void windowOpened(WindowEvent windowEvent) {
    }

    public void windowClosed(WindowEvent windowEvent) {
    }

    public void windowClosing(WindowEvent windowEvent) {
        this.mCloseOption = 1;
    }

    public void addActionListener(ActionListener actionListener) {
        ArrayList arrayList = this.mActionListenerList;
        for (int i = 0; i < arrayList.size(); ++i) {
            ActionListener actionListener2 = (ActionListener)arrayList.get(i);
            if (!actionListener2.equals(actionListener)) continue;
            return;
        }
        arrayList.add(actionListener);
    }

    public void removeActionListener(ActionListener actionListener) {
        ArrayList arrayList = this.mActionListenerList;
        for (int i = arrayList.size() - 1; i >= 0; --i) {
            ActionListener actionListener2 = (ActionListener)arrayList.get(i);
            if (!actionListener2.equals(actionListener)) continue;
            arrayList.remove(actionListener);
        }
    }

    protected void notifyToListener(String string) {
        ArrayList arrayList = this.mActionListenerList;
        for (int i = 0; i < arrayList.size(); ++i) {
            ActionListener actionListener = (ActionListener)arrayList.get(i);
            actionListener.actionPerformed(this.getActionEvent(string));
        }
    }

    private ActionEvent getActionEvent(String string) {
        return new ActionEvent(this, 0, string);
    }

    public void setCenter(Window window) {
        SGUtility.setCenter(this, window);
    }

    protected Number getNumber(JTextComponent jTextComponent) {
        if (jTextComponent == null) {
            return null;
        }
        String string = jTextComponent.getText();
        Double d = SGUtilityText.getDouble(string);
        return d;
    }

    public int getCloseOption() {
        return this.mCloseOption;
    }

    protected void setCloseOption(int n) {
        this.mCloseOption = n;
    }

    public void setVisible(boolean bl) {
        Window window = this.getOwner();
        if (window instanceof SGDrawingWindow) {
            SGDrawingWindow sGDrawingWindow = (SGDrawingWindow)window;
            if (bl && this.isModal()) {
                sGDrawingWindow.setModalDialogShown(true);
            }
            super.setVisible(bl);
            if (bl && this.isModal()) {
                sGDrawingWindow.setModalDialogShown(false);
            }
        } else {
            super.setVisible(bl);
        }
    }

    public SGDrawingWindow getOwnerWindow() {
        Window window = this.getOwner();
        SGDrawingWindow sGDrawingWindow = null;
        if (window instanceof SGDrawingWindow) {
            sGDrawingWindow = (SGDrawingWindow)window;
        }
        return sGDrawingWindow;
    }
}

