/*
 * Decompiled with CFR 0.152.
 */
package jp.riken.brain.ni.samuraigraph.base;

import java.awt.Graphics;
import java.awt.Image;
import java.awt.image.ImageObserver;
import jp.riken.brain.ni.samuraigraph.base.SGIDisposable;
import jp.riken.brain.ni.samuraigraph.base.SGTuple2f;

public class SGImage
implements SGIDisposable {
    private Image mImage = null;
    private ImageObserver mImageObserver = null;
    private float mX;
    private float mY;
    private float mWidth;
    private float mHeight;
    private float mMagnification = 1.0f;
    private float mScalingFactor = 1.0f;
    private boolean mDisposed = false;

    public SGImage(ImageObserver imageObserver) {
        this.setImageObserver(imageObserver);
        this.setDafaultImageSize();
    }

    public SGImage(Image image, ImageObserver imageObserver) {
        this.setImage(image);
        this.setImageObserver(imageObserver);
        this.setDafaultImageSize();
    }

    public SGImage(Image image, ImageObserver imageObserver, float f, float f2, float f3, float f4) {
        this.setImage(image);
        this.setImageObserver(imageObserver);
        this.setImageBounds(f, f2, f3, f4);
    }

    public void dispose() {
        this.mDisposed = true;
        this.mImage = null;
        this.mImageObserver = null;
    }

    public boolean isDisposed() {
        return this.mDisposed;
    }

    public boolean setImageLocationX(float f) {
        return this.setImageLocation(f, this.getImageLocation().y);
    }

    public boolean setImageLocationY(float f) {
        return this.setImageLocation(this.getImageLocation().x, f);
    }

    public boolean setImageLocation(float f, float f2) {
        this.mX = f;
        this.mY = f2;
        return true;
    }

    public boolean setImageWidth(float f) {
        this.mWidth = f;
        return true;
    }

    public boolean setImageHeight(float f) {
        this.mHeight = f;
        return true;
    }

    public boolean setImageSize(float f, float f2) {
        this.setImageWidth(f);
        this.setImageHeight(f2);
        return true;
    }

    public boolean setImageBounds(float f, float f2, float f3, float f4) {
        this.setImageLocation(f, f2);
        this.setImageSize(f3, f4);
        return true;
    }

    public SGTuple2f getImageLocation() {
        return new SGTuple2f(this.mX, this.mY);
    }

    public float getImageLocationX() {
        return this.mX;
    }

    public float getImageLocationY() {
        return this.mY;
    }

    public SGTuple2f getImageSize() {
        return new SGTuple2f(this.mWidth, this.mHeight);
    }

    public float getImageWidth() {
        return this.mWidth;
    }

    public float getImageHeight() {
        return this.mHeight;
    }

    public boolean setImage(Image image) {
        this.mImage = image;
        return true;
    }

    public boolean setDafaultImageSize() {
        if (this.mImageObserver == null || this.mImage == null) {
            return false;
        }
        Image image = this.mImage;
        ImageObserver imageObserver = this.mImageObserver;
        this.setImageSize(image.getWidth(imageObserver), image.getHeight(imageObserver));
        return true;
    }

    public Image getImage() {
        return this.mImage;
    }

    public boolean setImageObserver(ImageObserver imageObserver) {
        this.mImageObserver = imageObserver;
        return true;
    }

    public ImageObserver getImageObserver() {
        return this.mImageObserver;
    }

    public boolean setMagnification(float f) {
        this.mMagnification = f;
        return true;
    }

    public float getMagnification() {
        return this.mMagnification;
    }

    public boolean setScalingFactor(float f) {
        if (f < 0.0f) {
            throw new IllegalArgumentException("f<0.0f");
        }
        this.mScalingFactor = f;
        return true;
    }

    public float getScalingFactor() {
        return this.mScalingFactor;
    }

    public void drawImage(Graphics graphics) {
        if (this.mImage == null || this.mImageObserver == null) {
            return;
        }
        float f = this.getMagnification();
        float f2 = this.getScalingFactor();
        int n = (int)this.mX;
        int n2 = (int)this.mY;
        int n3 = (int)(f * f2 * this.mWidth);
        int n4 = (int)(f * f2 * this.mHeight);
        graphics.drawImage(this.mImage, n, n2, n3, n4, this.mImageObserver);
    }
}

