/*
 * Decompiled with CFR 0.152.
 */
package jp.riken.brain.ni.samuraigraph.base;

import java.awt.Component;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.KeyStroke;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;
import jp.riken.brain.ni.samuraigraph.base.SGButtonGroup;
import jp.riken.brain.ni.samuraigraph.base.SGDrawingWindow;
import jp.riken.brain.ni.samuraigraph.base.SGINode;
import jp.riken.brain.ni.samuraigraph.base.SGIPropertyDialogObserver;
import jp.riken.brain.ni.samuraigraph.base.SGIRootObjectConstants;
import jp.riken.brain.ni.samuraigraph.base.SGToggleMenuItem;
import jp.riken.brain.ni.samuraigraph.base.SGUserProperties;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SGMenuBar
extends JMenuBar
implements ActionListener,
MenuListener,
SGIRootObjectConstants {
    private static final long serialVersionUID = 7504775458155768651L;
    private List<ActionListener> mActionListenerList = new ArrayList<ActionListener>();
    private List<MenuListener> mMenuListenerList = new ArrayList<MenuListener>();

    public SGMenuBar() {
        this.create();
    }

    private boolean create() {
        SGMenuBar sGMenuBar = this;
        int n = Toolkit.getDefaultToolkit().getMenuShortcutKeyMask();
        JMenu jMenu = new JMenu("File");
        jMenu.setMnemonic(70);
        sGMenuBar.add(jMenu);
        jMenu.addMenuListener(this);
        this.createMenuItem(jMenu, "Create New Window", this, 78, KeyStroke.getKeyStroke(78, n), true);
        this.createMenuItem(jMenu, "Close Window", this, 87, KeyStroke.getKeyStroke(87, n), true);
        jMenu.addSeparator();
        this.createMenuItem(jMenu, "Draw Graph", this, 68, KeyStroke.getKeyStroke(79, n), true);
        jMenu.addSeparator();
        this.createMenuItem(jMenu, "Load Property", this, 76, null, true);
        this.createMenuItem(jMenu, "Save Property", this, 83, null, true);
        jMenu.addSeparator();
        this.createMenuItem(jMenu, "Load Data Set", this, -1, null, true);
        this.createMenuItem(jMenu, "Save Data Set", this, -1, null, true);
        jMenu.addSeparator();
        this.createMenuItem(jMenu, "Load Background Image", this, 73, null, true);
        jMenu.addSeparator();
        this.createMenuItem(jMenu, "Export as Image", this, 69, KeyStroke.getKeyStroke(69, n), false);
        this.createMenuItem(jMenu, "Print", this, 80, KeyStroke.getKeyStroke(80, n), false);
        jMenu.addSeparator();
        this.createMenuItem(jMenu, "Exit", this, 88, KeyStroke.getKeyStroke(81, n), true);
        jMenu = new JMenu("Edit");
        jMenu.setMnemonic(69);
        sGMenuBar.add(jMenu);
        jMenu.addMenuListener(this);
        this.createMenuItem(jMenu, "Undo", this, 85, KeyStroke.getKeyStroke(90, n), false);
        this.createMenuItem(jMenu, "Redo", this, 82, KeyStroke.getKeyStroke(89, n), false);
        jMenu.addSeparator();
        this.createMenuItem(jMenu, "Clear Undo Buffer", this, 66, null, true);
        jMenu.addSeparator();
        this.createMenuItem(jMenu, "Cut", this, 84, KeyStroke.getKeyStroke(88, n), false);
        this.createMenuItem(jMenu, "Copy", this, 67, KeyStroke.getKeyStroke(67, n), false);
        this.createMenuItem(jMenu, "Paste", this, 80, KeyStroke.getKeyStroke(86, n), false);
        jMenu.addSeparator();
        this.createMenuItem(jMenu, "Delete", this, 68, KeyStroke.getKeyStroke(127, 0), false);
        this.createMenuItem(jMenu, "Duplicate", this, 73, KeyStroke.getKeyStroke(68, n), false);
        jMenu.addSeparator();
        this.createMenuItem(jMenu, "Delete Background Image", this, 77, null, false);
        jMenu = new JMenu("Insert");
        jMenu.setMnemonic(73);
        sGMenuBar.add(jMenu);
        jMenu.addMenuListener(this);
        Object object = this.createToggleMenuItem(jMenu, "Label", this, 76, null, false);
        JMenuItem jMenuItem = this.createToggleMenuItem(jMenu, "Significant Difference", this, 68, null, false);
        JMenuItem jMenuItem2 = this.createToggleMenuItem(jMenu, "Axis Break", this, 66, null, false);
        JMenuItem jMenuItem3 = this.createToggleMenuItem(jMenu, "Timing Line", this, 84, null, false);
        JMenuItem jMenuItem4 = this.createToggleMenuItem(jMenu, "Rectangle", this, 82, null, false);
        JMenuItem jMenuItem5 = this.createToggleMenuItem(jMenu, "Ellipse", this, 69, null, false);
        JMenuItem jMenuItem6 = this.createToggleMenuItem(jMenu, "Arrow", this, 65, null, false);
        JMenuItem jMenuItem7 = this.createToggleMenuItem(jMenu, "Line", this, 73, null, false);
        SGButtonGroup sGButtonGroup = new SGButtonGroup();
        sGButtonGroup.add((AbstractButton)object);
        sGButtonGroup.add(jMenuItem);
        sGButtonGroup.add(jMenuItem2);
        sGButtonGroup.add(jMenuItem3);
        sGButtonGroup.add(jMenuItem4);
        sGButtonGroup.add(jMenuItem5);
        sGButtonGroup.add(jMenuItem6);
        sGButtonGroup.add(jMenuItem7);
        jMenu = new JMenu("Layout");
        jMenu.setMnemonic(76);
        sGMenuBar.add(jMenu);
        jMenu.addMenuListener(this);
        object = new JMenu("Paper Size");
        ((AbstractButton)object).setMnemonic(80);
        jMenu.add((JMenuItem)object);
        this.createMenuItem((JMenu)object, "A4 Portrait", this, 65, null, true);
        this.createMenuItem((JMenu)object, "B5 Portrait", this, 66, null, true);
        this.createMenuItem((JMenu)object, "US Letter Portrait", this, 85, null, true);
        ((JMenu)object).addSeparator();
        this.createMenuItem((JMenu)object, "A4 Landscape", this, 52, null, true);
        this.createMenuItem((JMenu)object, "B5 Landscape", this, 53, null, true);
        this.createMenuItem((JMenu)object, "US Letter Landscape", this, 83, null, true);
        ((JMenu)object).addSeparator();
        this.createMenuItem((JMenu)object, "Bounding Box", this, 79, null, true);
        this.createMenuItem((JMenu)object, "User Customize", this, 67, null, true);
        jMenu.addSeparator();
        object = new JMenu("Tool Bar");
        ((AbstractButton)object).setMnemonic(84);
        jMenu.add((JMenuItem)object);
        jMenuItem = this.createCheckBoxMenuItem((JMenu)object, "File", this, -1, null, true);
        jMenuItem.setSelected(true);
        jMenuItem = this.createCheckBoxMenuItem((JMenu)object, "Edit", this, -1, null, true);
        jMenuItem.setSelected(true);
        jMenuItem = this.createCheckBoxMenuItem((JMenu)object, "Insert", this, -1, null, true);
        jMenuItem.setSelected(true);
        jMenuItem = this.createCheckBoxMenuItem((JMenu)object, "Layout", this, -1, null, true);
        jMenuItem.setSelected(true);
        jMenuItem = this.createCheckBoxMenuItem((JMenu)object, "Zoom", this, -1, null, true);
        jMenuItem.setSelected(true);
        jMenu.addSeparator();
        object = new JMenu("Grid");
        ((AbstractButton)object).setMnemonic(71);
        jMenu.add((JMenuItem)object);
        this.createMenuItem((JMenu)object, "Plus", this, 80, KeyStroke.getKeyStroke(73, 9), true);
        this.createMenuItem((JMenu)object, "Minus", this, 77, KeyStroke.getKeyStroke(68, 9), true);
        this.createCheckBoxMenuItem((JMenu)object, "Visible", this, 86, KeyStroke.getKeyStroke(71, 9), true);
        this.createCheckBoxMenuItem((JMenu)object, "Snap to Grid", this, 83, KeyStroke.getKeyStroke(83, 9), true);
        jMenu.addSeparator();
        object = new JMenu("Zoom");
        ((AbstractButton)object).setMnemonic(90);
        jMenu.add((JMenuItem)object);
        this.createMenuItem((JMenu)object, "Zoom In", this, 73, KeyStroke.getKeyStroke(90, 9), true);
        jMenuItem = this.createMenuItem((JMenu)object, "Zoom Out", this, 79, KeyStroke.getKeyStroke(79, 9), true);
        jMenuItem.setDisplayedMnemonicIndex(5);
        this.createMenuItem((JMenu)object, "Default Zoom", this, 68, null, true);
        this.createMenuItem((JMenu)object, "Zoom Way Out", this, 87, null, true);
        this.createCheckBoxMenuItem((JMenu)object, "Auto Zoom", this, 65, null, true);
        jMenu.addSeparator();
        this.createCheckBoxMenuItem(jMenu, "Lock", this, 79, null, true);
        jMenu = new JMenu("Arrange");
        jMenu.setMnemonic(65);
        sGMenuBar.add(jMenu);
        jMenu.addMenuListener(this);
        this.createMenuItem(jMenu, "Bring to Front", this, 70, KeyStroke.getKeyStroke(70, n), false);
        this.createMenuItem(jMenu, "Bring Forward", this, 66, KeyStroke.getKeyStroke(66, n), false);
        this.createMenuItem(jMenu, "Send Backward", this, 83, KeyStroke.getKeyStroke(83, n), false);
        this.createMenuItem(jMenu, "Send to Back", this, 75, KeyStroke.getKeyStroke(75, n), false);
        jMenu.addSeparator();
        this.createMenuItem(jMenu, "Auto Arrangement", this, 82, null, true);
        jMenu = new JMenu("Properties");
        jMenu.setMnemonic(80);
        sGMenuBar.add(jMenu);
        jMenu.addMenuListener(this);
        jMenu = new JMenu("Help");
        jMenu.setMnemonic(72);
        sGMenuBar.add(jMenu);
        jMenu.addMenuListener(this);
        this.createMenuItem(jMenu, "Upgrade", this, 85, null, true);
        jMenu.addSeparator();
        this.createMenuItem(jMenu, "Change Log", this, 67, null, true);
        jMenu.addSeparator();
        this.createMenuItem(jMenu, "Proxy", this, 80, null, true);
        jMenu.addSeparator();
        object = SGUserProperties.getInstance().getProperty("dev");
        if (Boolean.valueOf((String)object).booleanValue()) {
            this.createMenuItem(jMenu, "Memory Info", this, 77, KeyStroke.getKeyStroke(77, 9), true);
            jMenu.addSeparator();
        }
        this.createMenuItem(jMenu, "About", this, 65, null, true);
        return true;
    }

    private JMenuItem createMenuItem(JMenu jMenu, String string, ActionListener actionListener, int n, KeyStroke keyStroke, boolean bl) {
        return this.createMenuItem(jMenu, string, string, actionListener, n, keyStroke, bl);
    }

    private JMenuItem createMenuItem(JMenu jMenu, String string, String string2, ActionListener actionListener, int n, KeyStroke keyStroke, boolean bl) {
        JMenuItem jMenuItem = new JMenuItem(string);
        return this.createMenuItemSub(jMenu, jMenuItem, string2, actionListener, n, keyStroke, bl);
    }

    private JCheckBoxMenuItem createCheckBoxMenuItem(JMenu jMenu, String string, ActionListener actionListener, int n, KeyStroke keyStroke, boolean bl) {
        JCheckBoxMenuItem jCheckBoxMenuItem = new JCheckBoxMenuItem(string);
        return (JCheckBoxMenuItem)this.createMenuItemSub(jMenu, jCheckBoxMenuItem, string, actionListener, n, keyStroke, bl);
    }

    private JMenuItem createToggleMenuItem(JMenu jMenu, String string, ActionListener actionListener, int n, KeyStroke keyStroke, boolean bl) {
        SGToggleMenuItem sGToggleMenuItem = new SGToggleMenuItem(string);
        return this.createMenuItemSub(jMenu, sGToggleMenuItem, string, actionListener, n, keyStroke, bl);
    }

    private JMenuItem createNodeMenuItem(SGINode sGINode, JMenu jMenu, String string, ActionListener actionListener) {
        return this.createNodeMenuItem(sGINode, jMenu, string, actionListener, -1, null, true);
    }

    private JMenuItem createNodeMenuItem(SGINode sGINode, JMenu jMenu, String string, ActionListener actionListener, int n, KeyStroke keyStroke, boolean bl) {
        SGDrawingWindow.NodeMenuItem nodeMenuItem = new SGDrawingWindow.NodeMenuItem(string);
        nodeMenuItem.setNode(sGINode);
        return this.createMenuItemSub(jMenu, nodeMenuItem, string, actionListener, n, keyStroke, bl);
    }

    private JMenuItem createMenuItemSub(JMenu jMenu, JMenuItem jMenuItem, String string, ActionListener actionListener, int n, KeyStroke keyStroke, boolean bl) {
        jMenuItem.setActionCommand(string);
        jMenuItem.addActionListener(actionListener);
        if (n != -1) {
            jMenuItem.setMnemonic(n);
        }
        if (keyStroke != null) {
            jMenuItem.setAccelerator(keyStroke);
        }
        jMenuItem.setEnabled(bl);
        jMenu.add(jMenuItem);
        return jMenuItem;
    }

    private JMenu getMenuFromMenuBar(String string) {
        SGMenuBar sGMenuBar = this;
        for (int i = 0; i < sGMenuBar.getMenuCount(); ++i) {
            JMenu jMenu = sGMenuBar.getMenu(i);
            String string2 = jMenu.getText();
            if (!string2.equals(string)) continue;
            return jMenu;
        }
        return null;
    }

    private JMenu getMenu(JMenu jMenu, String string) {
        for (int i = 0; i < jMenu.getItemCount(); ++i) {
            JMenu jMenu2;
            JMenuItem jMenuItem = jMenu.getItem(i);
            if (jMenuItem == null || !(jMenuItem instanceof JMenu) || !(jMenu2 = (JMenu)jMenuItem).getText().equals(string)) continue;
            return jMenu2;
        }
        return null;
    }

    private JMenuItem getMenuItem(String string, String string2) {
        JMenu jMenu = this.getMenuFromMenuBar(string);
        if (jMenu == null) {
            return null;
        }
        return this.getMenuItem(jMenu, string2);
    }

    private JMenuItem getMenuItem(JMenu jMenu, String string) {
        for (int i = 0; i < jMenu.getItemCount(); ++i) {
            JMenuItem jMenuItem = jMenu.getItem(i);
            if (jMenuItem == null) continue;
            if (jMenuItem instanceof JMenu) {
                JMenu jMenu2 = (JMenu)jMenuItem;
                JMenuItem jMenuItem2 = this.getMenuItem(jMenu2, string);
                if (jMenuItem2 == null) continue;
                return jMenuItem2;
            }
            if (!jMenuItem.getText().equals(string)) continue;
            return jMenuItem;
        }
        return null;
    }

    private List<Component> getMenuItemList(String string) {
        JMenu jMenu = this.getMenuFromMenuBar(string);
        if (jMenu == null) {
            return null;
        }
        ArrayList<Component> arrayList = new ArrayList<Component>();
        Component[] componentArray = jMenu.getMenuComponents();
        for (int i = 0; i < componentArray.length; ++i) {
            if (!(componentArray[i] instanceof JMenuItem)) continue;
            arrayList.add(componentArray[i]);
        }
        return arrayList;
    }

    public void addActionListener(ActionListener actionListener) {
        this.mActionListenerList.add(actionListener);
    }

    public void removeActionListener(ActionListener actionListener) {
        this.mActionListenerList.remove(actionListener);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Serializable serializable;
        Object object = actionEvent.getSource();
        if (object instanceof SGToggleMenuItem) {
            serializable.setSelected(!(serializable = (SGToggleMenuItem)object).isSelected());
        }
        serializable = new ActionEvent(this, actionEvent.getID(), actionEvent.getActionCommand(), actionEvent.getModifiers());
        for (int i = 0; i < this.mActionListenerList.size(); ++i) {
            ActionListener actionListener = this.mActionListenerList.get(i);
            actionListener.actionPerformed((ActionEvent)serializable);
        }
    }

    public boolean isMenuItemEnabled(String string, String string2) {
        JMenuItem jMenuItem = this.getMenuItem(string, string2);
        if (jMenuItem == null) {
            throw new IllegalArgumentException("item==null");
        }
        return jMenuItem.isEnabled();
    }

    public void setMenuItemEnabled(String string, String string2, boolean bl) {
        JMenuItem jMenuItem = this.getMenuItem(string, string2);
        if (jMenuItem == null) {
            throw new IllegalArgumentException("item==null");
        }
        jMenuItem.setEnabled(bl);
    }

    public boolean isMenuItemSelected(String string, String string2) {
        JMenuItem jMenuItem = this.getMenuItem(string, string2);
        if (jMenuItem == null) {
            throw new IllegalArgumentException("item==null");
        }
        return jMenuItem.isSelected();
    }

    public void setMenuItemSelected(String string, String string2, boolean bl) {
        JMenuItem jMenuItem = this.getMenuItem(string, string2);
        if (jMenuItem == null) {
            throw new IllegalArgumentException("item==null");
        }
        jMenuItem.setSelected(bl);
    }

    public void addMenuListener(MenuListener menuListener) {
        for (int i = 0; i < this.mMenuListenerList.size(); ++i) {
            MenuListener menuListener2 = this.mMenuListenerList.get(i);
            if (!menuListener2.equals(menuListener)) continue;
            return;
        }
        this.mMenuListenerList.add(menuListener);
    }

    public void removeActionListener(MenuListener menuListener) {
        for (int i = this.mMenuListenerList.size() - 1; i >= 0; --i) {
            MenuListener menuListener2 = this.mMenuListenerList.get(i);
            if (!menuListener2.equals(menuListener)) continue;
            this.mMenuListenerList.remove(menuListener);
        }
    }

    @Override
    public void menuSelected(MenuEvent menuEvent) {
        for (int i = 0; i < this.mMenuListenerList.size(); ++i) {
            MenuListener menuListener = this.mMenuListenerList.get(i);
            menuListener.menuSelected(menuEvent);
        }
    }

    @Override
    public void menuDeselected(MenuEvent menuEvent) {
        for (int i = 0; i < this.mMenuListenerList.size(); ++i) {
            MenuListener menuListener = this.mMenuListenerList.get(i);
            menuListener.menuDeselected(menuEvent);
        }
    }

    @Override
    public void menuCanceled(MenuEvent menuEvent) {
        for (int i = 0; i < this.mMenuListenerList.size(); ++i) {
            MenuListener menuListener = this.mMenuListenerList.get(i);
            menuListener.menuCanceled(menuEvent);
        }
    }

    public void setInsertToggleButtonsEnabled(boolean bl) {
        List<Component> list = this.getMenuItemList("Insert");
        for (int i = 0; i < list.size(); ++i) {
            SGToggleMenuItem sGToggleMenuItem = (SGToggleMenuItem)list.get(i);
            sGToggleMenuItem.setEnabled(bl);
        }
    }

    public void setInsertToggleItemsUnSelected() {
        List<Component> list = this.getMenuItemList("Insert");
        for (int i = 0; i < list.size(); ++i) {
            SGToggleMenuItem sGToggleMenuItem = (SGToggleMenuItem)list.get(i);
            sGToggleMenuItem.setSelected(false);
        }
    }

    public boolean hasMenuItem(String string) {
        return this.getMenuItem("Insert", string) != null;
    }

    public void setInsertToggleItemSelected(String string, boolean bl) {
        if (!this.hasMenuItem(string)) {
            throw new IllegalArgumentException();
        }
        this.getMenuItem("Insert", string).setSelected(bl);
    }

    public boolean isInsertToggleItemSelected(String string) {
        if (!this.hasMenuItem(string)) {
            throw new IllegalArgumentException();
        }
        return this.getMenuItem("Insert", string).isSelected();
    }

    public void createPropertyMenuBarItem(SGINode sGINode, ActionListener actionListener) {
        JMenu jMenu = this.getMenuFromMenuBar("Properties");
        jMenu.removeAll();
        this.createMenuItem(sGINode, jMenu, actionListener);
    }

    private void createMenuItem(SGINode sGINode, JMenu jMenu, ActionListener actionListener) {
        ArrayList arrayList = sGINode.getChildNodes();
        String string = sGINode.getClassDescription();
        String string2 = sGINode.getInstanceDescription();
        boolean bl = sGINode instanceof SGIPropertyDialogObserver;
        if (arrayList.size() != 0) {
            if (string != null && string2 != null) {
                JMenu jMenu2 = new JMenu(string);
                jMenu.add(jMenu2);
                if (bl) {
                    this.createNodeMenuItem(sGINode, jMenu2, string2, actionListener);
                }
                for (int i = 0; i < arrayList.size(); ++i) {
                    SGINode sGINode2 = (SGINode)arrayList.get(i);
                    this.createMenuItem(sGINode2, jMenu2, actionListener);
                }
            }
        } else if (bl && string2 != null) {
            this.createNodeMenuItem(sGINode, jMenu, string2, actionListener);
        }
    }

    public boolean isToolBarMenuSelected(String string) {
        JMenu jMenu = this.getMenuFromMenuBar("Layout");
        JMenu jMenu2 = this.getMenu(jMenu, "Tool Bar");
        JMenuItem jMenuItem = this.getMenuItem(jMenu2, string);
        if (jMenuItem != null) {
            return jMenuItem.isSelected();
        }
        throw new IllegalArgumentException();
    }

    public void setToolBarMenuItemSelected(String string, boolean bl) {
        JMenu jMenu = this.getMenuFromMenuBar("Layout");
        JMenu jMenu2 = this.getMenu(jMenu, "Tool Bar");
        JMenuItem jMenuItem = this.getMenuItem(jMenu2, string);
        if (jMenuItem == null) {
            throw new IllegalArgumentException();
        }
        jMenuItem.setSelected(bl);
    }
}

