/*
 * Decompiled with CFR 0.152.
 */
package jp.riken.brain.ni.samuraigraph.base;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.TexturePaint;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import jp.riken.brain.ni.samuraigraph.base.SGTransparentPaint;
import jp.riken.brain.ni.samuraigraph.base.SGUtilityText;

public class SGPatternPaint
extends SGTransparentPaint {
    public static final int INDEX_0_DEGREE = 0;
    public static final int INDEX_45_DEGREE = 1;
    public static final int INDEX_90_DEGREE = 2;
    public static final int INDEX_135_DEGREE = 3;
    public static final int INDEX_STRIPES_0_DEGREE = 4;
    public static final int INDEX_STRIPES_45_DEGREE = 5;
    public static final int INDEX_3_STRIPES_90_DEGREE = 6;
    public static final int INDEX_45_DEGREE_WIDE = 7;
    public static final String NAME_0_DEGREE = "0 degree";
    public static final String NAME_45_DEGREE = "45 degree";
    public static final String NAME_90_DEGREE = "90 degree";
    public static final String NAME_135_DEGREE = "135 degree";
    public static final String NAME_STRIPES_0_DEGREE = "Stripes 0 degree";
    public static final String NAME_STRIPES_45_DEGREE = "Stripes 45 degree";
    public static final String NAME_3_STRIPES_90_DEGREE = "3 stripes 90 degree";
    public static final String NAME_45_DEGREE_WIDE = "45 degree wide";
    public static final String[] TYPE_PATTERN_NAMES = new String[]{"0 degree", "45 degree", "90 degree", "135 degree", "Stripes 0 degree", "Stripes 45 degree", "3 stripes 90 degree", "45 degree wide"};
    public static final int[] INDEX_PATTERN_TYPES = new int[]{0, 1, 2, 3, 4, 5, 6, 7};
    public static final int INDEX_UNKNOWN = -1;
    public static final String NAME_UNKNOWN = "UNKNOWN";
    protected Color mColor = Color.BLACK;
    protected int mTypeIndex = 0;

    public Color getColor() {
        return this.mColor;
    }

    public int getTypeIndex() {
        return this.mTypeIndex;
    }

    public boolean setColor(Color color) {
        if (null == color) {
            return false;
        }
        this.mColor = color;
        return true;
    }

    public boolean setTypeIndex(int n) {
        if (!SGPatternPaint.isValidType(n)) {
            return false;
        }
        this.mTypeIndex = n;
        return true;
    }

    public Paint getPaint(Rectangle2D rectangle2D) {
        switch (this.mTypeIndex) {
            case 0: {
                return SGPatternPaint.getPatternPaint_Size3x3(this.getTransparentedColor(this.mColor), this.getTransparentedColor(Color.WHITE), 0, this.mMagnification);
            }
            case 1: {
                return SGPatternPaint.getPatternPaint_Size4x4(this.getTransparentedColor(this.mColor), this.getTransparentedColor(Color.WHITE), 1, this.mMagnification);
            }
            case 2: {
                return SGPatternPaint.getPatternPaint_Size3x3(this.getTransparentedColor(this.mColor), this.getTransparentedColor(Color.WHITE), 3, this.mMagnification);
            }
            case 3: {
                return SGPatternPaint.getPatternPaint_Size4x4(this.getTransparentedColor(this.mColor), this.getTransparentedColor(Color.WHITE), 2, this.mMagnification);
            }
            case 4: {
                return SGPatternPaint.getPatternPaint_Stripe_Size4x4(this.getTransparentedColor(this.mColor), this.getTransparentedColor(Color.WHITE), 0, this.mMagnification);
            }
            case 5: {
                return SGPatternPaint.getPatternPaint_Stripe_Size4x4(this.getTransparentedColor(this.mColor), this.getTransparentedColor(Color.WHITE), 2, this.mMagnification);
            }
            case 6: {
                return SGPatternPaint.getPatternPaint_3_stripes_Size5x5(this.getTransparentedColor(this.mColor), this.getTransparentedColor(Color.WHITE), this.mMagnification);
            }
            case 7: {
                return SGPatternPaint.getPatternPaint_Size10x10(this.getTransparentedColor(this.mColor), this.getTransparentedColor(Color.WHITE), 1, this.mMagnification);
            }
        }
        return null;
    }

    public Paint getOpaquePaint(Rectangle2D rectangle2D) {
        return this.getOpaquePaint(rectangle2D, this.mMagnification);
    }

    public Paint getOpaquePaint(Rectangle2D rectangle2D, float f) {
        switch (this.mTypeIndex) {
            case 0: {
                return SGPatternPaint.getPatternPaint_Size3x3(this.mColor, Color.WHITE, 0, f);
            }
            case 1: {
                return SGPatternPaint.getPatternPaint_Size4x4(this.mColor, Color.WHITE, 1, f);
            }
            case 2: {
                return SGPatternPaint.getPatternPaint_Size3x3(this.mColor, Color.WHITE, 3, f);
            }
            case 3: {
                return SGPatternPaint.getPatternPaint_Size4x4(this.mColor, Color.WHITE, 2, f);
            }
            case 4: {
                return SGPatternPaint.getPatternPaint_Stripe_Size4x4(this.mColor, Color.WHITE, 0, this.mMagnification);
            }
            case 5: {
                return SGPatternPaint.getPatternPaint_Stripe_Size4x4(this.mColor, Color.WHITE, 2, this.mMagnification);
            }
            case 6: {
                return SGPatternPaint.getPatternPaint_3_stripes_Size5x5(this.mColor, Color.WHITE, this.mMagnification);
            }
            case 7: {
                return SGPatternPaint.getPatternPaint_Size10x10(this.mColor, Color.WHITE, 1, this.mMagnification);
            }
        }
        return null;
    }

    public boolean equals(Object object) {
        if (!(object instanceof SGPatternPaint)) {
            return false;
        }
        SGPatternPaint sGPatternPaint = (SGPatternPaint)object;
        if (!super.equals(sGPatternPaint)) {
            return false;
        }
        if (!sGPatternPaint.mColor.equals(this.mColor)) {
            return false;
        }
        return sGPatternPaint.mTypeIndex == this.mTypeIndex;
    }

    public int hashCode() {
        int n = super.hashCode();
        n = 37 * n + this.mColor.hashCode();
        n = 37 * n + this.mTypeIndex;
        return n;
    }

    private static Paint getPatternPaint_Size3x3(Color color, Color color2, int n, float f) {
        BufferedImage bufferedImage = new BufferedImage(3, 3, 2);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.setRenderingHint(RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_QUALITY);
        graphics2D.setColor(color2);
        graphics2D.fillRect(0, 0, 3, 3);
        graphics2D.setColor(color);
        switch (n) {
            case 0: {
                graphics2D.fillRect(0, 1, 3, 1);
                break;
            }
            case 1: {
                graphics2D.fillRect(2, 0, 1, 1);
                graphics2D.fillRect(1, 1, 1, 1);
                graphics2D.fillRect(0, 2, 1, 1);
                break;
            }
            case 2: {
                graphics2D.fillRect(0, 0, 1, 1);
                graphics2D.fillRect(1, 1, 1, 1);
                graphics2D.fillRect(2, 2, 1, 1);
                break;
            }
            case 3: {
                graphics2D.fillRect(1, 0, 1, 3);
                break;
            }
        }
        if (f == 1.0f) {
            Rectangle rectangle = new Rectangle(0, 0, 3, 3);
            return new TexturePaint(bufferedImage, rectangle);
        }
        int n2 = (int)Math.ceil(3.0 * (double)f);
        BufferedImage bufferedImage2 = new BufferedImage(n2, n2, 2);
        Graphics2D graphics2D2 = bufferedImage2.createGraphics();
        graphics2D2.drawImage(bufferedImage.getScaledInstance(n2, n2, 4), 0, 0, null);
        Rectangle rectangle = new Rectangle(0, 0, n2, n2);
        return new TexturePaint(bufferedImage2, rectangle);
    }

    private static Paint getPatternPaint_Size4x4(Color color, Color color2, int n, float f) {
        BufferedImage bufferedImage = new BufferedImage(4, 4, 2);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.setRenderingHint(RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_QUALITY);
        graphics2D.setColor(color2);
        graphics2D.fillRect(0, 0, 4, 4);
        graphics2D.setColor(color);
        switch (n) {
            case 0: {
                graphics2D.fillRect(0, 1, 4, 1);
                break;
            }
            case 1: {
                graphics2D.fillRect(3, 0, 1, 1);
                graphics2D.fillRect(2, 1, 1, 1);
                graphics2D.fillRect(1, 2, 1, 1);
                graphics2D.fillRect(0, 3, 1, 1);
                break;
            }
            case 2: {
                graphics2D.fillRect(0, 0, 1, 1);
                graphics2D.fillRect(1, 1, 1, 1);
                graphics2D.fillRect(2, 2, 1, 1);
                graphics2D.fillRect(3, 3, 1, 1);
                break;
            }
            case 3: {
                graphics2D.fillRect(1, 0, 1, 4);
                break;
            }
        }
        if (f == 1.0f) {
            Rectangle rectangle = new Rectangle(0, 0, 4, 4);
            return new TexturePaint(bufferedImage, rectangle);
        }
        int n2 = (int)Math.ceil(4.0 * (double)f);
        BufferedImage bufferedImage2 = new BufferedImage(n2, n2, 2);
        Graphics2D graphics2D2 = bufferedImage2.createGraphics();
        graphics2D2.drawImage(bufferedImage.getScaledInstance(n2, n2, 4), 0, 0, null);
        Rectangle rectangle = new Rectangle(0, 0, n2, n2);
        return new TexturePaint(bufferedImage2, rectangle);
    }

    private static Paint getPatternPaint_Stripe_Size4x4(Color color, Color color2, int n, float f) {
        BufferedImage bufferedImage = new BufferedImage(4, 4, 2);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.setRenderingHint(RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_QUALITY);
        graphics2D.setColor(color2);
        graphics2D.fillRect(0, 0, 4, 4);
        graphics2D.setColor(color);
        switch (n) {
            case 0: {
                graphics2D.fillRect(0, 0, 4, 1);
                graphics2D.fillRect(0, 1, 1, 3);
                graphics2D.fillRect(0, 2, 4, 1);
                graphics2D.fillRect(2, 1, 1, 3);
                break;
            }
            case 1: {
                graphics2D.fillRect(0, 0, 4, 1);
                graphics2D.fillRect(0, 1, 1, 3);
                break;
            }
            case 2: {
                graphics2D.fillRect(0, 0, 1, 1);
                graphics2D.fillRect(1, 1, 1, 1);
                graphics2D.fillRect(2, 2, 1, 1);
                graphics2D.fillRect(3, 3, 1, 1);
                graphics2D.fillRect(1, 3, 1, 1);
                graphics2D.fillRect(3, 1, 1, 1);
                break;
            }
            case 3: {
                graphics2D.drawLine(0, 0, 3, 0);
                graphics2D.drawLine(0, 0, 0, 3);
                graphics2D.drawLine(1, 3, 3, 1);
                break;
            }
        }
        if (f == 1.0f) {
            Rectangle rectangle = new Rectangle(0, 0, 4, 4);
            return new TexturePaint(bufferedImage, rectangle);
        }
        int n2 = (int)Math.ceil(4.0 * (double)f);
        BufferedImage bufferedImage2 = new BufferedImage(n2, n2, 2);
        Graphics2D graphics2D2 = bufferedImage2.createGraphics();
        graphics2D2.drawImage(bufferedImage.getScaledInstance(n2, n2, 4), 0, 0, null);
        Rectangle rectangle = new Rectangle(0, 0, n2, n2);
        return new TexturePaint(bufferedImage2, rectangle);
    }

    private static Paint getPatternPaint_3_stripes_Size5x5(Color color, Color color2, float f) {
        BufferedImage bufferedImage = new BufferedImage(5, 5, 2);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.setRenderingHint(RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_QUALITY);
        graphics2D.setColor(color2);
        graphics2D.fillRect(0, 0, 5, 5);
        graphics2D.setColor(color);
        graphics2D.drawLine(0, 0, 4, 0);
        graphics2D.drawLine(0, 1, 0, 4);
        graphics2D.drawLine(2, 4, 4, 2);
        if (f == 1.0f) {
            return new TexturePaint(bufferedImage, new Rectangle(0, 0, 5, 5));
        }
        int n = (int)Math.ceil(5.0 * (double)f);
        BufferedImage bufferedImage2 = new BufferedImage(n, n, 2);
        Graphics2D graphics2D2 = bufferedImage2.createGraphics();
        graphics2D2.drawImage(bufferedImage.getScaledInstance(n, n, 4), 0, 0, null);
        Rectangle rectangle = new Rectangle(0, 0, n, n);
        return new TexturePaint(bufferedImage2, rectangle);
    }

    private static Paint getPatternPaint_Size10x10(Color color, Color color2, int n, float f) {
        BufferedImage bufferedImage = new BufferedImage(10, 10, 2);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.setRenderingHint(RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_QUALITY);
        graphics2D.setColor(color2);
        graphics2D.fillRect(0, 0, 10, 10);
        graphics2D.setColor(color);
        switch (n) {
            case 0: {
                graphics2D.fillRect(0, 0, 10, 1);
                break;
            }
            case 1: {
                graphics2D.fillRect(9, 0, 1, 1);
                graphics2D.fillRect(8, 1, 1, 1);
                graphics2D.fillRect(7, 2, 1, 1);
                graphics2D.fillRect(6, 3, 1, 1);
                graphics2D.fillRect(5, 4, 1, 1);
                graphics2D.fillRect(4, 5, 1, 1);
                graphics2D.fillRect(3, 6, 1, 1);
                graphics2D.fillRect(2, 7, 1, 1);
                graphics2D.fillRect(1, 8, 1, 1);
                graphics2D.fillRect(0, 9, 1, 1);
                break;
            }
            case 2: {
                graphics2D.fillRect(0, 0, 1, 1);
                graphics2D.fillRect(1, 1, 1, 1);
                graphics2D.fillRect(2, 2, 1, 1);
                graphics2D.fillRect(3, 3, 1, 1);
                graphics2D.fillRect(4, 4, 1, 1);
                graphics2D.fillRect(5, 5, 1, 1);
                graphics2D.fillRect(6, 6, 1, 1);
                graphics2D.fillRect(7, 7, 1, 1);
                graphics2D.fillRect(8, 8, 1, 1);
                graphics2D.fillRect(9, 9, 1, 1);
                break;
            }
            case 3: {
                graphics2D.fillRect(0, 0, 1, 10);
            }
        }
        if (f == 1.0f) {
            return new TexturePaint(bufferedImage, new Rectangle(0, 0, 10, 10));
        }
        int n2 = (int)Math.ceil(10.0 * (double)f);
        BufferedImage bufferedImage2 = new BufferedImage(n2, n2, 2);
        Graphics2D graphics2D2 = bufferedImage2.createGraphics();
        graphics2D2.drawImage(bufferedImage.getScaledInstance(n2, n2, 4), 0, 0, null);
        Rectangle rectangle = new Rectangle(0, 0, n2, n2);
        return new TexturePaint(bufferedImage2, rectangle);
    }

    public static boolean isValidType(int n) {
        int[] nArray = INDEX_PATTERN_TYPES;
        for (int i = 0; i < nArray.length; ++i) {
            if (n != nArray[i]) continue;
            return true;
        }
        return false;
    }

    public static Integer getTypeFromName(String string) {
        if (string == null) {
            return null;
        }
        int n = -1;
        for (int i = 0; i < TYPE_PATTERN_NAMES.length; ++i) {
            if (!SGUtilityText.isEqualString(TYPE_PATTERN_NAMES[i], string)) continue;
            n = INDEX_PATTERN_TYPES[i];
            break;
        }
        if (n != -1) {
            return n;
        }
        return null;
    }

    public static String getTypeName(int n) {
        if (SGPatternPaint.isValidType(n)) {
            return TYPE_PATTERN_NAMES[n];
        }
        return NAME_UNKNOWN;
    }
}

