/*
 * Decompiled with CFR 0.152.
 */
package jp.riken.brain.ni.samuraigraph.base;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JColorChooser;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;
import javax.swing.border.LineBorder;
import javax.swing.border.MatteBorder;
import javax.swing.colorchooser.ColorSelectionModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import jp.riken.brain.ni.samuraigraph.base.SGColorDialog;
import jp.riken.brain.ni.samuraigraph.base.SGColorSelectionButton;
import jp.riken.brain.ni.samuraigraph.base.SGComboBox;
import jp.riken.brain.ni.samuraigraph.base.SGPatternPaint;

public class SGPatternPaintDialog
extends JDialog
implements ActionListener,
FocusListener,
ChangeListener {
    private static final long serialVersionUID = 1735316951627888668L;
    protected SGPatternPaint mPatternPaint = null;
    private JPanel mPatternSelectionPanel = null;
    private JLabel mColorSelectionLabel = null;
    private SGColorSelectionButton mColorSelectionButton = null;
    private JLabel mPatternSelectionLabel = null;
    private SGComboBox mPatternSelectionComboBox = null;
    protected SGColorDialog mColorDialog = null;
    protected SGColorSelectionButton mCurrentColorSetButton = null;
    private Icon mColorSelectionButtonEmphasisIcon = null;
    private List<ChangeListener> _listener = new ArrayList<ChangeListener>();
    private ChangeEvent _changeEvent = null;

    public SGPatternPaintDialog(JDialog jDialog, String string, boolean bl) {
        super(jDialog, string, bl);
        this.mPatternPaint = new SGPatternPaint();
        this.initComponents();
        this.initProperty();
        this.initialize();
    }

    private void initComponents() {
        this.getContentPane().setLayout(new BorderLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.mPatternSelectionPanel = new JPanel();
        this.mColorSelectionLabel = new JLabel();
        this.mColorSelectionButton = new SGColorSelectionButton();
        this.mPatternSelectionLabel = new JLabel();
        this.mPatternSelectionComboBox = new SGComboBox();
        this.mPatternSelectionPanel.setLayout(new GridBagLayout());
        this.mColorSelectionLabel.setText("Color");
        this.mColorSelectionLabel.setFont(new Font("Dialog", 0, 11));
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 10);
        this.mPatternSelectionPanel.add((Component)this.mColorSelectionLabel, gridBagConstraints);
        this.mColorSelectionButton.setFont(new Font("Dialog", 0, 11));
        this.mColorSelectionButton.setPreferredSize(new Dimension(65, 20));
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 10);
        this.mPatternSelectionPanel.add((Component)this.mColorSelectionButton, gridBagConstraints);
        this.mPatternSelectionLabel.setText("Pattern");
        this.mPatternSelectionLabel.setFont(new Font("Dialog", 0, 11));
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 10);
        this.mPatternSelectionPanel.add((Component)this.mPatternSelectionLabel, gridBagConstraints);
        this.mPatternSelectionComboBox.setPreferredSize(new Dimension(140, 20));
        this.mPatternSelectionComboBox.setFont(new Font("Dialog", 0, 11));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 10);
        this.mPatternSelectionPanel.add((Component)this.mPatternSelectionComboBox, gridBagConstraints);
        this.add((Component)this.mPatternSelectionPanel, "Center");
    }

    private boolean initProperty() {
        String[] stringArray = SGPatternPaint.TYPE_PATTERN_NAMES;
        for (int i = 0; i < stringArray.length; ++i) {
            this.mPatternSelectionComboBox.addItem(stringArray[i]);
        }
        this.pack();
        return true;
    }

    protected boolean initialize() {
        this.mColorSelectionButton.addActionListener(this);
        this.mColorSelectionButton.addFocusListener(this);
        this.mPatternSelectionComboBox.addActionListener(this);
        this.mColorDialog = new SGColorDialog(this, "Color Dialog", false);
        this.mColorDialog.pack();
        this.mColorDialog.setResizable(false);
        JColorChooser jColorChooser = this.mColorDialog.getColorChooser();
        ColorSelectionModel colorSelectionModel = jColorChooser.getSelectionModel();
        colorSelectionModel.addChangeListener(this);
        this.mColorSelectionButtonEmphasisIcon = this.createIcon("/resources/Lines.gif");
        this.mColorSelectionButton.setColor(Color.BLACK);
        return true;
    }

    public void dispose() {
        super.dispose();
    }

    public void stateChanged(ChangeEvent changeEvent) {
        Object object = changeEvent.getSource();
        if (this.mCurrentColorSetButton != null && object instanceof ColorSelectionModel) {
            Color color = this.mColorDialog.getSelectedColor();
            this.mCurrentColorSetButton.setColor(color);
            this.firePatternModelChanged();
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.mColorSelectionButton) {
            if (this.mCurrentColorSetButton != null) {
                this.mCurrentColorSetButton.setBorder(this.getUnfocusedBorder());
            }
            this.mCurrentColorSetButton = (SGColorSelectionButton)object;
            this.mCurrentColorSetButton.setBorder(this.getFocusedBorder());
            if (!this.mColorDialog.isVisible()) {
                this.mColorDialog.setSelectedColor(this.mCurrentColorSetButton.getColor());
                this.mColorDialog.setLocation(this.getX() + 20, this.getY() + 20);
                this.mColorDialog.setVisible(true);
            }
        } else if (object == this.mPatternSelectionComboBox) {
            this.firePatternModelChanged();
        }
    }

    public void focusGained(FocusEvent focusEvent) {
        Object object = focusEvent.getSource();
        if (object instanceof SGColorSelectionButton) {
            SGColorSelectionButton sGColorSelectionButton = (SGColorSelectionButton)object;
            sGColorSelectionButton.setBorder(this.getFocusedBorder());
            this.mCurrentColorSetButton = sGColorSelectionButton;
        }
    }

    public void focusLost(FocusEvent focusEvent) {
        Object object = focusEvent.getSource();
        if (object instanceof SGColorSelectionButton) {
            SGColorSelectionButton sGColorSelectionButton = (SGColorSelectionButton)object;
            Component component = focusEvent.getOppositeComponent();
            if (component == null) {
                return;
            }
            boolean bl = this.isColorChooserComponent(component);
            if (!bl) {
                sGColorSelectionButton.setBorder(this.getUnfocusedBorder());
                this.mCurrentColorSetButton = null;
            }
        }
    }

    private boolean isColorChooserComponent(Component component) {
        Container container = component.getParent();
        if (container == null) {
            return false;
        }
        if (this.mColorDialog.equals(container)) {
            return true;
        }
        return this.isColorChooserComponent(container);
    }

    private Border getFocusedBorder() {
        return new MatteBorder(this.mColorSelectionButtonEmphasisIcon);
    }

    private ImageIcon createIcon(String string) {
        if (string == null) {
            return null;
        }
        Class<?> clazz = this.getClass();
        URL uRL = clazz.getResource(string);
        ImageIcon imageIcon = uRL != null ? new ImageIcon(uRL) : new ImageIcon(string);
        return imageIcon;
    }

    private Border getUnfocusedBorder() {
        return new LineBorder(Color.BLACK, 1);
    }

    public void setSelectedPatternPaint(SGPatternPaint sGPatternPaint) {
        if (!this.mPatternPaint.equals(sGPatternPaint)) {
            try {
                this.mPatternPaint = (SGPatternPaint)sGPatternPaint.clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                throw new InternalError();
            }
        }
        Color color = sGPatternPaint.getColor();
        int n = sGPatternPaint.getTypeIndex();
        this.mColorSelectionButton.setColor(color);
        this.mPatternSelectionComboBox.setSelectedItem(SGPatternPaint.getTypeName(n));
    }

    public SGPatternPaint getPatternPaint() {
        Color color = this.mColorSelectionButton.getColor();
        int n = SGPatternPaint.getTypeFromName((String)this.mPatternSelectionComboBox.getSelectedItem());
        SGPatternPaint sGPatternPaint = new SGPatternPaint();
        sGPatternPaint.setColor(color);
        sGPatternPaint.setTypeIndex(n);
        return sGPatternPaint;
    }

    public void addModelChangeListener(ChangeListener changeListener) {
        if (!this._listener.contains(changeListener)) {
            this._listener.add(changeListener);
        }
    }

    protected void firePatternModelChanged() {
        if (null == this._changeEvent) {
            this._changeEvent = new ChangeEvent(this);
        }
        for (ChangeListener changeListener : this._listener) {
            changeListener.stateChanged(this._changeEvent);
        }
    }
}

