/*
 * Decompiled with CFR 0.152.
 */
package jp.riken.brain.ni.samuraigraph.base;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.GraphicsConfiguration;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JFormattedTextField;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import javax.swing.border.Border;
import javax.swing.border.LineBorder;
import javax.swing.border.MatteBorder;
import javax.swing.colorchooser.ColorSelectionModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import jp.riken.brain.ni.samuraigraph.base.SGColorDialog;
import jp.riken.brain.ni.samuraigraph.base.SGColorSelectionButton;
import jp.riken.brain.ni.samuraigraph.base.SGDialog;
import jp.riken.brain.ni.samuraigraph.base.SGIDrawingElementConstants;
import jp.riken.brain.ni.samuraigraph.base.SGIPropertyDialogObserver;
import jp.riken.brain.ni.samuraigraph.base.SGSpinner;
import jp.riken.brain.ni.samuraigraph.base.SGTextField;
import jp.riken.brain.ni.samuraigraph.base.SGUtility;

public abstract class SGPropertyDialog
extends SGDialog
implements ChangeListener,
FocusListener,
SGIDrawingElementConstants {
    private static final long serialVersionUID = 214371996196142459L;
    protected List<SGIPropertyDialogObserver> mPropertyDialogObserverList = new ArrayList<SGIPropertyDialogObserver>();
    private Icon mColorSelectionButtonEmphasisIcon = null;
    protected SGColorDialog mColorDialog = null;
    protected SGColorSelectionButton mCurrentColorSetButton = null;
    public static final String NOTIFY_ACTION_COMMIT = "Notify action commit";
    public static final String NOTIFY_ACTION_PREVIEW = "Notify action preview";
    public static final String NOTIFY_ACTION_CANCEL = "Notify action cancel";
    protected String mCommitActionStateMessage = null;
    private String mInputErrorMessage = "";
    private final ArrayList mInputErrorComponentNameList = new ArrayList();
    private static final String ERR_MSG_HEADER = "The input values are illegal in the following components:\n";
    protected static final String DEFAULT_INPUT_ERROR_MESSAGE = "The input value is illegal.";
    public static final String ERRMSG_AXIS_VALUE_INVALID = "Axis value is invalid";

    public SGPropertyDialog() {
    }

    public SGPropertyDialog(Dialog dialog) {
        super(dialog);
    }

    public SGPropertyDialog(Dialog dialog, boolean bl) {
        super(dialog, bl);
    }

    public SGPropertyDialog(Dialog dialog, String string) {
        super(dialog, string);
    }

    public SGPropertyDialog(Dialog dialog, String string, boolean bl) {
        super(dialog, string, bl);
    }

    public SGPropertyDialog(Dialog dialog, String string, boolean bl, GraphicsConfiguration graphicsConfiguration) {
        super(dialog, string, bl, graphicsConfiguration);
    }

    public SGPropertyDialog(Frame frame) {
        super(frame);
    }

    public SGPropertyDialog(Frame frame, boolean bl) {
        super(frame, bl);
    }

    public SGPropertyDialog(Frame frame, String string) {
        super(frame, string);
    }

    public SGPropertyDialog(Frame frame, String string, boolean bl) {
        super(frame, string, bl);
    }

    public SGPropertyDialog(Frame frame, String string, boolean bl, GraphicsConfiguration graphicsConfiguration) {
        super(frame, string, bl, graphicsConfiguration);
    }

    protected boolean initialize() {
        JButton jButton;
        this.mColorDialog = new SGColorDialog(this, "Color Dialog", false);
        this.mColorDialog.pack();
        this.mColorDialog.setResizable(false);
        JColorChooser jColorChooser = this.mColorDialog.getColorChooser();
        ColorSelectionModel colorSelectionModel = jColorChooser.getSelectionModel();
        colorSelectionModel.addChangeListener(this);
        this.mColorDialog.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
            }
        });
        this.mColorSelectionButtonEmphasisIcon = this.createIcon("/resources/Lines.gif");
        List list = this.getColorSelectionButtonsList();
        for (int i = 0; i < list.size(); ++i) {
            SGColorSelectionButton sGColorSelectionButton = (SGColorSelectionButton)list.get(i);
            sGColorSelectionButton.addFocusListener(this);
        }
        List list2 = this.getColorSelectionButtonsList();
        for (int i = 0; i < list2.size(); ++i) {
            Object e = list2.get(i);
            jButton = (JButton)e;
            jButton.addActionListener(this);
        }
        List list3 = this.getTextFieldComponentsList();
        for (int i = 0; i < list3.size(); ++i) {
            jButton = list3.get(i);
            JTextField jTextField = (JTextField)((Object)jButton);
            jTextField.addActionListener(this);
        }
        this.getOKButton().addActionListener(this);
        this.getCancelButton().addActionListener(this);
        this.getPreviewButton().addActionListener(this);
        return true;
    }

    protected void onEscKeyTyped() {
        this.onCanceled();
    }

    public void dispose() {
        this.mColorDialog = null;
        super.dispose();
    }

    private ImageIcon createIcon(String string) {
        if (string == null) {
            return null;
        }
        Class<?> clazz = this.getClass();
        URL uRL = clazz.getResource(string);
        ImageIcon imageIcon = uRL != null ? new ImageIcon(uRL) : new ImageIcon(string);
        return imageIcon;
    }

    protected String getString(String string) {
        ResourceBundle resourceBundle = ResourceBundle.getBundle("res", Locale.JAPAN);
        String string2 = resourceBundle.getString(string);
        return string2;
    }

    public SGColorDialog getColorDialog() {
        return this.mColorDialog;
    }

    public void stateChanged(ChangeEvent changeEvent) {
        Object object = changeEvent.getSource();
        if (this.mCurrentColorSetButton != null && object instanceof ColorSelectionModel) {
            Color color = this.mColorDialog.getSelectedColor();
            this.mCurrentColorSetButton.setColor(color);
        }
    }

    public void setVisible(boolean bl) {
        if (!bl && this.mColorDialog != null) {
            this.mColorDialog.setVisible(false);
        }
        super.setVisible(bl);
    }

    public abstract List getColorSelectionButtonsList();

    public abstract List getTextFieldComponentsList();

    public abstract List getNumberTextFieldList();

    public abstract List getSpinnerList();

    protected List getFormattedTextFieldsListFromSpinners() {
        ArrayList<JFormattedTextField> arrayList = new ArrayList<JFormattedTextField>();
        List list = this.getSpinnerList();
        for (int i = 0; i < list.size(); ++i) {
            SGSpinner sGSpinner = (SGSpinner)list.get(i);
            arrayList.add(sGSpinner.getFormattedTextField());
        }
        return arrayList;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (this.getColorSelectionButtonsList().contains(object)) {
            SGColorSelectionButton sGColorSelectionButton = (SGColorSelectionButton)object;
            if (this.mCurrentColorSetButton != null) {
                this.mCurrentColorSetButton.setBorder(this.getUnfocusedBorder());
            }
            this.mCurrentColorSetButton = sGColorSelectionButton;
            this.mCurrentColorSetButton.setBorder(this.getFocusedBorder());
            if (!this.mColorDialog.isVisible()) {
                if (this.mCurrentColorSetButton != null) {
                    this.mColorDialog.setSelectedColor(this.mCurrentColorSetButton.getColor());
                }
                this.mColorDialog.setLocation(this.getX() + 20, this.getY() + 20);
                this.mColorDialog.setVisible(true);
            }
        } else {
            try {
                List list = this.getTextFieldComponentsList();
                if (object.equals(this.getOKButton()) || list.contains(object)) {
                    this.onOK();
                } else if (object.equals(this.getCancelButton())) {
                    this.onCanceled();
                } else if (object.equals(this.getPreviewButton())) {
                    this.onPreviewed();
                }
            }
            catch (Exception exception) {
                SGUtility.showErrorMessageDialog(this, "Unknown error occurred.\b This dialog will be closed.", "ERROR");
                this.setVisible(false);
                this.clearAllSpinners();
            }
        }
    }

    protected abstract JButton getOKButton();

    protected abstract JButton getCancelButton();

    protected abstract JButton getPreviewButton();

    public static SpinnerNumberModel getLineWidthSpinnerNumberModel() {
        return new SpinnerNumberModel(0.25, 0.25, 6.0, 0.25);
    }

    public static SpinnerNumberModel getFontSizeSpinnerNumberModel() {
        return new SpinnerNumberModel(6.0, 6.0, 96.0, 1.0);
    }

    public boolean addPropertyDialogObserver(SGIPropertyDialogObserver sGIPropertyDialogObserver) {
        this.mPropertyDialogObserverList.add(sGIPropertyDialogObserver);
        return true;
    }

    public boolean removePropertyDialogObserver(SGIPropertyDialogObserver sGIPropertyDialogObserver) {
        return this.mPropertyDialogObserverList.remove(sGIPropertyDialogObserver);
    }

    public boolean removeAllPropertyDialogObserver() {
        this.mPropertyDialogObserverList.clear();
        return true;
    }

    protected boolean onOK() {
        if (!this.commit()) {
            return false;
        }
        this.setCloseOption(0);
        this.setVisible(false);
        this.clearAllSpinners();
        return true;
    }

    protected boolean onCanceled() {
        if (!this.cancel()) {
            return false;
        }
        this.setCloseOption(1);
        this.setVisible(false);
        this.clearAllSpinners();
        return true;
    }

    protected boolean onPreviewed() {
        return this.preview();
    }

    protected void clearAllSpinners() {
        List list = this.getSpinnerList();
        for (int i = 0; i < list.size(); ++i) {
            SGSpinner sGSpinner = (SGSpinner)list.get(i);
            sGSpinner.clearTemporaryValues();
        }
    }

    protected boolean commit() {
        this.mCommitActionStateMessage = NOTIFY_ACTION_COMMIT;
        if (!this.checkInputValues()) {
            return false;
        }
        List<SGIPropertyDialogObserver> list = this.mPropertyDialogObserverList;
        for (int i = 0; i < list.size(); ++i) {
            SGIPropertyDialogObserver sGIPropertyDialogObserver = list.get(i);
            if (!this.setPropertiesToListeners(sGIPropertyDialogObserver)) {
                String string = this.getInputErrorMessage();
                String string2 = string != null ? string : DEFAULT_INPUT_ERROR_MESSAGE;
                SGUtility.showIllegalInputErrorMessageDialog(this, string2);
                return false;
            }
            if (sGIPropertyDialogObserver.commit()) continue;
            return false;
        }
        return true;
    }

    protected boolean cancel() {
        this.mCommitActionStateMessage = NOTIFY_ACTION_CANCEL;
        List<SGIPropertyDialogObserver> list = this.mPropertyDialogObserverList;
        for (int i = 0; i < list.size(); ++i) {
            SGIPropertyDialogObserver sGIPropertyDialogObserver = list.get(i);
            if (sGIPropertyDialogObserver.cancel()) continue;
            return false;
        }
        return true;
    }

    protected boolean preview() {
        this.mCommitActionStateMessage = NOTIFY_ACTION_PREVIEW;
        if (!this.checkInputValues()) {
            return false;
        }
        List<SGIPropertyDialogObserver> list = this.mPropertyDialogObserverList;
        for (int i = 0; i < list.size(); ++i) {
            SGIPropertyDialogObserver sGIPropertyDialogObserver = list.get(i);
            if (!this.setPropertiesToListeners(sGIPropertyDialogObserver)) {
                String string = this.getInputErrorMessage();
                String string2 = string != null ? string : DEFAULT_INPUT_ERROR_MESSAGE;
                SGUtility.showIllegalInputErrorMessageDialog(this, string2);
                return false;
            }
            if (sGIPropertyDialogObserver.preview()) continue;
            return false;
        }
        return true;
    }

    private boolean checkInputValues() {
        if (!this.hasValidInputValues()) {
            String string = this.getInputErrorMessage();
            SGUtility.showIllegalInputErrorMessageDialog(this, string);
            return false;
        }
        return true;
    }

    protected boolean hasValidInputValues() {
        boolean bl = true;
        this.mInputErrorComponentNameList.clear();
        List list = this.getSpinnerList();
        for (int i = 0; i < list.size(); ++i) {
            SGSpinner sGSpinner = (SGSpinner)list.get(i);
            if (sGSpinner.hasValidValue()) continue;
            this.addInputErrorDescription(sGSpinner.getDescription());
            bl = false;
        }
        return bl;
    }

    protected boolean hasValidNumber(SGTextField sGTextField, Number number, Number number2) {
        boolean bl = true;
        boolean bl2 = false;
        if (sGTextField.isIndeterminate()) {
            if (sGTextField.getText() != null) {
                bl2 = true;
            }
        } else {
            bl2 = true;
        }
        if (bl2) {
            String string = sGTextField.getDescription();
            Number number3 = this.getNumber(sGTextField);
            if (number3 != null) {
                if (Double.isNaN(number3.doubleValue())) {
                    this.addInputErrorDescription(string);
                    bl = false;
                } else {
                    if (number != null && number3.doubleValue() < number.doubleValue()) {
                        this.addInputErrorDescription(string);
                        bl = false;
                    }
                    if (bl && number2 != null && number3.doubleValue() > number2.doubleValue()) {
                        this.addInputErrorDescription(string);
                        bl = false;
                    }
                }
            } else {
                this.addInputErrorDescription(string);
                bl = false;
            }
        }
        return bl;
    }

    protected String getInputErrorMessage() {
        if (this.mInputErrorComponentNameList.size() != 0) {
            ArrayList arrayList = this.mInputErrorComponentNameList;
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(ERR_MSG_HEADER);
            for (int i = 0; i < arrayList.size(); ++i) {
                String string = (String)arrayList.get(i);
                stringBuffer.append(" - ");
                stringBuffer.append(string);
                stringBuffer.append('\n');
            }
            return stringBuffer.toString();
        }
        return this.mInputErrorMessage;
    }

    protected boolean addInputErrorDescription(String string) {
        this.mInputErrorComponentNameList.add(string);
        return true;
    }

    protected boolean setInputErrorMessage(String string) {
        this.mInputErrorMessage = string;
        return true;
    }

    public abstract boolean setPropertiesToListeners(SGIPropertyDialogObserver var1);

    public abstract boolean setDialogProperty();

    public void windowClosing(WindowEvent windowEvent) {
        super.windowClosing(windowEvent);
        this.onCanceled();
    }

    protected boolean setValue(SGTextField sGTextField, Object object) {
        return SGUtility.setValue(sGTextField, object);
    }

    protected boolean setValue(SGSpinner sGSpinner, Object object) {
        return SGUtility.setValue(sGSpinner, object);
    }

    public void focusGained(FocusEvent focusEvent) {
        Object object = focusEvent.getSource();
        if (object instanceof SGColorSelectionButton) {
            SGColorSelectionButton sGColorSelectionButton = (SGColorSelectionButton)object;
            sGColorSelectionButton.setBorder(this.getFocusedBorder());
            this.mCurrentColorSetButton = sGColorSelectionButton;
        }
    }

    public void focusLost(FocusEvent focusEvent) {
        Object object = focusEvent.getSource();
        if (object instanceof SGColorSelectionButton) {
            SGColorSelectionButton sGColorSelectionButton = (SGColorSelectionButton)object;
            Component component = focusEvent.getOppositeComponent();
            if (component == null) {
                return;
            }
            boolean bl = this.isColorChooserComponent(component);
            if (!bl) {
                sGColorSelectionButton.setBorder(this.getUnfocusedBorder());
                this.mCurrentColorSetButton = null;
            }
        }
    }

    private boolean isColorChooserComponent(Component component) {
        Container container = component.getParent();
        if (container == null) {
            return false;
        }
        if (this.mColorDialog.equals(container)) {
            return true;
        }
        return this.isColorChooserComponent(container);
    }

    private Border getFocusedBorder() {
        return new MatteBorder(this.mColorSelectionButtonEmphasisIcon);
    }

    private Border getUnfocusedBorder() {
        return new LineBorder(Color.BLACK, 1);
    }
}

