/*
 * Decompiled with CFR 0.152.
 */
package jp.riken.brain.ni.samuraigraph.base;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.DecimalFormat;
import javax.swing.JPanel;
import javax.swing.Timer;
import javax.swing.border.EmptyBorder;
import javax.swing.border.EtchedBorder;
import jp.riken.brain.ni.samuraigraph.base.SGDrawingWindow;
import jp.riken.brain.ni.samuraigraph.base.SGIConstants;
import jp.riken.brain.ni.samuraigraph.base.SGIProgressControl;
import jp.riken.brain.ni.samuraigraph.base.SGProgressBar;
import jp.riken.brain.ni.samuraigraph.base.SGUtility;

public class SGStatusBar
extends JPanel
implements SGIConstants,
SGIProgressControl {
    private static final long serialVersionUID = -6426045627363525268L;
    private ProgressPanel mProgressPanel;
    private MessagePanel mMessagePanel;
    private PositionPanel mPositionPanal;
    private boolean mSavedFlag = false;
    private String mMessage = "";
    private static final int STATUS_BAR_WIDTH = 18;
    private static final String STATUS_BAR_CHANGED_LABEL = "*";

    public SGStatusBar(SGDrawingWindow sGDrawingWindow) {
        this.setVisible(true);
        this.setOpaque(true);
        this.setBackground(sGDrawingWindow.getBackground());
        boolean bl = false;
        String string = SGUtility.getLookAndFeelID();
        if ("Aqua".equals(string)) {
            bl = true;
        }
        this.setBorder(new EmptyBorder(0, 0, 0, bl ? 18 : 0));
        this.setSize(0, 18);
        ProgressPanel progressPanel = new ProgressPanel();
        MessagePanel messagePanel = new MessagePanel();
        PositionPanel positionPanel = new PositionPanel();
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(2, 0, 0, 2);
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)progressPanel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(2, 0, 0, 2);
        this.add((Component)messagePanel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(2, 0, 0, 0);
        this.add((Component)positionPanel, gridBagConstraints);
        this.mProgressPanel = progressPanel;
        this.mMessagePanel = messagePanel;
        this.mPositionPanal = positionPanel;
    }

    public void setProgressValue(float f) {
        this.mProgressPanel.setProgressValue(f);
    }

    public boolean startProgress() {
        this.setMessage("");
        return this.mProgressPanel.startProgress();
    }

    public boolean endProgress() {
        this.setMessage("");
        return this.mProgressPanel.endProgress();
    }

    public void setIndeterminateProgress(boolean bl) {
        this.mProgressPanel.setIndeterminateProgress(bl);
    }

    public void setProgressMessage(String string) {
        this.setMessage(string);
    }

    public void drawPosition(float f, float f2) {
        DecimalFormat decimalFormat = new DecimalFormat("0.0");
        String string = decimalFormat.format(f) + " : " + decimalFormat.format(f2);
        this.mPositionPanal.setText(string);
        this.repaint();
    }

    public void setMessage(String string) {
        String string2 = string;
        if (string.equals("")) {
            string2 = this.mSavedFlag ? STATUS_BAR_CHANGED_LABEL : "";
        }
        this.mMessagePanel.setText(string2);
        this.mMessage = string;
        this.repaint();
    }

    public void setSaved(boolean bl) {
        String string = bl ? STATUS_BAR_CHANGED_LABEL : "";
        this.mSavedFlag = bl;
        if (this.mMessage.equals("")) {
            this.mMessagePanel.setText(string);
        }
    }

    private static class StatusPanel
    extends JPanel {
        private static final long serialVersionUID = 4682736556541214505L;
        protected String mString = "";
        private static final int FONT_SIZE = 12;

        private StatusPanel() {
            this.setBorder(new EtchedBorder(1));
            this.setFont(new Font("Dialog", 0, 12));
        }

        public void paintComponent(Graphics graphics) {
            super.paintComponent(graphics);
            Graphics2D graphics2D = (Graphics2D)graphics;
            graphics2D.drawString(this.mString, 6, 13);
        }

        protected void setText(String string) {
            this.mString = string;
        }
    }

    private static class PositionPanel
    extends StatusPanel {
        private static final long serialVersionUID = 4728894476527846504L;

        private PositionPanel() {
            this.setPreferredSize(new Dimension(80, 18));
            this.mString = "0.0 : 0.0";
        }
    }

    private static class ProgressPanel
    extends StatusPanel {
        private static final long serialVersionUID = 7911685209399341546L;
        private SGProgressBar mProgressBar = new SGProgressBar();
        private Timer timer;
        private float mCurrentValue = 0.0f;
        private boolean mEndFlag = true;

        private ProgressPanel() {
            this.setPreferredSize(new Dimension(0, 18));
            this.setLayout(new BorderLayout());
            this.add((Component)this.mProgressBar, "Center");
            this.timer = new Timer(100, new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    ProgressPanel.this.mProgressBar.setProgressValue(ProgressPanel.this.mCurrentValue);
                    ProgressPanel.this.mProgressBar.paintImmediately(ProgressPanel.this.mProgressBar.getVisibleRect());
                    if (ProgressPanel.this.mEndFlag) {
                        ProgressPanel.this.timer.stop();
                        ProgressPanel.this.mProgressBar.initProgressValue();
                    }
                }
            });
        }

        private boolean startProgress() {
            if (!this.mEndFlag) {
                return false;
            }
            this.mEndFlag = false;
            this.mCurrentValue = 0.0f;
            if (this.mProgressBar.isIndeterminate()) {
                this.setIndeterminateProgress(false);
            }
            this.timer.start();
            return true;
        }

        private boolean endProgress() {
            if (this.mEndFlag) {
                return false;
            }
            if (this.mProgressBar.isIndeterminate()) {
                this.setIndeterminateProgress(false);
            }
            this.mEndFlag = true;
            return true;
        }

        private void setProgressValue(float f) {
            this.setIndeterminateProgress(false);
            this.mCurrentValue = f;
        }

        private void setIndeterminateProgress(boolean bl) {
            this.mProgressBar.setIndeterminate(bl);
        }
    }

    private static class MessagePanel
    extends StatusPanel {
        private static final long serialVersionUID = -6437538220874018805L;

        private MessagePanel() {
            this.setPreferredSize(new Dimension(120, 18));
        }
    }
}

