/*
 * Decompiled with CFR 0.152.
 */
package jp.riken.brain.ni.samuraigraph.base;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import jp.riken.brain.ni.samuraigraph.base.SGIDisposable;
import jp.riken.brain.ni.samuraigraph.base.SGIUndoable;
import jp.riken.brain.ni.samuraigraph.base.SGProperties;

public class SGUndoManager
implements SGIDisposable {
    private SGIUndoable mUndoable = null;
    private List mMementoList = new ArrayList();
    private int mMementoCounter = 0;
    private List mChangedObjectListList = new ArrayList();
    private int mChangedObjectListCounter = 0;
    private boolean mChangedFlag = false;
    private boolean mDisposed = false;

    public SGUndoManager(SGIUndoable sGIUndoable) {
        this.mUndoable = sGIUndoable;
    }

    public boolean initPropertiesHistory() {
        return this.addMemento(this.mUndoable.getMemento());
    }

    public boolean setMementoBackward() {
        --this.mMementoCounter;
        return this.setCurrentMemento();
    }

    public boolean setMementoForward() {
        ++this.mMementoCounter;
        return this.setCurrentMemento();
    }

    private boolean setCurrentMemento() {
        SGProperties sGProperties = (SGProperties)this.mMementoList.get(this.mMementoCounter);
        return this.mUndoable.setMemento(sGProperties);
    }

    public boolean undo() {
        if (!this.isUndoable()) {
            return false;
        }
        ArrayList arrayList = (ArrayList)this.mChangedObjectListList.get(this.mChangedObjectListCounter - 1);
        for (int i = 0; i < arrayList.size(); ++i) {
            SGIUndoable sGIUndoable = (SGIUndoable)arrayList.get(i);
            boolean bl = sGIUndoable.equals(this.mUndoable) ? this.mUndoable.setMementoBackward() : sGIUndoable.undo();
            if (bl) continue;
            throw new Error("undo erorr:" + sGIUndoable);
        }
        --this.mChangedObjectListCounter;
        return true;
    }

    public boolean redo() {
        if (!this.isRedoable()) {
            return false;
        }
        ArrayList arrayList = (ArrayList)this.mChangedObjectListList.get(this.mChangedObjectListCounter);
        for (int i = 0; i < arrayList.size(); ++i) {
            SGIUndoable sGIUndoable = (SGIUndoable)arrayList.get(i);
            boolean bl = sGIUndoable.equals(this.mUndoable) ? this.mUndoable.setMementoForward() : sGIUndoable.redo();
            if (bl) continue;
            throw new Error("redo erorr:" + sGIUndoable);
        }
        ++this.mChangedObjectListCounter;
        return true;
    }

    private boolean updateObjectHistory(List list) {
        ArrayList arrayList = new ArrayList(this.mChangedObjectListList.subList(0, this.mChangedObjectListCounter));
        arrayList.add(new ArrayList(list));
        this.mChangedObjectListList = arrayList;
        ++this.mChangedObjectListCounter;
        return true;
    }

    public boolean updateHistory() {
        if (this.mUndoable.isChanged()) {
            if (!this.updateMementoList()) {
                return false;
            }
            ArrayList<SGIUndoable> arrayList = new ArrayList<SGIUndoable>();
            arrayList.add(this.mUndoable);
            if (!this.updateObjectHistory(arrayList)) {
                return false;
            }
        }
        return true;
    }

    public boolean updateHistory(List list) {
        ArrayList<SGIUndoable> arrayList = new ArrayList<SGIUndoable>();
        if (this.mUndoable.isChanged()) {
            if (!this.updateMementoList()) {
                return false;
            }
            arrayList.add(this.mUndoable);
        }
        for (int i = 0; i < list.size(); ++i) {
            SGIUndoable sGIUndoable = (SGIUndoable)list.get(i);
            if (!sGIUndoable.isChangedRoot()) continue;
            if (!sGIUndoable.updateHistory()) {
                return false;
            }
            arrayList.add(sGIUndoable);
        }
        return arrayList.size() == 0 || this.updateObjectHistory(arrayList);
    }

    private boolean updateMementoList() {
        ++this.mMementoCounter;
        SGProperties sGProperties = this.mUndoable.getMemento();
        if (sGProperties == null) {
            return false;
        }
        return this.addMemento(sGProperties);
    }

    private boolean addMemento(SGProperties sGProperties) {
        for (int i = this.mMementoList.size() - 1; i >= this.mMementoCounter; --i) {
            SGProperties sGProperties2 = (SGProperties)this.mMementoList.remove(i);
            sGProperties2.dispose();
            sGProperties2 = null;
        }
        this.mMementoList.add(sGProperties);
        return true;
    }

    public boolean isUndoable() {
        return this.mChangedObjectListCounter != 0;
    }

    public boolean isRedoable() {
        return this.mChangedObjectListCounter != this.mChangedObjectListList.size();
    }

    public List getMementoList() {
        return new ArrayList(this.mMementoList);
    }

    public List getChangedObjectListList() {
        return new ArrayList(this.mChangedObjectListList);
    }

    public int getChangedObjectListIndex() {
        return this.mChangedObjectListCounter;
    }

    public int getMementoIndex() {
        return this.mMementoCounter;
    }

    public void dispose() {
        this.clear();
        this.mUndoable = null;
        this.mChangedObjectListList = null;
        this.mMementoList = null;
    }

    public boolean isDisposed() {
        return this.mDisposed;
    }

    public void initUndoBuffer() {
        this.clear();
        this.initPropertiesHistory();
    }

    private void clear() {
        List list = this.mMementoList;
        for (int i = 0; i < list.size(); ++i) {
            SGProperties sGProperties = (SGProperties)list.get(i);
            sGProperties.dispose();
        }
        this.mMementoList.clear();
        this.mChangedObjectListList.clear();
        this.mChangedObjectListCounter = 0;
        this.mMementoCounter = 0;
        list = null;
    }

    public void setChanged(boolean bl) {
        this.mChangedFlag = bl;
    }

    public boolean isChanged() {
        return this.mChangedFlag;
    }

    void dump() {
        System.out.println(this.mChangedObjectListList);
        System.out.println("size=" + this.mChangedObjectListList.size());
        System.out.println(this.mChangedObjectListCounter);
        System.out.println(this.mMementoList);
        System.out.println("size=" + this.mMementoList.size());
        System.out.println(this.mMementoCounter);
        System.out.println();
    }

    public boolean deleteForwardHistory() {
        Object object;
        int n;
        HashSet hashSet = new HashSet();
        for (n = this.mChangedObjectListList.size() - 1; n >= this.mChangedObjectListCounter; --n) {
            object = (List)this.mChangedObjectListList.remove(n);
            hashSet.addAll(object);
            object.clear();
        }
        for (n = this.mMementoList.size() - 1; n > this.mMementoCounter; --n) {
            object = (SGProperties)this.mMementoList.remove(n);
            ((SGProperties)object).dispose();
            object = null;
        }
        return true;
    }
}

