/*
 * Decompiled with CFR 0.152.
 */
package jp.riken.brain.ni.samuraigraph.base;

import java.awt.Color;
import java.awt.Dimension;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.DateFormat;
import java.text.NumberFormat;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import javax.print.attribute.standard.MediaSize;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import jp.riken.brain.ni.samuraigraph.base.SGCSVTokenizer;
import jp.riken.brain.ni.samuraigraph.base.SGIConstants;
import jp.riken.brain.ni.samuraigraph.base.SGIDrawingElementConstants;
import jp.riken.brain.ni.samuraigraph.base.SGIPropertyFileConstants;
import org.w3c.dom.Document;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SGUtilityText
implements SGIConstants,
SGIDrawingElementConstants,
SGIPropertyFileConstants {
    public static final String[] DEFAULT_DATE_FORMAT_ARRAY = new String[]{"yy/MM/dd", "yy.MM.dd", "yy-MM-dd", "yyyyMMdd", "yyMMdd", "yy MM dd", "yyyy MM dd"};
    private static final List<DateFormat> DATE_FORMAT_ARRAY_LIST = new ArrayList<DateFormat>();
    private static EntityResolver mPropertyEntityResolver = new PropertyEntityResolver();
    public static final Color[] DEFAULT_COLORS = new Color[]{Color.RED, Color.GREEN, Color.BLUE, Color.CYAN, Color.MAGENTA, Color.YELLOW, Color.ORANGE, Color.PINK, Color.WHITE, Color.LIGHT_GRAY, Color.GRAY, Color.DARK_GRAY, Color.BLACK};
    public static final String[] DEFAULT_COLOR_NAMES = new String[]{"RED", "GREEN", "BLUE", "CYAN", "MAGENTA", "YELLOW", "ORANGE", "PINK", "WHITE", "LIGHT_GRAY", "GRAY", "DARK_GRAY", "BLACK"};

    public static String getSuperscriptString(String string, String string2) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(string);
        stringBuffer.append("^{");
        stringBuffer.append(string2);
        stringBuffer.append("}");
        return stringBuffer.toString();
    }

    public static String getSubscriptString(String string, String string2) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(string);
        stringBuffer.append("_{");
        stringBuffer.append(string2);
        stringBuffer.append("}");
        return stringBuffer.toString();
    }

    public static boolean getSubscriptAndSuperscriptInfo(String string, ArrayList arrayList, ArrayList arrayList2, ArrayList arrayList3) {
        if (string == null || arrayList == null || arrayList2 == null || arrayList3 == null) {
            return false;
        }
        if (string.length() == 0) {
            return false;
        }
        int n = string.length();
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        int n2 = 0;
        StringBuffer stringBuffer = new StringBuffer();
        StringBuffer stringBuffer2 = new StringBuffer();
        StringBuffer stringBuffer3 = new StringBuffer();
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (bl || bl2) {
                if (bl3) {
                    if (bl4) {
                        if (bl) {
                            stringBuffer2.append('\\');
                            stringBuffer2.append(c);
                        } else {
                            stringBuffer3.append('\\');
                            stringBuffer3.append(c);
                        }
                        bl4 = false;
                        continue;
                    }
                    if (c == '\\') {
                        bl4 = true;
                        continue;
                    }
                    if (c == '}' && n2 == 0) {
                        bl3 = false;
                        bl = false;
                        bl2 = false;
                        continue;
                    }
                    if (c == '}') {
                        --n2;
                    }
                    if (c == '{') {
                        ++n2;
                    }
                    if (bl) {
                        stringBuffer2.append(c);
                        continue;
                    }
                    stringBuffer3.append(c);
                    continue;
                }
                if (c == '{') {
                    bl3 = true;
                    n2 = 0;
                    continue;
                }
                if (!bl4) {
                    if (c == '\\') {
                        bl4 = true;
                        continue;
                    }
                    if (bl) {
                        stringBuffer2.append(c);
                        bl = false;
                        continue;
                    }
                    stringBuffer3.append(c);
                    bl2 = false;
                    continue;
                }
                if (bl) {
                    stringBuffer2.append('\\');
                    stringBuffer2.append(c);
                    bl = false;
                } else {
                    stringBuffer3.append('\\');
                    stringBuffer3.append(c);
                    bl2 = false;
                }
                bl4 = false;
                continue;
            }
            if (c == '^' && !bl4) {
                if (stringBuffer.length() == 0 || stringBuffer2.length() != 0) {
                    return false;
                }
                bl = true;
                continue;
            }
            if (c == '_' && !bl4) {
                if (stringBuffer.length() == 0 || stringBuffer3.length() != 0) {
                    return false;
                }
                bl2 = true;
                continue;
            }
            if (c == '\\' && !bl4) {
                bl4 = true;
                continue;
            }
            if (stringBuffer2.length() != 0 || stringBuffer3.length() != 0) {
                arrayList.add(stringBuffer.toString());
                if (stringBuffer2.length() != 0) {
                    arrayList2.add(stringBuffer2.toString());
                } else {
                    arrayList2.add(null);
                }
                if (stringBuffer3.length() != 0) {
                    arrayList3.add(stringBuffer3.toString());
                } else {
                    arrayList3.add(null);
                }
                stringBuffer.setLength(0);
                stringBuffer2.setLength(0);
                stringBuffer3.setLength(0);
            }
            stringBuffer.append(c);
            bl4 = false;
        }
        if (bl || bl2 || bl3 || bl4) {
            return false;
        }
        if (stringBuffer.length() != 0) {
            arrayList.add(stringBuffer.toString());
            if (stringBuffer2.length() != 0) {
                arrayList2.add(stringBuffer2.toString());
            } else {
                arrayList2.add(null);
            }
            if (stringBuffer3.length() != 0) {
                arrayList3.add(stringBuffer3.toString());
            } else {
                arrayList3.add(null);
            }
        }
        return true;
    }

    public static final String unescapeString(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (bl) {
                stringBuffer.append(c);
                bl = false;
                continue;
            }
            if (c == '\\') {
                bl = true;
                continue;
            }
            stringBuffer.append(c);
        }
        return stringBuffer.toString();
    }

    public static boolean tokenize(String string, List<SGCSVTokenizer.Token> list, boolean bl) {
        if (string == null || list == null) {
            throw new IllegalArgumentException("str==null || tokenList==null");
        }
        if (string.length() == 0) {
            return true;
        }
        if (SGUtilityText.count(string, '\"') % 2 != 0) {
            return false;
        }
        SGCSVTokenizer sGCSVTokenizer = new SGCSVTokenizer(string, bl);
        while (sGCSVTokenizer.hasMoreTokens()) {
            try {
                SGCSVTokenizer.Token token = sGCSVTokenizer.nextToken();
                list.add(token);
            }
            catch (NoSuchElementException noSuchElementException) {}
        }
        return true;
    }

    public static String createString(ArrayList arrayList) {
        char[] cArray = new char[arrayList.size()];
        for (int i = 0; i < cArray.length; ++i) {
            cArray[i] = ((Character)arrayList.get(i)).charValue();
        }
        String string = new String(cArray);
        return string;
    }

    public static String readLine(BufferedReader bufferedReader) {
        String string = null;
        try {
            while ((string = bufferedReader.readLine()) != null) {
                boolean bl = true;
                char[] cArray = string.toCharArray();
                for (int i = 0; i < string.length(); ++i) {
                    if (Character.isSpaceChar(cArray[i])) continue;
                    bl = false;
                    break;
                }
                if (bl || string.length() == 0) continue;
                break;
            }
        }
        catch (IOException iOException) {
            return null;
        }
        return string;
    }

    public static String getColorListString(List list) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append('{');
        for (int i = 0; i < list.size(); ++i) {
            Color color = (Color)list.get(i);
            String string = SGUtilityText.getColorString(color);
            stringBuffer.append(string);
            if (i != list.size() - 1) {
                stringBuffer.append(',');
                continue;
            }
            stringBuffer.append('}');
        }
        return stringBuffer.toString();
    }

    public static boolean writeColorListPropertyLine(Writer writer, String string, List list) throws IOException {
        writer.write(string);
        writer.write("=");
        String string2 = SGUtilityText.getColorListString(list);
        writer.write(string2);
        writer.write("\n");
        return true;
    }

    public static String getInnerString(String string, int n, int n2) {
        if (string == null) {
            return null;
        }
        if (string.length() < 2) {
            return null;
        }
        int n3 = string.indexOf(n) + 1;
        if (n3 == -1) {
            return null;
        }
        int n4 = string.lastIndexOf(n2);
        if (n4 == -1) {
            return null;
        }
        if (n4 <= n3) {
            return null;
        }
        String string2 = string.substring(n3, n4);
        return string2;
    }

    public static String[] getStringsInBracket(String string) {
        if (string == null) {
            return null;
        }
        String string2 = SGUtilityText.getInnerString(string, 40, 41);
        if (string2 == null) {
            return null;
        }
        String[] stringArray = string2.split(",");
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = stringArray[i].trim();
        }
        return stringArray;
    }

    public static int[] getIntegerArray(String string) {
        if (string == null) {
            return null;
        }
        String[] stringArray = SGUtilityText.getStringsInBracket(string);
        if (stringArray == null) {
            return null;
        }
        int[] nArray = new int[stringArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            Integer n = SGUtilityText.getInteger(stringArray[i]);
            if (n == null) {
                return null;
            }
            nArray[i] = n;
        }
        return nArray;
    }

    public static float[] getFloatArray(String string) {
        if (string == null) {
            return null;
        }
        String[] stringArray = SGUtilityText.getStringsInBracket(string);
        if (stringArray == null) {
            return null;
        }
        float[] fArray = new float[stringArray.length];
        for (int i = 0; i < fArray.length; ++i) {
            Float f = SGUtilityText.getFloat(stringArray[i]);
            if (f == null) {
                return null;
            }
            fArray[i] = f.floatValue();
        }
        return fArray;
    }

    public static double[] getDoubleArray(String string) {
        if (string == null) {
            return null;
        }
        String[] stringArray = SGUtilityText.getStringsInBracket(string);
        if (stringArray == null) {
            return null;
        }
        double[] dArray = new double[stringArray.length];
        for (int i = 0; i < dArray.length; ++i) {
            Double d = SGUtilityText.getDouble(stringArray[i]);
            if (d == null) {
                return null;
            }
            dArray[i] = d;
        }
        return dArray;
    }

    public static Color parseColor(String string) {
        int[] nArray = SGUtilityText.getIntegerArray(string);
        if (nArray == null) {
            return null;
        }
        int n = nArray.length;
        if (n != 4 && n != 3) {
            return null;
        }
        for (int i = 0; i < n; ++i) {
            if (nArray[i] >= 0 && nArray[i] <= 255) continue;
            return null;
        }
        Color color = null;
        if (n == 3) {
            color = new Color(nArray[0], nArray[1], nArray[2]);
        } else if (n == 4) {
            color = new Color(nArray[0], nArray[1], nArray[2], nArray[3]);
        }
        return color;
    }

    public static String getColorString(Color color) {
        if (color == null) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append('(');
        stringBuffer.append(color.getRed());
        stringBuffer.append(',');
        stringBuffer.append(color.getGreen());
        stringBuffer.append(',');
        stringBuffer.append(color.getBlue());
        stringBuffer.append(',');
        stringBuffer.append(color.getAlpha());
        stringBuffer.append(')');
        return stringBuffer.toString();
    }

    public static Boolean getBoolean(String string) {
        if (string == null) {
            return null;
        }
        Boolean bl = null;
        if (Boolean.TRUE.toString().equalsIgnoreCase(string)) {
            bl = Boolean.TRUE;
        } else if (Boolean.FALSE.toString().equalsIgnoreCase(string)) {
            bl = Boolean.FALSE;
        } else {
            return null;
        }
        return bl;
    }

    public static Integer getInteger(String string) {
        Number number = SGUtilityText.parse(string);
        if (number == null) {
            return null;
        }
        return number.intValue();
    }

    public static Float getFloat(String string) {
        Number number = SGUtilityText.parse(string);
        if (number == null) {
            return null;
        }
        return Float.valueOf(number.floatValue());
    }

    public static Double getDouble(String string) {
        if (string == null) {
            return null;
        }
        if ("NaN".equalsIgnoreCase(string)) {
            return Double.NaN;
        }
        Number number = SGUtilityText.parse(string);
        if (number == null) {
            return null;
        }
        return number.doubleValue();
    }

    public static String getCSVString(String string) {
        if (string == null) {
            return null;
        }
        boolean bl = false;
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c == ',') {
                bl = true;
            } else if (c == '\"') {
                bl = true;
                stringBuffer.append('\"');
            }
            stringBuffer.append(c);
        }
        if (string.startsWith(" ") || string.startsWith("\t") || string.endsWith(" ") || string.endsWith("\t")) {
            bl = true;
        }
        if (bl) {
            String string2 = stringBuffer.toString();
            stringBuffer.append("\"");
            stringBuffer.append(string2);
            stringBuffer.append("\"");
        }
        return stringBuffer.toString();
    }

    public static List<Color> getColorList(String string) {
        String string2 = SGUtilityText.getInnerString(string, 123, 125);
        if (string2 == null) {
            return null;
        }
        ArrayList<String> arrayList = SGUtilityText.getStringListFromCommaSeparatedLine(string2);
        ArrayList<Color> arrayList2 = new ArrayList<Color>();
        for (int i = 0; i < arrayList.size(); ++i) {
            String string3 = arrayList.get(i);
            Color color = SGUtilityText.parseColor(string3);
            arrayList2.add(color);
        }
        return arrayList2;
    }

    public static ArrayList<String> getStringListFromCommaSeparatedLine(String string) {
        String string2;
        int n;
        int n2;
        int n3 = 0;
        ArrayList<String> arrayList = new ArrayList<String>();
        while ((n2 = string.indexOf("(", n3)) < (n = string.indexOf(")", n3)) && (string2 = string.substring(n2, n + 1)) != null) {
            arrayList.add(string2);
            n3 = n + 1;
        }
        return arrayList;
    }

    public static boolean isValidFontStyle(int n) {
        int[] nArray = new int[]{0, 1, 2, 3};
        for (int i = 0; i < nArray.length; ++i) {
            if (n != nArray[i]) continue;
            return true;
        }
        return false;
    }

    public static String getFontStyleName(int n) {
        String string = null;
        switch (n) {
            case 0: {
                string = "Plain";
                break;
            }
            case 3: {
                string = "Bold Italic";
                break;
            }
            case 1: {
                string = "Bold";
                break;
            }
            case 2: {
                string = "Italic";
            }
        }
        return string;
    }

    public static Integer getFontStyle(String string) {
        if (string == null) {
            return null;
        }
        Integer n = null;
        if (SGUtilityText.isEqualString("Plain", string)) {
            n = 0;
        } else if (SGUtilityText.isEqualString("Bold", string)) {
            n = 1;
        } else if (SGUtilityText.isEqualString("Italic", string)) {
            n = 2;
        } else if (SGUtilityText.isEqualString("Bold Italic", string)) {
            n = 3;
        }
        return n;
    }

    public static String getScaleTypeName(int n) {
        String string = null;
        switch (n) {
            case 0: {
                string = "Linear";
                break;
            }
            case 1: {
                string = "Log";
                break;
            }
        }
        return string;
    }

    public static int getScaleType(String string) {
        if (string == null) {
            return -1;
        }
        int n = -1;
        if ("Linear".equalsIgnoreCase(string)) {
            n = 0;
        } else if ("Log".equalsIgnoreCase(string)) {
            n = 1;
        }
        return n;
    }

    public static Document getDocument(String string) {
        Document document = null;
        try {
            URL uRL = new URL(string);
            document = SGUtilityText.getDocument(uRL);
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
        return document;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Document getDocument(URL uRL) {
        Document document = null;
        BufferedInputStream bufferedInputStream = null;
        try {
            bufferedInputStream = new BufferedInputStream(uRL.openStream());
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return null;
        }
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            documentBuilder.setEntityResolver(mPropertyEntityResolver);
            document = documentBuilder.parse(bufferedInputStream, uRL.toString());
        }
        catch (Exception exception) {
            Document document2 = null;
            return document2;
        }
        finally {
            try {
                if (bufferedInputStream != null) {
                    ((InputStream)bufferedInputStream).close();
                }
            }
            catch (IOException iOException) {}
        }
        return document;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static Document getDocumentFromString(String string) {
        Document document = null;
        InputStream inputStream = null;
        try {
            inputStream = new BufferedInputStream(new ByteArrayInputStream(string.getBytes("UTF-8")));
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            documentBuilder.setEntityResolver(mPropertyEntityResolver);
            document = documentBuilder.parse(inputStream);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            Document document2 = null;
            return document2;
        }
        catch (IOException iOException) {
            Document document3 = null;
            return document3;
        }
        catch (SAXException sAXException) {
            Document document4 = null;
            return document4;
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            catch (IOException iOException) {}
        }
        return document;
    }

    private static Number parse(String string) {
        if (string == null) {
            return null;
        }
        String string2 = string;
        if (string.startsWith("+") && string.length() > 1) {
            string2 = string2.substring(1);
        }
        string2 = string2.toUpperCase();
        string2 = string2.replaceAll("E\\+", "E");
        ParsePosition parsePosition = new ParsePosition(0);
        Number number = NumberFormat.getInstance().parse(string2, parsePosition);
        if (parsePosition.getIndex() != string2.length()) {
            return null;
        }
        return number;
    }

    public static Number getLengthInPoint(String string) {
        return SGUtilityText.getLength(string, "pt");
    }

    public static Number getLength(String string, String string2) {
        if (string == null) {
            return null;
        }
        if (string.length() == 0) {
            return null;
        }
        String string3 = string.toLowerCase();
        String[] stringArray = SGUtilityText.getUnitsArrayOfLength();
        for (int i = 0; i < stringArray.length; ++i) {
            Number number;
            if (!string3.endsWith(stringArray[i]) || (number = SGUtilityText.removeUnit(string3, stringArray[i])) == null) continue;
            return SGUtilityText.convert(number.doubleValue(), stringArray[i], string2);
        }
        return null;
    }

    public static Integer getInteger(String string, String string2) {
        Number number = SGUtilityText.removeUnit(string, string2);
        if (number == null) {
            return null;
        }
        return number.intValue();
    }

    public static Float getFloat(String string, String string2) {
        Number number = SGUtilityText.removeUnit(string, string2);
        if (number == null) {
            return null;
        }
        return Float.valueOf(number.floatValue());
    }

    public static Double getDouble(String string, String string2) {
        Number number = SGUtilityText.removeUnit(string, string2);
        if (number == null) {
            return null;
        }
        return number.doubleValue();
    }

    public static boolean isValidString(String string) {
        if (string == null) {
            return false;
        }
        int n = string.length();
        if (n == 0) {
            return false;
        }
        boolean bl = false;
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (c == ' ' || c == '\u3000' || c == '\t' || c == '\n' || c == '\r' || c == '\f') continue;
            bl = true;
            break;
        }
        return bl;
    }

    public static String getSerialName(List<String> list, String string) {
        String string2;
        CharSequence charSequence;
        int n = -1;
        for (int i = 0; i < list.size(); ++i) {
            charSequence = list.get(i);
            if (!((String)charSequence).startsWith(string)) continue;
            String string3 = ((String)charSequence).substring(string.length());
            if (string3.startsWith("(") && string3.endsWith(")")) {
                int n2;
                String string4 = string3.substring(1, string3.length() - 1);
                Integer n3 = SGUtilityText.getInteger(string4);
                if (n3 == null || (n2 = n3.intValue()) <= n) continue;
                n = n2;
                continue;
            }
            if (!"".equals(string3)) continue;
            n = 0;
        }
        if (n != -1) {
            ++n;
            charSequence = new StringBuffer();
            ((StringBuffer)charSequence).append(string);
            ((StringBuffer)charSequence).append('(');
            ((StringBuffer)charSequence).append(n);
            ((StringBuffer)charSequence).append(')');
            string2 = ((StringBuffer)charSequence).toString();
        } else {
            string2 = string;
        }
        return string2;
    }

    public static void addAvailableDateFormat(String string) {
        DATE_FORMAT_ARRAY_LIST.add(new SimpleDateFormat(string));
    }

    public static Date getDate(String string) {
        Date date = null;
        List<DateFormat> list = DATE_FORMAT_ARRAY_LIST;
        for (int i = 0; i < list.size(); ++i) {
            DateFormat dateFormat = list.get(i);
            ParsePosition parsePosition = new ParsePosition(0);
            Date date2 = dateFormat.parse(string, parsePosition);
            if (parsePosition.getIndex() != string.length() || date2 == null) continue;
            date = date2;
            break;
        }
        return date;
    }

    public static String[] getUnitsArrayOfLength() {
        return new String[]{"cm", "mm", "pt", "inch"};
    }

    public static boolean isLengthUnit(String string) {
        if (string == null) {
            throw new IllegalArgumentException();
        }
        String[] stringArray = SGUtilityText.getUnitsArrayOfLength();
        boolean bl = false;
        for (int i = 0; i < stringArray.length; ++i) {
            if (!stringArray[i].equalsIgnoreCase(string)) continue;
            bl = true;
            break;
        }
        return bl;
    }

    public static double convert(double d, String string, String string2) {
        int n;
        if (string == null || string2 == null) {
            throw new IllegalArgumentException();
        }
        if (!SGUtilityText.isLengthUnit(string) || !SGUtilityText.isLengthUnit(string2)) {
            throw new IllegalArgumentException();
        }
        if (string.equalsIgnoreCase(string2)) {
            return d;
        }
        String[] stringArray = SGUtilityText.getUnitsArrayOfLength();
        float[] fArray = new float[]{1.0f, 0.1f, 0.035277776f, 2.54f};
        int n2 = -1;
        for (n = 0; n < stringArray.length; ++n) {
            if (!stringArray[n].equalsIgnoreCase(string)) continue;
            n2 = n;
            break;
        }
        if (n2 == -1) {
            throw new IllegalArgumentException();
        }
        n = -1;
        for (int i = 0; i < stringArray.length; ++i) {
            if (!stringArray[i].equalsIgnoreCase(string2)) continue;
            n = i;
            break;
        }
        if (n == -1) {
            throw new IllegalArgumentException();
        }
        float f = fArray[n2] / fArray[n];
        return d * (double)f;
    }

    public static double convertToPoint(double d, String string) {
        return SGUtilityText.convert(d, string, "pt");
    }

    public static double convertFromPoint(double d, String string) {
        return SGUtilityText.convert(d, "pt", string);
    }

    public static String convertString(String string, String string2) {
        if (string == null || string2 == null) {
            return null;
        }
        if (string.length() == 0 || string2.length() == 0) {
            return null;
        }
        String string3 = string.toLowerCase();
        String string4 = string2.toLowerCase();
        String[] stringArray = SGUtilityText.getUnitsArrayOfLength();
        String string5 = null;
        for (int i = 0; i < stringArray.length; ++i) {
            if (!string.endsWith(stringArray[i])) continue;
            string5 = stringArray[i];
            break;
        }
        if (string5 == null) {
            return null;
        }
        Number number = SGUtilityText.removeUnit(string3, string5);
        if (number == null) {
            return null;
        }
        double d = number.doubleValue();
        double d2 = SGUtilityText.convert(d, string5, string4);
        String string6 = Double.toString(d2);
        return string6;
    }

    public static Number removeUnit(String string, String string2) {
        String string3 = SGUtilityText.removeSuffix(string, string2);
        if (string3 == null) {
            return null;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string3);
        ArrayList<String> arrayList = new ArrayList<String>();
        while (stringTokenizer.hasMoreTokens()) {
            arrayList.add(stringTokenizer.nextToken());
        }
        if (arrayList.size() != 1) {
            return null;
        }
        String string4 = (String)arrayList.get(0);
        return SGUtilityText.getDouble(string4);
    }

    public static String removeSuffix(String string, String string2) {
        int n;
        if (string == null) {
            return null;
        }
        if (string.length() == 0) {
            return null;
        }
        if (string2 == null) {
            return string;
        }
        if (!string.endsWith(string2)) {
            return string;
        }
        int n2 = -1;
        while ((n = string.indexOf(string2, n2 + 1)) != -1) {
            n2 = n;
        }
        String string3 = string.substring(0, n2);
        if (string3.length() == 0) {
            return null;
        }
        return string3;
    }

    public static Color getColor(String string) {
        if (string == null) {
            throw new IllegalArgumentException("name==null");
        }
        Color color = null;
        for (int i = 0; i < DEFAULT_COLOR_NAMES.length; ++i) {
            if (!SGUtilityText.isEqualString(DEFAULT_COLOR_NAMES[i], string)) continue;
            color = DEFAULT_COLORS[i];
            break;
        }
        return color;
    }

    public static Color getColor(String string, String string2, String string3) {
        Integer n = SGUtilityText.getInteger(string);
        if (n == null) {
            return null;
        }
        Integer n2 = SGUtilityText.getInteger(string2);
        if (n2 == null) {
            return null;
        }
        Integer n3 = SGUtilityText.getInteger(string3);
        if (n3 == null) {
            return null;
        }
        if (!SGUtilityText.isValidColor(n, n2, n3)) {
            return null;
        }
        return new Color(n, n2, n3);
    }

    public static boolean isValidColor(int n, int n2, int n3) {
        return SGUtilityText.isValidColorComponent(n) && SGUtilityText.isValidColorComponent(n2) && SGUtilityText.isValidColorComponent(n3);
    }

    private static boolean isValidColorComponent(int n) {
        return n >= 0 && n < 256;
    }

    public static Color parseColorString(String string) {
        Color color = SGUtilityText.getColor(string);
        if (null != color) {
            return color;
        }
        return SGUtilityText.parseColor(string);
    }

    public static final MediaSize getMediaSize(String string) {
        if (string == null) {
            return null;
        }
        MediaSize mediaSize = null;
        if (SGUtilityText.isEqualString("A4", string)) {
            mediaSize = MediaSize.ISO.A4;
        } else if (SGUtilityText.isEqualString("A3", string)) {
            mediaSize = MediaSize.ISO.A3;
        } else if (SGUtilityText.isEqualString("B5", string)) {
            mediaSize = MediaSize.ISO.B5;
        } else if (SGUtilityText.isEqualString("B4", string)) {
            mediaSize = MediaSize.ISO.B4;
        } else if (SGUtilityText.isEqualString("US_Letter", string) || SGUtilityText.isEqualString("Letter", string)) {
            mediaSize = MediaSize.NA.LETTER;
        }
        return mediaSize;
    }

    public static final Boolean isPortrait(String string) {
        if (string == null) {
            return null;
        }
        if (SGUtilityText.isEqualString("Portrait", string)) {
            return Boolean.TRUE;
        }
        if (SGUtilityText.isEqualString("Landscape", string)) {
            return Boolean.FALSE;
        }
        return null;
    }

    public static Dimension getDimension(String string) {
        int[] nArray = SGUtilityText.getIntegerArray(string);
        if (nArray == null) {
            return null;
        }
        int n = nArray.length;
        if (n != 2) {
            return null;
        }
        if (nArray[0] < 0 || nArray[1] < 0) {
            return null;
        }
        Dimension dimension = new Dimension(nArray[0], nArray[1]);
        return dimension;
    }

    public static Number getNumber(String string, StringBuffer stringBuffer) {
        if (string == null) {
            return null;
        }
        String string2 = string.toLowerCase();
        String string3 = null;
        String[] stringArray = SGUtilityText.getUnitsArrayOfLength();
        for (int i = 0; i < stringArray.length; ++i) {
            if (!string2.endsWith(stringArray[i])) continue;
            string3 = stringArray[i];
            break;
        }
        if (string3 == null) {
            return null;
        }
        stringBuffer.append(string3);
        Number number = SGUtilityText.removeUnit(string2, string3);
        if (number == null) {
            return null;
        }
        return number.doubleValue();
    }

    public static String getBooleanString(String string) {
        String string2 = Boolean.TRUE.toString();
        String string3 = Boolean.FALSE.toString();
        Integer n = SGUtilityText.getInteger(string);
        String string4 = null;
        if (n != null) {
            string4 = "0".equals(string) ? string2 : string3;
        } else if (string2.equalsIgnoreCase(string)) {
            string4 = string2;
        } else if (string3.equalsIgnoreCase(string)) {
            string4 = string3;
        }
        return string4;
    }

    public static List<SGCSVTokenizer.Token> getFirstTokenList(BufferedReader bufferedReader) {
        String string;
        ArrayList<SGCSVTokenizer.Token> arrayList = new ArrayList<SGCSVTokenizer.Token>();
        while ((string = SGUtilityText.readLine(bufferedReader)) != null) {
            if (SGUtilityText.count(string, '\"') % 2 != 0) {
                return null;
            }
            arrayList.clear();
            SGCSVTokenizer sGCSVTokenizer = new SGCSVTokenizer(string, true);
            while (sGCSVTokenizer.hasMoreTokens()) {
                try {
                    SGCSVTokenizer.Token token = sGCSVTokenizer.nextToken();
                    arrayList.add(token);
                }
                catch (NoSuchElementException noSuchElementException) {}
            }
            int n = arrayList.size();
            if (n == 0) continue;
            break;
        }
        return arrayList;
    }

    public static int count(String string, char c) {
        int n = 0;
        int n2 = string.length();
        for (int i = 0; i < n2; ++i) {
            char c2 = string.charAt(i);
            if (c2 != c) continue;
            ++n;
        }
        return n;
    }

    public static boolean isDoubleQuoted(String string) {
        if (string.length() < 2) {
            return false;
        }
        return string.startsWith("\"") && string.endsWith("\"");
    }

    public static boolean isEqualString(String string, String string2) {
        if (string == null || string2 == null) {
            throw new IllegalArgumentException("str1 == null || str2 == null");
        }
        List<Character> list = SGUtilityText.getCharList(string);
        List<Character> list2 = SGUtilityText.getCharList(string2);
        return ((Object)list).equals(list2);
    }

    private static List<Character> getCharList(String string) {
        String string2 = string.toUpperCase();
        ArrayList<Character> arrayList = new ArrayList<Character>();
        for (int i = 0; i < string2.length(); ++i) {
            char c = string2.charAt(i);
            if (!Character.isLetterOrDigit(c)) continue;
            arrayList.add(Character.valueOf(c));
        }
        return arrayList;
    }

    private static char[] toArray(List<Character> list) {
        char[] cArray = new char[list.size()];
        for (int i = 0; i < cArray.length; ++i) {
            cArray[i] = list.get(i).charValue();
        }
        return cArray;
    }

    public static boolean startsWith(String string, String string2) {
        if (string == null || string2 == null) {
            throw new IllegalArgumentException("str == null || prefix == null");
        }
        List<Character> list = SGUtilityText.getCharList(string);
        List<Character> list2 = SGUtilityText.getCharList(string2);
        char[] cArray = SGUtilityText.toArray(list);
        char[] cArray2 = SGUtilityText.toArray(list2);
        String string3 = new String(cArray);
        String string4 = new String(cArray2);
        return string3.startsWith(string4);
    }

    public static String getCharString(String string) {
        if (string == null) {
            throw new IllegalArgumentException("str == null");
        }
        List<Character> list = SGUtilityText.getCharList(string);
        char[] cArray = SGUtilityText.toArray(list);
        return new String(cArray);
    }

    public static String[][] readStringMaps(String string) {
        String[] stringArray = string.split(",");
        String[][] stringArray2 = new String[stringArray.length][2];
        for (int i = 0; i < stringArray.length; ++i) {
            String[] stringArray3 = stringArray[i].split("=");
            if (stringArray3.length < 2) continue;
            stringArray2[i][0] = stringArray3[0].trim();
            stringArray2[i][1] = stringArray3[1].trim();
        }
        return stringArray2;
    }

    public static Integer[] parseIndices(String string) {
        int n;
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        if (string.length() != 0) {
            int n2 = string.indexOf(123);
            n = string.lastIndexOf(125);
            if (n2 == -1 || n == -1) {
                Integer n3 = SGUtilityText.getInteger(string);
                if (n3 == null) {
                    return null;
                }
                return new Integer[]{n3};
            }
            if (n2 > n) {
                return null;
            }
            String string2 = string.substring(n2 + 1, n);
            StringTokenizer stringTokenizer = new StringTokenizer(string2, ",");
            while (stringTokenizer.hasMoreTokens()) {
                String string3 = stringTokenizer.nextToken();
                Integer n4 = SGUtilityText.getInteger(string3);
                if (n4 == null) {
                    return null;
                }
                arrayList.add(n4);
            }
        }
        Integer[] integerArray = new Integer[arrayList.size()];
        for (n = 0; n < integerArray.length; ++n) {
            integerArray[n] = (Integer)arrayList.get(n);
        }
        return integerArray;
    }

    public static String[] parseStrings(String string) {
        String[] stringArray = null;
        if (string.length() != 0) {
            int n = string.indexOf(123);
            int n2 = string.lastIndexOf(125);
            if (n == -1 || n2 == -1) {
                return new String[]{string};
            }
            if (n > n2) {
                return null;
            }
            String string2 = string.substring(n + 1, n2);
            stringArray = string2.split(",");
            for (int i = 0; i < stringArray.length; ++i) {
                stringArray[i] = stringArray[i].trim();
            }
        }
        return stringArray;
    }

    public static void main(String[] stringArray) {
        String string = "Hello World! 1234 ";
        String string2 = " HELLO-WORLD !__1234__-";
        System.out.println(SGUtilityText.isEqualString(string, string2));
    }

    static {
        String[] stringArray = DEFAULT_DATE_FORMAT_ARRAY;
        for (int i = 0; i < stringArray.length; ++i) {
            SGUtilityText.addAvailableDateFormat(stringArray[i]);
        }
    }

    private static class PropertyEntityResolver
    implements EntityResolver {
        private PropertyEntityResolver() {
        }

        public InputSource resolveEntity(String string, String string2) throws SAXException, IOException {
            if (string.startsWith("-//NILAB//DTD Samurai-Graph Property XML 1.0//EN") && string2.startsWith("http://samurai-graph.sourceforge.jp/property.dtd")) {
                String string3 = "/resources/property.dtd";
                InputStream inputStream = this.getClass().getResourceAsStream(string3);
                return new InputSource(inputStream);
            }
            return null;
        }
    }
}

