/*
 * Decompiled with CFR 0.152.
 */
package jp.riken.brain.ni.samuraigraph.data;

import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.util.Map;
import jp.riken.brain.ni.samuraigraph.base.SGBufferedFileWriter;
import jp.riken.brain.ni.samuraigraph.base.SGData;
import jp.riken.brain.ni.samuraigraph.base.SGIConstants;
import jp.riken.brain.ni.samuraigraph.base.SGIDataSource;
import jp.riken.brain.ni.samuraigraph.base.SGITextDataConstants;
import jp.riken.brain.ni.samuraigraph.base.SGProperties;
import jp.riken.brain.ni.samuraigraph.base.SGUtility;
import jp.riken.brain.ni.samuraigraph.base.SGUtilityText;
import jp.riken.brain.ni.samuraigraph.data.SGDataColumn;
import jp.riken.brain.ni.samuraigraph.data.SGDataSourceObserver;
import jp.riken.brain.ni.samuraigraph.data.SGIDataColumnTypeConstants;
import jp.riken.brain.ni.samuraigraph.data.SGNumberDataColumn;
import jp.riken.brain.ni.samuraigraph.data.SGTextDataFile;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SGArrayData
extends SGData
implements SGITextDataConstants,
SGIConstants,
SGIDataColumnTypeConstants {
    protected SGTextDataFile mDataFile = null;
    protected SGDataSourceObserver mObserver = null;

    public SGArrayData() {
    }

    public SGArrayData(SGTextDataFile sGTextDataFile, SGDataSourceObserver sGDataSourceObserver) {
        if (sGTextDataFile == null || sGDataSourceObserver == null) {
            throw new IllegalArgumentException("dataFile == null || obs == null");
        }
        this.mDataFile = sGTextDataFile;
        this.mObserver = sGDataSourceObserver;
        sGDataSourceObserver.addData(this);
    }

    public int getColNum() {
        return this.mDataFile.getColNum();
    }

    public int getRowNum() {
        return this.mDataFile.getRowNum();
    }

    @Override
    public void dispose() {
        super.dispose();
        this.mObserver.dataDisposed(this);
        this.mDataFile = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean saveData(File file, int n) {
        boolean bl = false;
        SGDataColumn[] sGDataColumnArray = this.getDataSetColumns();
        SGBufferedFileWriter sGBufferedFileWriter = null;
        try {
            String string;
            int n2;
            sGBufferedFileWriter = new SGBufferedFileWriter(file);
            BufferedWriter bufferedWriter = sGBufferedFileWriter.getBufferedWriter();
            boolean bl2 = true;
            for (n2 = 0; n2 < sGDataColumnArray.length; ++n2) {
                string = sGDataColumnArray[n2].getTitle();
                if (string != null) continue;
                bl2 = false;
                break;
            }
            if (bl2) {
                for (n2 = 0; n2 < sGDataColumnArray.length; ++n2) {
                    string = sGDataColumnArray[n2].getTitle();
                    String string2 = SGUtilityText.getCSVString(string);
                    if (n2 != 0) {
                        bufferedWriter.write(44);
                    }
                    bufferedWriter.write(string2);
                }
                bufferedWriter.write(10);
            }
            bl = this.writeData(bufferedWriter, n);
        }
        catch (IOException iOException) {
            boolean bl3 = false;
            return bl3;
        }
        finally {
            if (sGBufferedFileWriter != null) {
                sGBufferedFileWriter.close();
            }
        }
        return bl;
    }

    protected abstract SGDataColumn[] getDataSetColumns();

    public SGDataColumn[] getDataSetColumnsClone() {
        SGDataColumn[] sGDataColumnArray = this.getDataSetColumns();
        SGDataColumn[] sGDataColumnArray2 = new SGDataColumn[sGDataColumnArray.length];
        for (int i = 0; i < sGDataColumnArray.length; ++i) {
            sGDataColumnArray2[i] = (SGDataColumn)sGDataColumnArray[i].clone();
        }
        return sGDataColumnArray2;
    }

    public abstract SGDataColumn[] getUsedDataColumnsClone();

    public int getColNum(Class clazz) {
        return this.mDataFile.getColNum(clazz);
    }

    public abstract int getPointsNumber();

    public int[] getIndexArray(Class clazz) {
        return this.mDataFile.getIndexArray(clazz);
    }

    @Override
    public boolean setData(SGData sGData) {
        if (!(sGData instanceof SGArrayData)) {
            throw new IllegalArgumentException("!(data instanceof SGArrayData)");
        }
        SGArrayData sGArrayData = (SGArrayData)sGData;
        this.mDataFile = sGArrayData.mDataFile;
        this.mObserver = sGArrayData.mObserver;
        this.mObserver.addData(this);
        return true;
    }

    public String[] getTitles() {
        return this.mDataFile.getTitles();
    }

    public String getTitle(int n) {
        return this.mDataFile.getTitle(n);
    }

    public String[] getValueTypes() {
        return this.mDataFile.getValueTypes();
    }

    public abstract String[] getCurrentColumnType();

    @Override
    public boolean getProperties(SGProperties sGProperties) {
        return sGProperties instanceof ArrayDataProperties;
    }

    @Override
    public boolean setProperties(SGProperties sGProperties) {
        return sGProperties instanceof ArrayDataProperties;
    }

    protected Integer readIndex(Element element, String string) {
        Integer n = null;
        String string2 = element.getAttribute(string);
        if (string2.length() != 0) {
            n = SGUtilityText.getInteger(string2);
        }
        return n;
    }

    protected Integer[] readIndices(Element element, String string) {
        return SGUtility.readIndices(element, string);
    }

    @Override
    protected boolean writeData(Writer writer, int n) throws IOException {
        SGDataColumn[] sGDataColumnArray = this.getDataSetColumns();
        StringBuffer stringBuffer = new StringBuffer();
        Object[][] objectArray = this.getDataSetValues();
        for (int i = 0; i < objectArray.length; ++i) {
            int n2;
            int n3 = objectArray[i].length;
            if (n == 6) {
                n2 = 0;
                for (int j = 0; j < n3; ++j) {
                    Double d;
                    if (!(sGDataColumnArray[j] instanceof SGNumberDataColumn) || !(objectArray[i][j] instanceof Double) || !(d = (Double)objectArray[i][j]).isNaN()) continue;
                    n2 = 1;
                    break;
                }
                if (n2 != 0) {
                    stringBuffer.append("#");
                    stringBuffer.append("<");
                    stringBuffer.append("NAC");
                    stringBuffer.append(">");
                }
            }
            for (n2 = 0; n2 < n3; ++n2) {
                stringBuffer.append(objectArray[i][n2]);
                if (n2 == n3 - 1) continue;
                stringBuffer.append(',');
            }
            stringBuffer.append('\n');
        }
        writer.write(stringBuffer.toString());
        return true;
    }

    protected Object[][] getDataSetValues() {
        int n = this.getPointsNumber();
        SGDataColumn[] sGDataColumnArray = this.getDataSetColumns();
        int n2 = sGDataColumnArray.length;
        Object[][] objectArray = new Object[n][];
        for (int i = 0; i < n; ++i) {
            objectArray[i] = new Object[n2];
            for (int j = 0; j < n2; ++j) {
                SGDataColumn sGDataColumn = sGDataColumnArray[j];
                objectArray[i][j] = sGDataColumn.getExportedValue(i);
            }
        }
        return objectArray;
    }

    protected boolean checkColumnIndexRange(Integer n) {
        return this.mDataFile.checkColumnIndexRange(n);
    }

    protected void setDataColumn(SGDataColumn sGDataColumn, int n) {
        this.mDataFile.setDataColumn(sGDataColumn, n);
    }

    @Override
    public String getDataType(int n) {
        return this.getDataType();
    }

    @Override
    public boolean writeProperty(Element element, int n) {
        switch (n) {
            case 1: 
            case 3: 
            case 4: 
            case 5: {
                if (this.writeAttributeColumnIndices(element)) break;
                return false;
            }
            case 2: 
            case 6: {
                if (this.writeSequentialColumnIndices(element)) break;
                return false;
            }
            case 7: {
                if (this.writeSequentialColumnName(element)) break;
                return false;
            }
        }
        return true;
    }

    protected abstract boolean writeAttributeColumnIndices(Element var1);

    protected abstract boolean writeSequentialColumnIndices(Element var1);

    protected abstract boolean writeSequentialColumnName(Element var1);

    protected String getSequentialColumnName(int n) {
        return "column" + n;
    }

    protected SGDataColumn getColumn(Integer n) {
        if (n != null) {
            return this.mDataFile.mDataColumns[n];
        }
        return null;
    }

    protected SGDataColumn[] getColumns(Integer[] integerArray) {
        if (integerArray != null) {
            SGDataColumn[] sGDataColumnArray = new SGDataColumn[integerArray.length];
            for (int i = 0; i < sGDataColumnArray.length; ++i) {
                sGDataColumnArray[i] = this.mDataFile.mDataColumns[integerArray[i]];
            }
            return sGDataColumnArray;
        }
        return null;
    }

    @Override
    public Map<String, Object> getInfoMap() {
        Map<String, Object> map = super.getInfoMap();
        map.put("DataType", this.getDataType());
        return map;
    }

    @Override
    public Object copy() {
        SGArrayData sGArrayData = (SGArrayData)super.copy();
        this.mObserver.addData(sGArrayData);
        return sGArrayData;
    }

    public SGTextDataFile getDataFile() {
        return this.mDataFile;
    }

    @Override
    public SGIDataSource getDataSource() {
        return this.getDataFile();
    }

    public static abstract class ArrayDataProperties
    extends SGData.DataProperties {
    }
}

