/*
 * Decompiled with CFR 0.152.
 */
package jp.riken.brain.ni.samuraigraph.data;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.util.List;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import ucar.nc2.Attribute;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SGAttributePanel
extends JPanel {
    private static final long serialVersionUID = 8246986947494258210L;
    private JScrollPane mScrollPane;
    private JTable mTable;
    public static final String COLUMN_NAME_NUMBER = "No.";
    public static final String COLUMN_NAME_NAME = "Name";
    public static final String COLUMN_NAME_VALUE = "Value";
    public static final String[] COLUMN_NAME_ARRAY = new String[]{"No.", "Name", "Value"};
    private static final int[] PREFERRED_COLUMN_WIDTH_ARRAY = new int[]{10, 60, 180};
    protected AttributeTableModel mTableModel = null;

    public SGAttributePanel() {
        this.initComponents();
        this.initProperty();
    }

    private void initComponents() {
        this.mScrollPane = new JScrollPane();
        this.mTable = new JTable();
        this.setLayout(new BorderLayout());
        this.mScrollPane.setPreferredSize(new Dimension(300, 80));
        this.mScrollPane.setViewportView(this.mTable);
        this.add((Component)this.mScrollPane, "Center");
    }

    private void initProperty() {
        this.initTableModel();
        this.updateTable();
    }

    protected void initTableModel() {
        this.mTableModel = new AttributeTableModel();
        this.mTableModel.setColumnIdentifiers(this.getColumnNameArray());
        this.mTable.setModel(this.mTableModel);
    }

    public void updateTable() {
        this.setPreferredColumnWidth();
    }

    private void setPreferredColumnWidth() {
        String[] stringArray = this.getColumnNameArray();
        int[] nArray = this.getPreferredColumnWidthArray();
        for (int i = 0; i < stringArray.length; ++i) {
            TableColumn tableColumn = this.mTable.getColumn(stringArray[i]);
            tableColumn.setPreferredWidth(nArray[i]);
        }
    }

    protected String[] getColumnNameArray() {
        return COLUMN_NAME_ARRAY;
    }

    protected int[] getPreferredColumnWidthArray() {
        return PREFERRED_COLUMN_WIDTH_ARRAY;
    }

    public boolean setAttributes(List<Attribute> list) {
        this.initTableModel();
        for (int i = 0; i < list.size(); ++i) {
            Attribute attribute = list.get(i);
            this.mTableModel.addData(i, attribute);
        }
        this.updateTable();
        return true;
    }

    public void clear() {
        this.initTableModel();
    }

    public JTable getTable() {
        return this.mTable;
    }

    public String getRowText(int n) {
        TableColumnModel tableColumnModel = this.mTable.getColumnModel();
        int n2 = tableColumnModel.getColumnIndex(COLUMN_NAME_NAME);
        int n3 = tableColumnModel.getColumnIndex(COLUMN_NAME_VALUE);
        Object object = this.mTable.getValueAt(n, n2);
        Object object2 = this.mTable.getValueAt(n, n3);
        StringBuffer stringBuffer = new StringBuffer();
        if (object != null) {
            stringBuffer.append(object);
        }
        stringBuffer.append('\n');
        if (object2 != null) {
            stringBuffer.append(object2);
        }
        return stringBuffer.toString();
    }

    protected static class AttributeTableModel
    extends DefaultTableModel {
        private static final long serialVersionUID = -6469371272912213709L;

        protected AttributeTableModel() {
        }

        public boolean isCellEditable(int n, int n2) {
            return false;
        }

        protected void addData(int n, Attribute attribute) {
            Object[] objectArray = new Object[]{Integer.toString(n + 1), attribute.getName(), attribute.getValue(0)};
            super.addRow(objectArray);
        }
    }
}

