/*
 * Decompiled with CFR 0.152.
 */
package jp.riken.brain.ni.samuraigraph.data;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.MediaTracker;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;
import javax.swing.BorderFactory;
import javax.swing.DefaultBoundedRangeModel;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import jp.riken.brain.ni.samuraigraph.base.SGButton;
import jp.riken.brain.ni.samuraigraph.base.SGTextField;
import jp.riken.brain.ni.samuraigraph.data.SGVariable;

public class SGCoordinateVariablePanel
extends JPanel
implements ActionListener,
ChangeListener {
    private static final long serialVersionUID = 5417060635224002801L;
    private SGVariable mVariable = null;
    private double[] mValues = null;
    private JLabel mLabel;
    private SGButton mLeftButton;
    private JPanel mPanel;
    private SGButton mRightButton;
    private JSlider mSlider;
    private SGTextField mTextField;
    private JLabel mUnitLabel;

    public SGCoordinateVariablePanel() {
        this.initComponents();
    }

    public SGCoordinateVariablePanel(SGVariable sGVariable, double[] dArray, int n, String string) {
        this.initComponents();
        if (n < 0 || n >= dArray.length) {
            throw new IllegalArgumentException("Index out of bounds: " + n);
        }
        if (!sGVariable.isCoordinateVariable()) {
            throw new IllegalArgumentException("Given variable is not a coordinate variable.");
        }
        this.mVariable = sGVariable;
        String string2 = sGVariable.getDimension(0).getName();
        this.mLabel.setText(string2);
        this.mLabel.setToolTipText(string2);
        this.mValues = (double[])dArray.clone();
        this.setValueText(n);
        String string3 = null;
        string3 = string == null ? "" : string;
        this.mUnitLabel.setText(string3);
        this.mUnitLabel.setToolTipText(string3);
        DefaultBoundedRangeModel defaultBoundedRangeModel = new DefaultBoundedRangeModel();
        defaultBoundedRangeModel.setMinimum(0);
        defaultBoundedRangeModel.setMaximum(dArray.length - 1);
        defaultBoundedRangeModel.setExtent(0);
        defaultBoundedRangeModel.setValue(n);
        this.mSlider.setModel(defaultBoundedRangeModel);
        this.setSliderToolTipText(n);
        this.mLeftButton.addActionListener(this);
        this.mRightButton.addActionListener(this);
        this.mSlider.addChangeListener(this);
        this.mLeftButton.setIcon(this.createIcon("Minus.png"));
        this.mRightButton.setIcon(this.createIcon("Plus.png"));
        this.mLeftButton.setDisabledIcon(this.createIcon("MinusDisabled.png"));
        this.mRightButton.setDisabledIcon(this.createIcon("PlusDisabled.png"));
    }

    private void initComponents() {
        this.mPanel = new JPanel();
        this.mLabel = new JLabel();
        this.mSlider = new JSlider();
        this.mTextField = new SGTextField();
        this.mLeftButton = new SGButton();
        this.mRightButton = new SGButton();
        this.mUnitLabel = new JLabel();
        this.mPanel.setPreferredSize(new Dimension(400, 36));
        this.mPanel.setLayout(new GridBagLayout());
        this.setLayout(new GridBagLayout());
        this.mLabel.setFont(new Font("Dialog", 0, 12));
        this.mLabel.setText("Name");
        this.mLabel.setPreferredSize(new Dimension(40, 16));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.add((Component)this.mLabel, gridBagConstraints);
        this.mSlider.setBorder(BorderFactory.createEtchedBorder());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(4, 2, 4, 2);
        this.add((Component)this.mSlider, gridBagConstraints);
        this.mTextField.setColumns(6);
        this.mTextField.setEditable(false);
        this.mTextField.setText("Value");
        this.mTextField.setFont(new Font("Dialog", 0, 12));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.add((Component)this.mTextField, gridBagConstraints);
        this.mLeftButton.setPreferredSize(new Dimension(18, 18));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        this.add((Component)this.mLeftButton, gridBagConstraints);
        this.mRightButton.setPreferredSize(new Dimension(18, 18));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        this.add((Component)this.mRightButton, gridBagConstraints);
        this.mUnitLabel.setFont(new Font("Dialog", 0, 12));
        this.mUnitLabel.setText("Unit");
        this.mUnitLabel.setPreferredSize(new Dimension(40, 13));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.add((Component)this.mUnitLabel, gridBagConstraints);
    }

    public void stateChanged(ChangeEvent changeEvent) {
        Object object = changeEvent.getSource();
        if (object.equals(this.mSlider)) {
            int n = this.getCurrentIndex();
            this.setValueText(n);
            this.setSliderToolTipText(n);
        }
    }

    private void setSliderToolTipText(int n) {
        int n2 = this.mValues.length - 1;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(n);
        stringBuffer.append('/');
        stringBuffer.append(n2);
        String string = stringBuffer.toString();
        this.mSlider.setToolTipText(string);
        this.mLeftButton.setToolTipText(string);
        this.mRightButton.setToolTipText(string);
    }

    private void setValueText(int n) {
        double d = this.mValues[n];
        String string = Double.toString(d);
        this.mTextField.setText(string);
        this.mTextField.setToolTipText(string);
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                SGCoordinateVariablePanel.this.mTextField.setCaretPosition(0);
            }
        });
    }

    public int getCurrentIndex() {
        return this.mSlider.getValue();
    }

    public double getCurrentValue() {
        return this.mValues[this.getCurrentIndex()];
    }

    public void setComponentsEnabled(boolean bl) {
        this.mLabel.setEnabled(bl);
        this.mSlider.setEnabled(bl);
        this.mLeftButton.setEnabled(bl);
        this.mRightButton.setEnabled(bl);
        this.mTextField.setEnabled(bl);
    }

    public String getVariableName() {
        return this.mVariable.getName();
    }

    private ImageIcon createIcon(String string) {
        URL uRL = this.getClass().getResource("/resources/" + string);
        ImageIcon imageIcon = new ImageIcon(uRL);
        MediaTracker mediaTracker = new MediaTracker(this);
        mediaTracker.addImage(imageIcon.getImage(), 0);
        try {
            mediaTracker.waitForAll();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return imageIcon;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object.equals(this.mLeftButton)) {
            this.mSlider.setValue(this.mSlider.getValue() - 1);
        } else if (object.equals(this.mRightButton)) {
            this.mSlider.setValue(this.mSlider.getValue() + 1);
        }
    }
}

