/*
 * Decompiled with CFR 0.152.
 */
package jp.riken.brain.ni.samuraigraph.data;

import java.awt.Dialog;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JButton;
import javax.swing.SwingUtilities;
import jp.riken.brain.ni.samuraigraph.base.SGDataColumnInfo;
import jp.riken.brain.ni.samuraigraph.base.SGDataColumnInfoSet;
import jp.riken.brain.ni.samuraigraph.base.SGDialog;
import jp.riken.brain.ni.samuraigraph.data.SGIDataSetupTableHolder;

public abstract class SGDataSetupDialog
extends SGDialog
implements PropertyChangeListener {
    protected SGDataColumnInfo[] mDataColumnInfo = null;

    public SGDataSetupDialog(Dialog dialog, boolean bl) {
        super(dialog, bl);
    }

    public SGDataSetupDialog(Frame frame, boolean bl) {
        super(frame, bl);
    }

    protected abstract JButton getOKButton();

    protected abstract JButton getCancelButton();

    protected abstract SGIDataSetupTableHolder getTableHolder();

    public SGDataColumnInfo[] getDataColumnInfo() {
        if (this.mDataColumnInfo == null) {
            return null;
        }
        return (SGDataColumnInfo[])this.mDataColumnInfo.clone();
    }

    protected void onEscKeyTyped() {
        this.setVisible(false);
    }

    public void clear() {
        this.getTableHolder().clear();
    }

    public SGDataColumnInfoSet getDataColumnInfoSet() {
        return this.getTableHolder().getDataColumnInfoSet();
    }

    public void componentResized(ComponentEvent componentEvent) {
        super.componentResized(componentEvent);
        this.updateTable();
    }

    public void componentShown(ComponentEvent componentEvent) {
        super.componentShown(componentEvent);
        this.updateTable();
    }

    private void updateTable() {
        this.getTableHolder().updateTable();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        String string = actionEvent.getActionCommand();
        if ("OK".equals(string)) {
            this.mDataColumnInfo = this.getTableHolder().getDataColumnInfoSet().getDataColumnInfoArray();
            this.notifyToListener("OK");
            this.setVisible(false);
        } else if ("Cancel".equals(string)) {
            this.setVisible(false);
        } else if (object.equals(this.getTableHolder().getClearButton())) {
            this.getOKButton().setEnabled(false);
        } else if (object.equals(this.getTableHolder().getRestoreButton())) {
            this.getOKButton().setEnabled(true);
        } else if (object.equals(this.getTableHolder().getComplementButton())) {
            this.getOKButton().setEnabled(true);
        }
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        String string;
        Object object = propertyChangeEvent.getSource();
        if (object.equals(this.getTableHolder().getTable()) && "tableCellEditor".equals(string = propertyChangeEvent.getPropertyName())) {
            SwingUtilities.invokeLater(new InputObserver());
        }
    }

    public void setVisible(boolean bl) {
        this.pack();
        super.setVisible(bl);
    }

    protected class InputObserver
    extends Thread {
        InputObserver() {
        }

        public void run() {
            boolean bl = SGDataSetupDialog.this.getTableHolder().checkSelectedItems();
            SGDataSetupDialog.this.getOKButton().setEnabled(bl);
        }
    }
}

