/*
 * Decompiled with CFR 0.152.
 */
package jp.riken.brain.ni.samuraigraph.data;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import jp.riken.brain.ni.samuraigraph.base.SGCSVTokenizer;
import jp.riken.brain.ni.samuraigraph.base.SGData;
import jp.riken.brain.ni.samuraigraph.base.SGDataColumnInfo;
import jp.riken.brain.ni.samuraigraph.base.SGTuple2d;
import jp.riken.brain.ni.samuraigraph.base.SGUtility;
import jp.riken.brain.ni.samuraigraph.base.SGUtilityText;
import jp.riken.brain.ni.samuraigraph.base.SGValueRange;
import jp.riken.brain.ni.samuraigraph.data.SGDataSourceObserver;
import jp.riken.brain.ni.samuraigraph.data.SGDate;
import jp.riken.brain.ni.samuraigraph.data.SGDefaultColumnTypeUtility;
import jp.riken.brain.ni.samuraigraph.data.SGIDataColumnNameConstants;
import jp.riken.brain.ni.samuraigraph.data.SGIDataColumnTypeConstants;
import jp.riken.brain.ni.samuraigraph.data.SGISXYTypeData;
import jp.riken.brain.ni.samuraigraph.data.SGISXYTypeMultipleData;
import jp.riken.brain.ni.samuraigraph.data.SGISXYZTypeData;
import jp.riken.brain.ni.samuraigraph.data.SGIVXYTypeData;
import jp.riken.brain.ni.samuraigraph.data.SGNetCDFData;
import jp.riken.brain.ni.samuraigraph.data.SGNetCDFDataColumnInfo;
import jp.riken.brain.ni.samuraigraph.data.SGNetCDFFile;
import jp.riken.brain.ni.samuraigraph.data.SGSXYMultipleDimensionNetCDFData;
import jp.riken.brain.ni.samuraigraph.data.SGSXYMultipleNetCDFData;
import jp.riken.brain.ni.samuraigraph.data.SGSXYMultipleVariableNetCDFData;
import jp.riken.brain.ni.samuraigraph.data.SGVariable;
import org.w3c.dom.NamedNodeMap;
import ucar.ma2.DataType;
import ucar.nc2.Attribute;
import ucar.nc2.Dimension;
import ucar.nc2.NetcdfFile;
import ucar.nc2.Variable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SGDataUtility
implements SGIDataColumnTypeConstants,
SGIDataColumnNameConstants {
    private static final String[] ARRAY_EMPTY = new String[]{""};
    private static final String[] ARRAY_NUMBER_SXYZ = new String[]{"", "X", "Y", "Z"};
    private static final String[] ARRAY_NUMBER_NETCDF_SXYZ = new String[]{"", "X", "Y", "Z", "Time", "SerialNumbers"};
    private static final String[] ARRAY_NUMBER_VXY_POLAR = new String[]{"", "X-Coordinate", "Y-Coordinate", "Magnitude", "Angle"};
    private static final String[] ARRAY_NUMBER_VXY_ORTHOGONAL = new String[]{"", "X-Coordinate", "Y-Coordinate", "X-Component", "Y-Component"};
    private static final String[] ARRAY_NUMBER_NETCDF_VXY_POLAR = new String[]{"", "X-Coordinate", "Y-Coordinate", "Magnitude", "Angle", "Time", "SerialNumbers"};
    private static final String[] ARRAY_NUMBER_NETCDF_VXY_ORTHOGONAL = new String[]{"", "X-Coordinate", "Y-Coordinate", "X-Component", "Y-Component", "Time", "SerialNumbers"};
    private static final String MID_COLUMN_NO = " for No.";
    private static final String MID_COLUMN_NETCDF = " for ";
    private static final int DEFAULT_MULTIPLE_DIMENSION_NUM = 4;
    public static final String ATTRIBUTE_KEY_VALUE_TYPE = "value_type";

    public static final String appendColumnNo(String string, int n) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(string);
        stringBuffer.append(MID_COLUMN_NO);
        stringBuffer.append(n + 1);
        return stringBuffer.toString();
    }

    public static final String appendColumnTitle(String string, String string2) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(string);
        stringBuffer.append(MID_COLUMN_NETCDF);
        stringBuffer.append(string2);
        return stringBuffer.toString();
    }

    public static final String appendColumnNoOrTitle(String string, int n, boolean bl, String string2) {
        if (bl) {
            return SGDataUtility.appendColumnNo(string, n);
        }
        return SGDataUtility.appendColumnTitle(string, string2);
    }

    public static final String appendNetCDFColumnTitle(String string, int n, SGDataColumnInfo[] sGDataColumnInfoArray) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(string);
        stringBuffer.append(MID_COLUMN_NETCDF);
        if (sGDataColumnInfoArray[n] instanceof SGNetCDFDataColumnInfo) {
            stringBuffer.append(((SGNetCDFDataColumnInfo)sGDataColumnInfoArray[n]).getVariableName());
        } else {
            stringBuffer.append(sGDataColumnInfoArray[n].getTitle());
        }
        return stringBuffer.toString();
    }

    public static final String appendColumnType(String string, int n, boolean bl, SGDataColumnInfo[] sGDataColumnInfoArray, boolean bl2) {
        if (bl) {
            return SGDataUtility.appendNetCDFColumnTitle(string, n, sGDataColumnInfoArray);
        }
        return SGDataUtility.appendColumnNoOrTitle(string, n, bl2, sGDataColumnInfoArray[n].getTitle());
    }

    public static final Integer getAppendedColumnIndex(String string) {
        int n = string.toUpperCase().indexOf("for".toUpperCase());
        if (n == -1) {
            return null;
        }
        String string2 = string.substring(n += "for".length()).trim().toUpperCase();
        if (!SGUtilityText.startsWith(string2, "No".toUpperCase())) {
            return null;
        }
        String string3 = (string2 = SGUtilityText.getCharString(string2)).substring("No".length());
        Integer n2 = SGUtilityText.getInteger(string3);
        if (n2 == null) {
            return null;
        }
        return n2 - 1;
    }

    public static final Integer getAppendedColumnIndex(String string, SGDataColumnInfo[] sGDataColumnInfoArray) {
        Integer n = SGDataUtility.getColumnIndexOfNetCDFAppendedColumnTitle(string, sGDataColumnInfoArray);
        if (null == n) {
            n = SGDataUtility.getAppendedColumnIndex(string);
        }
        return n;
    }

    public static final Integer getAppendedColumnIndex(String string, String[] stringArray) {
        int n = string.toUpperCase().indexOf(MID_COLUMN_NETCDF.trim().toUpperCase());
        if (n == -1) {
            return null;
        }
        String string2 = string.substring(n += MID_COLUMN_NETCDF.trim().length()).trim();
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i] == null || !string2.equals(stringArray[i].trim())) continue;
            return i;
        }
        return SGDataUtility.getAppendedColumnIndex(string);
    }

    public static final Integer getColumnIndexOfNetCDFAppendedColumnTitle(String string, SGDataColumnInfo[] sGDataColumnInfoArray) {
        int n = string.toUpperCase().indexOf(MID_COLUMN_NETCDF.trim().toUpperCase());
        if (n == -1) {
            return null;
        }
        String string2 = string.substring(n += MID_COLUMN_NETCDF.trim().length()).trim();
        for (int i = 0; i < sGDataColumnInfoArray.length; ++i) {
            if (!(sGDataColumnInfoArray[i] instanceof SGNetCDFDataColumnInfo ? string2.equals(((SGNetCDFDataColumnInfo)sGDataColumnInfoArray[i]).getVariableName()) : string2.equals(sGDataColumnInfoArray[i].getTitle()))) continue;
            return i;
        }
        return null;
    }

    public static final Integer getColumnIndexOfNetCDFAppendedColumnTitle(String string, SGNetCDFFile sGNetCDFFile) {
        int n = string.toUpperCase().indexOf(MID_COLUMN_NETCDF.toUpperCase().trim());
        if (n == -1) {
            return null;
        }
        String string2 = string.substring(n += MID_COLUMN_NETCDF.trim().length()).trim();
        int n2 = sGNetCDFFile.getVariableIndex(string2);
        if (n2 == -1) {
            return null;
        }
        return n2;
    }

    public static final Integer getColumnIndexOfAppendedColumnType(String string, boolean bl, SGDataColumnInfo[] sGDataColumnInfoArray) {
        if (bl) {
            return SGDataUtility.getColumnIndexOfNetCDFAppendedColumnTitle(string, sGDataColumnInfoArray);
        }
        return SGDataUtility.getAppendedColumnIndex(string, sGDataColumnInfoArray);
    }

    private static String[] getSXYColumnTypeCandidates(String string, Map<String, Object> map, String string2) {
        ArrayList<String> arrayList;
        block20: {
            Serializable serializable;
            int n;
            ArrayList<Integer> arrayList2;
            ArrayList<Integer> arrayList3;
            boolean[] blArray;
            SGDataColumnInfo[] sGDataColumnInfoArray;
            Integer n2;
            boolean bl;
            block19: {
                Object object;
                bl = SGDataUtility.isNetCDFData(string);
                Boolean bl2 = null;
                Boolean bl3 = null;
                if (bl) {
                    bl2 = (Boolean)map.get("Multiple");
                    if (bl2 == null) {
                        return null;
                    }
                    bl3 = (Boolean)map.get("Graphs for multiple variables");
                    if (bl3 == null) {
                        return null;
                    }
                }
                arrayList = new ArrayList<String>();
                arrayList.add("");
                if (!"Text".equals(string2)) {
                    arrayList.add("X");
                    arrayList.add("Y");
                }
                n2 = (Integer)map.get("Current Row Index");
                sGDataColumnInfoArray = (SGDataColumnInfo[])map.get("Column Information");
                blArray = SGDataUtility.isEmptyOrRepeatedColumnTitle(sGDataColumnInfoArray);
                arrayList3 = new ArrayList<Integer>();
                arrayList2 = new ArrayList<Integer>();
                for (n = 0; n < sGDataColumnInfoArray.length; ++n) {
                    String string3 = sGDataColumnInfoArray[n].getColumnType();
                    object = n;
                    if ("X".equals(string3)) {
                        arrayList3.add((Integer)object);
                        continue;
                    }
                    if (!"Y".equals(string3)) continue;
                    arrayList2.add((Integer)object);
                }
                n = 0;
                for (int i = 0; i < sGDataColumnInfoArray.length; ++i) {
                    object = sGDataColumnInfoArray[i].getValueType();
                    if ("Number".equals(object)) {
                        ++n;
                        continue;
                    }
                    if (!"Date".equals(object) || !"X".equals(sGDataColumnInfoArray[i].getColumnType()) && !"Y".equals(sGDataColumnInfoArray[i].getColumnType())) continue;
                    ++n;
                }
                if (bl && "Number".equals(string2)) {
                    arrayList.add("Time");
                    arrayList.add("Pickup");
                    arrayList.add("SerialNumbers");
                }
                if (!bl || bl3.booleanValue()) break block19;
                arrayList.add("Lower Error");
                arrayList.add("Upper Error");
                arrayList.add("Lower / Upper Error");
                arrayList.add("Tick Label");
                break block20;
            }
            List<Integer> list = SGDataUtility.getOptionalColumnsAssignableIndexList(string, sGDataColumnInfoArray, arrayList3, arrayList2);
            if (list == null) break block20;
            list.remove(n2);
            if ("Number".equals(string2)) {
                for (int i = 0; i < list.size(); ++i) {
                    serializable = list.get(i);
                    String string4 = sGDataColumnInfoArray[(Integer)serializable].getValueType();
                    if ("Sampling Rate".equals(string4)) continue;
                    int n3 = (Integer)serializable;
                    if (n >= 4) {
                        arrayList.add(SGDataUtility.appendColumnType("Lower Error", n3, bl, sGDataColumnInfoArray, blArray[n3]));
                        arrayList.add(SGDataUtility.appendColumnType("Upper Error", n3, bl, sGDataColumnInfoArray, blArray[n3]));
                        arrayList.add(SGDataUtility.appendColumnType("Lower / Upper Error", n3, bl, sGDataColumnInfoArray, blArray[n3]));
                        continue;
                    }
                    if (n < 3) continue;
                    arrayList.add(SGDataUtility.appendColumnType("Lower / Upper Error", n3, bl, sGDataColumnInfoArray, blArray[n3]));
                }
            }
            if (!"Sampling Rate".equals(sGDataColumnInfoArray[n2].getValueType())) {
                int n4;
                ArrayList<Integer> arrayList4 = new ArrayList<Integer>();
                serializable = new ArrayList();
                for (n4 = 0; n4 < list.size(); ++n4) {
                    Integer n5 = list.get(n4);
                    String string5 = sGDataColumnInfoArray[n5].getValueType();
                    if ("Date".equals(string5)) {
                        arrayList4.add(n5);
                        continue;
                    }
                    serializable.add(n5);
                }
                if (arrayList4.size() != 0) {
                    for (n4 = 0; n4 < serializable.size(); ++n4) {
                        Integer n6 = (Integer)serializable.get(n4);
                        int n7 = n6;
                        arrayList.add(SGDataUtility.appendColumnType("Tick Label", n7, bl, sGDataColumnInfoArray, blArray[n7]));
                    }
                } else {
                    for (n4 = 0; n4 < list.size(); ++n4) {
                        Integer n8 = list.get(n4);
                        int n9 = n8;
                        arrayList.add(SGDataUtility.appendColumnType("Tick Label", n9, bl, sGDataColumnInfoArray, blArray[n9]));
                    }
                }
            }
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String[] getColumnTypeCandidates(String string, Map<String, Object> map, String string2) {
        String[] stringArray = null;
        if (SGDataUtility.isSXYTypeData(string)) {
            stringArray = "Byte Data".equals(string2) ? ARRAY_EMPTY : SGDataUtility.getSXYColumnTypeCandidates(string, map, string2);
            return (String[])stringArray.clone();
        } else if ("SXYZ".equals(string)) {
            if ("Number".equals(string2)) {
                stringArray = ARRAY_NUMBER_SXYZ;
                return (String[])stringArray.clone();
            } else if ("Text".equals(string2)) {
                stringArray = ARRAY_EMPTY;
                return (String[])stringArray.clone();
            } else if ("Date".equals(string2)) {
                stringArray = ARRAY_EMPTY;
                return (String[])stringArray.clone();
            } else {
                if (!"Byte Data".equals(string2)) throw new IllegalArgumentException("Invalid value type: " + string2);
                stringArray = ARRAY_EMPTY;
            }
            return (String[])stringArray.clone();
        } else if ("SXYZ_NETCDF".equals(string)) {
            if ("Number".equals(string2)) {
                stringArray = ARRAY_NUMBER_NETCDF_SXYZ;
                return (String[])stringArray.clone();
            } else if ("Text".equals(string2)) {
                stringArray = ARRAY_EMPTY;
                return (String[])stringArray.clone();
            } else if ("Date".equals(string2)) {
                stringArray = ARRAY_EMPTY;
                return (String[])stringArray.clone();
            } else {
                if (!"Byte Data".equals(string2)) throw new IllegalArgumentException("Invalid value type: " + string2);
                stringArray = ARRAY_EMPTY;
            }
            return (String[])stringArray.clone();
        } else if ("VXY".equals(string)) {
            if ("Number".equals(string2)) {
                stringArray = SGDataUtility.isPolar(map) ? ARRAY_NUMBER_VXY_POLAR : ARRAY_NUMBER_VXY_ORTHOGONAL;
                return (String[])stringArray.clone();
            } else if ("Text".equals(string2)) {
                stringArray = ARRAY_EMPTY;
                return (String[])stringArray.clone();
            } else if ("Date".equals(string2)) {
                stringArray = ARRAY_EMPTY;
                return (String[])stringArray.clone();
            } else {
                if (!"Byte Data".equals(string2)) throw new IllegalArgumentException("Invalid value type: " + string2);
                stringArray = ARRAY_EMPTY;
            }
            return (String[])stringArray.clone();
        } else {
            if (!"VXY_NETCDF".equals(string)) throw new IllegalArgumentException("Invalid data type: " + string);
            if ("Number".equals(string2)) {
                stringArray = SGDataUtility.isPolar(map) ? ARRAY_NUMBER_NETCDF_VXY_POLAR : ARRAY_NUMBER_NETCDF_VXY_ORTHOGONAL;
                return (String[])stringArray.clone();
            } else if ("Text".equals(string2)) {
                stringArray = ARRAY_EMPTY;
                return (String[])stringArray.clone();
            } else if ("Date".equals(string2)) {
                stringArray = ARRAY_EMPTY;
                return (String[])stringArray.clone();
            } else {
                if (!"Byte Data".equals(string2)) throw new IllegalArgumentException("Invalid value type: " + string2);
                stringArray = ARRAY_EMPTY;
            }
        }
        return (String[])stringArray.clone();
    }

    /*
     * WARNING - void declaration
     */
    public static boolean checkDataColumns(String string, SGDataColumnInfo[] sGDataColumnInfoArray, Map<String, Object> map) {
        int n;
        int n2;
        int n3 = sGDataColumnInfoArray.length;
        Object[] objectArray = new String[n3];
        for (n2 = 0; n2 < n3; ++n2) {
            objectArray[n2] = sGDataColumnInfoArray[n2].getColumnType();
        }
        if (!SGDataUtility.isSXYTypeData(string)) {
            for (n2 = 0; n2 < n3 - 1; ++n2) {
                if (objectArray[n2] == null || "".equals(objectArray[n2])) continue;
                for (n = n2 + 1; n < n3; ++n) {
                    if (!((String)objectArray[n2]).equals(objectArray[n])) continue;
                    return false;
                }
            }
        }
        if (SGDataUtility.isSXYTypeData(string)) {
            int n4;
            boolean bl;
            n2 = SGDataUtility.count(objectArray, "X");
            n = SGDataUtility.count(objectArray, "Y");
            boolean bl2 = n2 == 1 && n > 1;
            boolean bl3 = n2 > 1 && n == 1;
            boolean bl4 = bl = n2 == 1 && n == 1;
            if (!(bl2 || bl3 || bl)) {
                return false;
            }
            String string2 = null;
            String string3 = null;
            if (bl2) {
                string2 = "Y";
                string3 = "X";
            } else if (bl3) {
                string2 = "X";
                string3 = "Y";
            }
            if (!bl) {
                HashSet<String> hashSet = new HashSet<String>();
                if (string2 != null) {
                    for (n4 = 0; n4 < n3; ++n4) {
                        if (!string2.equals(objectArray[n4])) continue;
                        hashSet.add(sGDataColumnInfoArray[n4].getValueType());
                    }
                }
                if (hashSet.contains("Sampling Rate")) {
                    return false;
                }
                if (hashSet.contains("Date")) {
                    return false;
                }
            }
            boolean bl5 = false;
            if (SGDataUtility.isArrayData(string)) {
                bl5 = true;
            } else if (SGDataUtility.isNetCDFData(string)) {
                Boolean bl6 = (Boolean)map.get("Graphs for multiple variables");
                if (bl6 == null) {
                    return false;
                }
                bl5 = bl6;
            } else {
                return false;
            }
            if (bl5) {
                void var22_36;
                Object object;
                Serializable serializable;
                Object object2;
                n4 = SGDataUtility.isNetCDFData(string) ? 1 : 0;
                ArrayList<Object> arrayList = new ArrayList<Object>();
                ArrayList<Object> arrayList2 = new ArrayList<Object>();
                ArrayList<Object> arrayList3 = new ArrayList<Object>();
                for (int i = 0; i < objectArray.length; ++i) {
                    Object object3 = objectArray[i];
                    if (((String)object3).startsWith("Lower Error")) {
                        object2 = SGDataUtility.getColumnIndexOfAppendedColumnType((String)object3, n4 != 0, sGDataColumnInfoArray);
                        if (object2 == null) {
                            return false;
                        }
                        arrayList.add(object2);
                        continue;
                    }
                    if (((String)object3).startsWith("Upper Error")) {
                        object2 = SGDataUtility.getColumnIndexOfAppendedColumnType((String)object3, n4 != 0, sGDataColumnInfoArray);
                        if (object2 == null) {
                            return false;
                        }
                        arrayList2.add(object2);
                        continue;
                    }
                    if (!((String)object3).startsWith("Lower / Upper Error")) continue;
                    object2 = SGDataUtility.getColumnIndexOfAppendedColumnType((String)object3, n4 != 0, sGDataColumnInfoArray);
                    if (object2 == null) {
                        return false;
                    }
                    arrayList3.add(object2);
                }
                ArrayList<Integer> arrayList4 = new ArrayList<Integer>();
                for (int i = 0; i < objectArray.length; ++i) {
                    object2 = objectArray[i];
                    if (!((String)object2).startsWith("Tick Label")) continue;
                    serializable = SGDataUtility.getColumnIndexOfAppendedColumnType((String)object2, n4 != 0, sGDataColumnInfoArray);
                    if (serializable == null) {
                        return false;
                    }
                    arrayList4.add((Integer)serializable);
                }
                if (!bl) {
                    Integer n5 = null;
                    for (int i = 0; i < objectArray.length; ++i) {
                        if (!((String)objectArray[i]).equals(string3)) continue;
                        n5 = i;
                        break;
                    }
                    if (n5 == null) {
                        return false;
                    }
                    if (arrayList.contains(n5)) {
                        return false;
                    }
                    if (arrayList2.contains(n5)) {
                        return false;
                    }
                    if (arrayList3.contains(n5)) {
                        return false;
                    }
                    if (arrayList4.contains(n5)) {
                        return false;
                    }
                }
                TreeSet<Object> treeSet = new TreeSet<Object>();
                treeSet.addAll(arrayList);
                treeSet.addAll(arrayList2);
                treeSet.addAll(arrayList3);
                treeSet.addAll(arrayList4);
                ArrayList<Integer> arrayList5 = new ArrayList<Integer>();
                serializable = new ArrayList();
                for (Integer n6 : treeSet) {
                    object = objectArray[n6];
                    if ("X".equals(object)) {
                        arrayList5.add(n6);
                        continue;
                    }
                    if (!"Y".equals(object)) continue;
                    serializable.add(n6);
                }
                if (arrayList5.size() != 0 && serializable.size() != 0) {
                    return false;
                }
                if (SGDataUtility.isDuplicated(arrayList)) {
                    return false;
                }
                if (SGDataUtility.isDuplicated(arrayList2)) {
                    return false;
                }
                if (SGDataUtility.isDuplicated(arrayList3)) {
                    return false;
                }
                if (SGDataUtility.isDuplicated(arrayList4)) {
                    return false;
                }
                if (!((Object)arrayList).equals(arrayList2)) {
                    return false;
                }
                boolean i = false;
                while (var22_36 < arrayList3.size()) {
                    object = arrayList3.get((int)var22_36);
                    if (arrayList.contains(object)) {
                        return false;
                    }
                    if (arrayList2.contains(object)) {
                        return false;
                    }
                    ++var22_36;
                }
            }
        } else if (string.equals("SXYZ") || string.equals("SXYZ_NETCDF")) {
            n2 = SGDataUtility.count(objectArray, "X");
            if (n2 != 1) {
                return false;
            }
            n = SGDataUtility.count(objectArray, "Y");
            if (n != 1) {
                return false;
            }
            int n7 = SGDataUtility.count(objectArray, "Z");
            if (n7 != 1) {
                return false;
            }
        } else if (string.equals("VXY") || string.equals("VXY_NETCDF")) {
            int n8;
            int n9;
            n2 = SGDataUtility.count(objectArray, "X-Coordinate");
            if (n2 != 1) {
                return false;
            }
            n = SGDataUtility.count(objectArray, "Y-Coordinate");
            if (n != 1) {
                return false;
            }
            if (SGDataUtility.isPolar(map)) {
                n9 = SGDataUtility.count(objectArray, "Magnitude");
                n8 = SGDataUtility.count(objectArray, "Angle");
            } else {
                n9 = SGDataUtility.count(objectArray, "X-Component");
                n8 = SGDataUtility.count(objectArray, "Y-Component");
            }
            if (n9 != 1) {
                return false;
            }
            if (n8 != 1) {
                return false;
            }
        }
        return !SGDataUtility.isNetCDFData(string) || (n2 = SGDataUtility.count(objectArray, "Time")) <= 1;
    }

    private static boolean exists(Object[] objectArray, Object object) {
        for (int i = 0; i < objectArray.length; ++i) {
            if (!object.equals(objectArray[i])) continue;
            return true;
        }
        return false;
    }

    private static int count(Object[] objectArray, Object object) {
        int n = 0;
        for (int i = 0; i < objectArray.length; ++i) {
            if (!object.equals(objectArray[i])) continue;
            ++n;
        }
        return n;
    }

    private static boolean isDuplicated(List list) {
        for (int i = 0; i < list.size() - 1; ++i) {
            for (int j = i + 1; j < list.size(); ++j) {
                if (!SGUtility.equals(list.get(i), list.get(j))) continue;
                return true;
            }
        }
        return false;
    }

    private static int indexOf(Object[] objectArray, Object object) {
        for (int i = 0; i < objectArray.length; ++i) {
            if (!object.equals(objectArray[i])) continue;
            return i;
        }
        return -1;
    }

    private static int lastIndexOf(Object[] objectArray, Object object) {
        for (int i = objectArray.length - 1; i >= 0; --i) {
            if (!object.equals(objectArray[i])) continue;
            return i;
        }
        return -1;
    }

    public static boolean isPolar(Map<String, Object> map) {
        Object object = map.get("Polar selected");
        if (object == null) {
            throw new Error("Mode for vector data is not selected.");
        }
        Boolean bl = (Boolean)object;
        return bl;
    }

    static boolean[] isEmptyOrRepeatedColumnTitle(SGDataColumnInfo[] sGDataColumnInfoArray) {
        int n = sGDataColumnInfoArray.length;
        boolean[] blArray = new boolean[n];
        Arrays.fill(blArray, false);
        for (int i = 0; i < n; ++i) {
            SGDataColumnInfo sGDataColumnInfo = sGDataColumnInfoArray[i];
            String string = sGDataColumnInfo.getTitle();
            if (string == null || string.trim().equals("")) {
                blArray[i] = true;
            }
            if (blArray[i]) continue;
            for (int j = i + 1; j < n; ++j) {
                if (!string.equalsIgnoreCase(sGDataColumnInfoArray[j].getTitle())) continue;
                blArray[i] = true;
                blArray[j] = true;
            }
        }
        return blArray;
    }

    public static boolean getDataTypeCandidateList(List<SGCSVTokenizer.Token> list, List<Integer> list2, List<String> list3) {
        int n;
        int n2;
        int n3 = 0;
        for (int i = 0; i < list2.size(); ++i) {
            Integer n4 = list2.get(i);
            n2 = n4;
            if (n2 != 1) continue;
            ++n3;
        }
        String[] stringArray = new String[]{"SXY", "SXY_MULTIPLE", "SXY_SAMPLING", "VXY", "SXYZ"};
        for (n = 0; n < stringArray.length; ++n) {
            n2 = SGDataUtility.getMinimumNumberColumns(stringArray[n]);
            if (n3 < n2) continue;
            list3.add(stringArray[n]);
        }
        if (n3 >= SGDataUtility.getMinimumNumberColumns("SXY_DATE")) {
            for (n = 0; n < list.size(); ++n) {
                SGCSVTokenizer.Token token = list.get(n);
                if (SGUtilityText.getDate(token.getString()) == null) continue;
                list3.add("SXY_DATE");
                break;
            }
        }
        return true;
    }

    public static int getMinimumNumberColumns(String string) {
        int n = -1;
        if ("SXY".equals(string)) {
            n = 1;
        } else if ("SXY_MULTIPLE".equals(string)) {
            n = 1;
        } else if ("SXY_SAMPLING".equals(string)) {
            n = 1;
        } else if ("VXY".equals(string)) {
            n = 4;
        } else if ("SXYZ".equals(string)) {
            n = 3;
        }
        return n;
    }

    public static List<Integer> getColumnIndexListOfNumber(List<SGCSVTokenizer.Token> list) {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        for (int i = 0; i < list.size(); ++i) {
            SGCSVTokenizer.Token token = list.get(i);
            String string = token.getString();
            if (token.isDoubleQuoted()) {
                arrayList.add(0);
                continue;
            }
            Double d = SGUtilityText.getDouble(string);
            if (d != null) {
                arrayList.add(1);
                continue;
            }
            arrayList.add(0);
        }
        return arrayList;
    }

    private static List<String> getColumnNameList(SGNetCDFDataColumnInfo[] sGNetCDFDataColumnInfoArray, String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < sGNetCDFDataColumnInfoArray.length; ++i) {
            String string2 = sGNetCDFDataColumnInfoArray[i].getColumnType();
            if (!string2.equals(string)) continue;
            arrayList.add(sGNetCDFDataColumnInfoArray[i].getVariableName());
        }
        return arrayList;
    }

    private static boolean getColumnNameAndAppendedNumberList(SGNetCDFDataColumnInfo[] sGNetCDFDataColumnInfoArray, String string, List<String> list, List<Integer> list2) {
        for (int i = 0; i < sGNetCDFDataColumnInfoArray.length; ++i) {
            String string2 = sGNetCDFDataColumnInfoArray[i].getColumnType();
            if (!string2.startsWith(string)) continue;
            String string3 = sGNetCDFDataColumnInfoArray[i].getVariableName();
            Integer n = SGDataUtility.getColumnIndexOfNetCDFAppendedColumnTitle(string2, sGNetCDFDataColumnInfoArray);
            if (n == null) {
                return false;
            }
            list.add(string3);
            list2.add(n);
        }
        return true;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean checkNetCDFDataColumns(SGNetCDFDataColumnInfo[] sGNetCDFDataColumnInfoArray, String string, SGNetCDFFile sGNetCDFFile, Map<String, Object> map) {
        List<String> list;
        Object object;
        List<String> list2 = SGDataUtility.getColumnNameList(sGNetCDFDataColumnInfoArray, "Time");
        if (list2.size() > 1) {
            return false;
        }
        SGVariable sGVariable = null;
        Dimension dimension = null;
        if (list2.size() == 1) {
            object = list2.get(0);
            sGVariable = sGNetCDFFile.findVariable((String)object);
            if (sGVariable == null) {
                return false;
            }
            if (!sGVariable.isCoordinateVariable()) {
                return false;
            }
            dimension = sGVariable.getDimension(0);
        }
        if ((object = SGDataUtility.getColumnNameList(sGNetCDFDataColumnInfoArray, "SerialNumbers")).size() > 1) {
            return false;
        }
        SGVariable sGVariable2 = null;
        Dimension dimension2 = null;
        if (object.size() == 1) {
            list = (String)object.get(0);
            sGVariable2 = sGNetCDFFile.findVariable((String)((Object)list));
            if (sGVariable2 == null) {
                return false;
            }
            if (!sGVariable2.isCoordinateVariable()) {
                return false;
            }
            dimension2 = sGVariable2.getDimension(0);
        }
        if (SGDataUtility.isSXYTypeData(string)) {
            Object object2;
            List<String> list3;
            List<Object> list4;
            Object object3;
            List<Object> list5;
            SGVariable sGVariable3;
            list = (Boolean)map.get("Multiple");
            if (list == null) {
                return false;
            }
            Boolean bl = (Boolean)map.get("Graphs for multiple variables");
            if (bl == null) {
                return false;
            }
            List<String> list6 = SGDataUtility.getColumnNameList(sGNetCDFDataColumnInfoArray, "X");
            List<String> list7 = SGDataUtility.getColumnNameList(sGNetCDFDataColumnInfoArray, "Y");
            if (list6.size() == 0 || list7.size() == 0) {
                return false;
            }
            if (bl != false ? list6.size() != 1 && list7.size() != 1 : list6.size() != 1 || list7.size() != 1) {
                return false;
            }
            String string2 = list6.get(0);
            String string3 = list7.get(0);
            SGVariable sGVariable4 = sGNetCDFFile.findVariable(string2);
            SGVariable sGVariable5 = sGNetCDFFile.findVariable(string3);
            if (sGVariable2 != null) {
                sGVariable3 = sGVariable2;
                list5 = new ArrayList<String>();
                list5.addAll(list6);
                list5.addAll(list7);
            } else if (list6.size() == 1 && list7.size() == 1) {
                if (sGVariable4.isCoordinateVariable()) {
                    sGVariable3 = sGVariable4;
                    list5 = list7;
                } else {
                    if (!sGVariable5.isCoordinateVariable()) return false;
                    sGVariable3 = sGVariable5;
                    list5 = list6;
                }
            } else if (list6.size() == 1) {
                if (!sGVariable4.isCoordinateVariable()) {
                    return false;
                }
                sGVariable3 = sGVariable4;
                list5 = list7;
            } else {
                if (!sGVariable5.isCoordinateVariable()) {
                    return false;
                }
                sGVariable3 = sGVariable5;
                list5 = list6;
            }
            ArrayList<SGVariable> arrayList = new ArrayList<SGVariable>();
            for (int i = 0; i < list5.size(); ++i) {
                String string4 = (String)list5.get(i);
                object3 = sGNetCDFFile.findVariable(string4);
                if (object3 == null) {
                    return false;
                }
                if (((SGVariable)object3).isCoordinateVariable()) {
                    return false;
                }
                arrayList.add((SGVariable)object3);
            }
            Dimension dimension3 = sGVariable3.getDimension(0);
            for (int i = 0; i < arrayList.size(); ++i) {
                object3 = (SGVariable)arrayList.get(i);
                list4 = ((SGVariable)object3).getDimensions();
                if (list4.contains(dimension3)) continue;
                return false;
            }
            if (!bl.booleanValue()) {
                List<Dimension> list8;
                list3 = SGDataUtility.getColumnNameList(sGNetCDFDataColumnInfoArray, "Lower Error");
                object3 = SGDataUtility.getColumnNameList(sGNetCDFDataColumnInfoArray, "Upper Error");
                if (!(list3.size() == 0 && object3.size() == 0 || list3.size() == 1 && object3.size() == 1)) {
                    return false;
                }
                list4 = SGDataUtility.getColumnNameList(sGNetCDFDataColumnInfoArray, "Lower / Upper Error");
                if (list3.size() == 1 && object3.size() == 1 && list4.size() != 0) {
                    return false;
                }
                if (list3.size() != 0) {
                    object2 = list3.get(0);
                    String string5 = (String)object3.get(0);
                    SGVariable sGVariable6 = sGNetCDFFile.findVariable((String)object2);
                    if (sGVariable6 == null) {
                        return false;
                    }
                    list8 = sGNetCDFFile.findVariable(string5);
                    if (list8 == null) {
                        return false;
                    }
                    boolean bl2 = sGVariable6.isCoordinateVariable();
                    if (bl2) {
                        return false;
                    }
                    boolean bl3 = ((SGVariable)((Object)list8)).isCoordinateVariable();
                    if (bl3) {
                        return false;
                    }
                    List<Dimension> list9 = sGVariable6.getDimensions();
                    if (!list9.contains(dimension3)) {
                        return false;
                    }
                    List<Dimension> list10 = ((SGVariable)((Object)list8)).getDimensions();
                    if (!list10.contains(dimension3)) {
                        return false;
                    }
                } else if (list4.size() != 0) {
                    object2 = (String)list4.get(0);
                    SGVariable sGVariable7 = sGNetCDFFile.findVariable((String)object2);
                    if (sGVariable7 == null) {
                        return false;
                    }
                    boolean bl4 = sGVariable7.isCoordinateVariable();
                    if (bl4) {
                        return false;
                    }
                    list8 = sGVariable7.getDimensions();
                    if (!list8.contains(dimension3)) {
                        return false;
                    }
                }
            } else {
                Object object4;
                boolean bl5;
                SGVariable sGVariable8;
                Object object5;
                void var26_65;
                list3 = new ArrayList<String>();
                object3 = new ArrayList<Integer>();
                list4 = new ArrayList<Dimension>();
                object2 = new ArrayList<Integer>();
                if (!SGDataUtility.getColumnNameAndAppendedNumberList(sGNetCDFDataColumnInfoArray, "Lower Error", list3, object3)) {
                    return false;
                }
                if (!SGDataUtility.getColumnNameAndAppendedNumberList(sGNetCDFDataColumnInfoArray, "Upper Error", list4, object2)) {
                    return false;
                }
                if (list3.size() != list4.size()) {
                    return false;
                }
                boolean bl6 = false;
                while (var26_65 < list3.size()) {
                    String string6 = list3.get((int)var26_65);
                    String string7 = (String)list4.get((int)var26_65);
                    object5 = sGNetCDFFile.findVariable(string6);
                    if (object5 == null) {
                        return false;
                    }
                    sGVariable8 = sGNetCDFFile.findVariable(string7);
                    if (sGVariable8 == null) {
                        return false;
                    }
                    bl5 = ((SGVariable)object5).isCoordinateVariable();
                    if (bl5) {
                        return false;
                    }
                    boolean bl7 = sGVariable8.isCoordinateVariable();
                    if (bl7) {
                        return false;
                    }
                    object4 = ((SGVariable)object5).getDimensions();
                    if (!object4.contains(dimension3)) {
                        return false;
                    }
                    List<Dimension> list11 = sGVariable8.getDimensions();
                    if (!list11.contains(dimension3)) {
                        return false;
                    }
                    ++var26_65;
                }
                ArrayList<String> arrayList2 = new ArrayList<String>();
                ArrayList<Integer> arrayList3 = new ArrayList<Integer>();
                if (!SGDataUtility.getColumnNameAndAppendedNumberList(sGNetCDFDataColumnInfoArray, "Lower / Upper Error", arrayList2, arrayList3)) {
                    return false;
                }
                for (int i = 0; i < arrayList2.size(); ++i) {
                    object5 = (String)arrayList2.get(i);
                    sGVariable8 = sGNetCDFFile.findVariable((String)object5);
                    if (sGVariable8 == null) {
                        return false;
                    }
                    bl5 = sGVariable8.isCoordinateVariable();
                    if (bl5) {
                        return false;
                    }
                    List<Dimension> list12 = sGVariable8.getDimensions();
                    if (!list12.contains(dimension3)) {
                        return false;
                    }
                    object4 = (Integer)arrayList3.get(i);
                    if (object3.contains(object4)) {
                        return false;
                    }
                    if (!object2.contains(object4)) continue;
                    return false;
                }
            }
            if (sGVariable != null) {
                for (int i = 0; i < arrayList.size(); ++i) {
                    object3 = (SGVariable)arrayList.get(i);
                    list4 = ((SGVariable)object3).getDimensions();
                    if (list4.contains(dimension)) continue;
                    return false;
                }
            }
            if (sGVariable2 != null) {
                for (int i = 0; i < arrayList.size(); ++i) {
                    object3 = (SGVariable)arrayList.get(i);
                    list4 = ((SGVariable)object3).getDimensions();
                    if (list4.contains(dimension2)) continue;
                    return false;
                }
            }
            if (bl.booleanValue()) return true;
            List<String> list13 = SGDataUtility.getColumnNameList(sGNetCDFDataColumnInfoArray, "Pickup");
            if (list13.size() != 1) {
                return false;
            }
            object3 = list13.get(0);
            list4 = sGNetCDFFile.findDimension((String)object3);
            if (list4 == null) {
                return false;
            }
            if (list4.equals(dimension3) || list4.equals(dimension)) {
                return false;
            }
            object2 = (SGVariable)arrayList.get(0);
            List<Dimension> list14 = ((SGVariable)object2).getDimensions();
            if (!list14.contains(list4)) {
                return false;
            }
            Integer n = (Integer)map.get("Multiple dimension start");
            if (n == null) {
                return false;
            }
            if (n < 0 || n >= list4.getLength()) {
                return false;
            }
            Integer n2 = (Integer)map.get("Multiple dimension end");
            if (n2 == null) {
                return false;
            }
            if (n2 < 0 || n2 >= list4.getLength()) {
                return false;
            }
            Integer n3 = (Integer)map.get("Multiple dimension step");
            if (n3 != null) return true;
            return false;
        }
        if ("VXY_NETCDF".equals(string)) {
            boolean bl = SGDataUtility.isPolar(map);
            String string8 = null;
            String string9 = null;
            if (bl) {
                string8 = "Magnitude";
                string9 = "Angle";
            } else {
                string8 = "X-Component";
                string9 = "Y-Component";
            }
            List<String> list15 = SGDataUtility.getColumnNameList(sGNetCDFDataColumnInfoArray, "X-Coordinate");
            if (list15.size() != 1) {
                return false;
            }
            List<String> list16 = SGDataUtility.getColumnNameList(sGNetCDFDataColumnInfoArray, "Y-Coordinate");
            if (list16.size() != 1) {
                return false;
            }
            List<String> list17 = SGDataUtility.getColumnNameList(sGNetCDFDataColumnInfoArray, string8);
            if (list17.size() != 1) {
                return false;
            }
            List<String> list18 = SGDataUtility.getColumnNameList(sGNetCDFDataColumnInfoArray, string9);
            if (list18.size() != 1) {
                return false;
            }
            String string10 = list15.get(0);
            String string11 = list16.get(0);
            String string12 = list17.get(0);
            String string13 = list18.get(0);
            SGVariable sGVariable9 = sGNetCDFFile.findVariable(string10);
            if (sGVariable9 == null) {
                return false;
            }
            SGVariable sGVariable10 = sGNetCDFFile.findVariable(string11);
            if (sGVariable10 == null) {
                return false;
            }
            SGVariable sGVariable11 = sGNetCDFFile.findVariable(string12);
            if (sGVariable11 == null) {
                return false;
            }
            SGVariable sGVariable12 = sGNetCDFFile.findVariable(string13);
            if (sGVariable12 == null) {
                return false;
            }
            if (sGVariable2 != null) {
                if (sGVariable9.isCoordinateVariable()) {
                    return false;
                }
                if (sGVariable10.isCoordinateVariable()) {
                    return false;
                }
            } else {
                if (!sGVariable9.isCoordinateVariable()) {
                    return false;
                }
                if (!sGVariable10.isCoordinateVariable()) {
                    return false;
                }
            }
            if (sGVariable11.isCoordinateVariable()) {
                return false;
            }
            if (sGVariable12.isCoordinateVariable()) {
                return false;
            }
            List<Dimension> list19 = sGVariable9.getDimensions();
            List<Dimension> list20 = sGVariable10.getDimensions();
            List<Dimension> list21 = sGVariable11.getDimensions();
            List<Dimension> list22 = sGVariable12.getDimensions();
            if (sGVariable2 != null) {
                if (!list19.contains(dimension2)) {
                    return false;
                }
                if (!list20.contains(dimension2)) {
                    return false;
                }
                if (!list21.contains(dimension2)) {
                    return false;
                }
                if (!list22.contains(dimension2)) {
                    return false;
                }
            } else {
                Dimension dimension4 = list19.get(0);
                Dimension dimension5 = list20.get(0);
                if (!list21.contains(dimension4)) {
                    return false;
                }
                if (!list21.contains(dimension5)) {
                    return false;
                }
                if (!list22.contains(dimension4)) {
                    return false;
                }
                if (!list22.contains(dimension5)) {
                    return false;
                }
            }
            if (sGVariable == null) return true;
            if (dimension2 != null) {
                if (!list19.contains(dimension)) {
                    return false;
                }
                if (!list20.contains(dimension)) {
                    return false;
                }
            }
            if (!list21.contains(dimension)) {
                return false;
            }
            if (list22.contains(dimension)) return true;
            return false;
        }
        if (!"SXYZ_NETCDF".equals(string)) throw new Error("Invalid data type: " + string);
        list = SGDataUtility.getColumnNameList(sGNetCDFDataColumnInfoArray, "X");
        if (list.size() != 1) {
            return false;
        }
        List<String> list23 = SGDataUtility.getColumnNameList(sGNetCDFDataColumnInfoArray, "Y");
        if (list23.size() != 1) {
            return false;
        }
        List<String> list24 = SGDataUtility.getColumnNameList(sGNetCDFDataColumnInfoArray, "Z");
        if (list24.size() != 1) {
            return false;
        }
        String string14 = list.get(0);
        String string15 = list23.get(0);
        String string16 = list24.get(0);
        SGVariable sGVariable13 = sGNetCDFFile.findVariable(string14);
        if (sGVariable13 == null) {
            return false;
        }
        SGVariable sGVariable14 = sGNetCDFFile.findVariable(string15);
        if (sGVariable14 == null) {
            return false;
        }
        SGVariable sGVariable15 = sGNetCDFFile.findVariable(string16);
        if (sGVariable15 == null) {
            return false;
        }
        if (sGVariable2 != null) {
            if (sGVariable13.isCoordinateVariable()) {
                return false;
            }
            if (sGVariable14.isCoordinateVariable()) {
                return false;
            }
        } else {
            if (!sGVariable13.isCoordinateVariable()) {
                return false;
            }
            if (!sGVariable14.isCoordinateVariable()) {
                return false;
            }
        }
        if (sGVariable15.isCoordinateVariable()) {
            return false;
        }
        List<Dimension> list25 = sGVariable13.getDimensions();
        List<Dimension> list26 = sGVariable14.getDimensions();
        List<Dimension> list27 = sGVariable15.getDimensions();
        if (sGVariable2 != null) {
            if (!list25.contains(dimension2)) {
                return false;
            }
            if (!list26.contains(dimension2)) {
                return false;
            }
            if (!list27.contains(dimension2)) {
                return false;
            }
        } else {
            Dimension dimension6 = list25.get(0);
            Dimension dimension7 = list26.get(0);
            if (!list27.contains(dimension6)) {
                return false;
            }
            if (!list27.contains(dimension7)) {
                return false;
            }
        }
        if (sGVariable == null) return true;
        if (sGVariable2 != null) {
            if (!list25.contains(dimension)) {
                return false;
            }
            if (!list26.contains(dimension)) {
                return false;
            }
        }
        if (list27.contains(dimension)) return true;
        return false;
    }

    public static double getMaxValue(double[] dArray) {
        boolean bl = false;
        double d = -1.7976931348623157E308;
        for (int i = 0; i < dArray.length; ++i) {
            if (Double.isNaN(dArray[i]) || Double.isInfinite(dArray[i])) continue;
            if (dArray[i] > d) {
                d = dArray[i];
            }
            bl = true;
        }
        if (!bl) {
            return Double.NaN;
        }
        return d;
    }

    public static double getMinValue(double[] dArray) {
        boolean bl = false;
        double d = Double.MAX_VALUE;
        for (int i = 0; i < dArray.length; ++i) {
            if (Double.isNaN(dArray[i]) || Double.isInfinite(dArray[i])) continue;
            if (dArray[i] < d) {
                d = dArray[i];
            }
            bl = true;
        }
        if (!bl) {
            return Double.NaN;
        }
        return d;
    }

    public static SGValueRange getBounds(double[] dArray) {
        return new SGValueRange(SGDataUtility.getMinValue(dArray), SGDataUtility.getMaxValue(dArray));
    }

    public static SGValueRange getBoundsX(SGISXYTypeData sGISXYTypeData) {
        double[] dArray = sGISXYTypeData.getXValueArray();
        if (dArray == null) {
            return null;
        }
        if (sGISXYTypeData.isErrorBarAvailable() && !sGISXYTypeData.isErrorBarVertical().booleanValue()) {
            return SGDataUtility.getBounds(sGISXYTypeData, dArray);
        }
        return SGDataUtility.getBounds(dArray);
    }

    public static SGValueRange getBoundsY(SGISXYTypeData sGISXYTypeData) {
        double[] dArray = sGISXYTypeData.getYValueArray();
        if (dArray == null) {
            return null;
        }
        if (sGISXYTypeData.isErrorBarAvailable() && sGISXYTypeData.isErrorBarVertical().booleanValue()) {
            return SGDataUtility.getBounds(sGISXYTypeData, dArray);
        }
        return SGDataUtility.getBounds(dArray);
    }

    private static SGValueRange getBounds(SGISXYTypeData sGISXYTypeData, double[] dArray) {
        double[] dArray2 = sGISXYTypeData.getLowerErrorValueArray();
        double[] dArray3 = sGISXYTypeData.getUpperErrorValueArray();
        double[] dArray4 = new double[dArray.length];
        double[] dArray5 = new double[dArray.length];
        for (int i = 0; i < dArray.length; ++i) {
            dArray4[i] = dArray[i] + dArray2[i];
            dArray5[i] = dArray[i] + dArray3[i];
        }
        SGValueRange sGValueRange = SGDataUtility.getBounds(dArray);
        SGValueRange sGValueRange2 = SGDataUtility.getBounds(dArray4);
        SGValueRange sGValueRange3 = SGDataUtility.getBounds(dArray5);
        ArrayList<SGValueRange> arrayList = new ArrayList<SGValueRange>();
        arrayList.add(sGValueRange);
        arrayList.add(sGValueRange2);
        arrayList.add(sGValueRange3);
        Double d = SGDataUtility.getMinValue(arrayList);
        Double d2 = SGDataUtility.getMaxValue(arrayList);
        double d3 = d != null ? d : Double.NaN;
        double d4 = d2 != null ? d2 : Double.NaN;
        SGValueRange sGValueRange4 = new SGValueRange(d3, d4);
        return sGValueRange4;
    }

    public static Double getMinValue(List<SGValueRange> list) {
        Double d = null;
        for (int i = 0; i < list.size(); ++i) {
            SGValueRange sGValueRange = list.get(i);
            if (!sGValueRange.isMinValid()) continue;
            double d2 = sGValueRange.getMinValue();
            if (d == null) {
                d = d2;
                continue;
            }
            if (!(d2 < d)) continue;
            d = d2;
        }
        return d;
    }

    public static Double getMaxValue(List<SGValueRange> list) {
        Double d = null;
        for (int i = 0; i < list.size(); ++i) {
            SGValueRange sGValueRange = list.get(i);
            if (!sGValueRange.isMaxValid()) continue;
            double d2 = sGValueRange.getMaxValue();
            if (d == null) {
                d = d2;
                continue;
            }
            if (!(d2 > d)) continue;
            d = d2;
        }
        return d;
    }

    public static SGValueRange getBoundsX(SGISXYTypeMultipleData sGISXYTypeMultipleData) {
        int n;
        SGISXYTypeData[] sGISXYTypeDataArray = sGISXYTypeMultipleData.getSXYDataArray();
        ArrayList<SGValueRange> arrayList = new ArrayList<SGValueRange>();
        for (n = 0; n < sGISXYTypeDataArray.length; ++n) {
            SGValueRange sGValueRange = SGDataUtility.getBoundsX(sGISXYTypeDataArray[n]);
            arrayList.add(sGValueRange);
        }
        for (n = 0; n < sGISXYTypeDataArray.length; ++n) {
            sGISXYTypeDataArray[n].dispose();
        }
        return SGDataUtility.getBounds(arrayList);
    }

    public static SGValueRange getBoundsY(SGISXYTypeMultipleData sGISXYTypeMultipleData) {
        int n;
        SGISXYTypeData[] sGISXYTypeDataArray = sGISXYTypeMultipleData.getSXYDataArray();
        ArrayList<SGValueRange> arrayList = new ArrayList<SGValueRange>();
        for (n = 0; n < sGISXYTypeDataArray.length; ++n) {
            SGValueRange sGValueRange = SGDataUtility.getBoundsY(sGISXYTypeDataArray[n]);
            arrayList.add(sGValueRange);
        }
        for (n = 0; n < sGISXYTypeDataArray.length; ++n) {
            sGISXYTypeDataArray[n].dispose();
        }
        return SGDataUtility.getBounds(arrayList);
    }

    private static SGValueRange getBounds(List<SGValueRange> list) {
        Double d = SGDataUtility.getMinValue(list);
        Double d2 = SGDataUtility.getMaxValue(list);
        double d3 = d != null ? d : Double.NaN;
        double d4 = d2 != null ? d2 : Double.NaN;
        return new SGValueRange(d3, d4);
    }

    public static SGValueRange getBoundsX(SGIVXYTypeData sGIVXYTypeData) {
        SGTuple2d[] sGTuple2dArray = sGIVXYTypeData.getCoordinateArray();
        if (sGTuple2dArray == null) {
            return null;
        }
        int n = sGTuple2dArray.length;
        double[] dArray = new double[n];
        for (int i = 0; i < n; ++i) {
            dArray[i] = sGTuple2dArray[i].x;
        }
        return SGDataUtility.getBounds(dArray);
    }

    public static SGValueRange getBoundsY(SGIVXYTypeData sGIVXYTypeData) {
        SGTuple2d[] sGTuple2dArray = sGIVXYTypeData.getCoordinateArray();
        if (sGTuple2dArray == null) {
            return null;
        }
        int n = sGTuple2dArray.length;
        double[] dArray = new double[n];
        for (int i = 0; i < n; ++i) {
            dArray[i] = sGTuple2dArray[i].y;
        }
        return SGDataUtility.getBounds(dArray);
    }

    public static boolean hasTickLabels(String string) {
        return "SXY".equals(string) || "SXY_DATE".equals(string);
    }

    public static SGValueRange getBoundsX(SGISXYZTypeData sGISXYZTypeData) {
        double[] dArray = sGISXYZTypeData.getXValueArray();
        if (dArray == null) {
            return null;
        }
        return SGDataUtility.getBounds(dArray);
    }

    public static SGValueRange getBoundsY(SGISXYZTypeData sGISXYZTypeData) {
        double[] dArray = sGISXYZTypeData.getYValueArray();
        if (dArray == null) {
            return null;
        }
        return SGDataUtility.getBounds(dArray);
    }

    public static SGValueRange getBoundsZ(SGISXYZTypeData sGISXYZTypeData) {
        double[] dArray = sGISXYZTypeData.getZValueArray();
        if (dArray == null) {
            return null;
        }
        return SGDataUtility.getBounds(dArray);
    }

    public static boolean isArrayData(SGData sGData) {
        return SGDataUtility.isArrayData(sGData.getDataType());
    }

    public static boolean isNetCDFData(SGData sGData) {
        return SGDataUtility.isNetCDFData(sGData.getDataType());
    }

    public static boolean isArrayData(String string) {
        if (string == null) {
            throw new IllegalArgumentException("Input data type is null.");
        }
        Object[] objectArray = new String[]{"SXY", "SXY_MULTIPLE", "SXY_SAMPLING", "VXY", "SXY_DATE", "SXYZ"};
        return SGUtility.contains(objectArray, string);
    }

    public static boolean isNetCDFData(String string) {
        if (string == null) {
            throw new IllegalArgumentException("Input data type is null.");
        }
        Object[] objectArray = new String[]{"SXY_NETCDF", "SXY_MULTIPLE_NETCDF", "SXY_MULTIPLE_NETCDF_PICKUP", "VXY_NETCDF", "SXYZ_NETCDF"};
        return SGUtility.contains(objectArray, string);
    }

    public static boolean isSXYTypeData(String string) {
        if (string == null) {
            throw new IllegalArgumentException("Input data type is null.");
        }
        Object[] objectArray = new String[]{"SXY", "SXY_MULTIPLE", "SXY_NETCDF", "SXY_MULTIPLE_NETCDF", "SXY_MULTIPLE_NETCDF_PICKUP"};
        return SGUtility.contains(objectArray, string);
    }

    public static boolean isVXYTypeData(String string) {
        if (string == null) {
            throw new IllegalArgumentException("Input data type is null.");
        }
        Object[] objectArray = new String[]{"VXY", "VXY_NETCDF"};
        return SGUtility.contains(objectArray, string);
    }

    public static boolean isMultipleData(String string) {
        if (string == null) {
            throw new IllegalArgumentException("Input data type is null.");
        }
        Object[] objectArray = new String[]{"SXY_MULTIPLE", "SXY_SAMPLING", "SXY_MULTIPLE_NETCDF", "SXY_MULTIPLE_NETCDF_PICKUP"};
        return SGUtility.contains(objectArray, string);
    }

    public static boolean isNetCDFDimensionData(String string) {
        if (string == null) {
            throw new IllegalArgumentException("Input data type is null.");
        }
        Object[] objectArray = new String[]{"SXY_MULTIPLE_NETCDF_PICKUP"};
        return SGUtility.contains(objectArray, string);
    }

    public static boolean isValidData(String string) {
        if (SGDataUtility.isArrayData(string)) {
            return true;
        }
        return SGDataUtility.isNetCDFData(string);
    }

    public static Map<String, Object> updateInfoMap(String string, SGDataColumnInfo[] sGDataColumnInfoArray, Map<String, Object> map) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>(map);
        if (SGDataUtility.isSXYTypeData(string)) {
            hashMap.put("Column Information", sGDataColumnInfoArray.clone());
        }
        return hashMap;
    }

    public static String[] updateDataColumns(String string, SGDataColumnInfo[] sGDataColumnInfoArray, String[] stringArray) {
        String[] stringArray2 = (String[])stringArray.clone();
        if (SGDataUtility.isSXYTypeData(string)) {
            ArrayList<Integer> arrayList = new ArrayList<Integer>();
            ArrayList<Integer> arrayList2 = new ArrayList<Integer>();
            for (int i = 0; i < stringArray.length; ++i) {
                Integer n = i;
                if ("X".equals(stringArray[i])) {
                    arrayList.add(n);
                    continue;
                }
                if (!"Y".equals(stringArray[i])) continue;
                arrayList2.add(n);
            }
            List<Integer> list = SGDataUtility.getOptionalColumnsAssignableIndexList(string, sGDataColumnInfoArray, arrayList, arrayList2);
            if (list == null) {
                return null;
            }
            for (int i = 0; i < stringArray.length; ++i) {
                String string2 = stringArray[i];
                if (!string2.startsWith("Lower Error") && !string2.startsWith("Upper Error") && !string2.startsWith("Lower / Upper Error") && !string2.startsWith("Tick Label")) continue;
                Integer n = SGDataUtility.getColumnIndexOfAppendedColumnType(string2, SGDataUtility.isNetCDFData(string), sGDataColumnInfoArray);
                if (n == null) {
                    return null;
                }
                if (list.contains(n)) continue;
                stringArray2[i] = "";
            }
        }
        return stringArray2;
    }

    private static List<Integer> getOptionalColumnsAssignableIndexList(String string, SGDataColumnInfo[] sGDataColumnInfoArray, List<Integer> list, List<Integer> list2) {
        if (!SGDataUtility.isSXYTypeData(string)) {
            return null;
        }
        TreeSet<Integer> treeSet = new TreeSet<Integer>();
        treeSet.addAll(list);
        treeSet.addAll(list2);
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        if (SGDataUtility.isArrayData(string)) {
            arrayList.addAll(treeSet);
        } else if (SGDataUtility.isNetCDFData(string)) {
            for (int i = 0; i < sGDataColumnInfoArray.length; ++i) {
                SGVariable sGVariable;
                SGNetCDFDataColumnInfo sGNetCDFDataColumnInfo = (SGNetCDFDataColumnInfo)sGDataColumnInfoArray[i];
                Integer n = i;
                if (!treeSet.contains(n) || (sGVariable = sGNetCDFDataColumnInfo.getVariable()).isCoordinateVariable()) continue;
                arrayList.add(n);
            }
        } else {
            return null;
        }
        return arrayList;
    }

    public static String createSamplingRateTitle(double d) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Sampling Rate ");
        stringBuffer.append(d);
        stringBuffer.append(" Hz");
        return stringBuffer.toString();
    }

    public static boolean getSXYColumnType(SGDataColumnInfo[] sGDataColumnInfoArray, List<Integer> list, List<Integer> list2, Map<Integer, Integer> map, Map<Integer, Integer> map2, Map<Integer, Integer> map3) {
        for (int i = 0; i < sGDataColumnInfoArray.length; ++i) {
            Integer n;
            String string = sGDataColumnInfoArray[i].getColumnType();
            if (SGUtilityText.isEqualString("X", string)) {
                list.add(i);
                continue;
            }
            if (SGUtilityText.isEqualString("Y", string)) {
                list2.add(i);
                continue;
            }
            if (SGUtilityText.startsWith(string, "Lower Error")) {
                n = SGDataUtility.getAppendedColumnIndex(string, sGDataColumnInfoArray);
                map.put(n, i);
                continue;
            }
            if (SGUtilityText.startsWith(string, "Upper Error")) {
                n = SGDataUtility.getAppendedColumnIndex(string, sGDataColumnInfoArray);
                map2.put(n, i);
                continue;
            }
            if (SGUtilityText.startsWith(string, "Lower / Upper Error")) {
                n = SGDataUtility.getAppendedColumnIndex(string, sGDataColumnInfoArray);
                map.put(n, i);
                map2.put(n, i);
                continue;
            }
            if (SGUtilityText.startsWith(string, "Tick Label")) {
                n = SGDataUtility.getAppendedColumnIndex(string, sGDataColumnInfoArray);
                map3.put(n, i);
                continue;
            }
            if ("".equals(string)) continue;
            return false;
        }
        return true;
    }

    public static boolean getSXYNetCDFColumnType(SGDataColumnInfo[] sGDataColumnInfoArray, List<String> list, List<String> list2, Map<String, String> map, Map<String, String> map2, Map<String, String> map3, List<String> list3, List<String> list4) {
        for (int i = 0; i < sGDataColumnInfoArray.length; ++i) {
            String string;
            SGNetCDFDataColumnInfo sGNetCDFDataColumnInfo;
            Integer n;
            SGNetCDFDataColumnInfo sGNetCDFDataColumnInfo2 = (SGNetCDFDataColumnInfo)sGDataColumnInfoArray[i];
            String string2 = sGNetCDFDataColumnInfo2.getColumnType();
            String string3 = sGNetCDFDataColumnInfo2.getVariableName();
            if (SGUtilityText.isEqualString("X", string2)) {
                list.add(string3);
                continue;
            }
            if (SGUtilityText.isEqualString("Y", string2)) {
                list2.add(string3);
                continue;
            }
            if (SGUtilityText.startsWith(string2, "Lower Error")) {
                n = SGDataUtility.getColumnIndexOfNetCDFAppendedColumnTitle(string2, sGDataColumnInfoArray);
                sGNetCDFDataColumnInfo = (SGNetCDFDataColumnInfo)sGDataColumnInfoArray[n];
                string = sGNetCDFDataColumnInfo.getVariableName();
                map.put(string, string3);
                continue;
            }
            if (SGUtilityText.startsWith(string2, "Upper Error")) {
                n = SGDataUtility.getColumnIndexOfNetCDFAppendedColumnTitle(string2, sGDataColumnInfoArray);
                sGNetCDFDataColumnInfo = (SGNetCDFDataColumnInfo)sGDataColumnInfoArray[n];
                string = sGNetCDFDataColumnInfo.getVariableName();
                map2.put(string, string3);
                continue;
            }
            if (SGUtilityText.startsWith(string2, "Lower / Upper Error")) {
                n = SGDataUtility.getColumnIndexOfNetCDFAppendedColumnTitle(string2, sGDataColumnInfoArray);
                sGNetCDFDataColumnInfo = (SGNetCDFDataColumnInfo)sGDataColumnInfoArray[n];
                string = sGNetCDFDataColumnInfo.getVariableName();
                map.put(string, string3);
                map2.put(string, string3);
                continue;
            }
            if (SGUtilityText.startsWith(string2, "Tick Label")) {
                n = SGDataUtility.getColumnIndexOfNetCDFAppendedColumnTitle(string2, sGDataColumnInfoArray);
                sGNetCDFDataColumnInfo = (SGNetCDFDataColumnInfo)sGDataColumnInfoArray[n];
                string = sGNetCDFDataColumnInfo.getVariableName();
                map3.put(string, string3);
                continue;
            }
            if (SGUtilityText.isEqualString("Time", string2)) {
                list3.add(string3);
                continue;
            }
            if (SGUtilityText.isEqualString("SerialNumbers", string2)) {
                list4.add(string3);
                continue;
            }
            if ("".equals(string2)) continue;
            return false;
        }
        return true;
    }

    public static boolean getSXYNetCDFColumnType(SGDataColumnInfo[] sGDataColumnInfoArray, List<String> list, List<String> list2, List<String> list3, List<String> list4, List<String> list5, List<String> list6, List<String> list7, List<String> list8) {
        for (int i = 0; i < sGDataColumnInfoArray.length; ++i) {
            SGNetCDFDataColumnInfo sGNetCDFDataColumnInfo = (SGNetCDFDataColumnInfo)sGDataColumnInfoArray[i];
            String string = sGNetCDFDataColumnInfo.getColumnType();
            String string2 = sGNetCDFDataColumnInfo.getVariableName();
            if (SGUtilityText.isEqualString("X", string)) {
                list.add(string2);
                continue;
            }
            if (SGUtilityText.isEqualString("Y", string)) {
                list2.add(string2);
                continue;
            }
            if (SGUtilityText.isEqualString("Lower Error", string)) {
                list3.add(string2);
                continue;
            }
            if (SGUtilityText.isEqualString("Upper Error", string)) {
                list4.add(string2);
                continue;
            }
            if (SGUtilityText.isEqualString("Lower / Upper Error", string)) {
                list3.add(string2);
                list4.add(string2);
                continue;
            }
            if (SGUtilityText.isEqualString("Tick Label", string)) {
                list5.add(string2);
                continue;
            }
            if (SGUtilityText.isEqualString("Pickup", string)) {
                list6.add(string2);
                continue;
            }
            if (SGUtilityText.isEqualString("Time", string)) {
                list7.add(string2);
                continue;
            }
            if (SGUtilityText.isEqualString("SerialNumbers", string)) {
                list8.add(string2);
                continue;
            }
            if ("".equals(string)) continue;
            return false;
        }
        return true;
    }

    public static boolean isComplementButtonVisible(Map<String, Object> map) {
        boolean bl;
        String string = (String)map.get("DataType");
        if (!SGDataUtility.isSXYTypeData(string)) {
            return false;
        }
        Boolean bl2 = (Boolean)map.get("Multiple");
        if (bl2 == null) {
            return false;
        }
        if (bl2.booleanValue()) {
            Boolean bl3 = (Boolean)map.get("Graphs for multiple variables");
            if (bl3 == null) {
                return false;
            }
            bl = bl3;
        } else {
            bl = false;
        }
        return bl;
    }

    public static boolean isComplementedButtonEnabled(Map<String, Object> map, String[] stringArray, List<SGDataColumnInfo> list) {
        String string = (String)map.get("DataType");
        if (SGDataUtility.isSXYTypeData(string)) {
            ArrayList<Integer> arrayList = new ArrayList<Integer>();
            ArrayList<Integer> arrayList2 = new ArrayList<Integer>();
            for (int i = 0; i < stringArray.length; ++i) {
                if ("X".equals(stringArray[i])) {
                    arrayList.add(i);
                    continue;
                }
                if (!"Y".equals(stringArray[i])) continue;
                arrayList2.add(i);
            }
            if (SGDataUtility.isArrayData(string)) {
                return arrayList.size() == 1 || arrayList2.size() == 1;
            }
            if (SGDataUtility.isNetCDFData(string)) {
                if (arrayList.size() == 1) {
                    return SGDataUtility.isComplementedButtonEnabled(map, stringArray, list, (Integer)arrayList.get(0));
                }
                if (arrayList2.size() == 1) {
                    return SGDataUtility.isComplementedButtonEnabled(map, stringArray, list, (Integer)arrayList2.get(0));
                }
                return false;
            }
            return false;
        }
        return false;
    }

    private static boolean isComplementedButtonEnabled(Map<String, Object> map, String[] stringArray, List<SGDataColumnInfo> list, Integer n) {
        SGNetCDFDataColumnInfo sGNetCDFDataColumnInfo = (SGNetCDFDataColumnInfo)list.get(n);
        SGVariable sGVariable = sGNetCDFDataColumnInfo.getVariable();
        return sGVariable.isCoordinateVariable();
    }

    public static String[] getComplementedColumnType(Map<String, Object> map, String[] stringArray, List<SGDataColumnInfo> list) {
        if (stringArray.length != list.size()) {
            return null;
        }
        String string = (String)map.get("DataType");
        String[] stringArray2 = null;
        if (SGDataUtility.isSXYTypeData(string)) {
            ArrayList<Integer> arrayList = new ArrayList<Integer>();
            ArrayList<Integer> arrayList2 = new ArrayList<Integer>();
            for (int i = 0; i < stringArray.length; ++i) {
                if ("X".equals(stringArray[i])) {
                    arrayList.add(i);
                    continue;
                }
                if (!"Y".equals(stringArray[i])) continue;
                arrayList2.add(i);
            }
            stringArray2 = arrayList.size() == 1 && arrayList2.size() == 0 ? SGDataUtility.getComplementedColumnType(map, stringArray, list, (Integer)arrayList.get(0), "X", "Y") : (arrayList.size() == 0 && arrayList2.size() == 1 ? SGDataUtility.getComplementedColumnType(map, stringArray, list, (Integer)arrayList2.get(0), "Y", "X") : (String[])stringArray.clone());
        } else {
            stringArray2 = (String[])stringArray.clone();
        }
        return stringArray2;
    }

    private static String[] getComplementedColumnType(Map<String, Object> map, String[] stringArray, List<SGDataColumnInfo> list, Integer n, String string, String string2) {
        String string3 = (String)map.get("DataType");
        String[] stringArray2 = new String[stringArray.length];
        stringArray2[n.intValue()] = string;
        if (SGDataUtility.isArrayData(string3)) {
            for (int i = 0; i < list.size(); ++i) {
                if (i == n) continue;
                SGDataColumnInfo sGDataColumnInfo = list.get(i);
                String string4 = sGDataColumnInfo.getValueType();
                stringArray2[i] = "Number".equals(string4) ? string2 : stringArray[i];
            }
        } else if (SGDataUtility.isNetCDFData(string3)) {
            SGNetCDFDataColumnInfo sGNetCDFDataColumnInfo = (SGNetCDFDataColumnInfo)list.get(n);
            SGVariable sGVariable = sGNetCDFDataColumnInfo.getVariable();
            if (sGVariable.isCoordinateVariable()) {
                Dimension dimension = sGVariable.getDimension(0);
                for (int i = 0; i < list.size(); ++i) {
                    List<Dimension> list2;
                    if (i == n) continue;
                    SGNetCDFDataColumnInfo sGNetCDFDataColumnInfo2 = (SGNetCDFDataColumnInfo)list.get(i);
                    SGVariable sGVariable2 = sGNetCDFDataColumnInfo2.getVariable();
                    if (sGVariable2.isCoordinateVariable()) {
                        stringArray2[i] = stringArray[i];
                    }
                    stringArray2[i] = (list2 = sGVariable2.getDimensions()).contains(dimension) ? string2 : "";
                }
            } else {
                stringArray2 = (String[])stringArray.clone();
            }
        }
        return stringArray2;
    }

    public static Integer[] calcDimIndices(Dimension dimension, Integer n, Integer n2, Integer n3) {
        if (dimension == null || n == null || n2 == null || n3 == null) {
            throw new IllegalArgumentException("dim == null || dimStart == null || dimEnd == null || dimStep == null");
        }
        int n4 = dimension.getLength();
        int n5 = n;
        int n6 = n2;
        int n7 = Math.abs(n3);
        if (n5 < 0 || n5 > n4) {
            throw new IllegalArgumentException("Dimension start is out of bounds: " + n5);
        }
        if (n6 < 0) {
            throw new IllegalArgumentException("Dimension end is out of bounds: " + n6);
        }
        if (n6 > n4) {
            n6 = n4 - 1;
        }
        TreeSet<Integer> treeSet = new TreeSet<Integer>();
        treeSet.add(n);
        if (n7 != 0) {
            int n8;
            if (n5 <= n6) {
                for (n8 = n5; n8 >= 0 && n8 <= n6; n8 += n7) {
                    treeSet.add(n8);
                }
            } else {
                for (n8 = n5; n8 >= 0 && n8 >= n6; n8 -= n7) {
                    treeSet.add(n8);
                }
            }
        }
        Integer[] integerArray = treeSet.toArray(new Integer[treeSet.size()]);
        return integerArray;
    }

    public static boolean isPickupColumnContained(SGDataColumnInfo[] sGDataColumnInfoArray) {
        for (int i = 0; i < sGDataColumnInfoArray.length; ++i) {
            if (!"Pickup".equals(sGDataColumnInfoArray[i].getColumnType())) continue;
            return true;
        }
        return false;
    }

    public static SGSXYMultipleNetCDFData toDimensionData(SGSXYMultipleVariableNetCDFData sGSXYMultipleVariableNetCDFData, SGDataColumnInfo[] sGDataColumnInfoArray) {
        Object object;
        SGNetCDFFile sGNetCDFFile = (SGNetCDFFile)sGSXYMultipleVariableNetCDFData.mNCFile.clone();
        SGDataSourceObserver sGDataSourceObserver = sGSXYMultipleVariableNetCDFData.mObserver;
        int n = sGSXYMultipleVariableNetCDFData.getDimensionStart();
        int n2 = sGSXYMultipleVariableNetCDFData.getDimensionEnd();
        int n3 = sGSXYMultipleVariableNetCDFData.getDimensionStep();
        SGNetCDFDataColumnInfo[] sGNetCDFDataColumnInfoArray = new SGNetCDFDataColumnInfo[sGDataColumnInfoArray.length];
        for (int i = 0; i < sGDataColumnInfoArray.length; ++i) {
            sGNetCDFDataColumnInfoArray[i] = (SGNetCDFDataColumnInfo)sGDataColumnInfoArray[i];
        }
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        SGDataUtility.updatePickupParameters(hashMap, sGNetCDFDataColumnInfoArray);
        if (n < 0) {
            n = 0;
            object = hashMap.get("Multiple dimension start");
            if (object instanceof Integer) {
                n = (Integer)object;
            }
        }
        if (n2 < 0) {
            n2 = 0;
            object = hashMap.get("Multiple dimension end");
            if (object instanceof Integer) {
                n2 = (Integer)object;
            }
        }
        if (n3 < 0) {
            n3 = 0;
            object = hashMap.get("Multiple dimension step");
            if (object instanceof Integer) {
                n3 = (Integer)object;
            }
        }
        if (null == (object = SGDataUtility.createDimensionNetCDFData(sGNetCDFFile, sGDataSourceObserver, sGDataColumnInfoArray, n, n2, n3))) {
            return null;
        }
        for (int i = 0; i < sGDataColumnInfoArray.length; ++i) {
            SGNetCDFDataColumnInfo sGNetCDFDataColumnInfo = (SGNetCDFDataColumnInfo)sGDataColumnInfoArray[i];
            String string = sGNetCDFDataColumnInfo.getVariableName();
            int n4 = sGNetCDFDataColumnInfo.getOrigin();
            if (sGNetCDFFile.findDimension(string) == null) continue;
            ((SGNetCDFData)object).setOrigin(string, n4);
        }
        return object;
    }

    public static SGSXYMultipleNetCDFData toVariableData(SGSXYMultipleDimensionNetCDFData sGSXYMultipleDimensionNetCDFData, SGDataColumnInfo[] sGDataColumnInfoArray) {
        SGDataSourceObserver sGDataSourceObserver;
        SGNetCDFFile sGNetCDFFile = (SGNetCDFFile)sGSXYMultipleDimensionNetCDFData.mNCFile.clone();
        SGSXYMultipleVariableNetCDFData sGSXYMultipleVariableNetCDFData = SGDataUtility.createVariableNetCDFData(sGNetCDFFile, sGDataSourceObserver = sGSXYMultipleDimensionNetCDFData.mObserver, sGDataColumnInfoArray);
        if (null == sGSXYMultipleVariableNetCDFData) {
            return null;
        }
        sGSXYMultipleVariableNetCDFData.setDimensionStart(sGSXYMultipleDimensionNetCDFData.getDimensionStart());
        sGSXYMultipleVariableNetCDFData.setDimensionEnd(sGSXYMultipleDimensionNetCDFData.getDimensionEnd());
        sGSXYMultipleVariableNetCDFData.setDimensionStep(sGSXYMultipleDimensionNetCDFData.getDimensionStep());
        for (int i = 0; i < sGDataColumnInfoArray.length; ++i) {
            SGNetCDFDataColumnInfo sGNetCDFDataColumnInfo = (SGNetCDFDataColumnInfo)sGDataColumnInfoArray[i];
            String string = sGNetCDFDataColumnInfo.getVariableName();
            int n = sGNetCDFDataColumnInfo.getOrigin();
            if (sGNetCDFFile.findDimension(string) == null) continue;
            sGSXYMultipleVariableNetCDFData.setOrigin(string, n);
        }
        return sGSXYMultipleVariableNetCDFData;
    }

    public static SGSXYMultipleDimensionNetCDFData createDimensionNetCDFData(SGNetCDFFile sGNetCDFFile, SGDataSourceObserver sGDataSourceObserver, SGDataColumnInfo[] sGDataColumnInfoArray, int n, int n2, int n3) {
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        ArrayList<String> arrayList3 = new ArrayList<String>();
        ArrayList<String> arrayList4 = new ArrayList<String>();
        ArrayList<String> arrayList5 = new ArrayList<String>();
        ArrayList<String> arrayList6 = new ArrayList<String>();
        ArrayList<String> arrayList7 = new ArrayList<String>();
        ArrayList<String> arrayList8 = new ArrayList<String>();
        if (!SGDataUtility.getSXYNetCDFColumnType(sGDataColumnInfoArray, arrayList, arrayList2, arrayList3, arrayList4, arrayList5, arrayList6, arrayList7, arrayList8)) {
            return null;
        }
        if (arrayList.size() != 1) {
            return null;
        }
        if (arrayList2.size() != 1) {
            return null;
        }
        if (arrayList6.size() != 1) {
            return null;
        }
        if (!(arrayList3.size() == 0 && arrayList4.size() == 0 || arrayList3.size() == 1 && arrayList4.size() == 1)) {
            return null;
        }
        String string = (String)arrayList.get(0);
        String string2 = (String)arrayList2.get(0);
        String string3 = null;
        if (arrayList3.size() > 0) {
            string3 = (String)arrayList3.get(0);
        }
        String string4 = null;
        if (arrayList4.size() > 0) {
            string4 = (String)arrayList4.get(0);
        }
        String string5 = null;
        if (arrayList5.size() > 0) {
            string5 = (String)arrayList5.get(0);
        }
        String string6 = (String)arrayList6.get(0);
        String string7 = null;
        if (arrayList7.size() != 0) {
            string7 = (String)arrayList7.get(0);
        }
        String string8 = null;
        if (arrayList8.size() != 0) {
            string8 = (String)arrayList8.get(0);
        }
        SGSXYMultipleDimensionNetCDFData sGSXYMultipleDimensionNetCDFData = new SGSXYMultipleDimensionNetCDFData(sGNetCDFFile, sGDataSourceObserver, string, string2, string3, string4, string5, string6, n, n2, n3, string7, string8);
        return sGSXYMultipleDimensionNetCDFData;
    }

    public static SGSXYMultipleVariableNetCDFData createVariableNetCDFData(SGNetCDFFile sGNetCDFFile, SGDataSourceObserver sGDataSourceObserver, SGDataColumnInfo[] sGDataColumnInfoArray) {
        String[] stringArray;
        String[] stringArray2;
        String[] stringArray3;
        String[] stringArray4;
        String[] stringArray5;
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        HashMap<String, String> hashMap = new HashMap<String, String>();
        HashMap<String, String> hashMap2 = new HashMap<String, String>();
        HashMap<String, String> hashMap3 = new HashMap<String, String>();
        ArrayList<String> arrayList3 = new ArrayList<String>();
        ArrayList<String> arrayList4 = new ArrayList<String>();
        if (!SGDataUtility.getSXYNetCDFColumnType(sGDataColumnInfoArray, arrayList, arrayList2, hashMap, hashMap2, hashMap3, arrayList3, arrayList4)) {
            return null;
        }
        if (hashMap.size() != hashMap2.size()) {
            return null;
        }
        String[] stringArray6 = arrayList.toArray(new String[arrayList.size()]);
        String[] stringArray7 = arrayList2.toArray(new String[arrayList2.size()]);
        Iterator iterator = hashMap.keySet().iterator();
        ArrayList<String[]> arrayList5 = new ArrayList<String[]>();
        ArrayList<String[]> arrayList6 = new ArrayList<String[]>();
        ArrayList<String[]> arrayList7 = new ArrayList<String[]>();
        while (iterator.hasNext()) {
            stringArray5 = (String[])iterator.next();
            arrayList7.add(stringArray5);
            stringArray4 = (String[])hashMap.get(stringArray5);
            if (stringArray4 != null) {
                arrayList5.add(stringArray4);
            }
            if ((stringArray3 = (String[])hashMap2.get(stringArray5)) == null) continue;
            arrayList6.add(stringArray3);
        }
        if (arrayList5.size() != arrayList6.size()) {
            return null;
        }
        if (arrayList5.size() != arrayList7.size()) {
            return null;
        }
        stringArray5 = arrayList5.toArray(new String[arrayList5.size()]);
        stringArray4 = arrayList6.toArray(new String[arrayList6.size()]);
        stringArray3 = arrayList7.toArray(new String[arrayList7.size()]);
        Iterator iterator2 = hashMap3.keySet().iterator();
        ArrayList<String[]> arrayList8 = new ArrayList<String[]>();
        ArrayList<String[]> arrayList9 = new ArrayList<String[]>();
        while (iterator2.hasNext()) {
            stringArray2 = (String[])iterator2.next();
            arrayList9.add(stringArray2);
            stringArray = (String[])hashMap3.get(stringArray2);
            if (stringArray == null) continue;
            arrayList8.add(stringArray);
        }
        if (arrayList8.size() != arrayList9.size()) {
            return null;
        }
        stringArray2 = arrayList8.toArray(new String[arrayList8.size()]);
        stringArray = arrayList9.toArray(new String[arrayList9.size()]);
        String string = null;
        if (arrayList3.size() != 0) {
            string = (String)arrayList3.get(0);
        }
        String string2 = null;
        if (arrayList4.size() != 0) {
            string2 = (String)arrayList4.get(0);
        }
        SGSXYMultipleVariableNetCDFData sGSXYMultipleVariableNetCDFData = new SGSXYMultipleVariableNetCDFData(sGNetCDFFile, sGDataSourceObserver, stringArray6, stringArray7, stringArray5, stringArray4, stringArray3, stringArray2, stringArray, string, string2);
        return sGSXYMultipleVariableNetCDFData;
    }

    public static void updateColumnTypeOfSXYMultipleVariableNetCDFDataFromVariableNames(SGNetCDFFile sGNetCDFFile, SGDataColumnInfo[] sGDataColumnInfoArray, String[] stringArray, String[] stringArray2, String[] stringArray3, String[] stringArray4, String[] stringArray5, String[] stringArray6, String[] stringArray7) {
        int n;
        int n2;
        int n3;
        int n4;
        for (n4 = 0; n4 < stringArray.length; ++n4) {
            n3 = sGNetCDFFile.getVariableIndex(stringArray[n4]);
            sGDataColumnInfoArray[n3].setColumnType("X");
        }
        for (n4 = 0; n4 < stringArray2.length; ++n4) {
            n3 = sGNetCDFFile.getVariableIndex(stringArray2[n4]);
            sGDataColumnInfoArray[n3].setColumnType("Y");
        }
        n4 = 0;
        n3 = 0;
        if (stringArray3 != null && stringArray3.length > 0 && stringArray4 != null && stringArray4.length > 0 && stringArray5 != null && stringArray5.length > 0 && stringArray3.length == stringArray4.length && stringArray3.length == stringArray5.length) {
            n4 = 1;
        }
        if (stringArray6 != null && stringArray6.length > 0 && stringArray7 != null && stringArray7.length > 0 && stringArray6.length == stringArray7.length) {
            n3 = 1;
        }
        if (n4 != 0) {
            for (n2 = 0; n2 < stringArray3.length; ++n2) {
                int n5;
                n = sGNetCDFFile.getVariableIndex(stringArray3[n2]);
                if (n != (n5 = sGNetCDFFile.getVariableIndex(stringArray4[n2]))) {
                    sGDataColumnInfoArray[n].setColumnType("Lower Error for " + stringArray5[n2]);
                    sGDataColumnInfoArray[n5].setColumnType("Upper Error for " + stringArray5[n2]);
                    continue;
                }
                sGDataColumnInfoArray[n].setColumnType("Lower / Upper Error for " + stringArray5[n2]);
            }
        }
        if (n3 != 0) {
            for (n2 = 0; n2 < stringArray6.length; ++n2) {
                n = sGNetCDFFile.getVariableIndex(stringArray6[n2]);
                sGDataColumnInfoArray[n].setColumnType("Tick Label for " + stringArray7[n2]);
            }
        }
    }

    public static boolean isSameNetCDFGroup(String string, String string2) {
        String[] stringArray;
        String[] stringArray2 = string.split("/");
        if (stringArray2.length == (stringArray = string2.split("/")).length) {
            for (int i = 0; i < stringArray2.length - 1; ++i) {
                if (stringArray2[i].equals(stringArray[i])) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private static SGVariable getDimensionVariable(SGNetCDFDataColumnInfo[] sGNetCDFDataColumnInfoArray) {
        SGVariable sGVariable = null;
        for (int i = 0; i < sGNetCDFDataColumnInfoArray.length; ++i) {
            String string = sGNetCDFDataColumnInfoArray[i].getColumnType();
            if (!"Pickup".equals(string)) continue;
            sGVariable = sGNetCDFDataColumnInfoArray[i].getVariable();
            break;
        }
        if (sGVariable != null && sGVariable.isCoordinateVariable()) {
            return sGVariable;
        }
        return null;
    }

    public static boolean updatePickupParameters(Map<String, Object> map, SGNetCDFDataColumnInfo[] sGNetCDFDataColumnInfoArray) {
        Object object;
        Integer n = (Integer)map.get("Multiple dimension start");
        if (n == null) {
            n = 0;
        }
        map.put("Multiple dimension start", n);
        Integer n2 = (Integer)map.get("Multiple dimension end");
        SGVariable sGVariable = SGDataUtility.getDimensionVariable(sGNetCDFDataColumnInfoArray);
        if (sGVariable != null) {
            object = sGVariable.getDimension(0);
            int n3 = object.getLength();
            if (n2 != null) {
                if (n2 >= n3) {
                    n2 = n3 - 1;
                }
            } else {
                n2 = n3 - 1;
            }
        } else if (n2 == null) {
            n2 = 0;
        }
        map.put("Multiple dimension end", n2);
        object = (Integer)map.get("Multiple dimension step");
        if (object == null) {
            if (sGVariable != null) {
                if (!sGVariable.isCoordinateVariable()) {
                    return false;
                }
                Dimension dimension = sGVariable.getDimension(0);
                int n4 = dimension.getLength();
                object = n4 / 4;
            } else {
                object = 0;
            }
        }
        map.put("Multiple dimension step", object);
        return true;
    }

    public static boolean isSGDateVariable(Variable variable) {
        if (DataType.CHAR.equals((Object)variable.getDataType())) {
            List list = variable.getAttributes();
            for (Attribute attribute : list) {
                if (!attribute.isString()) continue;
                String string = attribute.getName();
                String string2 = attribute.getStringValue();
                if (!ATTRIBUTE_KEY_VALUE_TYPE.equals(string.trim()) || !"Date".equals(string2.trim())) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isSGTextVariable(Variable variable) {
        if (DataType.CHAR.equals((Object)variable.getDataType())) {
            List list = variable.getAttributes();
            for (Attribute attribute : list) {
                if (!attribute.isString()) continue;
                String string = attribute.getName();
                String string2 = attribute.getStringValue();
                if (string == null || string2 == null || !ATTRIBUTE_KEY_VALUE_TYPE.equals(string.trim()) || !"Text".equals(string2.trim())) continue;
                return true;
            }
        }
        return false;
    }

    public static Attribute getValueTypeAttribute(String string) {
        Attribute attribute = new Attribute(ATTRIBUTE_KEY_VALUE_TYPE, string);
        return attribute;
    }

    public static boolean canOpenNetCDF(SGNetCDFData sGNetCDFData) {
        try {
            boolean bl = NetcdfFile.canOpen((String)sGNetCDFData.getNetcdfFile().getNetcdfFile().getLocation());
            return bl;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static void dumpInfoMap(Map<String, Object> map) {
        for (String string : map.keySet()) {
            if (null == map.get(string)) {
                System.out.println("   key=" + string + " : null");
                continue;
            }
            if (string.equals("Data Source")) {
                System.out.println("   key=" + string + " : " + map.get(string).getClass().getSimpleName());
                continue;
            }
            System.out.println("   key=" + string + " : " + map.get(string).toString());
        }
    }

    public static double[] getDateValueArray(SGDate[] sGDateArray) {
        int n = sGDateArray.length;
        double[] dArray = new double[n];
        Calendar calendar = Calendar.getInstance();
        for (int i = 0; i < n; ++i) {
            SGDate sGDate = sGDateArray[i];
            calendar.set(sGDate.year, sGDate.month, sGDate.date);
            dArray[i] = calendar.getTimeInMillis() / 86400000L;
        }
        return dArray;
    }

    public static SGNetCDFDataColumnInfo[] getNetCDFDataColumnInfo(List<SGVariable> list, Map<String, Object> map) {
        String string;
        Integer n;
        String string2;
        SGNetCDFDataColumnInfo[] sGNetCDFDataColumnInfoArray;
        String string3;
        NamedNodeMap namedNodeMap = (NamedNodeMap)map.get("NodeMap");
        SGNetCDFDataColumnInfo[] sGNetCDFDataColumnInfoArray2 = null;
        if (namedNodeMap != null) {
            sGNetCDFDataColumnInfoArray2 = SGDefaultColumnTypeUtility.getOriginMap(namedNodeMap);
        }
        if ((string3 = (String)map.get("GroupName")) != null) {
            sGNetCDFDataColumnInfoArray = new HashMap();
            Set<Map.Entry<String, Integer>> set = sGNetCDFDataColumnInfoArray2.entrySet();
            for (Map.Entry<String, Integer> entry : set) {
                string2 = entry.getKey();
                n = entry.getValue();
                string = SGDataUtility.appendGroupName(string2, string3);
                sGNetCDFDataColumnInfoArray.put(string, n);
            }
            sGNetCDFDataColumnInfoArray2 = sGNetCDFDataColumnInfoArray;
        }
        sGNetCDFDataColumnInfoArray = new SGNetCDFDataColumnInfo[list.size()];
        for (int i = 0; i < sGNetCDFDataColumnInfoArray.length; ++i) {
            SGVariable sGVariable = list.get(i);
            int n2 = 0;
            if (sGNetCDFDataColumnInfoArray2 != null && sGVariable.isCoordinateVariable() && (n = (Integer)sGNetCDFDataColumnInfoArray2.get(string2 = sGVariable.getName())) != null) {
                string = sGVariable.getDimension(0);
                n2 = n;
                if (n2 < 0 || n2 >= string.getLength()) {
                    n2 = 0;
                }
            }
            sGNetCDFDataColumnInfoArray[i] = new SGNetCDFDataColumnInfo(sGVariable, sGVariable.getNameInPriorityOrder(), sGVariable.getValueType(), n2);
        }
        return sGNetCDFDataColumnInfoArray;
    }

    static String appendGroupName(String string, String string2) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(string2);
        stringBuffer.append('/');
        stringBuffer.append(string);
        return stringBuffer.toString();
    }
}

