/*
 * Decompiled with CFR 0.152.
 */
package jp.riken.brain.ni.samuraigraph.data;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import jp.riken.brain.ni.samuraigraph.base.SGButton;
import jp.riken.brain.ni.samuraigraph.data.SGAbstractAttributeDialog;
import jp.riken.brain.ni.samuraigraph.data.SGAttributePanel;
import jp.riken.brain.ni.samuraigraph.data.SGNetCDFFile;

public class SGGlobalAttributeDialog
extends SGAbstractAttributeDialog {
    public static final String TITLE = "Global Attributes";
    private SGAttributePanel mAttributePanel;
    private SGButton mCloseButton;
    private JScrollPane mScrollPane;
    private JTextArea mTextArea;

    public SGGlobalAttributeDialog(Frame frame, boolean bl) {
        super(frame, bl);
        this.initComponents();
        this.initProperty();
    }

    public SGGlobalAttributeDialog(Dialog dialog, boolean bl) {
        super(dialog, bl);
        this.initComponents();
        this.initProperty();
    }

    private void initComponents() {
        this.mAttributePanel = new SGAttributePanel();
        this.mCloseButton = new SGButton();
        this.mScrollPane = new JScrollPane();
        this.mTextArea = new JTextArea();
        this.setDefaultCloseOperation(2);
        this.getContentPane().setLayout(new GridBagLayout());
        this.mAttributePanel.setPreferredSize(new Dimension(360, 120));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.mAttributePanel, gridBagConstraints);
        this.mCloseButton.setText("Close");
        this.mCloseButton.setFont(new Font("Dialog", 1, 12));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.mCloseButton, gridBagConstraints);
        this.mTextArea.setColumns(20);
        this.mTextArea.setRows(5);
        this.mScrollPane.setViewportView(this.mTextArea);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.mScrollPane, gridBagConstraints);
        this.pack();
    }

    private void initProperty() {
        this.setTitle(TITLE);
        this.mTextArea.setLineWrap(true);
        this.mCloseButton.addActionListener(this);
        this.mAttributePanel.getTable().addMouseListener(this);
    }

    protected JButton getCloseButton() {
        return this.mCloseButton;
    }

    protected JTextArea getTextArea() {
        return this.mTextArea;
    }

    protected SGAttributePanel getAttributePanel() {
        return this.mAttributePanel;
    }

    public void setNetcdfFile(SGNetCDFFile sGNetCDFFile) {
        List list = sGNetCDFFile.getNetcdfFile().getGlobalAttributes();
        this.mAttributePanel.setAttributes(list);
    }
}

