/*
 * Decompiled with CFR 0.152.
 */
package jp.riken.brain.ni.samuraigraph.data;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import jp.riken.brain.ni.samuraigraph.base.SGData;
import jp.riken.brain.ni.samuraigraph.base.SGDataColumnInfo;
import jp.riken.brain.ni.samuraigraph.base.SGIDataSource;
import jp.riken.brain.ni.samuraigraph.base.SGITextDataConstants;
import jp.riken.brain.ni.samuraigraph.base.SGProperties;
import jp.riken.brain.ni.samuraigraph.base.SGUtility;
import jp.riken.brain.ni.samuraigraph.base.SGUtilityText;
import jp.riken.brain.ni.samuraigraph.data.SGCoordinateVariable;
import jp.riken.brain.ni.samuraigraph.data.SGDataSourceObserver;
import jp.riken.brain.ni.samuraigraph.data.SGDateVariable;
import jp.riken.brain.ni.samuraigraph.data.SGIDataColumnTypeConstants;
import jp.riken.brain.ni.samuraigraph.data.SGNetCDFDataColumnInfo;
import jp.riken.brain.ni.samuraigraph.data.SGNetCDFFile;
import jp.riken.brain.ni.samuraigraph.data.SGTextVariable;
import jp.riken.brain.ni.samuraigraph.data.SGVariable;
import org.w3c.dom.Element;
import ucar.ma2.Array;
import ucar.ma2.InvalidRangeException;
import ucar.nc2.Attribute;
import ucar.nc2.Dimension;
import ucar.nc2.Group;
import ucar.nc2.NetcdfFile;
import ucar.nc2.NetcdfFileWriteable;
import ucar.nc2.Variable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SGNetCDFData
extends SGData
implements SGITextDataConstants,
SGIDataColumnTypeConstants {
    public static final String FILL_VALUE = "_FillValue";
    public static final String KEY_ORIGIN_MAP = "Origin";
    protected SGNetCDFFile mNCFile = null;
    protected SGDataSourceObserver mObserver = null;
    protected Map<String, Integer> mOriginMap = new HashMap<String, Integer>();
    protected SGVariable mTimeVariable = null;
    protected SGVariable mSerialNumberVariable = null;
    protected Map<String, Object> mVariableCache = new HashMap<String, Object>();

    public SGNetCDFData() {
    }

    public SGNetCDFData(SGNetCDFFile sGNetCDFFile, SGDataSourceObserver sGDataSourceObserver, String string, String string2) {
        Dimension dimension;
        if (sGNetCDFFile == null || sGDataSourceObserver == null) {
            throw new IllegalArgumentException("ncfile == null || obs == null");
        }
        this.mNCFile = sGNetCDFFile;
        this.mObserver = sGDataSourceObserver;
        sGDataSourceObserver.addData(this);
        List<Dimension> list = sGNetCDFFile.getDimensions();
        Object object = list.iterator();
        while (object.hasNext()) {
            dimension = object.next();
            String string3 = dimension.getName();
            this.mOriginMap.put(string3, 0);
        }
        if (string != null) {
            object = sGNetCDFFile.findVariable(string);
            if (object == null) {
                throw new IllegalArgumentException("Illegal variable name: " + string);
            }
            if (!((SGVariable)object).isCoordinateVariable()) {
                throw new IllegalArgumentException("Time variable must be a coordinate variable.");
            }
            this.mTimeVariable = object;
        }
        if (string2 != null) {
            object = sGNetCDFFile.findVariable(string2);
            if (object == null) {
                throw new IllegalArgumentException("Illegal variable name: " + string2);
            }
            if (!((SGVariable)object).isCoordinateVariable()) {
                throw new IllegalArgumentException("Serial number variable must be a coordinate variable.");
            }
            this.mSerialNumberVariable = object;
        }
        if (this.mTimeVariable != null && this.mSerialNumberVariable != null && (object = this.mTimeVariable.getDimension(0)).equals((Object)(dimension = this.mSerialNumberVariable.getDimension(0)))) {
            throw new IllegalArgumentException("Dimensions of time and serial number variables must not be the same.");
        }
    }

    public SGNetCDFFile getNetcdfFile() {
        return this.mNCFile;
    }

    @Override
    public Object copy() {
        SGNetCDFData sGNetCDFData = (SGNetCDFData)super.copy();
        this.mObserver.addData(sGNetCDFData);
        sGNetCDFData.mOriginMap = new HashMap<String, Integer>(this.mOriginMap);
        sGNetCDFData.mVariableCache = new HashMap<String, Object>(this.mVariableCache);
        return sGNetCDFData;
    }

    @Override
    public void dispose() {
        super.dispose();
        this.mObserver.dataDisposed(this);
        this.mNCFile = null;
        this.mOriginMap.clear();
        this.mOriginMap = null;
        this.mTimeVariable = null;
        this.mSerialNumberVariable = null;
    }

    @Override
    public boolean setData(SGData sGData) {
        if (!(sGData instanceof SGNetCDFData)) {
            throw new IllegalArgumentException("Given data is not the instance of SGNetCDFData class.");
        }
        this.clearVariableCache();
        SGNetCDFData sGNetCDFData = (SGNetCDFData)sGData;
        this.mNCFile = sGNetCDFData.mNCFile;
        this.mObserver = sGNetCDFData.mObserver;
        this.mObserver.addData(this);
        this.mOriginMap = new HashMap<String, Integer>(sGNetCDFData.mOriginMap);
        this.mTimeVariable = sGNetCDFData.mTimeVariable;
        this.mSerialNumberVariable = sGNetCDFData.mSerialNumberVariable;
        return true;
    }

    @Override
    public boolean getProperties(SGProperties sGProperties) {
        if (!(sGProperties instanceof NetCDFDataProperties)) {
            return false;
        }
        NetCDFDataProperties netCDFDataProperties = (NetCDFDataProperties)sGProperties;
        if (this.mTimeVariable != null) {
            netCDFDataProperties.timeName = this.mTimeVariable.getName();
        }
        if (this.mSerialNumberVariable != null) {
            netCDFDataProperties.serialNumberName = this.mSerialNumberVariable.getName();
        }
        netCDFDataProperties.originMap = new HashMap<String, Integer>(this.mOriginMap);
        return true;
    }

    @Override
    public boolean setProperties(SGProperties sGProperties) {
        if (!(sGProperties instanceof NetCDFDataProperties)) {
            return false;
        }
        if (!sGProperties.equals(this.getProperties())) {
            this.clearVariableCache();
        }
        NetCDFDataProperties netCDFDataProperties = (NetCDFDataProperties)sGProperties;
        this.mTimeVariable = this.mNCFile.findVariable(netCDFDataProperties.timeName);
        this.mSerialNumberVariable = this.mNCFile.findVariable(netCDFDataProperties.serialNumberName);
        this.mOriginMap = new HashMap<String, Integer>(netCDFDataProperties.originMap);
        return true;
    }

    @Override
    public boolean writeProperty(Element element, int n) {
        StringBuffer stringBuffer = new StringBuffer();
        Iterator<String> iterator = this.mOriginMap.keySet().iterator();
        while (iterator.hasNext()) {
            String string = iterator.next();
            Integer n2 = this.mOriginMap.get(string);
            stringBuffer.append(string);
            stringBuffer.append('=');
            stringBuffer.append(n2);
            if (!iterator.hasNext()) continue;
            stringBuffer.append(',');
        }
        element.setAttribute(KEY_ORIGIN_MAP, stringBuffer.toString());
        if (this.mTimeVariable != null) {
            element.setAttribute("TimeVariableName", this.mTimeVariable.getName());
        }
        if (this.mSerialNumberVariable != null) {
            element.setAttribute("SerialNumberVariableName", this.mSerialNumberVariable.getName());
        }
        return true;
    }

    @Override
    public boolean readProperty(Element element) {
        String string = null;
        HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
        SGVariable sGVariable = null;
        SGVariable sGVariable2 = null;
        string = element.getAttribute(KEY_ORIGIN_MAP);
        if (string.length() != 0) {
            String[] stringArray = string.split(",");
            for (int i = 0; i < stringArray.length; ++i) {
                String string2 = stringArray[i].trim();
                String[] stringArray2 = string2.split("=");
                if (stringArray2.length != 2) {
                    return false;
                }
                String string3 = stringArray2[0].trim();
                if (this.mNCFile.findVariable(string3) == null) {
                    return false;
                }
                String string4 = stringArray2[1].trim();
                Integer n = SGUtilityText.getInteger(string4);
                if (n == null) {
                    return false;
                }
                hashMap.put(string3, n);
            }
        } else {
            return false;
        }
        string = element.getAttribute("TimeVariableName");
        if (string.length() != 0 && (sGVariable = this.mNCFile.findVariable(string)) == null) {
            return false;
        }
        string = element.getAttribute("SerialNumberVariableName");
        if (string.length() != 0 && (sGVariable2 = this.mNCFile.findVariable(string)) == null) {
            return false;
        }
        this.mOriginMap = hashMap;
        this.mTimeVariable = sGVariable;
        this.mSerialNumberVariable = sGVariable2;
        return true;
    }

    public boolean setOrigin(String string, int n) {
        Dimension dimension = this.mNCFile.findDimension(string);
        if (dimension == null) {
            return false;
        }
        int n2 = dimension.getLength();
        if (n < 0 || n >= n2) {
            return false;
        }
        this.mOriginMap.put(dimension.getName(), n);
        return true;
    }

    public int getOrigin(String string) {
        Dimension dimension = this.mNCFile.findDimension(string);
        if (dimension == null) {
            throw new IllegalArgumentException("Dimension is not found: " + string);
        }
        Integer n = this.mOriginMap.get(string);
        if (n == null) {
            throw new Error("Origin is not found in the map for the coordinate variable: " + string);
        }
        return n;
    }

    public double getCoordinateValue(String string, int n) throws IOException {
        SGVariable sGVariable = this.mNCFile.findVariable(string);
        if (sGVariable == null) {
            throw new IllegalArgumentException("Variable is not found: " + string);
        }
        if (!sGVariable.isCoordinateVariable()) {
            throw new IllegalArgumentException("Not a coordinate variable: " + string);
        }
        if (sGVariable instanceof SGCoordinateVariable) {
            SGCoordinateVariable sGCoordinateVariable = (SGCoordinateVariable)sGVariable;
            int n2 = sGCoordinateVariable.getLength();
            if (n < 0 || n >= n2) {
                throw new IllegalArgumentException("Index out of bounds [0, " + n2 + " + ]: " + n);
            }
            return n;
        }
        Array array = sGVariable.getVariable().read();
        int n3 = (int)array.getSize();
        if (n < 0 || n >= n3) {
            throw new IllegalArgumentException("Index out of bounds [0, " + n3 + " + ]: " + n);
        }
        return array.getDouble(n);
    }

    protected String getNameWithUnit(SGVariable sGVariable) {
        String string = sGVariable.getNameInPriorityOrder();
        String string2 = sGVariable.getUnitsString();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(string);
        if (string2 != null) {
            stringBuffer.append(" [");
            stringBuffer.append(string2);
            stringBuffer.append(']');
        }
        return stringBuffer.toString();
    }

    protected Number getFillValue(SGVariable sGVariable) {
        Attribute attribute = sGVariable.findAttribute(FILL_VALUE);
        if (attribute == null) {
            return null;
        }
        Number number = attribute.getNumericValue();
        return number;
    }

    public abstract String[] getCurrentColumnType();

    @Override
    public boolean setColumnInfo(SGDataColumnInfo[] sGDataColumnInfoArray) {
        if (!super.setColumnInfo(sGDataColumnInfoArray)) {
            return false;
        }
        for (int i = 0; i < sGDataColumnInfoArray.length; ++i) {
            SGNetCDFDataColumnInfo sGNetCDFDataColumnInfo = (SGNetCDFDataColumnInfo)sGDataColumnInfoArray[i];
            SGVariable sGVariable = sGNetCDFDataColumnInfo.getVariable();
            if (!sGVariable.isCoordinateVariable()) continue;
            String string = sGVariable.getName();
            this.mOriginMap.put(string, sGNetCDFDataColumnInfo.getOrigin());
        }
        this.clearVariableCache();
        return true;
    }

    private void clearVariableCache() {
        this.mVariableCache.clear();
    }

    @Override
    public String getDataType(int n) {
        if (n == 2 || n == 6) {
            return this.getDataTypeForDataSet();
        }
        return this.getDataType();
    }

    protected abstract String getDataTypeForDataSet();

    public abstract SGVariable[] getVariables();

    public boolean isFixedCoordinateVariable(String string) {
        SGVariable sGVariable = this.mNCFile.findVariable(string);
        if (sGVariable == null) {
            throw new IllegalArgumentException("Variable is not found: " + string);
        }
        if (!sGVariable.isCoordinateVariable()) {
            throw new IllegalArgumentException("Not a coordinate variable: " + string);
        }
        SGVariable[] sGVariableArray = this.getVariables();
        for (int i = 0; i < sGVariableArray.length; ++i) {
            if (!string.equals(sGVariableArray[i].getName())) continue;
            return false;
        }
        return true;
    }

    protected String[] readNames(Element element, String string) {
        String string2 = element.getAttribute(string);
        return SGUtilityText.parseStrings(string2);
    }

    protected double[] getCoordinateValueArray(SGVariable sGVariable) {
        String string = sGVariable.getName();
        Object object = this.getVariableCache(string);
        if (object != null) {
            return (double[])object;
        }
        double[] dArray = null;
        if (sGVariable instanceof SGCoordinateVariable) {
            SGCoordinateVariable sGCoordinateVariable = (SGCoordinateVariable)sGVariable;
            int n = sGCoordinateVariable.getLength();
            dArray = new double[n];
            for (int i = 0; i < dArray.length; ++i) {
                dArray[i] = i;
            }
        } else {
            Array array = null;
            try {
                array = sGVariable.getVariable().read();
            }
            catch (IOException iOException) {
                return null;
            }
            int n = (int)array.getSize();
            dArray = new double[n];
            for (int i = 0; i < n; ++i) {
                dArray[i] = array.getDouble(i);
            }
        }
        this.setVariableCache(string, dArray);
        return dArray;
    }

    protected double[] getValueArray(SGVariable sGVariable, SGVariable[] sGVariableArray) {
        String string = sGVariable.getName();
        Object object = this.getVariableCache(string);
        if (object != null) {
            return (double[])object;
        }
        return this.getValueArray(sGVariable, sGVariableArray, this.mOriginMap);
    }

    protected double[] getValueArray(SGVariable sGVariable, SGVariable[] sGVariableArray, Map<String, Integer> map) {
        String string;
        int n;
        if (sGVariable instanceof SGDateVariable) {
            return ((SGDateVariable)sGVariable).getNumberArray();
        }
        String string2 = sGVariable.getName();
        Object object = this.getVariableCache(string2);
        if (object != null) {
            return (double[])object;
        }
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        for (int i = 0; i < sGVariableArray.length; ++i) {
            n = sGVariable.findDimensionIndex(sGVariableArray[i].getName());
            arrayList.add(n);
        }
        List<Dimension> list = sGVariable.getDimensions();
        n = list.size();
        int[] nArray = new int[n];
        for (Dimension dimension : list) {
            string = dimension.getName();
            int n2 = sGVariable.findDimensionIndex(string);
            if (arrayList.contains(n2)) {
                nArray[n2] = 0;
                continue;
            }
            Integer n3 = map.get(string);
            nArray[n2] = n3;
        }
        Object object2 = new int[n];
        for (int i = 0; i < n; ++i) {
            string = list.get(i);
            object2[i] = arrayList.contains(i) ? (Object)string.getLength() : (Object)true;
        }
        Number number = this.getFillValue(sGVariable);
        string = null;
        try {
            string = sGVariable.read(nArray, (int[])object2);
        }
        catch (InvalidRangeException invalidRangeException) {
            return null;
        }
        catch (IOException iOException) {
            return null;
        }
        Array array = string.reduce();
        int n4 = (int)array.getSize();
        Double[] doubleArray = this.arrangeValueArray(array, sGVariable, sGVariableArray);
        double[] dArray = new double[n4];
        for (int i = 0; i < n4; ++i) {
            Double d = doubleArray[i];
            dArray[i] = number != null && d.doubleValue() == number.doubleValue() ? Double.NaN : d;
        }
        this.setVariableCache(sGVariable.getName(), dArray);
        return dArray;
    }

    protected abstract Double[] arrangeValueArray(Array var1, SGVariable var2, SGVariable[] var3);

    protected Double[] arrange1Dim(Array array) {
        int n = (int)array.getSize();
        Double[] doubleArray = new Double[n];
        for (int i = 0; i < n; ++i) {
            doubleArray[i] = array.getDouble(i);
        }
        return doubleArray;
    }

    protected Double[] arrange2Dim(Array array, SGVariable sGVariable, SGVariable[] sGVariableArray) {
        int n;
        Object object;
        int n2;
        ArrayList<Dimension> arrayList = new ArrayList<Dimension>();
        for (int i = 0; i < sGVariableArray.length; ++i) {
            arrayList.add(sGVariableArray[i].getDimension(0));
        }
        List<Dimension> list = sGVariable.getDimensions();
        int n3 = list.size();
        ArrayList<Dimension> arrayList2 = new ArrayList<Dimension>();
        for (n2 = 0; n2 < n3; ++n2) {
            Dimension dimension = list.get(n2);
            if (!arrayList.contains(dimension)) continue;
            arrayList2.add(dimension);
        }
        n2 = ((Dimension)arrayList2.get(0)).getLength();
        int n4 = ((Dimension)arrayList2.get(1)).getLength();
        Class clazz = array.getElementType();
        Object object2 = array.copyToNDJavaArray();
        if (clazz.equals(Double.TYPE)) {
            object = (double[][])object2;
        } else {
            int n5;
            Object object3;
            object = new double[n2][];
            if (clazz.equals(Float.TYPE)) {
                object3 = (float[][])object2;
                for (n = 0; n < n2; ++n) {
                    object[n] = new double[n4];
                    for (n5 = 0; n5 < n4; ++n5) {
                        object[n][n5] = object3[n][n5];
                    }
                }
            } else if (clazz.equals(Integer.TYPE)) {
                object3 = (int[][])object2;
                for (n = 0; n < n2; ++n) {
                    object[n] = new double[n4];
                    for (n5 = 0; n5 < n4; ++n5) {
                        object[n][n5] = object3[n][n5];
                    }
                }
            } else if (clazz.equals(Long.TYPE)) {
                object3 = (long[][])object2;
                for (n = 0; n < n2; ++n) {
                    object[n] = new double[n4];
                    for (n5 = 0; n5 < n4; ++n5) {
                        object[n][n5] = object3[n][n5];
                    }
                }
            } else if (clazz.equals(Short.TYPE)) {
                object3 = (short[][])object2;
                for (n = 0; n < n2; ++n) {
                    object[n] = new double[n4];
                    for (n5 = 0; n5 < n4; ++n5) {
                        object[n][n5] = object3[n][n5];
                    }
                }
            } else if (clazz.equals(Byte.TYPE)) {
                object3 = (byte[][])object2;
                for (n = 0; n < n2; ++n) {
                    object[n] = new double[n4];
                    for (n5 = 0; n5 < n4; ++n5) {
                        object[n][n5] = object3[n][n5];
                    }
                }
            } else {
                throw new Error("Not supported element type: " + clazz);
            }
        }
        boolean bl = false;
        if (!((Object)arrayList).equals(arrayList2)) {
            bl = true;
        }
        n = n2 * n4;
        Double[] doubleArray = new Double[n];
        int n6 = ((double[][])object).length;
        for (int i = 0; i < n6; ++i) {
            int n7 = object[i].length;
            for (int j = 0; j < n7; ++j) {
                int n8 = bl ? i * n7 + j : j * n6 + i;
                doubleArray[n8] = object[i][j];
            }
        }
        return doubleArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean saveDataAsNetCDF(File file) throws IOException, InvalidRangeException {
        SGVariable[] sGVariableArray = this.getVariables();
        NetcdfFile netcdfFile = this.getNetcdfFile().getNetcdfFile();
        NetcdfFileWriteable netcdfFileWriteable = null;
        try {
            int n;
            StringBuffer stringBuffer;
            Object object;
            SGVariable sGVariable;
            Object object22;
            netcdfFileWriteable = NetcdfFileWriteable.createNew((String)file.getAbsolutePath());
            List list = netcdfFile.getGlobalAttributes();
            for (Object object22 : list) {
                netcdfFileWriteable.addGlobalAttribute((Attribute)object22);
            }
            List list2 = netcdfFile.getVariables();
            object22 = new HashSet();
            HashSet<String> hashSet = new HashSet<String>();
            block5: for (int i = 0; i < sGVariableArray.length; ++i) {
                int n2;
                if (sGVariableArray[i] instanceof SGTextVariable) {
                    sGVariable = (SGTextVariable)sGVariableArray[i];
                    object = null;
                    Object object3 = list2.iterator();
                    while (object3.hasNext()) {
                        Variable variable = (Variable)object3.next();
                        if (!variable.getName().equals(sGVariable.getOriginalName())) continue;
                        object = variable;
                        break;
                    }
                    if (object == null) {
                        boolean bl = false;
                        return bl;
                    }
                    hashSet.add(object.getName());
                    object3 = object.getDimensions();
                    block7: for (int j = 0; j < object3.size(); ++j) {
                        stringBuffer = (Dimension)object3.get(j);
                        object22.add(stringBuffer);
                        for (n2 = 0; n2 < list2.size(); ++n2) {
                            if (!stringBuffer.getName().equals(((Variable)list2.get(i)).getName())) continue;
                            hashSet.add(((Variable)list2.get(i)).getName());
                            continue block7;
                        }
                    }
                    continue;
                }
                if (sGVariableArray[i] instanceof SGCoordinateVariable) {
                    sGVariable = (SGCoordinateVariable)sGVariableArray[i];
                    if (sGVariable.getVariable() != null) {
                        object = sGVariableArray[i].getVariable();
                        hashSet.add(object.getName());
                        List list3 = object.getDimensions();
                        block9: for (int j = 0; j < list3.size(); ++j) {
                            stringBuffer = (Dimension)list3.get(j);
                            object22.add(stringBuffer);
                            for (n2 = 0; n2 < list2.size(); ++n2) {
                                if (!stringBuffer.getName().equals(((Variable)list2.get(i)).getName())) continue;
                                hashSet.add(((Variable)list2.get(i)).getName());
                                continue block9;
                            }
                        }
                    }
                    if (((SGCoordinateVariable)sGVariable).getDimension() == null) continue;
                    object = ((SGCoordinateVariable)sGVariable).getDimension();
                    object22.add(object);
                    for (int j = 0; j < list2.size(); ++j) {
                        if (!object.getName().equals(((Variable)list2.get(i)).getName())) continue;
                        hashSet.add(((Variable)list2.get(i)).getName());
                        continue block5;
                    }
                    continue;
                }
                sGVariable = sGVariableArray[i].getVariable();
                hashSet.add(sGVariable.getName());
                object = sGVariable.getDimensions();
                block12: for (int j = 0; j < object.size(); ++j) {
                    Dimension dimension = (Dimension)object.get(j);
                    object22.add(dimension);
                    for (int k = 0; k < list2.size(); ++k) {
                        if (!dimension.getName().equals(((Variable)list2.get(i)).getName())) continue;
                        hashSet.add(((Variable)list2.get(i)).getName());
                        continue block12;
                    }
                }
            }
            Iterator iterator = object22.iterator();
            while (iterator.hasNext()) {
                sGVariable = (Dimension)iterator.next();
                object = new Dimension(sGVariable.getName(), sGVariable.getLength());
                netcdfFileWriteable.addDimension(null, (Dimension)object);
            }
            for (n = 0; n < list2.size(); ++n) {
                int n3;
                Group group;
                sGVariable = (Variable)list2.get(n);
                if (!hashSet.contains(sGVariable.getName())) continue;
                object = sGVariable.getAttributes();
                String string = sGVariable.getName();
                String[] stringArray = string.split("/");
                stringBuffer = new StringBuffer();
                for (int i = 0; i < stringArray.length - 1; ++i) {
                    stringBuffer.append(stringArray[i]);
                    if (i == stringArray.length - 2) continue;
                    stringBuffer.append("/");
                }
                String string2 = stringBuffer.toString();
                if (string2.length() == 0) {
                    group = new Variable((NetcdfFile)netcdfFileWriteable, null, null, sGVariable.getName(), sGVariable.getDataType(), sGVariable.getDimensionsString());
                    for (int i = 0; i < object.size(); ++i) {
                        group.addAttribute((Attribute)object.get(i));
                    }
                    netcdfFileWriteable.addVariable(null, (Variable)group);
                    continue;
                }
                group = netcdfFileWriteable.findGroup(string2);
                if (group == null) {
                    Group group2 = netcdfFileWriteable.getRootGroup();
                    for (n3 = 0; n3 < stringArray.length - 1; ++n3) {
                        Group group3 = group2.findGroup(stringArray[n3]);
                        if (group3 == null) {
                            group3 = new Group((NetcdfFile)netcdfFileWriteable, group2, stringArray[n3]);
                            group2.addGroup(group3);
                        }
                        group2 = group3;
                    }
                }
                group = netcdfFileWriteable.findGroup(string2);
                Variable variable = new Variable((NetcdfFile)netcdfFileWriteable, null, null, stringArray[stringArray.length - 1], sGVariable.getDataType(), sGVariable.getDimensionsString());
                for (n3 = 0; n3 < object.size(); ++n3) {
                    variable.addAttribute((Attribute)object.get(n3));
                }
                netcdfFileWriteable.addVariable(group, variable);
            }
            netcdfFileWriteable.create();
            for (n = 0; n < list2.size(); ++n) {
                sGVariable = (Variable)list2.get(n);
                object = sGVariable.read();
                if (!hashSet.contains(sGVariable.getName())) continue;
                netcdfFileWriteable.write(sGVariable.getName(), (Array)object);
            }
        }
        finally {
            if (netcdfFileWriteable != null) {
                netcdfFileWriteable.close();
            }
        }
        return true;
    }

    @Override
    public boolean saveData(File file, int n) {
        if (n == 7) {
            try {
                return this.saveDataAsNetCDF(file);
            }
            catch (Exception exception) {
                exception.printStackTrace();
                return false;
            }
        }
        boolean bl = false;
        SGVariable[] sGVariableArray = this.getVariables();
        try {
            FileWriter fileWriter = new FileWriter(file);
            for (int i = 0; i < sGVariableArray.length; ++i) {
                String string = this.getNameWithUnit(sGVariableArray[i]);
                if (string == null) {
                    string = "";
                }
                String string2 = SGUtilityText.getCSVString(string);
                if (i != 0) {
                    fileWriter.write(",");
                }
                fileWriter.write(string2);
            }
            fileWriter.write("\n");
            bl = this.writeData(fileWriter, n);
            fileWriter.close();
        }
        catch (IOException iOException) {
            return false;
        }
        return bl;
    }

    protected abstract double[][] getDataSetValues();

    @Override
    protected boolean writeData(Writer writer, int n) throws IOException {
        StringBuffer stringBuffer = new StringBuffer();
        double[][] dArray = this.getDataSetValues();
        for (int i = 0; i < dArray.length; ++i) {
            int n2;
            int n3 = dArray[i].length;
            if (n == 6) {
                n2 = 0;
                for (int j = 0; j < n3; ++j) {
                    Double d = dArray[i][j];
                    if (!d.isNaN()) continue;
                    n2 = 1;
                    break;
                }
                if (n2 != 0) {
                    stringBuffer.append("#");
                    stringBuffer.append("<");
                    stringBuffer.append("NAC");
                    stringBuffer.append(">");
                }
            }
            for (n2 = 0; n2 < n3; ++n2) {
                stringBuffer.append(dArray[i][n2]);
                if (n2 == n3 - 1) continue;
                stringBuffer.append(',');
            }
            stringBuffer.append('\n');
        }
        writer.write(stringBuffer.toString());
        return true;
    }

    public double[] getTimeValueArray() {
        if (this.mTimeVariable == null) {
            return null;
        }
        return this.getCoordinateValueArray(this.mTimeVariable);
    }

    public boolean isTimeVariableAvailable() {
        return this.mTimeVariable != null;
    }

    public int getCurrentTimeValueIndex() {
        if (this.mTimeVariable == null) {
            return -1;
        }
        String string = this.mTimeVariable.getName();
        Integer n = this.mOriginMap.get(string);
        return n;
    }

    public SGVariable getTimeVariable() {
        return this.mTimeVariable;
    }

    public Number getCurrentTimeValue() {
        if (this.mTimeVariable == null) {
            return -1;
        }
        int n = this.getCurrentTimeValueIndex();
        double[] dArray = this.getTimeValueArray();
        return dArray[n];
    }

    public void setCurrentTimeValueIndex(int n) {
        if (this.mTimeVariable == null) {
            return;
        }
        Dimension dimension = this.mTimeVariable.getDimension(0);
        int n2 = dimension.getLength();
        if (n < 0 || n >= n2) {
            throw new IllegalArgumentException("Index out of bounds: " + n);
        }
        String string = this.mTimeVariable.getName();
        this.mOriginMap.put(string, n);
        this.clearVariableCache();
    }

    protected String getName(SGVariable sGVariable) {
        return sGVariable != null ? sGVariable.getName() : null;
    }

    protected String getName(Dimension dimension) {
        return dimension != null ? dimension.getName() : null;
    }

    protected SGVariable findVariable(String string) {
        return string != null ? this.mNCFile.findVariable(string) : null;
    }

    protected Dimension findDimension(String string) {
        return string != null ? this.mNCFile.findDimension(string) : null;
    }

    protected SGVariable getVariable(SGNetCDFFile sGNetCDFFile, String string) {
        SGVariable sGVariable = null;
        if (string != null && (sGVariable = sGNetCDFFile.findVariable(string)) == null) {
            throw new IllegalArgumentException("Invalid variable name: " + string);
        }
        return sGVariable;
    }

    protected void checkNotCoordinateVariable(SGVariable sGVariable, List<Dimension> list) {
        if (sGVariable != null) {
            if (sGVariable.isCoordinateVariable()) {
                throw new IllegalArgumentException("The variable " + sGVariable.getName() + " must not be coordinate values.");
            }
            for (int i = 0; i < list.size(); ++i) {
                Dimension dimension = list.get(i);
                if (sGVariable.getDimensions().contains(dimension)) continue;
                throw new IllegalArgumentException("The variable " + sGVariable.getName() + " does not have a dimension " + dimension.getName());
            }
        }
    }

    @Override
    public Map<String, Object> getInfoMap() {
        Map<String, Object> map = super.getInfoMap();
        map.put("DataType", this.getDataType());
        map.put("Data Source", this.mNCFile);
        return map;
    }

    @Override
    public SGIDataSource getDataSource() {
        return this.getNetcdfFile();
    }

    public SGVariable getSerialNumberVariable() {
        return this.mSerialNumberVariable;
    }

    public boolean isSerialNumberAvailable() {
        return this.mSerialNumberVariable != null;
    }

    public Object getVariableCache(String string) {
        Object object = null;
        if (this.useFileCache(string)) {
            object = this.mNCFile.getVariableCache(string);
        } else {
            String string2 = this.getCacheKey(string).toString();
            object = this.mVariableCache.get(string2);
        }
        return object;
    }

    public void setVariableCache(String string, Object object) {
        if (this.useFileCache(string)) {
            this.mNCFile.setVariableCache(string, object);
        } else {
            String string2 = this.getCacheKey(string).toString();
            this.mVariableCache.put(string2, object);
        }
    }

    protected boolean useFileCache(String string) {
        SGVariable sGVariable = this.findVariable(string);
        if (sGVariable == null) {
            throw new IllegalArgumentException("var == null :" + string);
        }
        return sGVariable.isCoordinateVariable() || sGVariable instanceof SGCoordinateVariable || sGVariable instanceof SGTextVariable;
    }

    protected Integer getCacheKey(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(string);
        stringBuffer.append(this.mOriginMap.toString());
        return stringBuffer.toString().hashCode();
    }

    protected void setCacheMap(Map<String, Object> map) {
        this.mVariableCache = map;
    }

    public static abstract class NetCDFDataProperties
    extends SGData.DataProperties {
        protected String timeName = null;
        protected String serialNumberName = null;
        protected Map<String, Integer> originMap = new HashMap<String, Integer>();

        public void dispose() {
            super.dispose();
            this.timeName = null;
            this.serialNumberName = null;
            this.originMap.clear();
            this.originMap = null;
        }

        public boolean equals(Object object) {
            if (!(object instanceof NetCDFDataProperties)) {
                return false;
            }
            NetCDFDataProperties netCDFDataProperties = (NetCDFDataProperties)object;
            if (!SGUtility.equals(this.timeName, netCDFDataProperties.timeName)) {
                return false;
            }
            if (!SGUtility.equals(this.serialNumberName, netCDFDataProperties.serialNumberName)) {
                return false;
            }
            return ((Object)this.originMap).equals(netCDFDataProperties.originMap);
        }
    }
}

